/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.gateway;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.mapper.HisBusinessConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.HisBusinessUrlEntityMapper;
import com.ebaiyihui.wisdommedical.model.HisBusinessConfigEntity;
import com.ebaiyihui.wisdommedical.model.HisBusinessUrlEntity;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class GateWayCommonUtil<T> {
    private static final Logger log = LoggerFactory.getLogger(GateWayCommonUtil.class);
    @Autowired
    private HisBusinessUrlEntityMapper hisBusinessUrlEntityAutowMapper;
    @Autowired
    private HisBusinessConfigMapper hisBusinessConfigAutowMapper;
    @Autowired
    private JedisCluster jedisAutowCluster;
    private static HisBusinessUrlEntityMapper hisBusinessUrlEntityMapper;
    private static HisBusinessConfigMapper hisBusinessConfigMapper;
    private static JedisCluster jedisCluster;

    @PostConstruct
    public void init() {
        hisBusinessUrlEntityMapper = this.hisBusinessUrlEntityAutowMapper;
        hisBusinessConfigMapper = this.hisBusinessConfigAutowMapper;
        jedisCluster = this.jedisAutowCluster;
    }

    public GatewayResponse<T> requestHis(String transactionId, String organCode, String businessCode, GatewayRequest gatewayRequest, Class clazz) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        FrontResponse frontResponse = new FrontResponse();
        try {
            GatewayResponse baseResponse = this.getHisBusinessUrl(transactionId, organCode, businessCode, false);
            if (baseResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)baseResponse.getMsg(), (String)transactionId);
            }
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(transactionId);
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            String url = (String)baseResponse.getData();
            String result = "";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)frontRequest));
            result = HttpKit.jsonPost((String)url, (String)JSONObject.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u51fa\u53c2\uff1a" + result);
            1 typeReference = new /* Unavailable Anonymous Inner Class!! */;
            frontResponse = (FrontResponse)JSONObject.parseObject((String)result, (Type)typeReference.getType(), (Feature[])new Feature[0]);
            if (frontResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)frontResponse.getMessage(), (String)transactionId);
            }
        }
        catch (Exception e) {
            log.error("\u8bf7\u6c42his\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38\u4fe1\u606f\u4e3a - >{}", (Object)e.getMessage());
            return GatewayResponse.specialError((String)"\u8bf7\u6c42hsi\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38", (String)transactionId);
        }
        return GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId());
    }

    public GatewayResponse<T> requestHis(String transactionId, String organCode, String businessCode, GatewayRequest gatewayRequest) {
        GatewayResponse gatewayResponse = new GatewayResponse();
        FrontResponse frontResponse = new FrontResponse();
        try {
            GatewayResponse baseResponse = this.getHisBusinessUrl(transactionId, organCode, businessCode, false);
            if (baseResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)baseResponse.getMsg(), (String)transactionId);
            }
            FrontRequest frontRequest = new FrontRequest();
            frontRequest.setTransactionId(transactionId);
            frontRequest.setChannel(gatewayRequest.getChannel());
            frontRequest.setChannelName(gatewayRequest.getChannelName());
            frontRequest.setBody(gatewayRequest.getBody());
            String url = (String)baseResponse.getData();
            String result = "";
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)frontRequest));
            result = HttpKit.jsonPost((String)url, (String)JSONObject.toJSONString((Object)frontRequest));
            log.info("\u8bf7\u6c42\u524d\u7f6e\u673a\u670d\u52a1\u51fa\u53c2\uff1a" + result);
            frontResponse = (FrontResponse)JSONObject.parseObject((String)result, FrontResponse.class);
            if (frontResponse.getCode().equals("0")) {
                return GatewayResponse.specialError((String)frontResponse.getMessage(), (String)transactionId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return GatewayResponse.specialError((String)"\u8bf7\u6c42hsi\u524d\u7f6e\u673a\u51fa\u73b0\u5f02\u5e38", (String)transactionId);
        }
        return GatewayResponse.specialSuccess((Object)frontResponse.getBody(), (String)frontResponse.getTransactionId());
    }

    public GatewayResponse<String> getHisBusinessUrl(String transactionId, String organCode, String businessCode, boolean redisOpen) {
        HisBusinessUrlEntity hisBusinessUrlEntity;
        String url = "";
        if (redisOpen) {
            log.info("redis\u83b7\u53d6\u5230\u524d\u7f6e\u673a\u63a5\u53e3\u5730\u5740key\uff1a" + organCode + businessCode);
            url = jedisCluster.get(organCode + "_" + businessCode);
            log.info("redis\u83b7\u53d6\u5230\u524d\u7f6e\u673a\u63a5\u53e3\u5730\u5740value\uff1a" + url);
            if (!StringUtils.isEmpty((Object)url)) {
                return GatewayResponse.specialSuccess((Object)url, (String)transactionId);
            }
        }
        if (StringUtils.isEmpty((Object)(hisBusinessUrlEntity = (HisBusinessUrlEntity)hisBusinessUrlEntityMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"status", (Object)new Byte("1")))))) {
            return GatewayResponse.specialError((String)"\u83b7\u53d6\u524d\u7f6e\u673a\u670d\u52a1\u57df\u540d\u5931\u8d25", (String)transactionId);
        }
        HisBusinessConfigEntity hisBusinessConfig = (HisBusinessConfigEntity)hisBusinessConfigMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"organ_code", (Object)organCode)).eq((Object)"business_code", (Object)businessCode));
        if (StringUtils.isEmpty((Object)hisBusinessConfig)) {
            return GatewayResponse.specialError((String)"\u83b7\u53d6\u524d\u7f6e\u673a\u670d\u52a1\u63a5\u53e3\u5730\u5740\u5931\u8d25", (String)transactionId);
        }
        url = hisBusinessUrlEntity.getHisFrontUrl().concat(hisBusinessConfig.getHisConfig());
        jedisCluster.set(organCode + "_" + businessCode, url);
        return GatewayResponse.specialSuccess((Object)url, (String)transactionId);
    }
}

