/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    public static final int NO_PAY_AUTO_CANCEL_APPOINTMENT = 2;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    private static String AUTO_CANCEL = "\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88";

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order.sdy"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) {
        try {
            log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
            RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = (RabbitMqDelayedOrderVo)JSON.parseObject((String)rabbitMqDelayedOrderVoStr, RabbitMqDelayedOrderVo.class);
            String orderId = rabbitMqDelayedOrderVo.getOrderId();
            if (StringUtils.isBlank((String)orderId)) {
                log.info("---\u961f\u5217\u6d88\u606forderId\u4e3a\u7a7a---");
                return;
            }
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectByPrimaryKey(Long.valueOf(Long.parseLong(orderId)));
            if (appointmentRecordEntity == null) {
                log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\u7a7a\uff1a" + orderId);
                return;
            }
            log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\uff1a " + JSON.toJSONString((Object)appointmentRecordEntity));
            if (Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
                log.info("\u66f4\u6539\u8ba2\u5355\u72b6\u6001\u4e3a\u5df2\u6bc1\u7ea6 -> " + orderId);
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.BREACH_APPOINT.getValue());
                appointmentRecordEntity.setRemark("\u5df2\u6bc1\u7ea6");
                log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
        }
        catch (NumberFormatException e) {
            return;
        }
    }
}

