/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PayOrder;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PaymentInquiryVO;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SdyPayUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class DelayedPayReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedPayReceiver.class);
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private PayCallBackService payCallBackService;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    StringRedisTemplate stringRedisTemplate;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    public static final String SERVICE_CODE = "ZHJY-APPOINTMENT";

    @RabbitListener(queues={"wisdommedical.appointment.delayed.pay.sdy"})
    @RabbitHandler
    public void process(String data) {
        block13: {
            try {
                log.info("\u67e5\u8be2\u652f\u4ed8\u72b6\u6001rabbit mq:{}", JSON.toJSON((Object)data));
                if (!StringUtils.isNotBlank((CharSequence)data)) break block13;
                PayOrder payOrder = (PayOrder)JSON.parseObject((String)data, PayOrder.class);
                int type = payOrder.getType();
                String orderNo = payOrder.getOrderNo();
                switch (type) {
                    case 1: {
                        AppointmentRecordEntity dayaAppointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(orderNo);
                        if (!Objects.equals(dayaAppointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) break;
                        PaymentResultsDTO queryOrderRes = this.queryOrderStatus(payOrder);
                        if (!queryOrderRes.getOrdSts().equals("1")) break;
                        try {
                            log.info("=======>\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u5f00\u59cb\u56de\u8c03");
                            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                            responseNotifyRestVo.setApplyId(this.propertiesConstant.getAppId());
                            responseNotifyRestVo.setDealTradeNo(queryOrderRes.getTsPayId());
                            responseNotifyRestVo.setOutTradeNo(queryOrderRes.getOrdNo());
                            responseNotifyRestVo.setTotalAmount(payOrder.getTotalAmount());
                            responseNotifyRestVo.setPayChannel("WECHAT");
                            responseNotifyRestVo.setPayTime(payOrder.getPayTime());
                            responseNotifyRestVo.setServiceCode(SERVICE_CODE);
                            this.payCallBackService.dayAppointmentCallBack(responseNotifyRestVo);
                        }
                        catch (AppointmentException e) {
                            log.error("\u6302\u53f7\u5145\u503c\u56de\u8c03\u5f02\u5e38");
                        }
                        log.info("=======>\u6302\u53f7\u652f\u4ed8\u56de\u8c03\u7ed3\u675f");
                        break;
                    }
                    case 2: {
                        PaymentResultsDTO paymentResultsDTO1 = this.queryOrderStatus(payOrder);
                        if (!paymentResultsDTO1.getOrdSts().equals("1")) break;
                        log.info("=======\u300b\u4f4f\u9662\u9884\u4ea4\u91d1\u56de\u8c03\u5f00\u59cb");
                        try {
                            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                            responseNotifyRestVo.setApplyId(this.propertiesConstant.getAppId());
                            responseNotifyRestVo.setDealTradeNo(paymentResultsDTO1.getTsPayId());
                            responseNotifyRestVo.setOutTradeNo(paymentResultsDTO1.getOrdNo());
                            responseNotifyRestVo.setTotalAmount(payOrder.getTotalAmount());
                            responseNotifyRestVo.setPayChannel("WECHAT");
                            responseNotifyRestVo.setPayTime(payOrder.getPayTime());
                            responseNotifyRestVo.setServiceCode(SERVICE_CODE);
                            this.payCallBackService.inHospDepositPayCallBack(responseNotifyRestVo);
                        }
                        catch (InHospitalException e) {
                            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u56de\u8c03\u5f02\u5e38");
                        }
                        log.info("========\u300b\u4f4f\u9662\u9884\u4ea4\u91d1\u56de\u8c03\u7ed3\u675f");
                        break;
                    }
                    case 3: {
                        PaymentResultsDTO paymentResultsDTO = this.queryOrderStatus(payOrder);
                        if (!paymentResultsDTO.getOrdSts().equals("1")) break;
                        log.info("=======\u300b\u95e8\u8bca\u7f34\u8d39\u56de\u8c03\u5f00\u59cb");
                        try {
                            ResponseNotifyRestVo responseNotifyRestVo = new ResponseNotifyRestVo();
                            responseNotifyRestVo.setApplyId(this.propertiesConstant.getAppId());
                            responseNotifyRestVo.setDealTradeNo(paymentResultsDTO.getTsPayId());
                            responseNotifyRestVo.setOutTradeNo(paymentResultsDTO.getOrdNo());
                            responseNotifyRestVo.setTotalAmount(payOrder.getTotalAmount());
                            responseNotifyRestVo.setPayChannel("WX");
                            responseNotifyRestVo.setPayTime(payOrder.getPayTime());
                            responseNotifyRestVo.setServiceCode(SERVICE_CODE);
                            this.payCallBackService.outpatientPaymentCallBack(responseNotifyRestVo);
                        }
                        catch (OutpatientPaymentException e) {
                            log.error("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03\u5f02\u5e38", (Throwable)e);
                        }
                        log.info("=======\u300b\u95e8\u8bca\u7f34\u8d39\u56de\u8c03\u7ed3\u675f");
                    }
                }
            }
            catch (Exception e) {
                log.error("\u76d1\u542c\u5230mq\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                return;
            }
        }
    }

    public PaymentResultsDTO queryOrderStatus(PayOrder payOrder) throws Exception {
        PaymentInquiryVO queryOrderReq = new PaymentInquiryVO();
        queryOrderReq.setOrdNo(payOrder.getOrderNo());
        PaymentResultsDTO queryOrderRes = SdyPayUtils.queryOrder((PaymentInquiryVO)queryOrderReq);
        if ("1".equals(queryOrderRes.getOrdSts())) {
            log.info("\u652f\u4ed8\u72b6\u6001" + queryOrderRes.getOrdSts());
            return queryOrderRes;
        }
        int number = payOrder.getNumber() + 1;
        Long display = NumberTimeEnum.getDisplay((Integer)number);
        if (number <= 10) {
            payOrder.setNumber(number);
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)display);
        }
        return queryOrderRes;
    }
}

