/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import java.util.HashMap;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.CustomExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RabbitMqConfig {
    public static final String DELAYED_QUEUE_NAME = "wisdommedical.appointment.delayed.order.sdy";
    public static final String EXCHANGE_NAME = "wisdommedical_appointment_delayed_exchange_sdy";
    public static final String DELAY_ORDER_ROUTING_KEY = "wisdommedical_appointment_delay_order_routing_key_sdy";
    public static final String PAY_QUEUE_NAME = "wisdommedical.appointment.delayed.pay.sdy";
    public static final String PAY_ROUTING_KEY = "wisdommedical_appointment_delay_pay_routing_key_sdy";
    public static final String REFUND_QUEUE_NAME = "wisdommedical.appointment.delayed.refund.sdy";
    public static final String REFUND_ROUTING_KEY = "wisdommedical_appointment_delay_refund_routing_key_sdy";

    @Bean
    public Queue queue() {
        return new Queue(DELAYED_QUEUE_NAME);
    }

    @Bean
    public Queue payQueue() {
        return new Queue(PAY_QUEUE_NAME);
    }

    @Bean
    public Queue refundQueue() {
        return new Queue(REFUND_QUEUE_NAME);
    }

    @Bean
    CustomExchange customExchange() {
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("x-delayed-type", "direct");
        return new CustomExchange(EXCHANGE_NAME, "x-delayed-message", true, false, args);
    }

    @Bean
    Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to((Exchange)this.customExchange()).with(DELAY_ORDER_ROUTING_KEY).noargs();
    }

    @Bean
    Binding payBinding() {
        return BindingBuilder.bind((Queue)this.payQueue()).to((Exchange)this.customExchange()).with(PAY_ROUTING_KEY).noargs();
    }

    @Bean
    Binding refundBinding() {
        return BindingBuilder.bind((Queue)this.refundQueue()).to((Exchange)this.customExchange()).with(REFUND_ROUTING_KEY).noargs();
    }
}

