/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.api.AppointmentClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.CancellationRequestDTO;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.MakeAnAppointmentNewReqDTO;
import com.ebaiyihui.his.pojo.vo.appoint.MakeAnAppointmentRequestDTO;
import com.ebaiyihui.his.pojo.vo.appoint.MakeAnAppointmentRequestVO;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.CardTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HospitalCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.IdCardTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ResponseTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.TimeArrangeIdTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.WeChatPayTypeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.PaymentResultsDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.dto.PayOrderDTO;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PayOrder;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PayOrderVO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.PaymentInquiryVO;
import com.ebaiyihui.wisdommedical.pojo.vo.PaymentRefundVO;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.NumberUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.RedisUtil;
import com.ebaiyihui.wisdommedical.util.SdyPayUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int HAF_HOURS = 1800;
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String HIS_MORNING = "0";
    public static final String HIS_AFTERNOON = "1";
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    public static final List<Integer> WAIT_CONFIRMED = Arrays.asList(11, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private AppointmentClient appointmentClient;

    private GetScheduleResItems builGetScheduleResItems(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
        getScheduleResItems.setLocName(createOrderVoReq.getDeptName());
        getScheduleResItems.setScheduleId(createOrderVoReq.getScheduleHisId());
        getScheduleResItems.setAdmDate(createOrderVoReq.getAdmDate() + createOrderVoReq.getStarTime());
        getScheduleResItems.setDocCode(createOrderVoReq.getDocCode());
        getScheduleResItems.setDocName(createOrderVoReq.getDocName());
        getScheduleResItems.setRegFee(createOrderVoReq.getRegFee());
        getScheduleResItems.setDiagFee(createOrderVoReq.getDiagFee());
        getScheduleResItems.setRegTitleName(createOrderVoReq.getRegTitleName());
        getScheduleResItems.setScheduleLevelName(createOrderVoReq.getScheduleLevelName());
        return getScheduleResItems;
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = null;
        if (null != confirmAppointmentVo && !CollectionUtils.isEmpty((Collection)confirmAppointmentVo.getTimeArrangeItems())) {
            timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    public List<AppointmentRecordVo> selectByUserIdAndStatus(Map<String, Object> queryMap, String appCode, String channelCode) throws Exception {
        List appointmentRecordEntityList = null;
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        List appointmentRecordEntityList = null;
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + JSON.toJSONString((Object)registerationQueryParamsDTO));
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)appointmentRecordEntityList));
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            String admDate = appointmentRecordVo.getAdmDate();
            boolean flag = DateUtils.judgeDate((String)appointmentRecordVo.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            if (admDate.equals(String.valueOf(LocalDate.now()))) {
                appointmentRecordVo.setIsTheDay(0L);
            } else if (flag) {
                appointmentRecordVo.setIsTheDay(1L);
            } else if (!flag) {
                appointmentRecordVo.setIsTheDay(-1L);
            }
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(480L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u8fd4\u56de\u5bf9\u8c61 \uff1a" + JSON.toJSONString((Object)appointmentRecordVoList));
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        log.info("\u672c\u4eba\u8bca\u7597\u6302\u53f7\u6570\u636e ------>{}", appointmentRecordEntityList);
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (WAIT_CONFIRMED.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            if (appointmentRecordEntity.getCreatetime() != null) {
                long createtime = appointmentRecordEntity.getCreatetime().getTime();
                appointmentRecordVo.setCreatetime(createtime);
            }
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            appointmentRecordVo.setIsTheDay(flag ? 1L : -1L);
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
            cardDetailsInfoReqVO.setChannelCode("app");
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
            }
            catch (ParseException e) {
                throw new AppointmentException("\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff01");
            }
            appointmentRecordDetailVo.setPatientAge(Integer.valueOf(age));
            appointmentRecordDetailVo.setPatientSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
            appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        }
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setRemark(appointmentRecordEntity.getRemark());
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        Date admDate = DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmDate(DateUtils.dateToYMDString((Date)admDate));
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        appointmentRecordDetailVo.setWeekday(DateUtils.getWeekZhou((String)appointmentRecordEntity.getAdmDate()));
        appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + " " + appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(480L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 480000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (WAIT_CONFIRMED.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        String ade = appointmentRecordEntity.getAdmDate();
        boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
        if (ade.equals(String.valueOf(LocalDate.now()))) {
            appointmentRecordDetailVo.setIsTheDay(0L);
        } else if (flag) {
            appointmentRecordDetailVo.setIsTheDay(1L);
        } else if (!flag) {
            appointmentRecordDetailVo.setIsTheDay(-1L);
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setRefundMoney(appointmentRecordEntity.getReturnAmount());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
    }

    public void unLock(CancellationRequestDTO cancelAppointmentVoReq) {
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)cancelAppointmentVoReq));
        FrontResponse gatewayResponse = this.appointApi.cancelRegister(cancelAppointmentVoReq);
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8fd4\u56de\u53c2\u6570 gatewayResponse:" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
        }
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        List<Integer> cancelAble = Arrays.asList(2, 20);
        if (null == appointmentRecordEntity || !cancelAble.contains(appointmentRecordEntity.getAppointStatus())) {
            throw new AppointmentException("\u6b64\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (AppointmentStatusEnum.APPOINT_SUCCESS.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            CancellationRequestDTO cancelRegisterReq = new CancellationRequestDTO();
            cancelRegisterReq.setHospitalCode(appointmentRecordEntity.getHospitalCode());
            cancelRegisterReq.setCertNo(appointmentRecordEntity.getPatientIdCard());
            cancelRegisterReq.setOrderNo(appointmentRecordEntity.getAppointmentId());
            cancelRegisterReq.setPid(appointmentRecordEntity.getPatientCardNo());
            cancelRegisterReq.setPreRegNo(appointmentRecordEntity.getAppointmentNo());
            cancelRegisterReq.setCertType("01");
            BusinessResultEntity businessResultEntity = new BusinessResultEntity();
            businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
            businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
            businessResultEntity.setHisRequest(JSON.toJSONString((Object)cancelRegisterReq));
            this.businessResultMapper.insertSelective(businessResultEntity);
            FrontResponse gatewayResponse = this.invokeHisCancelRegister(cancelRegisterReq, "");
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMessage());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u60a8\u5df2\u53d6\u6d88\u672c\u6b21\u9884\u7ea6\u6302\u53f7");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
        if (!overdueRefundDate) {
            throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.CANCEL_APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(appointmentRecordEntity.getPayTransationId());
        businessResultEntity.setStatus(new Byte("0"));
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(withdrawNumberVoReq.getPayChannel());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("refund method--------> begain");
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(new Date());
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        businessResultEntity.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        return baseResponse;
    }

    public BaseResponse<String> appointReturnNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
        if (!overdueRefundDate) {
            throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
        }
        GatewayRequest gatewayRequest = this.returnRegGatewayReq(withdrawNumberVoReq, appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, "");
        if (gatewayResponse.isSuccess()) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
            appointmentRecordEntity.setCancleChannelCode(withdrawNumberVoReq.getPayChannel());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        } else {
            log.info("his\u9000\u53f7\u5931\u8d25\uff1a" + gatewayResponse.getMsg());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("HIS\u9000\u53f7\u5931\u8d25:" + gatewayResponse.getMsg());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
        return BaseResponse.success();
    }

    public GatewayRequest<ReturnRegisterReq> returnRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAdmId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("returnAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = com.ebaiyihui.wisdommedical.util.HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        BaseResponse baseResponse;
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2================ -^.^-\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.REGISTERHT_PAY.getValue(), gatewayRequest, PayRegistrationRes.class);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2================ -^.^-\uff1a" + JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
            requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            requestRefundOrderVoReq.setSign(sign);
        }
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        if (gatewayResponse == null) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        PayRegistrationRes payRegistrationRes = (PayRegistrationRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        updatePayAppointment.setPayPostId(responseNotifyRestVo.getMchId());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        if (null != payRegistrationRes) {
            updatePayAppointment.setAdmId(payRegistrationRes.getAdmId());
            updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        }
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private FrontResponse<String> invokeHisCancelRegister(CancellationRequestDTO cancellationRequestDTO, String message) throws AppointmentException {
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)cancellationRequestDTO));
        FrontResponse gatewayResponse = this.appointApi.cancelRegister(cancellationRequestDTO);
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8fd4\u56de\u53c2\u6570 gatewayResponse:" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
        }
        if (gatewayResponse.getBody() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMessage());
        }
        return gatewayResponse;
    }

    private GatewayResponse<ReturnRegisterRes> invokeHisReturnRegister(GatewayRequest<ReturnRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.RETURN_REGISTER.getValue(), gatewayRequest, ReturnRegisterRes.class);
        if (gatewayResponse.getCode() == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u9000\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<PayRegistrationReq> cancelRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq registrationReq = new PayRegistrationReq();
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        registrationReq.setAppointId(appointmentRecordEntity.getReceptId());
        registrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getPayTransationId());
        registrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)registrationReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ReturnRegisterReq> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        MakeAnAppointmentRequestDTO makeAnAppointmentRequestDTO = this.buildMakeAnAppointmentRequestDTO(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2===================^.^\uff1a" + JSON.toJSONString((Object)makeAnAppointmentRequestDTO));
        FrontResponse dayGatewayResponse = this.appointApi.confirmRegister(makeAnAppointmentRequestDTO);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2===================^.^\uff1a" + JSON.toJSONString((Object)dayGatewayResponse));
        if (null == dayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMessage());
            throw new AppointmentException(dayGatewayResponse.getMessage());
        }
        if (null == dayGatewayResponse.getBody()) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(dayGatewayResponse.getMessage());
        }
        String sysAppointmnetId = UUIDUtils.getUUID();
        MakeAnAppointmentRequestVO makeAnAppointmentRequestVO = (MakeAnAppointmentRequestVO)dayGatewayResponse.getBody();
        AppointmentRecordEntity appointmentRecordEntity = this.buildnewSuccessAppointmentRecordEntity(sysAppointmnetId, makeAnAppointmentRequestVO, createOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\uff1aappointmentRecordEntity:{}", (Object)appointmentRecordEntity);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\u6210\u529f");
        AppointmentRecordEntity recordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setOrderId(String.valueOf(recordEntity.getId()));
        String endTime = createOrderVoReq.getAdmDate() + " " + createOrderVoReq.getEndTime() + ":00";
        String starTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis());
        String time = DateUtils.getTime((String)starTime, (String)endTime);
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo), (String)time);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    public String dayAppointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException, ParseException {
        Integer hours = LocalDateTime.now().getHour();
        String endData = createOrderVoReq.getAdmDate() + " " + createOrderVoReq.getEndTime() + ":00";
        if (DateUtils.compareTime((String)endData) == -1) {
            throw new AppointmentException("\u8be5\u53f7\u6e90\u5df2\u8fc7\u53d6\u53f7\u65f6\u95f4");
        }
        MakeAnAppointmentRequestDTO makeAnAppointmentRequestDTO = this.buildMakeAnAppointmentRequestDTO(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2===================^.^\uff1a" + JSON.toJSONString((Object)makeAnAppointmentRequestDTO));
        FrontResponse dayGatewayResponse = this.appointApi.confirmRegister(makeAnAppointmentRequestDTO);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2===================^.^\uff1a" + JSON.toJSONString((Object)dayGatewayResponse));
        if (null == dayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMessage());
            throw new AppointmentException(dayGatewayResponse.getMessage());
        }
        if (null == dayGatewayResponse.getBody()) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(dayGatewayResponse.getMessage());
        }
        String sysAppointmnetId = UUIDUtils.getUUID();
        MakeAnAppointmentRequestVO makeAnAppointmentRequestVO = (MakeAnAppointmentRequestVO)dayGatewayResponse.getBody();
        AppointmentRecordEntity appointmentRecordEntity = this.dayBuildnewSuccessAppointmentRecordEntity(sysAppointmnetId, makeAnAppointmentRequestVO, createOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\uff1aappointmentRecordEntity:{}", (Object)appointmentRecordEntity);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\u6210\u529f");
        AppointmentRecordEntity recordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setOrderId(String.valueOf(recordEntity.getId()));
        String starTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(System.currentTimeMillis());
        String time = DateUtils.getTime((String)starTime, (String)endData);
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo), (String)time);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private MakeAnAppointmentRequestDTO buildMakeAnAppointmentRequestDTO(AppointmentCreateOrderVoReq createOrderVoReq) {
        MakeAnAppointmentRequestDTO makeAnAppointmentRequestDTO = new MakeAnAppointmentRequestDTO();
        makeAnAppointmentRequestDTO.setHospitalCode(createOrderVoReq.getHospitalCode());
        makeAnAppointmentRequestDTO.setPid(createOrderVoReq.getPatientCardNo());
        makeAnAppointmentRequestDTO.setDeptCode(createOrderVoReq.getDeptCode());
        makeAnAppointmentRequestDTO.setDoctorId("");
        if (!createOrderVoReq.getDocCode().equals("\u666e\u901a\u53f7")) {
            makeAnAppointmentRequestDTO.setDoctorId(createOrderVoReq.getDocCode());
        }
        makeAnAppointmentRequestDTO.setRequestDay(createOrderVoReq.getAdmDate());
        makeAnAppointmentRequestDTO.setAmPm(createOrderVoReq.getAdmTimeRange());
        makeAnAppointmentRequestDTO.setBegTime(createOrderVoReq.getStarTime());
        makeAnAppointmentRequestDTO.setEndTime(createOrderVoReq.getEndTime());
        makeAnAppointmentRequestDTO.setLevelCode(createOrderVoReq.getLevelCode());
        makeAnAppointmentRequestDTO.setCertNo(createOrderVoReq.getIdNo());
        return makeAnAppointmentRequestDTO;
    }

    private FrontRequest<ConfirmRegisterReq> buildConfirmRegisterReq(AppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        FrontRequest frontRequest = new FrontRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setDeptNo(createOrderVoReq.getDeptCode());
        confirmRegisterReq.setPatientId(createOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setDoctorNo(createOrderVoReq.getDocCode());
        confirmRegisterReq.setTimeFlag(createOrderVoReq.getAdmTimeRange());
        confirmRegisterReq.setClinicDate(createOrderVoReq.getAdmDate());
        confirmRegisterReq.setAdmNo(createOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setFlowNo(createOrderVoReq.getLocName());
        confirmRegisterReq.setMedicalFee(createOrderVoReq.getStarTime());
        confirmRegisterReq.setPayChannel("\u652f\u4ed8\u5b9d\u5e73\u53f0");
        confirmRegisterReq.setRegFee(createOrderVoReq.getEndTime());
        if (null == createOrderVoReq.getAdmDate()) {
            throw new AppointmentException("\u9884\u7ea6\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7aadmDate");
        }
        confirmRegisterReq.setTimeArrangeId(createOrderVoReq.getAdmDate());
        frontRequest.setBody((Object)confirmRegisterReq);
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        scheduleResItemsList.removeIf(o -> !o.getScheduleId().equals(appointmentCreateOrderVoReq.getScheduleHisId()));
        getScheduleResVO.setItems(scheduleResItemsList);
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)scheduleResItemsList.get(0);
        if (!Objects.isNull(appointmentCreateOrderVoReq.getScheduleHisId())) {
            List collect = scheduleResItemsList.stream().filter(i -> appointmentCreateOrderVoReq.getScheduleHisId().equals(i.getScheduleId())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
                throw new AppointmentException("\u5f53\u524d\u6392\u73ed\u5df2\u88ab\u5360\u7528\uff0c\u5237\u65b0\u540e\u91cd\u8bd5");
            }
            getScheduleResItems = (GetScheduleResItems)collect.get(0);
        }
        return getScheduleResItems;
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems, String patientId) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(confirmRegisterRes.getTakeTime());
        appointmentRecordEntity.setAdmTimeRange(TimeArrangeIdTypeEnum.getDisplay((String)createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentNo(confirmRegisterRes.getNo());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientId(patientId);
        appointmentRecordEntity.setAdmTimeRange(confirmRegisterRes.getAdmitTimeRange());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientCardNo(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setCardId(cardDetail.getCardId());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
        }
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getCardId());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItems.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItems.getScheduleId());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u6210\u529f\uff0c\u5f85\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildnewSuccessAppointmentRecordEntity(String sysAppointmentId, MakeAnAppointmentRequestVO makeAnAppointmentRequestVO, AppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(makeAnAppointmentRequestVO.getOrderNo());
        appointmentRecordEntity.setAppointmentNo(makeAnAppointmentRequestVO.getPreRegNo());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setAdmAddress(makeAnAppointmentRequestVO.getDeptLocDesc() + "-" + makeAnAppointmentRequestVO.getDeptName());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        if (createOrderVoReq.getAdmTimeRange().equals("a")) {
            appointmentRecordEntity.setAdmRange(1);
        } else if (createOrderVoReq.getAdmTimeRange().equals("p")) {
            appointmentRecordEntity.setAdmRange(2);
        } else {
            appointmentRecordEntity.setAdmRange(5);
        }
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)createOrderVoReq.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(makeAnAppointmentRequestVO.getDeptName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName("\u82cf\u5dde\u5927\u5b66\u9644\u5c5e\u7b2c\u4e00\u533b\u9662");
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getStarTime() + "-" + createOrderVoReq.getEndTime());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientCardNo(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        BigDecimal totalFee = new BigDecimal(createOrderVoReq.getRegFee()).add(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(createOrderVoReq.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setRegTitleName(createOrderVoReq.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(createOrderVoReq.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setSysAppointmentId(sysAppointmentId);
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u6210\u529f\uff0c\u5f85\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity dayBuildnewSuccessAppointmentRecordEntity(String sysAppointmentId, MakeAnAppointmentRequestVO makeAnAppointmentRequestVO, AppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(makeAnAppointmentRequestVO.getOrderNo());
        appointmentRecordEntity.setAppointmentNo(makeAnAppointmentRequestVO.getPreRegNo());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setAdmAddress(makeAnAppointmentRequestVO.getDeptLocDesc() + "-" + makeAnAppointmentRequestVO.getDeptName());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        if (createOrderVoReq.getAdmTimeRange().equals("a")) {
            appointmentRecordEntity.setAdmRange(1);
        } else if (createOrderVoReq.getAdmTimeRange().equals("p")) {
            appointmentRecordEntity.setAdmRange(2);
        } else {
            appointmentRecordEntity.setAdmRange(5);
        }
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)createOrderVoReq.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(makeAnAppointmentRequestVO.getDeptName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName("\u82cf\u5dde\u5927\u5b66\u9644\u5c5e\u7b2c\u4e00\u533b\u9662");
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getStarTime() + "-" + createOrderVoReq.getEndTime());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientCardNo(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        BigDecimal totalFee = new BigDecimal(createOrderVoReq.getRegFee()).add(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(createOrderVoReq.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setRegTitleName(createOrderVoReq.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(createOrderVoReq.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setSysAppointmentId(sysAppointmentId);
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u5f53\u65e5\u6302\u53f7\u6210\u529f\uff0c\u5f85\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) throws Exception {
        BaseResponse baseResponse = new BaseResponse();
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dayAppointmentPayVoReq));
        String orderNo = dayAppointmentPayVoReq.getSysAppointmentId();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(orderNo);
        String getDateValue = this.jedisCluster.get("AppointmentPayDate" + orderNo);
        log.info("\u4e8c\u6b21\u62c9\u8d77\u8ba2\u5355\u53f7\uff1a" + JSON.toJSONString((Object)orderNo));
        log.info("redis\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u652f\u4ed8\u4fe1\u606f\uff1a" + getDateValue);
        if (getDateValue != null) {
            baseResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
            baseResponse.setCode("1");
            baseResponse.setData((Object)getDateValue);
            log.info("\u95e8\u8bca\u7f34\u8d39\u4e8c\u6b21\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
            return baseResponse;
        }
        if (appointmentRecordEntity == null) {
            return BaseResponse.error((String)"\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u5931\u8d25");
        }
        String admTimeRange = appointmentRecordEntity.getAdmTimeRange();
        String starTime = appointmentRecordEntity.getAdmDate() + " " + admTimeRange.substring(0, 5) + ":00";
        String endTime = appointmentRecordEntity.getAdmDate() + " " + admTimeRange.substring(6, 11) + ":00";
        if (DateUtils.compareTime((String)starTime) == -1 && DateUtils.compareTime((String)endTime) == 1) {
            if (Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.PAY.getValue()) || !Objects.equals(appointmentRecordEntity.getAppointStatus(), AppointmentStatusEnum.WAIT_PAY.getValue())) {
                return BaseResponse.error((String)"\u8be5\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u8bf7\u52ff\u53cd\u590d\u64cd\u4f5c");
            }
            PayOrderVO request = new PayOrderVO();
            request.setOpenId(dayAppointmentPayVoReq.getOpenId());
            request.setOrdNo(appointmentRecordEntity.getSysAppointmentId());
            request.setAmt(Integer.valueOf(NumberUtils.formatAmtY2F((String)appointmentRecordEntity.getPayAmount())));
            request.setBsOrdNo(dayAppointmentPayVoReq.getSysAppointmentId());
            request.setPatientId(appointmentRecordEntity.getPatientCardNo());
            request.setBusTye("1");
            request.setBusSubTye("1");
            request.setNotifyUrl("");
            if (Objects.isNull(appointmentRecordEntity.getPatientName())) {
                return BaseResponse.error((String)"\u60a3\u8005\u59d3\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u652f\u4ed8");
            }
            request.setPatientName(appointmentRecordEntity.getPatientName());
            request.setDesc("\u667a\u6167\u5c31\u533b\u6302\u53f7\u652f\u4ed8");
            String sdyTradeServer = SdyPayUtils.createSdyTradeServer((PayOrderVO)request, (String)(dayAppointmentPayVoReq.getHospitalCode().equals("pj") ? "1" : "2"));
            PayOrderDTO data = (PayOrderDTO)JSON.parseObject((String)sdyTradeServer, PayOrderDTO.class);
            log.info("\u9996\u6b21\u62c9\u8d77\u56de\u8c03\u4fe1\u606f\u5b58redis\uff1a" + sdyTradeServer);
            String payOrderKey = "AppointmentPayDate" + appointmentRecordEntity.getSysAppointmentId();
            String set = this.jedisCluster.set(payOrderKey, sdyTradeServer);
            this.jedisCluster.expire(payOrderKey, 1800);
            log.info("redis\u4e2d\u5b58\u4e00\u6b21\u56de\u8c03\u4fe1\u606f\u662f\u5426\u6210\u529f\uff1a" + JSON.toJSONString((Object)set));
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setType(1);
            payOrder.setOrderNo(appointmentRecordEntity.getSysAppointmentId());
            payOrder.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            payOrder.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
            payOrder.setDealTradeNo(data.getTsPayId());
            payOrder.setPayTime(new Date());
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            return BaseResponse.success((Object)sdyTradeServer);
        }
        return BaseResponse.error((String)"\u8bf7\u5728\u9884\u7ea6\u65f6\u95f4\u6bb5\u5185\u7f34\u8d39!");
    }

    public AppointmentPayVoReq byPayData(DayAppointmentPayVoReq dayAppointmentPayVoReq, AppointmentRecordEntity appointmentRecordEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        appointmentPayVoReq.setNonceStr(SignUtil.getNonceStr());
        appointmentPayVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        appointmentPayVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)appointmentPayVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        appointmentPayVoReq.setSign(sign);
        return appointmentPayVoReq;
    }

    private PayOrderVO buildPayOrderVO(DayAppointmentPayVoReq dayAppointmentPayVoReq, AppointmentRecordEntity appointmentRecordEntity, long orderSeq) {
        PayOrderVO request = new PayOrderVO();
        if ((dayAppointmentPayVoReq.getPayChannel().equals(PayChannelEnum.WECHAT.getValue()) || dayAppointmentPayVoReq.getPayChannel().equals(PayChannelEnum.ALIPAY.getValue())) && dayAppointmentPayVoReq.getPayType().equals(WeChatPayTypeEnum.JSAPI.getDisplay())) {
            request.setOpenId(dayAppointmentPayVoReq.getUserSign());
        }
        request.setOrdNo(String.valueOf(orderSeq));
        BigDecimal divide = appointmentRecordEntity.getRegFee().multiply(new BigDecimal(100));
        log.info("\u8ba2\u5355\u539f\u652f\u4ed8\u91d1\u989d\uff1a{}(\u5143)\uff0c\u8f6c\u6362\u5206\u5355\u4f4d\u540e\u91d1\u989d\uff1a{}(\u5206)", (Object)appointmentRecordEntity.getRegFee(), (Object)divide.intValue());
        BigDecimal dividey = BigDecimal.valueOf(divide.intValue()).divide(new BigDecimal(100));
        request.setAmt(Integer.valueOf(divide.intValue()));
        request.setDesc("");
        request.setNotifyUrl("http://10.7.0.142:9098/paymentPlatforms/payAsynchronousNotifications");
        request.setExpireSecond("");
        request.setBsOrdNo(appointmentRecordEntity.getAppointmentId());
        request.setCashierNo("");
        request.setCashierName("");
        request.setPatientId(appointmentRecordEntity.getPatientId());
        request.setPatientName("");
        request.setInvoiceNo("");
        request.setBusTye("");
        request.setBusSubTye("6");
        request.setHospitalAreaTye(HospitalCodeEnum.getDisplay((Integer)dayAppointmentPayVoReq.getOrganId()));
        request.setPaySource("3");
        return request;
    }

    private MakeAnAppointmentNewReqDTO buildMakeAnAppointmentNewReqDTO(DayAppointmentPayVoReq dayAppointmentPayVoReq, AppointmentRecordEntity appointmentRecordEntity, PayOrderDTO data) {
        MakeAnAppointmentNewReqDTO makeAnAppointmentNewReqDTO = new MakeAnAppointmentNewReqDTO();
        makeAnAppointmentNewReqDTO.setHospitalCode(HospitalCodeEnum.getDisplay((Integer)dayAppointmentPayVoReq.getOrganId()));
        makeAnAppointmentNewReqDTO.setRegType(dayAppointmentPayVoReq.getFundType());
        makeAnAppointmentNewReqDTO.setOrderNo(appointmentRecordEntity.getAppointmentId());
        makeAnAppointmentNewReqDTO.setResponseType(ResponseTypeEnums.APPOINTMENT_REGISTRATION.getValue());
        makeAnAppointmentNewReqDTO.setOwnCost(String.valueOf(appointmentRecordEntity.getRegFee()));
        makeAnAppointmentNewReqDTO.setOwnPayType(PayTypeEnum.getName((String)dayAppointmentPayVoReq.getPayChannel()));
        makeAnAppointmentNewReqDTO.setOwnPayTransNo(data.getTsPayId());
        return makeAnAppointmentNewReqDTO;
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = com.ebaiyihui.wisdommedical.util.HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            this.taskExecutor.execute(() -> {
                String data = (String)baseResponse.getData();
                String prepayId = data.substring(data.indexOf("prepay_id=") + 10, data.indexOf("\",\"paySign"));
                log.info("prepayId: " + prepayId);
                String sysAppointmentId = appointmentPayVoReq.getOutTradeNo();
                this.jedisCluster.set(sysAppointmentId, prepayId);
                this.jedisCluster.expire(sysAppointmentId, 518400);
            });
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private GatewayRequest<PayRegistrationReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setPayChannel("3");
        payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getOutTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(confirmAppointmentVo.getDocCode())).collect(Collectors.toList());
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getHisSchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_SCHEDULE.getValue(), gatewayRequest, GetScheduleResVO.class);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(getScheduleResItems.getRegFee());
        confirmAppointmentVo.setDiagFee(getScheduleResItems.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!WAIT_CONFIRMED.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if ("1".equals(baseResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public BaseResponse<String> cancelAppointment(String sysAppointmentId, Integer appCode) throws Exception {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u5f53\u524d\u6302\u53f7\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            return BaseResponse.error((String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88 \u8bf7\u8054\u7cfb\u7a97\u53e3\u8fdb\u884c\u53d6\u6d88");
        }
        CancellationRequestDTO cancellationRequestDTO = this.buildCancellationRequestDTO(appointmentRecordEntity, appCode);
        String result = null;
        try {
            String url = this.propertiesConstant.getSdyFrontUrl() + "/appoint/register/cancel";
            log.info("\u8bf7\u6c42his\u7684url-{},\u53d6\u6d88\u9884\u7ea6\u5165\u53c2->{}", (Object)url, (Object)JSON.toJSONString((Object)cancellationRequestDTO.toString()));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)cancellationRequestDTO));
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)result, FrontResponse.class);
            log.info("\u8bf7\u6c42his\u53d6\u6d88\u9884\u7ea6\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse.toString()));
            if ("1".equals(frontResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
                appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
                int n = this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return BaseResponse.success();
    }

    private CancellationRequestDTO buildCancellationRequestDTO(AppointmentRecordEntity appointmentRecordEntity, Integer appCode) {
        CancellationRequestDTO cancellationRequestDTO = new CancellationRequestDTO();
        cancellationRequestDTO.setHospitalCode(HospitalCodeEnum.getDisplay((Integer)appCode));
        cancellationRequestDTO.setPid(appointmentRecordEntity.getPatientCardNo());
        cancellationRequestDTO.setCertType(IdCardTypeEnum.ID_CARD.getValue());
        cancellationRequestDTO.setCertNo(appointmentRecordEntity.getPatientIdCard());
        cancellationRequestDTO.setPreRegNo(appointmentRecordEntity.getAppointmentId());
        cancellationRequestDTO.setOrderNo(appointmentRecordEntity.getScheduleHisId());
        return cancellationRequestDTO;
    }

    public BaseResponse<PaymentResultsDTO> appointmentPayResultInquiry(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(dayAppointmentPayVoReq.getSysAppointmentId());
        PaymentInquiryVO paymentInquiryVO = new PaymentInquiryVO();
        paymentInquiryVO.setOrdNo(appointmentPayorderEntity.getDealSeq());
        String result = null;
        try {
            String url = this.propertiesConstant.getSdyFrontUrl() + "/paymentPlatforms/paymentResultInquiry";
            log.info("\u8bf7\u6c42his\u7684url-{},\u82cf\u5927\u4e00\u81ea\u8d39\u4e3b\u52a8\u67e5\u8be2\u5165\u53c2->{}", (Object)url, (Object)JSON.toJSONString((Object)paymentInquiryVO.toString()));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)paymentInquiryVO));
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)result, FrontResponse.class);
            log.info("\u8bf7\u6c42his\u82cf\u5927\u4e00\u81ea\u8d39\u4e3b\u52a8\u67e5\u8be2\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse.toString()));
            if ("1".equals(frontResponse.getCode())) {
                BaseResponse payOrderResponse = (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
                log.info(JSON.toJSONString((Object)payOrderResponse));
                PaymentResultsDTO data = (PaymentResultsDTO)JSON.parseObject((String)JSON.toJSONString((Object)payOrderResponse.getData()), PaymentResultsDTO.class);
                if ("1".equals(data.getOrdSts())) {
                    appointmentPayorderEntity.setOrderStatus(Byte.valueOf((byte)1));
                }
                this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
                return payOrderResponse;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public BaseResponse refundCalls(RequestRefundVo param) {
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(param.getSysAppointmentId());
        long refundSeq = this.snowflakeIdWorker.nextId();
        if (CardTypeEnum.OWN_EXPENSE.getValue().equals(appointmentPayorderEntity.getBizSysSeq())) {
            PaymentRefundVO request = new PaymentRefundVO();
            request.setRefundOrdNo(String.valueOf(refundSeq));
            request.setOrgPayOrdNo(appointmentPayorderEntity.getDealSeq());
            BigDecimal divide = appointmentPayorderEntity.getDealMoney().multiply(new BigDecimal(100));
            log.info("\u8ba2\u5355\u539f\u652f\u4ed8\u91d1\u989d\uff1a{}(\u5143)\uff0c\u8f6c\u6362\u5206\u5355\u4f4d\u540e\u91d1\u989d\uff1a{}(\u5206)", (Object)appointmentPayorderEntity.getDealMoney(), (Object)divide.intValue());
            BigDecimal dividey = BigDecimal.valueOf(divide.intValue()).divide(new BigDecimal(100));
            request.setAmt(Integer.valueOf(divide.intValue()));
            request.setDesc("");
            request.setNotifyUrl("http://10.7.0.142:9098/paymentPlatforms/refundAsynchronousNotification");
            request.setCashierNo("");
            request.setCashierName("");
            String result = null;
            try {
                String url = this.propertiesConstant.getSdyFrontUrl() + "/paymentPlatforms/paymentRefund";
                log.info("\u8bf7\u6c42his\u7684url-{},\u82cf\u5927\u4e00\u81ea\u8d39\u9000\u8d39\u5165\u53c2->{}", (Object)url, (Object)JSON.toJSONString((Object)request.toString()));
                result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)request));
                FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)result, FrontResponse.class);
                log.info("\u8bf7\u6c42his\u82cf\u5927\u4e00\u81ea\u8d39\u9000\u8d39\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse.toString()));
                if ("1".equals(frontResponse.getCode())) {
                    BaseResponse payOrderResponse = (BaseResponse)JSON.parseObject((String)result, BaseResponse.class);
                    log.info(JSON.toJSONString((Object)payOrderResponse));
                    PaymentResultsDTO data = (PaymentResultsDTO)JSON.parseObject((String)JSON.toJSONString((Object)payOrderResponse.getData()), PaymentResultsDTO.class);
                    this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
                    return payOrderResponse;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void checkRegistBase(String idNo, String deptCode) throws AppointmentException {
        Period period = Period.between(LocalDate.parse(IdCardUtil.getBirthByIdCard((String)idNo), DateTimeFormatter.ofPattern("yyyyMMdd")), LocalDate.now());
        if ("10248".equals(deptCode)) {
            if (period.getYears() == 0 && period.getMonths() <= 7) {
                return;
            }
            throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u65b0\u751f\u513f\u95e8\u8bca\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e7\u4e2a\u6708)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
        }
        List<String> pediatricList = Arrays.asList("1015");
        if (pediatricList.contains(deptCode)) {
            if (period.getYears() > 14) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u513f\u79d1\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e14\u5c81)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
            }
            return;
        }
        List<String> gynaecologyList = Arrays.asList("1044");
        if (gynaecologyList.contains(deptCode)) {
            String gender = IdCardUtil.getGenderByIdCard((String)idNo);
            if ("M".equals(gender)) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u5987\u4ea7\u79d1\u6302\u53f7\u6761\u4ef6(\u4ec5\u9650\u5973\u6027)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6539\u6210\u9009\u62e9\u5176\u4ed6\u5c31\u8bca\u4eba\uff01");
            }
            return;
        }
    }
}

