/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.HttpKit;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.HospitalCodeEnum;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoctorReqDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorServiceImpl
implements DoctorService {
    private static final Logger log = LoggerFactory.getLogger(DoctorServiceImpl.class);
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ProPropertiesConstant proPropertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;

    public DoctorRecordEntity getDoctorRecordEntity(String doctorId, String hospitalCode) {
        return this.doctorRecordMapper.selectByDoctorIdAndHospitalCode(doctorId, hospitalCode);
    }

    public List<DoctorRecordEntity> getDoctorIdList(List<String> doctorCodes, String organId) {
        return this.doctorRecordMapper.getDoctorIdList(doctorCodes, organId);
    }

    public DoctorRecordEntity getDoctorRecordByDoctorCodeAndHosCode(String doctorCode, String organCode) {
        return this.doctorRecordMapper.getDoctorRecordByDoctorCodeAndHosCode(doctorCode, organCode);
    }

    public void updateDoctorIdByDoctorCode(String doctorId, String doctorCode, String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, doctorCode);
        if (doctorRecordEntity != null) {
            this.doctorRecordMapper.updateDoctorIdByDoctorCode(doctorId, doctorCode, hospitalCode);
        }
    }

    public List<Long> getDoctorCodeListBydoctorIds(String doctorIds) {
        List doctorCodeList = this.doctorRecordMapper.getDoctorCodeList(doctorIds, this.proPropertiesConstant.getOrganCode());
        List<Long> doctorIdList = doctorCodeList.stream().map(doctorRecordEntity -> {
            if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        return doctorIdList;
    }

    public List<ScheduleDoctorVoRes> getScheduleDoctor(ScheduleDoctorVoReq scheduleDoctorVoReq) throws DoctorScheduleException {
        ArrayList<ScheduleDoctorVoRes> scheduleDoctorVoResList = new ArrayList<ScheduleDoctorVoRes>();
        DoctorReqDTO doctorReqDTO = this.buildDoctorReqDTO(scheduleDoctorVoReq);
        String result = null;
        try {
            String url = this.proPropertiesConstant.getSdyFrontUrl() + "/doctor/getDoctorList";
            log.info("\u8bf7\u6c42his\u7684url-{},\u6839\u636e\u53f7\u7c7b\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u5165\u53c2->{}", (Object)url, (Object)JSON.toJSONString((Object)doctorReqDTO.toString()));
            result = HttpKit.jsonPost((String)url, (String)JSON.toJSONString((Object)doctorReqDTO));
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)result, FrontResponse.class);
            log.info("\u8bf7\u6c42his\u6839\u636e\u53f7\u7c7b\u83b7\u53d6\u533b\u751f\u4fe1\u606f\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse.toString()));
            if ("1".equals(frontResponse.getCode())) {
                ((List)frontResponse.getBody()).stream().forEach(item -> {
                    ScheduleDoctorVoRes scheduleDoctorVoRes = new ScheduleDoctorVoRes();
                    BeanUtils.copyProperties((Object)item, (Object)scheduleDoctorVoRes);
                    scheduleDoctorVoResList.add(scheduleDoctorVoRes);
                });
                HashMap<String, Object> params = new HashMap<String, Object>();
                List emplCodeList = scheduleDoctorVoResList.stream().map(e -> e.getDoctorId()).collect(Collectors.toList());
                params.put("emplCodeList", emplCodeList);
                params.put("organId", String.valueOf(scheduleDoctorVoReq.getOrganId()));
                List getDoctorBaseInfoVos = this.getDoctorInfoUtil.getDoctorInfoList(params);
                scheduleDoctorVoResList.stream().forEach(item -> {
                    for (GetDoctorBaseInfoVo getDoctorBaseInfoVo : getDoctorBaseInfoVos) {
                        if (!item.getDoctorId().equals(getDoctorBaseInfoVo.getEmplCode())) continue;
                        ScheduleDoctorVoRes scheduleDoctorVoRes = new ScheduleDoctorVoRes();
                        BeanUtils.copyProperties((Object)item, (Object)scheduleDoctorVoRes);
                    }
                });
                log.info("\u83b7\u53d6\u79d1\u5ba4\u5217\u8868\u51fa\u53c2->{}", (Object)JSON.toJSONString(scheduleDoctorVoResList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            }
        }
        catch (Exception e2) {
            log.info("\u6392\u73ed\u533b\u751f\u4fe1\u606f\u83b7\u53d6\u5931\u8d25 ->{}", (Throwable)e2);
            throw new DoctorScheduleException("\u83b7\u53d6\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5931\u8d25!");
        }
        return scheduleDoctorVoResList;
    }

    public BaseResponse<GetDoctorBaseInfoVo> getDoctorBasicInfo(String docCode, String organId) {
        if (StringUtils.isBlank((CharSequence)docCode)) {
            return BaseResponse.error((String)"docCode\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)organId)) {
            return BaseResponse.error((String)"organId\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        GetDoctorBaseInfoVo getDoctorBaseInfoVo = new GetDoctorBaseInfoVo();
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            ArrayList<Long> emplCodeList = new ArrayList<Long>();
            emplCodeList.add(Long.valueOf(docCode));
            params.put("emplCodeList", emplCodeList);
            params.put("organId", organId);
            List getDoctorBaseInfoVos = this.getDoctorInfoUtil.getDoctorInfoList(params);
            if (null == getDoctorBaseInfoVos || getDoctorBaseInfoVos.size() == 0) {
                return BaseResponse.success((Object)getDoctorBaseInfoVo);
            }
            getDoctorBaseInfoVo.setContactMobile(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getContactMobile());
            getDoctorBaseInfoVo.setCredNo(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getCredNo());
            getDoctorBaseInfoVo.setCredType(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getCredType());
            getDoctorBaseInfoVo.setEmplCode(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getEmplCode());
            getDoctorBaseInfoVo.setGender(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getGender());
            getDoctorBaseInfoVo.setHeadPortrait(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getHeadPortrait());
            getDoctorBaseInfoVo.setId(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getId());
            getDoctorBaseInfoVo.setSpeciality(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getSpeciality());
            getDoctorBaseInfoVo.setName(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getName());
            getDoctorBaseInfoVo.setOrganId(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getOrganId());
            getDoctorBaseInfoVo.setRegisterMobile(((GetDoctorBaseInfoVo)getDoctorBaseInfoVos.get(0)).getRegisterMobile());
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)"\u670d\u52a1\u51fa\u73b0\u9519\u8bef");
        }
        return BaseResponse.success((Object)getDoctorBaseInfoVo);
    }

    private DoctorReqDTO buildDoctorReqDTO(ScheduleDoctorVoReq scheduleDoctorVoReq) {
        DoctorReqDTO doctorReqDTO = new DoctorReqDTO();
        doctorReqDTO.setHospitalCode(HospitalCodeEnum.getDisplay((Integer)scheduleDoctorVoReq.getOrganId()));
        doctorReqDTO.setSchDate(scheduleDoctorVoReq.getSchDate());
        if (Objects.nonNull(scheduleDoctorVoReq.getDeptCode())) {
            doctorReqDTO.setDeptCode(scheduleDoctorVoReq.getDeptCode());
        }
        return doctorReqDTO;
    }
}

