/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.api.InHospitalClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItemsDetail;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.wisdommedical.common.NumberTimeEnum;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayWayCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.dto.PayOrderDTO;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PayOrder;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.vo.PayOrderVO;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.NumberUtils;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.RedisUtil;
import com.ebaiyihui.wisdommedical.util.SdyPayUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private InHospitalClient InHospitalApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    JedisCluster jedisCluster;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private InHospitalClient inHospitalClient;

    public List<GetInpAdmissionResItems> getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        FrontRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            return new ArrayList<GetInpAdmissionResItems>();
        }
        return getInpAdmissionResItemsList;
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        BigDecimal detailTotalMoney = new BigDecimal("0");
        FrontRequest gatewayRequest = this.buildGetRechargeDetailReq(inHospitalRechargeDetailReqVO);
        List rechargeDetailList = this.getRechargeDetail(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)rechargeDetailList)) {
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u9884\u4ea4\u91d1\u5145\u503c\u660e\u7ec6\u8bb0\u5f55");
        }
        for (GetIPDepositRecordsItems items : rechargeDetailList) {
            if (null == items.getAmout()) continue;
            detailTotalMoney = detailTotalMoney.add(new BigDecimal(items.getAmout()));
        }
        for (GetIPDepositRecordsItems getIPDepositRecordsItems : rechargeDetailList) {
            getIPDepositRecordsItems.setPrePayDateTime(getIPDepositRecordsItems.getPrePayDateTime().substring(0, 19));
            if (null != getIPDepositRecordsItems.getAmout()) {
                getIPDepositRecordsItems.setAmout(getIPDepositRecordsItems.getAmout());
            }
            if (null == getIPDepositRecordsItems.getPayChannel() || getIPDepositRecordsItems.getPayChannel().equals("")) continue;
            getIPDepositRecordsItems.setPayChannel(PayWayCodeEnum.getDisplay((String)getIPDepositRecordsItems.getPayChannel()));
        }
        List collect = rechargeDetailList.stream().sorted(Comparator.comparing(GetIPDepositRecordsItems::getPrePayDateTime).reversed()).collect(Collectors.toList());
        inHospitalRechargeDetailResVO.setDetailTotalMoney(String.valueOf(detailTotalMoney));
        inHospitalRechargeDetailResVO.setDetailRechargeList(collect);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        FrontRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        GetOrdItemsRes getOrdItemsRes = this.getInHospFeeDetail(getOrdItemsReqGatewayRequest);
        if (null == getOrdItemsRes) {
            new GetOrdItemsRes();
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        BeanUtils.copyProperties((Object)getOrdItemsRes, (Object)getIhHospitalOrderItemsResVo);
        List getOrdItemsResItemsList = getOrdItemsRes.getDetail();
        if (CollectionUtils.isEmpty((Collection)getOrdItemsResItemsList)) {
            return getIhHospitalOrderItemsResVo;
        }
        List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getAmount())).collect(Collectors.toList());
        log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u4e3a:{}", (Object)getOrdItemsResItemsList);
        BigDecimal totalMoney = new BigDecimal("0");
        for (BigDecimal amount : amountList) {
            totalMoney = totalMoney.add(amount);
        }
        Map getOrdItemsResItemsMap = getOrdItemsResItemsList.stream().collect(Collectors.groupingBy(GetOrdItemsResItemsDetail::getFeeType, Collectors.toList()));
        log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u7684\u533b\u5631\u96c6\u5408\u4e3a:{}", getOrdItemsResItemsMap);
        ArrayList ihHospitalOrderFreeTypeVoList = new ArrayList();
        getOrdItemsResItemsMap.keySet().forEach(freeType -> {
            IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
            ihHospitalOrderFreeTypeVo.setFreeType(freeType);
            ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList((List)getOrdItemsResItemsMap.get(freeType));
            ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        });
        getIhHospitalOrderItemsResVo.setTotalMoney(totalMoney);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        log.info("\u521b\u5efa\u4f4f\u9662\u9884\u4ea4\u91d1\u8ba2\u5355\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)inHospDepositCreateOrderReqVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setOrganCode(this.propertiesConstant.getOrganCode());
        getInpAdmissionReqVO.setChannelCode(inHospDepositCreateOrderReqVO.getChannelCode());
        getInpAdmissionReqVO.setHospitalCode(inHospDepositCreateOrderReqVO.getHospitalCode());
        getInpAdmissionReqVO.setCredNo(inHospDepositCreateOrderReqVO.getCredNo());
        FrontRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
        getInpAdmissionResItems.setPatientId(inHospDepositCreateOrderReqVO.getCardId());
        getInpAdmissionResItems.setPatientName(inHospDepositCreateOrderReqVO.getPatientName());
        getInpAdmissionResItems.setTotalMoney(inHospDepositCreateOrderReqVO.getRechargeMoney());
        getInpAdmissionResItemsList.add(getInpAdmissionResItems);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            throw new InHospitalException("\u901a\u8fc7\u4f4f\u9662\u53f7\u672a\u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f,\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0), inHospDepositCreateOrderReqVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.buildInpatientPayorderEntity(inHospDepositCreateOrderReqVO, inpatientDepositDetailEntity.getId());
        try {
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("pay\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        return this.payCreateOrder(inHospDepositPayReqVO, inpatientDepositDetailEntity);
    }

    public DepositRes InHospDeposit(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        FrontRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
        return this.getDepositRes(gatewayRequest);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        return depositCreateOrderResVO;
    }

    private FrontRequest<GetInpAdmissionReq> buildGetInpAdmissionReq(GetInpAdmissionReqVO getInpAdmissionReqVO) {
        FrontRequest gatewayRequest = new FrontRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCredNo(getInpAdmissionReqVO.getCredNo());
        getInpAdmissionReq.setHospitalCode(getInpAdmissionReqVO.getHospitalCode());
        gatewayRequest.setBody((Object)getInpAdmissionReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getInpAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getInpAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInpAdmissionItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private FrontRequest<GetIPDepositRecordsReq> buildGetRechargeDetailReq(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) {
        FrontRequest gatewayRequest = new FrontRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setInHospId(inHospitalRechargeDetailReqVO.getInHospNo());
        getIPDepositRecordsReq.setHospitalCode(inHospitalRechargeDetailReqVO.getHospitalCode());
        getIPDepositRecordsReq.setCardNo(inHospitalRechargeDetailReqVO.getCardNo());
        gatewayRequest.setBody((Object)getIPDepositRecordsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inHospitalRechargeDetailReqVO.getChannelCode()));
        gatewayRequest.setChannel(inHospitalRechargeDetailReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetRechargeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private FrontRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        FrontRequest gatewayRequest = new FrontRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        getOrdItemsReq.setHospitalCode(getHospitalOrderItemsReqVo.getHospitalCode());
        getOrdItemsReq.setCardNo(getHospitalOrderItemsReqVo.getPatientId());
        getOrdItemsReq.setFeeDate(getHospitalOrderItemsReqVo.getFreeDate());
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private FrontRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        FrontRequest gatewayRequest = new FrontRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospId(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setHospitalCode(inpatientDepositDetailEntity.getHospitalCode());
        depositReq.setCardNo(inpatientDepositDetailEntity.getCardNo());
        depositReq.setPayChannel("3");
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setPosId(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        depositReq.setRespmsg(depositRespmsg);
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private List<GetInpAdmissionResItems> getInpAdmission(FrontRequest<GetInpAdmissionReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse inpAdmission = this.inHospitalClient.getInpAdmission(gatewayRequest);
        if (null == inpAdmission) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(inpAdmission.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)inpAdmission.getErrCode(), (Object)inpAdmission.getMessage());
            return null;
        }
        GetInpAdmissionRes getInpAdmissionRes = (GetInpAdmissionRes)inpAdmission.getBody();
        if (null == getInpAdmissionRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionRes.getItems())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return null;
        }
        ArrayList items = getInpAdmissionRes.getItems();
        for (GetInpAdmissionResItems getInpAdmissionResItems : items) {
            getInpAdmissionResItems.setInHospNo(getInpAdmissionResItems.getInHospNo().replace(" ", ""));
            getInpAdmissionResItems.setStartDate(getInpAdmissionResItems.getStartDate().substring(0, 19));
            getInpAdmissionResItems.setDeptName(getInpAdmissionResItems.getDeptName().replace(" ", ""));
            getInpAdmissionResItems.setPatientName(getInpAdmissionResItems.getPatientName().replace(" ", ""));
            getInpAdmissionResItems.setNursingUnit(getInpAdmissionResItems.getNursingUnit().replace(" ", ""));
            getInpAdmissionResItems.setBed(getInpAdmissionResItems.getBed().replace(" ", ""));
            getInpAdmissionResItems.setPatientAge(String.valueOf(IdCardUtil.getAgeByIdCard((String)((GetInpAdmissionReq)gatewayRequest.getBody()).getCredNo())));
        }
        return getInpAdmissionRes.getItems();
    }

    private List<GetIPDepositRecordsItems> getRechargeDetail(FrontRequest<GetIPDepositRecordsReq> gatewayRequest) {
        ArrayList rechargeDetailList = null;
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse gatewayResponse = this.inHospitalClient.getIPDepositRecords(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = (GetIPDepositRecordsRes)gatewayResponse.getBody();
        if (null == getIPDepositRecordsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        rechargeDetailList = getIPDepositRecordsRes.getItems();
        if (null == rechargeDetailList || rechargeDetailList.isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u65e0\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8fd4\u56dehis\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868 Items:{}", (Object)getIPDepositRecordsRes.getItems());
        return rechargeDetailList;
    }

    private GetOrdItemsRes getInHospFeeDetail(FrontRequest<GetOrdItemsReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse gatewayResponse = this.InHospitalApi.getOrdItems(gatewayRequest);
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u51fa\u53c2 gatewayResponse:{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        GetOrdItemsRes getOrdItemsRes = (GetOrdItemsRes)gatewayResponse.getBody();
        if (null == getOrdItemsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        if (null == getOrdItemsRes.getDetail() || getOrdItemsRes.getDetail().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
            throw new InHospitalException("\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8d39\u7528\u6e05\u5355 OrdItems:{}", (Object)getOrdItemsRes);
        return getOrdItemsRes;
    }

    private DepositRes getDepositRes(FrontRequest<DepositReq> gatewayRequest) throws InHospitalException {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse gatewayResponse = this.inHospitalClient.deposit(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMessage());
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        DepositRes depositRes = (DepositRes)gatewayResponse.getBody();
        if (null == depositRes) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMessage());
        }
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8fd4\u56dehis\u5145\u503c\u6210\u529f\u51ed\u8bc1 depositRes:{}", (Object)depositRes);
        return depositRes;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setVisitId(inHospDepositCreateOrderReqVO.getVisitId());
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(inHospDepositCreateOrderReqVO.getInHospNo());
        depositDetailEntity.setInpatientDate(DateUtils.stringToSimpleDateJS((String)getInpAdmissionResItems.getStartDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(inHospDepositCreateOrderReqVO.getPatientId());
        depositDetailEntity.setPatientOrganId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setHospitalCode(inHospDepositCreateOrderReqVO.getHospitalCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0"));
        BigDecimal preMoneyBalance = new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0").subtract(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyBalance(preMoneyBalance);
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, Long id) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(id);
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setDealSeq("");
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(InHospDepositPayReqVO depositPayReqVO, InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        BaseResponse baseResponse = new BaseResponse();
        String sdyTradeServer = "";
        try {
            String orderNo = depositPayReqVO.getOrderSeq();
            inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderNo);
            if (inpatientDepositDetailEntity == null) {
                return BaseResponse.error((String)"\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55\u5931\u8d25");
            }
            String getDateValue = this.jedisCluster.get("OutpatientPayDate" + orderNo);
            log.info("\u4e8c\u6b21\u62c9\u8d77\u8ba2\u5355\u53f7\uff1a" + JSON.toJSONString((Object)orderNo));
            log.info("redis\u4e2d\u662f\u5426\u5b58\u5728\u8be5\u652f\u4ed8\u4fe1\u606f\uff1a" + getDateValue);
            if (getDateValue != null) {
                baseResponse.setMsg("\u64cd\u4f5c\u6210\u529f");
                baseResponse.setCode("1");
                baseResponse.setData((Object)getDateValue);
                log.info("\u95e8\u8bca\u7f34\u8d39\u4e8c\u6b21\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
                return baseResponse;
            }
            PayOrderVO request = new PayOrderVO();
            request.setOpenId(depositPayReqVO.getOpenId());
            request.setOrdNo(inpatientDepositDetailEntity.getOrderSeq());
            request.setAmt(Integer.valueOf(NumberUtils.formatAmtY2F((String)String.valueOf(inpatientDepositDetailEntity.getMoney()))));
            request.setBsOrdNo(inpatientDepositDetailEntity.getOrderSeq());
            request.setPatientId(inpatientDepositDetailEntity.getCardNo());
            request.setBusTye("2");
            request.setBusSubTye("3");
            request.setNotifyUrl("");
            if (Objects.isNull(inpatientDepositDetailEntity.getPatientName())) {
                return BaseResponse.error((String)"\u60a3\u8005\u59d3\u540d\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u652f\u4ed8");
            }
            request.setPatientName(inpatientDepositDetailEntity.getPatientName());
            request.setDesc("\u667a\u6167\u5c31\u533b\u4f4f\u9662\u5145\u503c");
            sdyTradeServer = SdyPayUtils.createSdyTradeServer((PayOrderVO)request, (String)(depositPayReqVO.getHospitalCode().equals("pj") ? "1" : "2"));
            PayOrderDTO data = (PayOrderDTO)JSON.parseObject((String)sdyTradeServer, PayOrderDTO.class);
            log.info("\u9996\u6b21\u62c9\u8d77\u56de\u8c03\u4fe1\u606f\u5b58redis\uff1a" + sdyTradeServer);
            String payOrderKey = "InHospDepositPayDate" + orderNo;
            String set = this.jedisCluster.set(payOrderKey, sdyTradeServer);
            this.jedisCluster.expire(payOrderKey, 1800);
            log.info("redis\u4e2d\u5b58\u4e00\u6b21\u56de\u8c03\u4fe1\u606f\u662f\u5426\u6210\u529f\uff1a" + JSON.toJSONString((Object)set));
            PayOrder payOrder = new PayOrder();
            payOrder.setNumber(1);
            payOrder.setType(2);
            payOrder.setOrderNo(inpatientDepositDetailEntity.getOrderSeq());
            payOrder.setTotalAmount(inpatientDepositDetailEntity.getMoney());
            payOrder.setPayChannel(depositPayReqVO.getPayChannel());
            payOrder.setDealTradeNo(data.getTsPayId());
            payOrder.setPayTime(new Date());
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)payOrder), (long)NumberTimeEnum.getDisplay((Integer)payOrder.getNumber()));
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
        }
        catch (Exception e) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
        }
        return BaseResponse.success((Object)sdyTradeServer);
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

