/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.api.NetReportClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetReportServiceImpl
implements NetReportService {
    private static final Logger log = LoggerFactory.getLogger(NetReportServiceImpl.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private NetReportClient ElectronicReportApi;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public BaseResponse<GetReportListsRes> queryReportHosList(ListReportHosReq param) throws NoSuchAlgorithmException, IOException, NoSuchProviderException, ExecutionException, InterruptedException, KeyManagementException {
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(param.getCardNo());
        listReportParam.setCredNo(param.getCredNo());
        listReportParam.setReportType(param.getReportType());
        listReportParam.setBeginTime(param.getBeginDate());
        listReportParam.setEndTime(param.getEndDate());
        FrontRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        FrontResponse reportLists = this.ElectronicReportApi.getReportLists(gatewayRequest);
        log.info("\u62a5\u544a\u8bb0\u5f55" + JSONObject.toJSONString((Object)reportLists));
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse(reportLists);
        if (gateWayData == null) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u544a\u8bb0\u5f55");
        }
        List reportDataList = gateWayData.getDatas();
        if (null == ((GetReportListsData)gateWayData.getDatas().get(0)).getReportNo()) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u544a\u8bb0\u5f55");
        }
        if (null == reportDataList || reportDataList.size() <= 0) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u62a5\u544a\u8bb0\u5f55");
        }
        reportDataList.sort(Comparator.comparing(GetReportListsData::getReportDate).reversed());
        gateWayData.setDatas(reportDataList);
        log.info("\u5217\u8868\u667a\u6167\u5c31\u533b\u51fa\u53c2{}", (Object)gateWayData);
        return BaseResponse.success((Object)gateWayData);
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        lisReportListReq.setCardNo(param.getCardNo());
        FrontRequest gateWayParam = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        FrontResponse response = this.ElectronicReportApi.lisReportList(gateWayParam);
        LisReportListRes gateWayData = (LisReportListRes)response.getBody();
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        ReportDetailRes reportDetail = new ReportDetailRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (lisReportListResDataList.size() == 0) {
            this.logger.error("request his  - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        this.logger.info(">{}", (Object)lisReportListResDataList);
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        try {
            if (StringUtils.isNotEmpty((CharSequence)reportDetail.getPatientDOB())) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date birthday = simpleDateFormat.parse(reportDetail.getPatientDOB());
                String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
                reportDetail.setAge(age);
            }
        }
        catch (ParseException e) {
            this.logger.info(e.toString());
        }
        return BaseResponse.success((Object)reportDetail);
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(FrontResponse<T> response) {
        if (response == null) {
            this.logger.error("request his  error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(response.getCode())) {
            this.logger.error("request his  error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getBody() == null) {
            this.logger.error("request his  error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        if (response.getCode().equals("0")) {
            this.logger.error(response.getMessage());
            return null;
        }
        return (T)response.getBody();
    }

    private <T> FrontRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}---{}", (Object)transactionId, (Object)JSON.toJSONString((Object)gatewayRequest));
        return gatewayRequest;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    public BaseResponse<PacsReportListRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        CardDetailsInfoRespVO cardDetail;
        LisReportListReq pacsReportListReq = new LisReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        pacsReportListReq.setReportName(param.getReportType());
        FrontRequest gatewayRequest = this.getGateWayParamNew((NetReportBaseRequest)param, (Object)pacsReportListReq);
        FrontResponse response = this.ElectronicReportApi.pacsReportList(gatewayRequest);
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse(response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        if (StringUtils.isNotBlank((CharSequence)param.getCardId()) && null != (cardDetail = this.getCardDetail(param.getCardId()))) {
            this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25=====");
            Date birth = DateUtils.stringToSimpleDate((String)cardDetail.getBirth());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)birth);
                gateWayData.setAge(String.valueOf(age));
            }
            catch (ParseException e) {
                this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u8f6c\u6362\u60a3\u8005\u5e74\u9f84\u5931\u8d25=====", (Object)e.getMessage());
            }
            gateWayData.setPatientName(cardDetail.getPatientName());
            gateWayData.setSex(String.valueOf(cardDetail.getGender()));
        }
        return BaseResponse.success((Object)gateWayData);
    }

    private <T> FrontRequest<T> getGateWayParamNew(NetReportBaseRequest baseRequest, T body) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

