/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.DowFieldListEnum;
import com.ebaiyihui.wisdommedical.common.enums.DowOutPatientFieldEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordPageResult;
import com.ebaiyihui.wisdommedical.pojo.vo.OutPatientOrderRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutPatientOrderRecordResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DowOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DowOutPatientOrderReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutPatientOrderRecordReqVo;
import com.ebaiyihui.wisdommedical.service.OrderService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.DownloadUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class OrderServiceImpl
implements OrderService {
    private static final Logger log = LoggerFactory.getLogger(OrderServiceImpl.class);
    public static final String GET_REAL_TIME_HIS_BILL_INFO = "getRealTimeHisBillInfo";
    public static final String REFUND_FLAG = "1";
    public static final String NOT_REFUND_FLAG = "0";
    public static final List<String> APPOINT_ORDER_STATUS_LIST = Arrays.asList("11", "15", "16", "17", "18");
    public static final List<String> APPOINT_ORDER_STATUS_LIST_DOW = Arrays.asList("11", "15", "16", "17", "18", "7");
    public static final List<String> OUTPATIENT_ORDER_STATUS_LIST = Arrays.asList("1", "3", "8", "9", "10", "11", "12");
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper depositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper payorderEntityMapper;
    @Autowired
    HttpServletResponse response;
    public static final String PAID = "2";

    public OrderRecordPageResult getAppointmentOrderList(OrderRecordReqVo orderRecordReqVo) {
        OrderRecordPageResult pageResult = new OrderRecordPageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        String orderStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(orderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)APPOINT_ORDER_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus();
        orderRecordReqVo.setOrderStatus(orderStatus);
        Page page = this.appointmentRecordMapper.selectPageByOrderRecordReqVo(orderRecordReqVo);
        int realCount = this.appointmentRecordMapper.getOrderRecordTotalCount(orderRecordReqVo.getHospitalCode());
        int cancelCount = this.appointmentRecordMapper.getOrderRecordCancel(orderRecordReqVo.getHospitalCode());
        int returnCount = this.appointmentRecordMapper.getOrderRecordReturn(orderRecordReqVo.getHospitalCode());
        int realAppointmentCount = this.appointmentRecordMapper.getOrderealCount(orderRecordReqVo.getHospitalCode());
        List appointmentRecordEntityList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)appointmentRecordEntityList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        pageResult.setTotalCount(Integer.valueOf(appointmentRecordEntityList.size()));
        pageResult.setCancelCount(Integer.valueOf(cancelCount));
        pageResult.setReturnCount(Integer.valueOf(returnCount));
        pageResult.setRealCount(Integer.valueOf(returnCount));
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal realMoney = BigDecimal.ZERO;
        for (AppointmentRecordEntity appointmentRecordEntity : appointmentRecordEntityList) {
            if (AppointmentStatusEnum.PAY.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
                realMoney = realMoney.add(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            }
            totalMoney = totalMoney.add(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        }
        pageResult.setRealMoney(Double.valueOf(realMoney.doubleValue()));
        pageResult.setTotalMoney(Double.valueOf(totalMoney.doubleValue()));
        List orderRecordResVoList = this.getOrderRecordResVoList(appointmentRecordEntityList);
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
        } else {
            pageResult.setContent(orderRecordResVoList);
        }
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        log.info("\u3010\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u8ba2\u5355\u5217\u8868\u3011\u8fd4\u56de\u53c2\u6570 pageResult: " + JSON.toJSONString((Object)pageResult));
        return pageResult;
    }

    public OutPatientOrderRecordPageResult getOutPatientOrderList(OutPatientOrderRecordReqVo orderRecordReqVo) {
        OutPatientOrderRecordPageResult pageResult = new OutPatientOrderRecordPageResult();
        PageHelper.startPage((int)orderRecordReqVo.getPageNum(), (int)orderRecordReqVo.getPageSize());
        String orderStatusReq = "1".equals(orderRecordReqVo.getOrderStatus()) ? "'" + StringUtils.join((Collection)OUTPATIENT_ORDER_STATUS_LIST, (String)"','") + "'" : orderRecordReqVo.getOrderStatus();
        orderRecordReqVo.setOrderStatus(orderStatusReq);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5217\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderRecordReqVo));
        Page page = this.opBusinessOrderEntityMapper.selectByOrderRecordReqVo(orderRecordReqVo);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5217\u8868\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)page));
        int totalCount = this.opBusinessOrderEntityMapper.getOrderRecordCount(orderRecordReqVo.getHospitalCode());
        Double totalMoney = this.opBusinessOrderEntityMapper.selectTotleMoneyCount(orderRecordReqVo.getHospitalCode());
        Double realMoney = this.opBusinessOrderEntityMapper.selectReturnMoneyCount(orderRecordReqVo.getHospitalCode());
        Double noMoney = this.opBusinessOrderEntityMapper.selectNoMoneyCount(orderRecordReqVo.getHospitalCode());
        int noCount = this.opBusinessOrderEntityMapper.getOrderNoCount(orderRecordReqVo.getHospitalCode());
        int realCount = this.opBusinessOrderEntityMapper.getOrderRealCount(orderRecordReqVo.getHospitalCode());
        int refundCount = this.opBusinessOrderEntityMapper.getRefundCount(orderRecordReqVo.getHospitalCode());
        Double refundMoney = this.opBusinessOrderEntityMapper.selectRefundMoney(orderRecordReqVo.getHospitalCode());
        pageResult.setRealMoney(realMoney);
        pageResult.setTotalMoney(totalMoney);
        pageResult.setTotalCount(Integer.valueOf(totalCount));
        pageResult.setNoCount(Integer.valueOf(noCount));
        pageResult.setRealCount(Integer.valueOf(realCount));
        pageResult.setNoMoney(noMoney);
        pageResult.setRefundCount(Integer.valueOf(refundCount));
        pageResult.setRefundMoney(refundMoney);
        List orderRecordResVoList = page.getResult();
        if (CollectionUtils.isEmpty((Collection)orderRecordResVoList)) {
            pageResult.setContent(new ArrayList());
            return pageResult;
        }
        for (OutPatientOrderRecordResVo orderRecordResVo : orderRecordResVoList) {
            String orderStatus = String.valueOf(orderRecordResVo.getOrderStatus());
            if (OUTPATIENT_ORDER_STATUS_LIST.contains(orderStatus)) {
                orderStatus = "1";
            }
            orderRecordResVo.setOrderStatus(Integer.valueOf(Integer.parseInt(orderStatus)));
        }
        pageResult.setContent(orderRecordResVoList);
        Long total = page.getTotal();
        double totalPages = (double)page.getTotal() / (double)page.getPageSize();
        pageResult.setPageSize(page.getPageSize());
        pageResult.setTotal(total.intValue());
        pageResult.setPageNum(page.getPageNum());
        pageResult.setTotalPages((int)Math.ceil(totalPages));
        log.info("\u3010\u7ba1\u7406\u7aef\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u5217\u8868\u3011\u8fd4\u56de\u53c2\u6570 pageResult: " + JSON.toJSONString((Object)pageResult));
        return pageResult;
    }

    public OutPatientOrderRecordVo getOutPatientOrderDetail(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        List list = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || CollectionUtils.isEmpty((Collection)list)) {
            return null;
        }
        OutPatientOrderRecordVo outPatientOrderRecordVo = new OutPatientOrderRecordVo();
        outPatientOrderRecordVo.setPatientName(opBusinessOrderEntity.getPatientName());
        outPatientOrderRecordVo.setSex(opBusinessOrderEntity.getPatientGender());
        outPatientOrderRecordVo.setAge(Integer.valueOf(opBusinessOrderEntity.getPatientAge()));
        outPatientOrderRecordVo.setDeptName(opBusinessOrderEntity.getDeptName());
        outPatientOrderRecordVo.setDocName(opBusinessOrderEntity.getDocName());
        outPatientOrderRecordVo.setAdmDate(opBusinessOrderEntity.getAdmTime());
        outPatientOrderRecordVo.setOutPatientId(outPatientId);
        outPatientOrderRecordVo.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        if (null != opBusinessOrderEntity.getPayTime() && !"".equals(opBusinessOrderEntity.getPayTime())) {
            outPatientOrderRecordVo.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        }
        outPatientOrderRecordVo.setAmount(String.valueOf(opBusinessOrderEntity.getMoney()));
        ArrayList<OutPatientOrderRecordDetailVo> orderRecordDetailVoList = new ArrayList<OutPatientOrderRecordDetailVo>();
        for (OpBusinessOrderDetailEntity entity : list) {
            OutPatientOrderRecordDetailVo outPatientOrderRecordDetailVo = new OutPatientOrderRecordDetailVo();
            outPatientOrderRecordDetailVo.setItemType(entity.getItemType());
            outPatientOrderRecordDetailVo.setItemName(entity.getItemName());
            outPatientOrderRecordDetailVo.setNum(entity.getQuantity());
            outPatientOrderRecordDetailVo.setPrice(entity.getPrice());
            orderRecordDetailVoList.add(outPatientOrderRecordDetailVo);
        }
        outPatientOrderRecordVo.setOutPatientOrderRecordDetailVoList(orderRecordDetailVoList);
        return outPatientOrderRecordVo;
    }

    private List<OrderRecordResVo> getOrderRecordResVoList(List<AppointmentRecordEntity> orderRecordResVoList) {
        ArrayList<OrderRecordResVo> manageOrderRecordResVoList = new ArrayList<OrderRecordResVo>();
        if (null == orderRecordResVoList || orderRecordResVoList.isEmpty()) {
            return null;
        }
        BigDecimal totalMoney = BigDecimal.ZERO;
        BigDecimal realMoney = BigDecimal.ZERO;
        for (AppointmentRecordEntity appointmentRecordEntity : orderRecordResVoList) {
            if (Objects.equals(AppointmentStatusEnum.PAY.values(), appointmentRecordEntity.getAppointStatus())) {
                realMoney = realMoney.add(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            }
            totalMoney = totalMoney.add(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            OrderRecordResVo orderRecordResVo = new OrderRecordResVo();
            String admDate = appointmentRecordEntity.getAdmDate();
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)appointmentRecordEntity.getAdmTimeRange()) && appointmentRecordEntity.getAdmTimeRange().length() > 5) {
                admDate = appointmentRecordEntity.getAdmDate() + " " + appointmentRecordEntity.getAdmTimeRange().substring(0, 5);
            }
            orderRecordResVo.setAppointmentTime(admDate);
            orderRecordResVo.setDeptName(appointmentRecordEntity.getDeptName());
            orderRecordResVo.setDoctorName(appointmentRecordEntity.getDocName());
            orderRecordResVo.setOrderDate(appointmentRecordEntity.getCreatetime());
            orderRecordResVo.setOrderMoney(appointmentRecordEntity.getPayAmount());
            orderRecordResVo.setOrderSeq(appointmentRecordEntity.getSysAppointmentId());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (APPOINT_ORDER_STATUS_LIST.contains(String.valueOf(appointStatus))) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            orderRecordResVo.setOrderStatus(appointStatus);
            orderRecordResVo.setPatientIdCard(appointmentRecordEntity.getPatientIdCard());
            orderRecordResVo.setPatientName(appointmentRecordEntity.getPatientName());
            orderRecordResVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
            manageOrderRecordResVoList.add(orderRecordResVo);
        }
        return manageOrderRecordResVoList;
    }

    public void dowRegisterOrderList(DowOrderRecordReqVo dowOrderRecordReqVo) throws IOException {
        String orderStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().toString().equals(dowOrderRecordReqVo.getOrderStatus()) ? "'" + org.apache.commons.lang3.StringUtils.join((Iterable)APPOINT_ORDER_STATUS_LIST, (String)"','") + "'" : dowOrderRecordReqVo.getOrderStatus();
        dowOrderRecordReqVo.setOrderStatus(orderStatus);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u5217\u8868\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)dowOrderRecordReqVo));
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectByOrderRecordReqVo(dowOrderRecordReqVo);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u6302\u53f7\u5217\u8868\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)appointmentRecordEntityList));
        XSSFWorkbook wb = new XSSFWorkbook();
        CellStyle cellStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("yyyy-MM-dd"));
        CellStyle cellStyleFull = wb.createCellStyle();
        DataFormat dataFormatFull = wb.createDataFormat();
        cellStyleFull.setDataFormat(dataFormatFull.getFormat("yyyy-MM-dd HH:ss:mm"));
        Sheet sheet = wb.createSheet();
        String[] titals = "\u8ba2\u5355\u53f7,\u60a3\u8005\u59d3\u540d,\u60a3\u8005\u8eab\u4efd\u8bc1\u53f7,\u6302\u53f7\u533b\u751f,\u6302\u53f7\u79d1\u5ba4,\u9884\u7ea6\u65f6\u95f4,\u6302\u53f7\u91d1\u989d,\u4e0b\u5355\u65f6\u95f4,\u8ba2\u5355\u72b6\u6001".split(",");
        Row row = sheet.createRow(0);
        int titleIndex = 0;
        for (String tital : titals) {
            Cell cell = row.createCell(titleIndex++);
            cell.setCellValue(tital);
        }
        int rowIndex = 1;
        Cell cell = null;
        for (AppointmentRecordEntity AppointmentRecordEntity2 : appointmentRecordEntityList) {
            if (OUTPATIENT_ORDER_STATUS_LIST.contains((int)AppointmentRecordEntity2.getAppointStatus())) {
                AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u652f\u4ed8\u5f85\u786e\u8ba4");
            }
            switch (AppointmentRecordEntity2.getAppointStatus()) {
                case 7: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u53d6\u53f7");
                    break;
                }
                case 5: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u53d6\u6d88");
                    break;
                }
                case 6: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u9000\u53f7");
                    break;
                }
                case 8: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u9000\u6b3e");
                    break;
                }
                case 2: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u9884\u7ea6");
                    break;
                }
                case 99: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5df2\u6bc1\u7ea6");
                    break;
                }
                default: {
                    AppointmentRecordEntity2.setAppointStatusMsg("\u5f85\u786e\u8ba4");
                }
            }
            row = sheet.createRow(rowIndex++);
            cell = row.createCell(0);
            cell.setCellValue(AppointmentRecordEntity2.getSysAppointmentId());
            cell = row.createCell(1);
            cell.setCellValue(AppointmentRecordEntity2.getPatientName());
            cell = row.createCell(2);
            cell.setCellValue(AppointmentRecordEntity2.getPatientIdCard());
            cell = row.createCell(3);
            cell.setCellValue(AppointmentRecordEntity2.getDocName());
            cell = row.createCell(4);
            cell.setCellValue(AppointmentRecordEntity2.getDeptName());
            cell = row.createCell(5);
            cell.setCellValue(AppointmentRecordEntity2.getAppointmentTime());
            cell.setCellStyle(cellStyle);
            cell = row.createCell(6);
            cell.setCellValue(AppointmentRecordEntity2.getPayAmount());
            cell = row.createCell(7);
            cell.setCellValue(AppointmentRecordEntity2.getCreatetime());
            cell.setCellStyle(cellStyleFull);
            cell = row.createCell(8);
            cell.setCellValue(AppointmentRecordEntity2.getAppointStatusMsg());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        wb.write((OutputStream)os);
        String fileName = URLEncoder.encode("GH" + DateUtils.getCurrentDateSimpleNoSpeToString() + ".xlsx", "UTF-8");
        new DownloadUtils().download(os, this.response, fileName);
    }

    public void dowOutPatientOrderList(DowOutPatientOrderReqVo dowOutPatientOrderReqVo) throws IOException {
        String orderStatusReq = "2".equals(dowOutPatientOrderReqVo.getOrderStatus()) ? "'" + StringUtils.join((Collection)OUTPATIENT_ORDER_STATUS_LIST, (String)"','") + "'" : dowOutPatientOrderReqVo.getOrderStatus();
        List orderRecordResVoList = this.opBusinessOrderEntityMapper.newSelectByOrderRecordReqVo(dowOutPatientOrderReqVo);
        log.info("\u7ba1\u7406\u7aef\u67e5\u8be2\u5217\u8868\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)orderRecordResVoList));
        XSSFWorkbook wb = new XSSFWorkbook();
        CellStyle cellStyle = wb.createCellStyle();
        DataFormat dataFormat = wb.createDataFormat();
        cellStyle.setDataFormat(dataFormat.getFormat("yyyy-MM-dd"));
        Sheet sheet = wb.createSheet();
        String[] titals = "\u5c31\u8bca\u5361\u53f7,\u60a3\u8005\u59d3\u540d,\u5c31\u8bca\u79d1\u5ba4,\u5c31\u8bca\u533b\u751f,\u5c31\u8bca\u65e5\u671f,\u7f34\u8d39\u91d1\u989d,\u652f\u4ed8\u65f6\u95f4,\u652f\u4ed8\u65b9\u5f0f,\u8ba2\u5355\u72b6\u6001".split(",");
        Row row = sheet.createRow(0);
        int titleIndex = 0;
        for (String tital : titals) {
            Cell cell = row.createCell(titleIndex++);
            cell.setCellValue(tital);
        }
        int rowIndex = 1;
        Cell cell = null;
        for (OutPatientOrderRecordResVo outPatientOrderRecordResVo : orderRecordResVoList) {
            String orderStatus = String.valueOf(dowOutPatientOrderReqVo.getOrderStatus());
            if (OUTPATIENT_ORDER_STATUS_LIST.contains(orderStatus)) {
                orderStatus = "1";
            }
            dowOutPatientOrderReqVo.setOrderStatus(orderStatus);
            if (Objects.equals(outPatientOrderRecordResVo.getPayType(), "WECHAT")) {
                outPatientOrderRecordResVo.setPayType("\u5fae\u4fe1\u652f\u4ed8");
            } else {
                outPatientOrderRecordResVo.setPayType("\u5176\u5b83");
            }
            switch (outPatientOrderRecordResVo.getOrderStatus()) {
                case 0: {
                    outPatientOrderRecordResVo.setOrderStatusMsg("\u672a\u7f34\u8d39");
                    outPatientOrderRecordResVo.setPayTime("");
                    outPatientOrderRecordResVo.setPayType("");
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    outPatientOrderRecordResVo.setOrderStatusMsg("\u5df2\u7f34\u8d39");
                    break;
                }
                case 4: {
                    outPatientOrderRecordResVo.setOrderStatusMsg("\u5df2\u9000\u8d39");
                    break;
                }
                default: {
                    outPatientOrderRecordResVo.setOrderStatusMsg("\u5f85\u786e\u8ba4");
                }
            }
            row = sheet.createRow(rowIndex++);
            cell = row.createCell(0);
            cell.setCellValue(outPatientOrderRecordResVo.getPatientCardNo());
            cell = row.createCell(1);
            cell.setCellValue(outPatientOrderRecordResVo.getPatientName());
            cell = row.createCell(2);
            cell.setCellValue(outPatientOrderRecordResVo.getDeptName());
            cell = row.createCell(3);
            cell.setCellValue(outPatientOrderRecordResVo.getDoctorName());
            cell = row.createCell(4);
            cell.setCellValue(outPatientOrderRecordResVo.getAdmDate());
            cell.setCellStyle(cellStyle);
            cell = row.createCell(5);
            cell.setCellValue(outPatientOrderRecordResVo.getOrderMoney());
            cell = row.createCell(6);
            cell.setCellValue(outPatientOrderRecordResVo.getPayTime());
            cell = row.createCell(7);
            cell.setCellValue(outPatientOrderRecordResVo.getPayType());
            cell = row.createCell(8);
            cell.setCellValue(outPatientOrderRecordResVo.getOrderStatusMsg());
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        wb.write((OutputStream)os);
        String fileName = URLEncoder.encode("JF" + DateUtils.getCurrentDateSimpleNoSpeToString() + ".xlsx", "UTF-8");
        new DownloadUtils().download(os, this.response, fileName);
    }

    private static List<List<String>> head(List<String> fieldList, int mark) {
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        if (mark == 1) {
            for (String s : fieldList) {
                ArrayList<String> head = new ArrayList<String>();
                head.add(DowFieldListEnum.getValue((String)s));
                list.add(head);
            }
        } else if (mark == 2) {
            for (String s : fieldList) {
                ArrayList<String> head = new ArrayList<String>();
                head.add(DowOutPatientFieldEnum.getValue((String)s));
                list.add(head);
            }
        }
        log.info("Excel\u5934\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private static List<List<Object>> dataList(List<?> dataList, List<String> fileList) {
        ArrayList<List<Object>> list = new ArrayList<List<Object>>();
        for (Object person : dataList) {
            ArrayList<Object> data = new ArrayList<Object>();
            for (String fieldName : fileList) {
                data.add(OrderServiceImpl.getFieldValue((String)fieldName, person));
            }
            list.add(data);
        }
        log.info("\u9700\u8981\u663e\u793a\u7684\u5b57\u6bb5\uff1a{}", (Object)JSON.toJSONString(list));
        return list;
    }

    private static Object getFieldValue(String fieldName, Object person) {
        try {
            String firstLetter = fieldName.substring(0, 1).toUpperCase();
            String getter = "get" + firstLetter + fieldName.substring(1);
            Method method = person.getClass().getMethod(getter, new Class[0]);
            return method.invoke(person, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u4f7f\u7528\u53cd\u5c04\u83b7\u53d6\u5bf9\u8c61\u5c5e\u6027\u503c\u5931\u8d25", (Throwable)e);
            return null;
        }
    }
}

