/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.crypto.SmUtil;
import cn.hutool.crypto.symmetric.SM4;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.mapper.PatientViewMapper;
import com.ebaiyihui.wisdommedical.model.PatientViewEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PatientViewReqVO;
import com.ebaiyihui.wisdommedical.service.PatientViewService;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PatientViewServiceImpl
implements PatientViewService {
    private static final Logger log = LoggerFactory.getLogger(PatientViewServiceImpl.class);
    private String url = "http://pat.sdfyy.cn:8051/360-panorama/";
    private String secretKey = "eurekaPanoram360";
    @Autowired
    private PatientViewMapper patientViewMapper;

    @ApiOperation(value="\u83b7\u53d6360\u60a3\u8005\u5e73\u53f0\u5730\u5740", notes="\u83b7\u53d6360\u60a3\u8005\u5e73\u53f0\u5730\u5740")
    public BaseResponse<String> getPatientViewUrl(PatientViewReqVO patientViewReqVO) {
        try {
            PatientViewEntity ucDocterById = this.patientViewMapper.getUcDocterById(patientViewReqVO.getOperatorId());
            if (BeanUtil.isEmpty((Object)ucDocterById, (String[])new String[0])) {
                BaseResponse.error((String)"\u6682\u65e0\u67e5\u8be2\u5230\u5f53\u524d\u533b\u751f\u7684\u5de5\u53f7 \u8bf7\u5728\u7efc\u7ba1\u7aef\u7ef4\u62a4");
            }
            if (StrUtil.isBlank((CharSequence)patientViewReqVO.getPatientIdCard())) {
                try {
                    log.info("\u5f53\u524d\u60a3\u8005PatientId={}", (Object)patientViewReqVO.getPatientId());
                    PatientViewEntity cardServiceByPatientId = this.patientViewMapper.getCardServiceByPatientId(patientViewReqVO.getPatientId());
                    log.info("\u67e5\u8be2\u5230\u7684\u5f53\u524d\u60a3\u8005\u8eab\u4efd\u8bc1\u53f7\u4e3a={}", (Object)JSON.toJSONString((Object)cardServiceByPatientId));
                    patientViewReqVO.setPatientIdCard(cardServiceByPatientId.getCardNo());
                }
                catch (Exception e) {
                    log.error("\u67e5\u8be2\u60a3\u8005\u8eab\u4efd\u8bc1\u53f7\u7801\u51fa\u73b0\u4e25\u91cd\u9519\u8bef");
                    e.printStackTrace();
                    BaseResponse.error((String)e.getMessage());
                }
            }
            SM4 sm4 = SmUtil.sm4((byte[])this.secretKey.getBytes());
            String sm4url = sm4.encryptHex(ucDocterById.getEmplCode() + "/" + patientViewReqVO.getPatientIdCard() + "/" + patientViewReqVO.getVisitType() + "/" + patientViewReqVO.getPatientPatid() + "/" + patientViewReqVO.getVisitSerialNumber() + "/" + patientViewReqVO.getMedicalInsuranceCardNumber() + "/" + patientViewReqVO.getHospitalCardNumber() + "/" + patientViewReqVO.getMedicalRecordNumber() + "/" + patientViewReqVO.getModuleNumber() + "/" + patientViewReqVO.getBranchCode() + "/-1/" + ucDocterById.getDeptCode() + "/browser/1/1/1");
            log.info("\u52a0\u5bc6\u524d\u7684url{}", (Object)(this.url + sm4.decryptStr(sm4url)));
            log.info("\u52a0\u5bc6\u540e\u7684url{}", (Object)(this.url + sm4url));
            return BaseResponse.success((Object)(this.url + sm4url));
        }
        catch (Exception e) {
            e.printStackTrace();
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public static void main(String[] args) {
        SM4 sm4 = SmUtil.sm4((byte[])"eurekaPanoram360".getBytes());
        String s = sm4.encryptHex("83541/32050319680119051X/2/0/0/0/0/0/patientProfile/02/-1/1010300/browser/1/1/1");
        System.out.println("https://pat.sdfyy.cn:8051/360-panorama/" + s);
        System.out.println("https://pat.sdfyy.cn/360-panorama/" + sm4.decryptStr(s));
    }
}

