/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.MakeAnAppointmentNewReqDTO;
import com.ebaiyihui.his.pojo.vo.appoint.MakeAnAppointmentNewResVO;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PreAnAppointmentNewReqDTO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayPreNewReq;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.paymentPlatforms.dto.PaymentResultsDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestPaymentRefundVO;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaymentCallRepVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.impl.AppointmentServiceImpl;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetUserInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SdyPayUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    private static final long REDIS_LOCK_TIMEOUT = 300L;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private AppointmentServiceImpl appointmentServiceimpl;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private GetUserInfoUtil getUserInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    public static final String APPCODE = "SDFYY";

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        PreAnAppointmentNewReqDTO preAnAppointmentNewReqDTO = new PreAnAppointmentNewReqDTO();
        preAnAppointmentNewReqDTO.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        preAnAppointmentNewReqDTO.setCertNo(appointmentRecordEntity.getPatientIdCard());
        preAnAppointmentNewReqDTO.setCertType(HIS_SUCCESS);
        preAnAppointmentNewReqDTO.setResponseType(HIS_SUCCESS);
        preAnAppointmentNewReqDTO.setRegType("2");
        preAnAppointmentNewReqDTO.setOrderNo(appointmentRecordEntity.getAppointmentId());
        preAnAppointmentNewReqDTO.setPID(appointmentRecordEntity.getPatientCardNo());
        log.info("\u5f53\u65e5\u6302\u53f7\u9884\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)preAnAppointmentNewReqDTO));
        FrontResponse preAnAppointmentNewResVOFrontResponse = this.appointApi.preConfirmNewRegister(preAnAppointmentNewReqDTO);
        log.info("\u5f53\u65e5\u6302\u53f7\u9884\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)preAnAppointmentNewResVOFrontResponse));
        MakeAnAppointmentNewReqDTO gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03gatewayRequest: " + JSON.toJSONString((Object)gatewayRequest.toString()));
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        FrontResponse dayRegisterGatewayRes = this.appointApi.confirmNewRegister(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMessage());
            businessResultEntity.setTransationId(responseNotifyRestVo.getOutTradeNo());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        MakeAnAppointmentNewResVO dayRegisterRes = (MakeAnAppointmentNewResVO)dayRegisterGatewayRes.getBody();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(responseNotifyRestVo.getServiceCode());
        servicePayBillEntity.setApplyCode(APPCODE);
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(APPCODE);
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        log.info("\u5f53\u65e5\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        return this.refund(requestRefundOrderVoReq);
    }

    private BaseResponse<String> appointnewRefund(AppointmentRecordEntity appointmentRecordEntity) throws Exception {
        RequestPaymentRefundVO requestPaymentRefundVO = new RequestPaymentRefundVO();
        PaymentResultsDTO paymentResultsDTO = SdyPayUtils.paymentRefund((RequestPaymentRefundVO)requestPaymentRefundVO);
        log.info("\u9000\u6b3e\u8fd4\u56de\u53c2\u6570\uff1a" + JSON.toJSONString((Object)paymentResultsDTO));
        if (Objects.isNull(paymentResultsDTO)) {
            return BaseResponse.error((String)"\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)paymentResultsDTO.getTsRefundId());
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setBizSysSeq(responseNotifyRestVo.getServiceCode());
        payOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, MakeAnAppointmentNewResVO dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, MakeAnAppointmentNewResVO dayRegisterRes) {
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getRegisterSn());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getInvoiceNo());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getDeptLocDesc());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private MakeAnAppointmentNewReqDTO buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        MakeAnAppointmentNewReqDTO payRegistrationReq = new MakeAnAppointmentNewReqDTO();
        payRegistrationReq.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payRegistrationReq.setResponseType(HIS_SUCCESS);
        payRegistrationReq.setRegType("2");
        payRegistrationReq.setOwnPayType(PAY_SUCCESS);
        payRegistrationReq.setOwnCost(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        payRegistrationReq.setOrderNo(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setOwnPayTransNo(appointmentRecordEntity.getSysAppointmentId());
        return payRegistrationReq;
    }

    private GatewayRequest<PayRegistrationReq> appointRegisGateway(AppointmentRecordEntity appointmentRecordEntity, PaymentCallRepVo repVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getSysAppointmentId());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(repVo.getPayFlowNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("buildnewDayRegisterParams");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)appointmentRecordEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
        log.info("========>\u751f\u6210\u8d26\u5355\u4fe1\u606f");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(responseNotifyRestVo.getServiceCode());
        servicePayBillEntity.setApplyCode(APPCODE);
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate, this.propertiesConstant.getOrganCode());
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        log.info("\u7f34\u8d39\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        FrontRequest param = new FrontRequest();
        ComfirmPayPreNewReq comfirmPayPreNewReq = new ComfirmPayPreNewReq();
        comfirmPayPreNewReq.setHospitalCode(opBusinessOrderEntity.getHospitalCode());
        comfirmPayPreNewReq.setOrderNo(opBusinessOrderEntity.getAdmId());
        comfirmPayPreNewReq.setMdtrtCertNo(opBusinessOrderEntity.getIdCard());
        comfirmPayPreNewReq.setPsnName(opBusinessOrderEntity.getPatientName());
        comfirmPayPreNewReq.setResponseType(HIS_SUCCESS);
        param.setBody((Object)comfirmPayPreNewReq);
        log.info("\u95e8\u8bca\u9884\u652f\u4ed8IN===\u300b", (Object)JSON.toJSONString((Object)param));
        FrontResponse preComfirePayResFrontResponse = this.outpatientPaymentApi.pendingPayItems(param);
        log.info("\u95e8\u8bca\u9884\u652f\u4ed8OUT===\u300b", (Object)JSON.toJSONString((Object)preComfirePayResFrontResponse));
        if (preComfirePayResFrontResponse.getBody() == null || ACCEPT_REQUEST.equals(preComfirePayResFrontResponse.getCode())) {
            log.info("\u95e8\u8bca\u9884\u652f\u4ed8\u5931\u8d25");
            return;
        }
        FrontRequest gatewayRequest = new FrontRequest();
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setResponseType(HIS_SUCCESS);
        comfirmPayNewReq.setAmount(String.valueOf(opBusinessOrderEntity.getMoney()));
        comfirmPayNewReq.setFlowNo(outPatientId);
        comfirmPayNewReq.setPaychannel(PAY_SUCCESS);
        comfirmPayNewReq.setPreSettlementNo(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setHospitalCode(opBusinessOrderEntity.getHospitalCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        log.info("\u95e8\u8bca\u652f\u4ed8IN===\u300b", (Object)JSON.toJSONString((Object)gatewayRequest));
        FrontResponse gatewayResponse = this.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u652f\u4ed8OUT===\u300b", (Object)JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse.getBody() != null && HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            String receiptId = ((ComfirmPayNewRes)gatewayResponse.getBody()).getReceiptId();
            opBusinessOrderEntity.setReceiptId(receiptId);
            if (ChannelEnum.USER_APPLETS.getValue().equals(opBusinessOrderEntity.getChannelCode())) {
                this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime())));
            }
            if (gatewayResponse.getBody() == null || ACCEPT_REQUEST.equals(gatewayResponse.getCode())) {
                log.info("\u95e8\u8bca\u652f\u4ed8\u5931\u8d25");
                return;
            }
            opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
            opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
            opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
            servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
            servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
            servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
            servicePayBillEntity.setWorkServiceCode(responseNotifyRestVo.getServiceCode());
            servicePayBillEntity.setApplyCode(APPCODE);
            servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
            servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
            servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
            servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
            servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
            servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
            this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        }
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        log.info("\u4f4f\u9662\u5145\u503c\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        log.info("\u95e8\u8bca\u8be6\u60c5\u8868\u6570\u636e===---\u300b", (Object)inpatientDepositDetailEntity);
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setPayTime(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
        inHospDepostPayCallDTO.setPaymentSeq(responseNotifyRestVo.getPayChannel());
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        DepositRes depositRes = this.inHospitalService.InHospDeposit(inpatientDepositDetailEntity, responseNotifyRestVo);
        inHospDepostPayCallDTO.setReceiptId(depositRes.getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(responseNotifyRestVo.getServiceCode());
        servicePayBillEntity.setApplyCode(APPCODE);
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private FrontResponse<ComfirmPayNewRes> comfirmPayNew(FrontRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        FrontResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        return gatewayResponse;
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        return false;
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }
}

