/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.exception.SyncHisScheduleException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalTitleMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DeptRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalTitleEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetDeptInfoDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.ScheduleDetailDTO;
import com.ebaiyihui.wisdommedical.service.SynchroHisService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional
public class SynchroHisServiceImpl
implements SynchroHisService {
    private static final Logger log = LoggerFactory.getLogger(SynchroHisServiceImpl.class);
    private static Logger logger = LoggerFactory.getLogger(SynchroHisServiceImpl.class);
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private HospitalTitleMapper hospitalTitleMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    private static final String HOSPITAL_NOT_CONFIG = "";
    private static final String HOSPITAL_INFO_NOT_CONFIG = "\u533b\u9662\u4fe1\u606f\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u914d\u7f6e\u8be5\u533b\u9662\u4fe1\u606f hospitalCode=";
    private static final String HOSPITAL_CODE_NOT_CONFIG = "----------------\u533b\u9662\u672a\u914d\u7f6e\uff0c\u533b\u9662\u7f16\u7801 hospitalCode:{}";
    private static final String HIS_ERROR = "\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94";
    private static final String HIS_SCHEDULE_QUERY_ERROR = "\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}";
    private static final String HIS_DOC_SCHEDULE_QUERY_ERROR = "\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38";
    private static final String HIS_NO_SCHEDULE_QUERY_ERROR = "\u6302\u53f7\u533b\u751f\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f";
    private static final String GET_HISSCHEDULE = "getHisSchedule";
    private static final String NOT_FOUND_SCHEDULE = "\u672a\u67e5\u8be2\u5230\u8be5\u79d1\u5ba4\u533b\u751f\u6392\u73ed,\u5c31\u8bca\u65e5\u671f{},\u79d1\u5ba4Code{},\u79d1\u5ba4\u540d\u79f0{}";

    public void syncDocSchedule(String hospitalCode) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error(HOSPITAL_CODE_NOT_CONFIG + hospitalCode);
            throw new SyncHisScheduleException(HOSPITAL_INFO_NOT_CONFIG + hospitalCode);
        }
        Integer allowDays = 7;
        String admDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        this.scheduleRecordMapper.updateAbleStatus(hospitalCode);
        this.scheduleDetailRecordMapper.updateAbleStatus(hospitalCode);
        for (int i = 0; i < allowDays; ++i) {
            List deptScheduleResItemsList = this.getHisDeptSchedule(admDate, admDate, hospitalCode);
            if (CollectionUtils.isEmpty((Collection)deptScheduleResItemsList)) {
                log.error("\u672a\u67e5\u8be2\u5230HIS\u6392\u73ed\u79d1\u5ba4,\u5c31\u8bca\u65e5\u671f\uff1a" + admDate);
                admDate = DateUtils.getNextDayToString((String)admDate);
                continue;
            }
            for (GetDeptScheduleResItems getDeptScheduleResItems : deptScheduleResItemsList) {
                DeptRecordEntity deptRecord = this.deptRecordMapper.selectOneByLocCodeAndHospitalCode(hospitalCode, getDeptScheduleResItems.getDeptCode());
                DeptRecordEntity newDeptRecord = this.buildNewDeptRecord(getDeptScheduleResItems.getDeptCode(), getDeptScheduleResItems.getDeptName(), hospitalCode);
                if (null == deptRecord) {
                    newDeptRecord.setCreatetime(new Date());
                    logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u4e8c\u7ea7\u79d1\u5ba4\uff0c\u65b0\u589e\u79d1\u5ba4\u4fe1\u606f\uff1a" + newDeptRecord.toString());
                    this.deptRecordMapper.insert(newDeptRecord);
                } else {
                    newDeptRecord.setId(deptRecord.getId());
                    logger.info("\u67e5\u8be2\u5230\u4e8c\u7ea7\u79d1\u5ba4\uff0c\u66f4\u65b0\u79d1\u5ba4\u4fe1\u606f\uff1a" + newDeptRecord.toString());
                    this.deptRecordMapper.updateByPrimaryKey(newDeptRecord);
                }
                List getScheduleResItemsList = this.getSchedule(admDate, getDeptScheduleResItems.getDeptCode(), hospitalCode);
                if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
                    log.error(NOT_FOUND_SCHEDULE, new Object[]{admDate, getDeptScheduleResItems.getDeptCode(), getDeptScheduleResItems.getDeptName()});
                    continue;
                }
                for (GetScheduleResItems getScheduleResItems : getScheduleResItemsList) {
                    DoctorRecordEntity doctorRecord = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, getScheduleResItems.getDocCode());
                    DoctorRecordEntity newDoctorRecord = this.buildDoctorRecord(getScheduleResItems, hospitalCode);
                    if (null == doctorRecord) {
                        newDoctorRecord.setDoctorId(HOSPITAL_NOT_CONFIG);
                        logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u6392\u73ed\u533b\u751f\uff0c\u65b0\u589e\u8be5\u533b\u751f\u4fe1\u606f\uff1a" + newDoctorRecord.toString());
                        this.doctorRecordMapper.insert(newDoctorRecord);
                    } else {
                        newDoctorRecord.setId(doctorRecord.getId());
                        newDoctorRecord.setDoctorId(doctorRecord.getDoctorId());
                        logger.info("\u67e5\u8be2\u5230\u8be5\u533b\u751f\uff0c\u66f4\u65b0\u533b\u751f\u4fe1\u606f\uff1a" + newDoctorRecord.toString());
                        this.doctorRecordMapper.updateByPrimaryKey(newDoctorRecord);
                    }
                    ScheduleRecordEntity scheduleRecord = this.scheduleRecordMapper.selectByScheduleIdAndHospitalCode(hospitalCode, getScheduleResItems.getScheduleId());
                    ScheduleRecordEntity newScheduleRecord = this.buildNewScheduleRecored(getScheduleResItems, getDeptScheduleResItems.getDeptCode(), getDeptScheduleResItems.getDeptName(), hospitalRecord);
                    if (null == scheduleRecord) {
                        newScheduleRecord.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
                        newScheduleRecord.setAutoId(Long.valueOf(this.snowflakeIdWorker.nextId()));
                        this.scheduleRecordMapper.insert(newScheduleRecord);
                    } else {
                        newScheduleRecord.setId(scheduleRecord.getId());
                        this.scheduleRecordMapper.updateByPrimaryKey(newScheduleRecord);
                    }
                    HospitalTitleEntity hospitalTitleOne = this.hospitalTitleMapper.selectByScheduleLevelCode(hospitalCode, getScheduleResItems.getScheduleLevelCode(), String.valueOf(1));
                    HospitalTitleEntity newhospitalTitleOne = this.buildHospitalTitle(getScheduleResItems, hospitalCode);
                    if (null == hospitalTitleOne || StringUtils.isEmpty((String)hospitalTitleOne.toString())) {
                        newhospitalTitleOne.setCategory(Byte.valueOf((byte)1));
                        log.info("\u672a\u67e5\u8be2\u5230\u533b\u751f\u804c\u79f0\uff0c\u65b0\u589e\u804c\u79f0\u4fe1\u606f\uff1a" + newhospitalTitleOne.toString());
                        this.hospitalTitleMapper.insert(newhospitalTitleOne);
                    }
                    HospitalTitleEntity hospitalTitleZero = this.hospitalTitleMapper.selectByScheduleLevelCode(hospitalCode, getScheduleResItems.getScheduleLevelCode(), String.valueOf(0));
                    HospitalTitleEntity newhospitalTitleZero = this.buildHospitalTitle(getScheduleResItems, hospitalCode);
                    if (null == hospitalTitleZero) {
                        newhospitalTitleZero.setCategory(Byte.valueOf((byte)0));
                        log.info("\u672a\u67e5\u8be2\u5230\u53f7\u6e90\u804c\u79f0\uff0c\u65b0\u589e\u804c\u79f0\u4fe1\u606f\uff1a" + newhospitalTitleZero.toString());
                        this.hospitalTitleMapper.insert(newhospitalTitleZero);
                    }
                    if (getScheduleResItems.getTimeArrangeItems().isEmpty()) continue;
                    for (TimeArrangeItems timeArrangeItem : getScheduleResItems.getTimeArrangeItems()) {
                        ScheduleDetailDTO detailDTO = new ScheduleDetailDTO();
                        detailDTO.setHisScheduleId(getScheduleResItems.getScheduleId());
                        detailDTO.setHospitalCode(hospitalCode);
                        ScheduleDetailRecordEntity scheduleDetailRecord = this.scheduleDetailRecordMapper.selectByScheduleDetail(detailDTO);
                        ScheduleDetailRecordEntity newScheduleDetailRecord = this.buidScheduleDetailRecord(timeArrangeItem, getScheduleResItems, hospitalRecord, newScheduleRecord);
                        if (null == scheduleDetailRecord || StringUtils.isEmpty((String)scheduleDetailRecord.toString())) {
                            newScheduleDetailRecord.setCreatetime(new Date());
                            newScheduleDetailRecord.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
                            this.scheduleDetailRecordMapper.insert(newScheduleDetailRecord);
                            continue;
                        }
                        newScheduleDetailRecord.setId(scheduleDetailRecord.getId());
                        this.scheduleDetailRecordMapper.updateByPrimaryKey(newScheduleDetailRecord);
                    }
                }
            }
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
    }

    private List<GetScheduleResItems> getHisSchedule(String admDate, String hospitalCode) throws SyncHisScheduleException {
        GetScheduleResVO data;
        GatewayRequest request = new GatewayRequest();
        GetScheduleReqVO scheduleReqVO = new GetScheduleReqVO();
        scheduleReqVO.setBgDate(admDate);
        scheduleReqVO.setEdDate(admDate);
        request.setChannel("\u4e92\u8054\u7f51APP");
        request.setChannelName("\u5927\u4f17\u7aef");
        request.setOrganCode(hospitalCode);
        request.setKeyWord(GET_HISSCHEDULE);
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)scheduleReqVO);
        logger.info("\u67e5\u8be2his\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse response = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), request.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), request, GetScheduleResVO.class);
        if (response == null) {
            log.error("\u5019\u8bca\u67e5\u8be2 getAwaitingQueue -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new SyncHisScheduleException();
        }
        logger.info("\u67e5\u8be2his\u6392\u73ed\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)response));
        if ("1".equals(response.getCode()) && null != (data = (GetScheduleResVO)response.getData())) {
            return data.getItems();
        }
        return null;
    }

    public void syncMissDocSchedule(String hospitalCode, String deptCode, String deptName) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error(HOSPITAL_CODE_NOT_CONFIG + hospitalCode);
            throw new SyncHisScheduleException(HOSPITAL_INFO_NOT_CONFIG + hospitalCode);
        }
        Integer allowDays = 7;
        String admDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        for (int i = 0; i < allowDays; ++i) {
            DeptRecordEntity deptRecord = this.deptRecordMapper.selectOneByLocCodeAndHospitalCode(hospitalCode, deptCode);
            DeptRecordEntity newDeptRecord = this.buildNewDeptRecord(deptCode, deptName, hospitalCode);
            if (null == deptRecord) {
                newDeptRecord.setCreatetime(new Date());
                logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u4e8c\u7ea7\u79d1\u5ba4\uff0c\u65b0\u589e\u79d1\u5ba4\u4fe1\u606f\uff1a" + newDeptRecord.toString());
                this.deptRecordMapper.insert(newDeptRecord);
            } else {
                newDeptRecord.setId(deptRecord.getId());
                logger.info("\u67e5\u8be2\u5230\u4e8c\u7ea7\u79d1\u5ba4\uff0c\u66f4\u65b0\u79d1\u5ba4\u4fe1\u606f\uff1a" + newDeptRecord.toString());
                this.deptRecordMapper.updateByPrimaryKey(newDeptRecord);
            }
            List getScheduleResItemsList = this.getSchedule(admDate, deptCode, hospitalCode);
            if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
                log.error(NOT_FOUND_SCHEDULE, new Object[]{admDate, deptCode, deptName});
                continue;
            }
            for (GetScheduleResItems getScheduleResItems : getScheduleResItemsList) {
                DoctorRecordEntity doctorRecord = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, getScheduleResItems.getDocCode());
                DoctorRecordEntity newDoctorRecord = this.buildDoctorRecord(getScheduleResItems, hospitalCode);
                if (null == doctorRecord) {
                    newDoctorRecord.setDoctorId(HOSPITAL_NOT_CONFIG);
                    logger.info("\u672a\u67e5\u8be2\u5230\u8be5\u6392\u73ed\u533b\u751f\uff0c\u65b0\u589e\u8be5\u533b\u751f\u4fe1\u606f\uff1a" + newDoctorRecord.toString());
                    this.doctorRecordMapper.insert(newDoctorRecord);
                } else {
                    newDoctorRecord.setId(doctorRecord.getId());
                    newDoctorRecord.setDoctorId(doctorRecord.getDoctorId());
                    logger.info("\u67e5\u8be2\u5230\u8be5\u533b\u751f\uff0c\u66f4\u65b0\u533b\u751f\u4fe1\u606f\uff1a" + newDoctorRecord.toString());
                    this.doctorRecordMapper.updateByPrimaryKey(newDoctorRecord);
                }
                ScheduleRecordEntity scheduleRecord = this.scheduleRecordMapper.selectByScheduleIdAndHospitalCode(hospitalCode, getScheduleResItems.getScheduleId());
                ScheduleRecordEntity newScheduleRecord = this.buildNewScheduleRecored(getScheduleResItems, deptCode, deptName, hospitalRecord);
                if (null == scheduleRecord) {
                    newScheduleRecord.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
                    newScheduleRecord.setAutoId(Long.valueOf(this.snowflakeIdWorker.nextId()));
                    this.scheduleRecordMapper.insert(newScheduleRecord);
                } else {
                    newScheduleRecord.setId(scheduleRecord.getId());
                    this.scheduleRecordMapper.updateByPrimaryKey(newScheduleRecord);
                }
                HospitalTitleEntity hospitalTitleOne = this.hospitalTitleMapper.selectByScheduleLevelCode(hospitalCode, getScheduleResItems.getScheduleLevelCode(), String.valueOf(1));
                HospitalTitleEntity newhospitalTitleOne = this.buildHospitalTitle(getScheduleResItems, hospitalCode);
                if (null == hospitalTitleOne || StringUtils.isEmpty((String)hospitalTitleOne.toString())) {
                    newhospitalTitleOne.setCategory(Byte.valueOf((byte)1));
                    log.info("\u672a\u67e5\u8be2\u5230\u533b\u751f\u804c\u79f0\uff0c\u65b0\u589e\u804c\u79f0\u4fe1\u606f\uff1a" + newhospitalTitleOne.toString());
                    this.hospitalTitleMapper.insert(newhospitalTitleOne);
                }
                HospitalTitleEntity hospitalTitleZero = this.hospitalTitleMapper.selectByScheduleLevelCode(hospitalCode, getScheduleResItems.getScheduleLevelCode(), String.valueOf(0));
                HospitalTitleEntity newhospitalTitleZero = this.buildHospitalTitle(getScheduleResItems, hospitalCode);
                if (null == hospitalTitleZero) {
                    newhospitalTitleZero.setCategory(Byte.valueOf((byte)0));
                    log.info("\u672a\u67e5\u8be2\u5230\u53f7\u6e90\u804c\u79f0\uff0c\u65b0\u589e\u804c\u79f0\u4fe1\u606f\uff1a" + newhospitalTitleZero.toString());
                    this.hospitalTitleMapper.insert(newhospitalTitleZero);
                }
                if (getScheduleResItems.getTimeArrangeItems().isEmpty()) continue;
                for (TimeArrangeItems timeArrangeItem : getScheduleResItems.getTimeArrangeItems()) {
                    ScheduleDetailDTO detailDTO = new ScheduleDetailDTO();
                    detailDTO.setHisScheduleId(getScheduleResItems.getScheduleId());
                    detailDTO.setHospitalCode(hospitalCode);
                    ScheduleDetailRecordEntity scheduleDetailRecord = this.scheduleDetailRecordMapper.selectByScheduleDetail(detailDTO);
                    ScheduleDetailRecordEntity newScheduleDetailRecord = this.buidScheduleDetailRecord(timeArrangeItem, getScheduleResItems, hospitalRecord, newScheduleRecord);
                    if (null == scheduleDetailRecord || StringUtils.isEmpty((String)scheduleDetailRecord.toString())) {
                        newScheduleDetailRecord.setCreatetime(new Date());
                        newScheduleDetailRecord.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
                        this.scheduleDetailRecordMapper.insert(newScheduleDetailRecord);
                        continue;
                    }
                    newScheduleDetailRecord.setId(scheduleDetailRecord.getId());
                    this.scheduleDetailRecordMapper.updateByPrimaryKey(newScheduleDetailRecord);
                }
            }
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
    }

    public void syncSchedule(String hospitalCode) throws SyncHisScheduleException {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord || StringUtils.isEmpty((String)hospitalRecord.toString())) {
            log.error(HOSPITAL_CODE_NOT_CONFIG + hospitalCode);
            throw new SyncHisScheduleException(HOSPITAL_INFO_NOT_CONFIG + hospitalCode);
        }
        Integer allowDays = 7;
        String admDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        this.scheduleRecordMapper.updateAbleStatus(hospitalCode);
        List getDeptScheduleResItemsList = this.syncDept(hospitalCode);
        ArrayList<ScheduleRecordEntity> list = new ArrayList<ScheduleRecordEntity>();
        for (int i = 0; i < allowDays; ++i) {
            for (GetDeptScheduleResItems getDeptScheduleResItems : getDeptScheduleResItemsList) {
                List getScheduleResItemsList = this.getSchedule(admDate, getDeptScheduleResItems.getDeptCode(), hospitalCode);
                if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
                    log.error(NOT_FOUND_SCHEDULE, new Object[]{admDate, getDeptScheduleResItems.getDeptCode(), getDeptScheduleResItems.getDeptName()});
                    continue;
                }
                for (GetScheduleResItems getScheduleResItems : getScheduleResItemsList) {
                    ScheduleRecordEntity scheduleRecord = this.scheduleRecordMapper.selectByScheduleIdAndHospitalCode(hospitalCode, getScheduleResItems.getScheduleId());
                    if (null == scheduleRecord) {
                        ScheduleRecordEntity newScheduleRecord = this.buildNewScheduleRecored(getScheduleResItems, getDeptScheduleResItems.getDeptCode(), getDeptScheduleResItems.getDeptName(), hospitalRecord);
                        list.add(newScheduleRecord);
                        continue;
                    }
                    scheduleRecord.setUpdateStatus(Byte.valueOf((byte)1));
                    scheduleRecord.setAvailableCount(getScheduleResItems.getRegAvailable());
                    scheduleRecord.setTotalCount(getScheduleResItems.getRegTotal());
                    list.add(scheduleRecord);
                }
            }
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        this.scheduleRecordMapper.insertOrUpdatePlanList(list);
    }

    public List<GetDeptScheduleResItems> syncDept(String hospitalCode) throws SyncHisScheduleException {
        Date startDate = DateUtils.getCurrentDate();
        Date endDate = DateUtils.addDays((Date)startDate, (Integer)6);
        List deptScheduleResItems = this.getHisDeptSchedule(DateUtils.dateToSimpleString((Date)startDate), DateUtils.dateToSimpleString((Date)endDate), hospitalCode);
        ArrayList<GetDeptInfoDTO> list = new ArrayList<GetDeptInfoDTO>();
        for (GetDeptScheduleResItems deptScheduleResItem : deptScheduleResItems) {
            GetDeptInfoDTO getDeptInfoDTO = new GetDeptInfoDTO();
            BeanUtils.copyProperties((Object)deptScheduleResItem, (Object)getDeptInfoDTO);
            getDeptInfoDTO.setHospitalCode(hospitalCode);
            list.add(getDeptInfoDTO);
        }
        int i = this.deptRecordMapper.insertOrUpdatePlanList(list);
        log.info("\u540c\u6b65\u79d1\u5ba4 \u6570\u636e\u6761\u6570\uff1a" + i);
        return deptScheduleResItems;
    }

    private List<GetDeptScheduleResItems> getHisDeptSchedule(String startDate, String endDate, String hospitalCode) {
        return null;
    }

    private List<GetScheduleResItems> getSchedule(String admDate, String deptCode, String hospitalCode) throws SyncHisScheduleException {
        GatewayRequest request = new GatewayRequest();
        GetScheduleReqVO scheduleReqVO = new GetScheduleReqVO();
        scheduleReqVO.setBgDate(admDate);
        scheduleReqVO.setEdDate(admDate);
        scheduleReqVO.setLocCode(deptCode);
        request.setOrganCode(hospitalCode);
        request.setKeyWord(GET_HISSCHEDULE);
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)scheduleReqVO);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), request.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), request, GetScheduleResVO.class);
        log.info("\u67e5\u8be2his\u533b\u751f\u6392\u73ed\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error(HIS_ERROR);
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(HIS_SCHEDULE_QUERY_ERROR, (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error(HIS_DOC_SCHEDULE_QUERY_ERROR);
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error(HIS_NO_SCHEDULE_QUERY_ERROR);
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    private ScheduleRecordEntity buildNewScheduleRecored(GetScheduleResItems schedule, String deptCode, String deptName, HospitalAreaRecordEntity hospitalRecord) {
        ScheduleRecordEntity scheduleRecord = new ScheduleRecordEntity();
        scheduleRecord.setAdmLocation(schedule.getAdmLocation());
        scheduleRecord.setAvailableCount(schedule.getRegAvailable());
        scheduleRecord.setDeptCategoryCode(schedule.getLocTypeCode());
        scheduleRecord.setDeptCategoryName(schedule.getLocTypeName());
        scheduleRecord.setDeptCode(deptCode);
        scheduleRecord.setDeptName(deptName);
        scheduleRecord.setDocCode(schedule.getDocCode());
        scheduleRecord.setDocName(schedule.getDocName());
        scheduleRecord.setHospitalArea(schedule.getHospitalAreaCode());
        scheduleRecord.setHospitalAreaName(schedule.getHospitalArea());
        scheduleRecord.setHospitalCode(hospitalRecord.getHospitalCode());
        scheduleRecord.setHospitalName(hospitalRecord.getHospitalAreaName());
        scheduleRecord.setIsPrecise(Byte.valueOf(schedule.getIsTimeArrange().byteValue()));
        scheduleRecord.setRegFee(StringUtils.isEmpty((String)schedule.getRegFee()) ? BigDecimal.ZERO : new BigDecimal(schedule.getRegFee()));
        scheduleRecord.setReplaceScheduleHisId(schedule.getReplaceScheduleId());
        scheduleRecord.setScheduleDate(DateUtils.stringToSimpleDate((String)schedule.getAdmDate()));
        scheduleRecord.setScheduleHisId(schedule.getScheduleId());
        scheduleRecord.setScheduleLevel(schedule.getScheduleLevelName());
        scheduleRecord.setScheduleLevelCode(schedule.getScheduleLevelCode());
        scheduleRecord.setScheduleLevelOrder(Integer.valueOf(1));
        scheduleRecord.setScheduleRange(Byte.valueOf(schedule.getAdmTimeRange()));
        scheduleRecord.setScheduleType(Byte.valueOf(schedule.getScheduleType().byteValue()));
        scheduleRecord.setServiceFee(new BigDecimal("0.0"));
        scheduleRecord.setStatus(Byte.valueOf(schedule.getScheduleStatus()));
        scheduleRecord.setTotalCount(schedule.getRegTotal());
        scheduleRecord.setRegTitelCode(schedule.getRegTitleCode());
        scheduleRecord.setRegTitelName(schedule.getRegTitleName());
        scheduleRecord.setUpdatetime(new Date());
        scheduleRecord.setUpdateStatus(Byte.valueOf((byte)1));
        scheduleRecord.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleRecord.setAutoId(Long.valueOf(this.snowflakeIdWorker.nextId()));
        scheduleRecord.setDiagFee(StringUtils.isEmpty((String)schedule.getDiagFee()) ? BigDecimal.ZERO : new BigDecimal(schedule.getDiagFee()));
        scheduleRecord.setIsAppend(schedule.getIsAppend());
        return scheduleRecord;
    }

    private DoctorRecordEntity buildDoctorRecord(GetScheduleResItems schedule, String hospitalCode) {
        DoctorRecordEntity doctorRecord = new DoctorRecordEntity();
        doctorRecord.setDocCode(schedule.getDocCode());
        doctorRecord.setDocName(schedule.getDocName());
        doctorRecord.setHospitalCode(hospitalCode);
        doctorRecord.setRegTitelCode(schedule.getRegTitleCode());
        doctorRecord.setRegTitelName(schedule.getRegTitleName());
        doctorRecord.setStatus(Byte.valueOf((byte)1));
        return doctorRecord;
    }

    private DeptRecordEntity buildNewDeptRecord(String deptCode, String deptName, String hospitalCode) {
        DeptRecordEntity deptRecord = new DeptRecordEntity();
        deptRecord.setAddress(HOSPITAL_NOT_CONFIG);
        deptRecord.setDeptCode(deptCode);
        deptRecord.setDeptName(deptName);
        deptRecord.setDeptType(Byte.valueOf((byte)1));
        deptRecord.setHospitalCode(hospitalCode);
        deptRecord.setIntroduction(HOSPITAL_NOT_CONFIG);
        deptRecord.setStatus(Byte.valueOf((byte)1));
        return deptRecord;
    }

    private ScheduleDetailRecordEntity buidScheduleDetailRecord(TimeArrangeItems timeArrangeItem, GetScheduleResItems schedule, HospitalAreaRecordEntity hospitalRecord, ScheduleRecordEntity scheduleRecord) {
        ScheduleDetailRecordEntity scheduleDetailRecord = new ScheduleDetailRecordEntity();
        scheduleDetailRecord.setEndNo(timeArrangeItem.getEndNo());
        scheduleDetailRecord.setEndTime(timeArrangeItem.getEndTime());
        scheduleDetailRecord.setHisScheduleId(schedule.getScheduleId());
        scheduleDetailRecord.setHospitalCode(hospitalRecord.getHospitalCode());
        scheduleDetailRecord.setStartTime(timeArrangeItem.getStartTime());
        scheduleDetailRecord.setSysScheduleId(scheduleRecord.getSysScheduleId());
        scheduleDetailRecord.setUpdatetime(new Date());
        scheduleDetailRecord.setUpdateStatus(Byte.valueOf((byte)1));
        scheduleDetailRecord.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return scheduleDetailRecord;
    }

    private HospitalTitleEntity buildHospitalTitle(GetScheduleResItems schedule, String hospitalCode) {
        HospitalTitleEntity hospitalTitle = new HospitalTitleEntity();
        hospitalTitle.setHospitalCode(hospitalCode);
        hospitalTitle.setHospitalAreaCode(schedule.getHospitalAreaCode());
        hospitalTitle.setName(schedule.getRegTitleName());
        hospitalTitle.setCode(schedule.getScheduleLevelCode());
        hospitalTitle.setStatus(Byte.valueOf((byte)1));
        hospitalTitle.setSerialNumber(Integer.valueOf(1));
        return hospitalTitle;
    }
}

