/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.exception.BillException;
import com.ebaiyihui.wisdommedical.pojo.vo.BillRespVo;
import com.ebaiyihui.wisdommedical.service.BillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u5355\u4e1a\u52a1api"})
@RequestMapping(value={"/api/v1/bill"})
public class BillController {
    private static final Logger log = LoggerFactory.getLogger(BillController.class);
    @Autowired
    private BillService billService;

    @ApiOperation(value="\u6302\u53f7\u670d\u52a1\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7", notes="\u6302\u53f7\u670d\u52a1\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7")
    @GetMapping(value={"getAppointmentBill"})
    public BaseResponse<List<BillRespVo>> getAppointmentBillByReceptId(@RequestParam(value="receptIdList") List<String> receptIdList) {
        if (CollectionUtils.isEmpty(receptIdList)) {
            return BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        List billRespVoList = null;
        try {
            billRespVoList = this.billService.getAppointmentBillByReceptId(receptIdList);
        }
        catch (BillException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)billRespVoList);
    }

    @ApiOperation(value="\u95e8\u8bca\u7f34\u8d39\u670d\u52a1\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7", notes="\u6839\u636ereceptId\u83b7\u53d6\u7b2c\u4e09\u65b9\u652f\u4ed8\u6d41\u6c34\u53f7")
    @GetMapping(value={"getOutPatientBill"})
    public BaseResponse<List<BillRespVo>> getOutpatientBillByReceptId(@RequestParam(value="receptIdList") List<String> receptIdList) {
        if (CollectionUtils.isEmpty(receptIdList)) {
            return BaseResponse.error((String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        }
        List billRespVoList = null;
        try {
            billRespVoList = this.billService.getOutPatientBillByReceptId(receptIdList);
        }
        catch (BillException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)billRespVoList);
    }
}

