/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    @Autowired
    private AppointmentService appointmentService;

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) {
        log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = (RabbitMqDelayedOrderVo)JSON.parseObject((String)rabbitMqDelayedOrderVoStr, RabbitMqDelayedOrderVo.class);
        String sysAppointmentId = rabbitMqDelayedOrderVo.getSysAppointmentId();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentService.getAppointmentRecordBySysAppointmentId(sysAppointmentId);
        if (appointmentRecordEntity == null) {
            log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\u7a7a\uff1a" + sysAppointmentId);
            return;
        }
        log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\uff1a " + JSON.toJSONString((Object)appointmentRecordEntity));
        if (appointmentRecordEntity.getAppointStatus().intValue() == AppointmentStatusEnum.WAIT_PAY.getValue().intValue() && AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() == appointmentRecordEntity.getAppointmentType()) {
            log.info("\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88 -> " + sysAppointmentId);
            UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo = new UpdateDelayAppointmentRecordVoReq();
            updateDelayAppointmentRecordVo.setCancelChannelCode(rabbitMqDelayedOrderVo.getChannelCode());
            updateDelayAppointmentRecordVo.setCancelReason("\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88");
            updateDelayAppointmentRecordVo.setCancelTime(new Date());
            updateDelayAppointmentRecordVo.setCancelType(CancelTypeEnum.NOT_PAY.getValue());
            updateDelayAppointmentRecordVo.setSysAppointmentId(sysAppointmentId);
            updateDelayAppointmentRecordVo.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
            updateDelayAppointmentRecordVo.setRemark("\u8d85\u65f6\u672a\u4ed8\u6b3e\uff0c\u5df2\u81ea\u52a8\u53d6\u6d88");
            this.appointmentService.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
        }
    }
}

