/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusRes;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterMsg;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.LockOrderReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ReturnRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetRecipelRes;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetPayRecordsResItems;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointOrderPayStatusCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HISPayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HisPayBusinessTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.UpdateScheduleDetailDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private MedicalCardApi cardApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    public static final List<Integer> appointmentStatusList = Arrays.asList(4, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ScheduleService scheduleService;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        List timeArrangeItems;
        String admDate = confirmAppointmentVo.getAdmDate();
        List getScheduleResItemsList = this.getHisDaySchedule(confirmAppointmentVo);
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            throw new ScheduleException("\u5b9e\u65f6\u67e5\u8be2\u533b\u751f\u6392\u73ed\u6570\u636e\u5f02\u5e38,\u8bf7\u91cd\u8bd5");
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)getScheduleResItemsList.get(0);
        confirmAppointmentVo = this.buildConfirmAppointmentVo(getScheduleResItems, confirmAppointmentVo);
        if (String.valueOf(LocalDate.now()).equals(admDate) && confirmAppointmentVo.getIsTimeArrange().equals(1) && !CollectionUtils.isEmpty((Collection)(timeArrangeItems = confirmAppointmentVo.getTimeArrangeItems()))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            timeArrangeItems.stream().filter(timeArrangeItem -> {
                LocalDateTime localDateTime = LocalDateTime.now();
                String admDteTimeStr = admDate + " " + timeArrangeItem.getStartTime();
                String nowDateTimeStr = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm"));
                try {
                    Long admDteTime = sdf.parse(admDteTimeStr).getTime();
                    Long nowDateTime = sdf.parse(nowDateTimeStr).getTime();
                    return admDteTime <= nowDateTime;
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u65e5\u671f\u5f02\u5e38:" + e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        if (String.valueOf(LocalDate.now()).equals(admDate)) {
            confirmAppointmentVo.setAppointmentType(2);
            confirmAppointmentVo.setWhetherToPay(YES_TOPAY);
        } else {
            confirmAppointmentVo.setAppointmentType(1);
            confirmAppointmentVo.setWhetherToPay(NOT_TOPAY);
        }
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        GatewayResponse dayGatewayResponse;
        QueryCardInfoResVO queryCardInfoResVO;
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getDoctorSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6392\u73ed\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(createOrderVoReq.getAdmTimeRange())).collect(Collectors.toList());
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u5348\u522b\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        if (null != createOrderVoReq.getTimeArrangeId() && !"".equals(createOrderVoReq.getTimeArrangeId())) {
            GetScheduleVoReq getScheduleVoReq = new GetScheduleVoReq();
            getScheduleVoReq.setDeptCode(createOrderVoReq.getDeptCode());
            getScheduleVoReq.setChannelName(createOrderVoReq.getChannelName());
            this.scheduleService.buildScheduleTimeArrangeItems(scheduleResItemsList, getScheduleVoReq);
            for (TimeArrangeItems timeArrangeItems : ((GetScheduleResItems)scheduleResItemsList.get(0)).getTimeArrangeItems()) {
                if (!createOrderVoReq.getTimeArrangeId().equals(timeArrangeItems.getTimeArrangeId())) continue;
                ((GetScheduleResItems)scheduleResItemsList.get(0)).setTimeArrangeItems(Arrays.asList(timeArrangeItems));
            }
        }
        if (null == (queryCardInfoResVO = this.getCardInfo(createOrderVoReq.getPatientCardNo(), createOrderVoReq.getChannelName()))) {
            log.error("======his\u83b7\u53d6\u60a3\u8005\u5361\u4fe1\u606f\u5931\u8d25=====");
            return null;
        }
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        AppointmentRecordEntity appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        createOrderVoReq.setPatientPhone(queryCardInfoResVO.getTelephone());
        if (LocalDate.now().toString().equals(createOrderVoReq.getAdmDate())) {
            GatewayRequest dayGatewayRequest = this.buildLockOrderReq(sysAppointmentId, getScheduleResItem, createOrderVoReq);
            log.info("\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + dayGatewayRequest);
            dayGatewayResponse = this.appointApi.lockOrder(dayGatewayRequest);
            log.info("\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + dayGatewayResponse);
            if (null == dayGatewayResponse) {
                log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                throw new AppointmentException("\u6302\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            if (!YES_TOPAY.equals(dayGatewayResponse.getCode())) {
                log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
                if ("430".equals(dayGatewayResponse.getErrCode())) {
                    throw new AppointmentException(dayGatewayResponse.getMsg());
                }
                throw new AppointmentException(dayGatewayResponse.getMsg());
            }
            if (null == gatewayResponse.getData()) {
                log.error("\u6302\u53f7 \u9501\u53f7\u5931\u8d25 lockOrder -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
                throw new AppointmentException("\u6302\u53f7\u5931\u8d25\uff0c\u8bf7\u552e\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
            }
        } else {
            throw new AppointmentException("\u6682\u65f6\u4e0d\u652f\u6301\u7ebf\u4e0a\u63d0\u524d\u6302\u53f7\uff0c\u8bf7\u9884\u7ea6\u5f53\u65e5\u4e4b\u5916\u7684\u53f7\u6e90\uff01");
        }
        DayConfirmRegisterRes dayConfirmRegisterRes = (DayConfirmRegisterRes)dayGatewayResponse.getData();
        appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(sysAppointmentId, dayConfirmRegisterRes, getScheduleResItem, createOrderVoReq, queryCardInfoResVO.getCredNo());
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo), (long)1800000L);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private AppointmentRecordEntity buildAppointmentRecordEntity(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq, CardDetailsInfoRespVO cardDetail) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAdmAddress(StringUtils.isEmpty((String)getScheduleResItem.getAdmLocation()) ? "null" : getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte(YES_TOPAY));
        appointmentRecordEntity.setPatientCardNo(cardDetail.getCardNo());
        appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPatientPhone());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(NOT_TOPAY));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildLockSourceAppointmentRecordEntity(long sysAppointmentId, DayConfirmRegisterRes dayConfirmRegisterRes, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq, String idCard) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(dayConfirmRegisterRes.getTransactionId());
        appointmentRecordEntity.setAppointmentNo(dayConfirmRegisterRes.getFlowNo());
        if (null != getScheduleResItem.getAdmLocation()) {
            appointmentRecordEntity.setAdmAddress(getScheduleResItem.getAdmLocation());
        } else {
            appointmentRecordEntity.setAdmAddress(getScheduleResItem.getLocName());
        }
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte(YES_TOPAY));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientId(createOrderVoReq.getPatientId());
        appointmentRecordEntity.setPatientIdCard(idCard);
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPatientPhone());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)idCard));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)idCard) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(NOT_TOPAY));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    private void checkPatientAppointmentInfo(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650");
        }
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
        if (!CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + JSON.toJSONString((Object)registerationQueryParamsDTO));
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)appointmentRecordEntityList));
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(1800L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u8fd4\u56de\u5bf9\u8c61 \uff1a" + JSON.toJSONString((Object)appointmentRecordVoList));
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            Integer appointStatus;
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.MORNING.getValue().intValue()) {
                appointmentRecordVo.setAdmTimeRange("09:00-12:00");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.AFTERNOON.getValue().intValue()) {
                appointmentRecordVo.setAdmTimeRange("13:00-17:00");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.ALL_DAY.getValue().intValue()) {
                appointmentRecordVo.setAdmTimeRange("09:00-17:00");
            }
            if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.NIGHT.getValue().intValue()) {
                appointmentRecordVo.setAdmTimeRange("18:00-21:00");
            }
            if (null != appointmentRecordEntity.getAdmTimeRange()) {
                appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            }
            if (appointmentStatusList.contains(appointStatus = appointmentRecordEntity.getAppointStatus())) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            appointmentRecordVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
            appointmentRecordVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            appointmentRecordVo.setIsTheDay(0L == daysRemaining ? 1L : 2L);
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
            cardDetailsInfoReqVO.setChannelCode("app");
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
        }
        Integer age = 0;
        try {
            age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
        }
        catch (ParseException e) {
            log.error("\u3010\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u3011\u8f6c\u6362\u5e74\u9f84\u51fa\u9519 :" + e.getMessage());
            throw new AppointmentException("\u8f6c\u6362\u5e74\u9f84\u51fa\u9519");
        }
        appointmentRecordDetailVo.setPatientAge(age);
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setHospitalName(appointmentRecordEntity.getHospitalName());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setPatientSex(Integer.valueOf(appointmentRecordEntity.getPatientSex()));
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        appointmentRecordDetailVo.setAdmDate(appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.MORNING.getValue().intValue()) {
            appointmentRecordDetailVo.setAdmTimeRange("09:00-12:00");
        }
        if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.AFTERNOON.getValue().intValue()) {
            appointmentRecordDetailVo.setAdmTimeRange("13:00-17:00");
        }
        if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.ALL_DAY.getValue().intValue()) {
            appointmentRecordDetailVo.setAdmTimeRange("09:00-17:00");
        }
        if (appointmentRecordEntity.getAdmRange() == AdmTimeRangeEnum.NIGHT.getValue().intValue()) {
            appointmentRecordDetailVo.setAdmTimeRange("18:00-21:00");
        }
        if (appointmentRecordEntity.getAppointmentType() == AppointmentTypeEnums.APPOINTMENT.getValue().intValue() && null != appointmentRecordEntity.getAdmTimeRange() && appointmentRecordEntity.getAdmTimeRange().length() >= 11) {
            appointmentRecordDetailVo.setAdmStartTime(appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
            appointmentRecordDetailVo.setAdmEndTime(appointmentRecordEntity.getAdmTimeRange().substring(6, 11));
        }
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        if (null == appointmentRecordEntity.getAdmAddress() || "".equals(appointmentRecordEntity.getAdmAddress())) {
            appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + appointmentRecordEntity.getDeptName());
        } else {
            appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getAdmAddress());
        }
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(1800L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 1800000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(appointmentRecordEntity.getRegFee());
        appointmentRecordDetailVo.setServiceFee(appointmentRecordEntity.getServiceFee());
        appointmentRecordDetailVo.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (appointmentStatusList.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
            appointmentRecordDetailVo.setIsTheDay(0L == daysRemaining ? 1L : 2L);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u53d6\u6d88\u9884\u7ea6 cancelAppoint";
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisCancelLockOrder(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CANCEL_APPOINTMENT.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88\u9884\u7ea6");
        appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88\u9884\u7ea6");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentCancelMsgPush(appointmentRecordEntity));
    }

    public void cancelRegister(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        GatewayRequest gatewayRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity.getAppointmentId(), appointmentRecordEntity.getAppointmentNo());
        String message = "\u53d6\u6d88\u6302\u53f7 \u53d6\u6d88\u6302\u53f7 cancelRegister";
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.CANCEL_APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisCancelRegister(gatewayRequest, message);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        int appointStatus = appointmentRecordEntity.getAppointStatus();
        if (appointStatus != AppointmentStatusEnum.PAY.getValue()) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (LocalDate.now().toString().equals(appointmentRecordEntity.getAdmDate())) {
            throw new AppointmentException("\u6682\u4e0d\u652f\u6301\u5f53\u65e5\u53f7\u7ebf\u4e0a\u9000\u6b3e\u3002\u8bf7\u524d\u5f80\u7ebf\u4e0b\u7a97\u53e3\u529e\u7406\uff01");
        }
        if (DateUtils.dateToSimpleString((Date)DateUtils.getCurrentDate()).compareTo(appointmentRecordEntity.getAdmDate()) >= 0) {
            throw new AppointmentException("\u60a8\u5df2\u7ecf\u8d85\u8fc7\u4e86\u9000\u6b3e\u65f6\u95f4\u9650\u5236\uff0c\u5f53\u524d\u65f6\u95f4\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        GatewayRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity.getAdmId(), withdrawNumberVoReq.getChannelCode());
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u9000\u53f7 withdrawNumber";
        GatewayResponse gatewayResponse = this.returnRegister(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        ReturnRegisterRes returnRegisterRes = (ReturnRegisterRes)gatewayResponse.getData();
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.HIS_REFUND.getValue().intValue()));
        appointmentPayorderEntity.setRefundBillNo(returnRegisterRes.getHisTradeNo());
        log.info("\u3010\u9000\u53f7\u3011\u6210\u529f -> \u4fee\u6539\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001 \uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setReturnAmount(new BigDecimal(returnRegisterRes.getReturnFee()));
        appointmentRecordEntity.setReturnTransationId(returnRegisterRes.getHisTradeNo());
        appointmentRecordEntity.setCancleTime(new Date());
        log.info("\u3010\u9000\u53f7\u3011\u6210\u529f -> \u4fee\u6539\u6302\u53f7\u8ba2\u5355\u72b6\u6001 \uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(withdrawNumberVoReq.getPayChannel());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        log.info("refund method--------> begain");
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUNDS_AWAITING_CONFIRMATION.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        businessResultEntity.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        return BaseResponse.success();
    }

    private GatewayResponse<ReturnRegisterRes> returnRegister(GatewayRequest<ReturnRegisterReq> gatewayRequest) throws AppointmentException {
        log.info("\u3010his\u9000\u53f7\u3011\u8bf7\u6c42\u53c2\u6570\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.returnRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u3010his\u9000\u53f7\u3011returnRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25");
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u9000\u53f7\u3011 returnRegister -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u9000\u53f7\u3011 returnRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        log.info("\u3010his\u9000\u53f7\u3011\u8bf7\u6c42\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a" + gatewayResponse);
        return gatewayResponse;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public BaseResponse confirmPay(String sysAppointmentId, String payChannel) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            throw new AppointmentException("\u8ba2\u5355\u4e0d\u5b58\u5728\uff0csysAppointmentId\uff1a" + sysAppointmentId);
        }
        if (AppointmentStatusEnum.PAY.getValue().intValue() == appointmentRecordEntity.getAppointStatus().intValue()) {
            return BaseResponse.success();
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(sysAppointmentId);
        if (null != appointmentPayorderEntity) {
            appointmentPayorderEntity.setOrderStatus(Byte.valueOf(Byte.parseByte(YES_TOPAY)));
            log.info("\u3010\u6302\u53f7\u652f\u4ed8\u6210\u529f\u3011-> \u4fee\u6539\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f\uff0c\u5f85\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentPayorderEntity));
            this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
        }
        log.info("\u3010\u6302\u53f7\u652f\u4ed8\u6210\u529f\u3011-> \u4fee\u6539\u6302\u53f7\u8ba2\u5355\u72b6\u6001\u4e3a\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        return BaseResponse.success();
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 PayRegistrationReq{}", gatewayRequest.getBody());
        GatewayResponse gatewayResponse = this.appointApi.dayRegister(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 PayRegistrationRes{}", (Object)JSON.toJSONString((Object)gatewayResponse));
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        if (gatewayResponse == null) {
            BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
            if (YES_TOPAY.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
            if (YES_TOPAY.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(gatewayResponse.getMsg() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        DayRegisterRes payRegistrationRes = (DayRegisterRes)gatewayResponse.getData();
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        updatePayAppointment.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        updatePayAppointment.setPayPostId(responseNotifyRestVo.getMchId());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        updatePayAppointment.setAppointNo(payRegistrationRes.getNo());
        updatePayAppointment.setAdmAdress(payRegistrationRes.getAdmitAddress());
        updatePayAppointment.setAdmId(payRegistrationRes.getAppointId());
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        if (null != payRegistrationRes) {
            updatePayAppointment.setReceptId(payRegistrationRes.getReceiptId());
        }
        updatePayAppointment.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelLockOrder(GatewayRequest<ReturnRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelAppoint(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u9884\u7ea6\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u9501\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<ReturnRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppoint");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<CancelRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, String appointmentId, String appointmentNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setAppointId(appointmentNo);
        cancelRegisterReq.setTransactionId(appointmentId);
        gatewayRequest.setBody((Object)cancelRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ReturnRegisterReq> buildWithdrawNumberGatewayReq(String appointmentId, String channel) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentId);
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("returnRegisterReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        if (LocalDate.now().toString().equals(createOrderVoReq.getAdmDate())) {
            throw new AppointmentException("\u5f53\u65e5\u53f7\u6e90\u6682\u4e0d\u652f\u6301\u9884\u7ea6\uff0c\u8bf7\u60a8\u5230\u7ebf\u4e0b\u81ea\u52a9\u673a\u6216\u7a97\u53e3\u5b8c\u6210\u6302\u53f7");
        }
        long sysAppointmnetId = this.snowflakeIdWorker.nextId();
        GetScheduleResItems getScheduleResItems = this.isHasAppointmentInfo(createOrderVoReq);
        if (null == getScheduleResItems) {
            throw new AppointmentException("\u6b64\u53f7\u6bb5\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u7528\u53ef\u7528\u53f7\u6bb5\uff01");
        }
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u5361\u4fe1\u606f\u6709\u8bef\uff0c\u9884\u7ea6\u5931\u8d25\uff01");
        }
        GatewayRequest gatewayRequest = this.buildConfirmRegisterReq(createOrderVoReq);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(createOrderVoReq.getChannelName());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6 \u8bf7\u6c42his\u5165\u53c2\uff1agatewayRequest:{}", (Object)gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.appoint(gatewayRequest);
        log.info("\u9884\u7ea6 \u8bf7\u6c42his\u51fa\u53c2\uff1aConfirmRegisterRes:{}", gatewayResponse.getData());
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (gatewayResponse == null) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u9884\u7ea6 confirmRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        ConfirmRegisterRes confirmRegisterRes = (ConfirmRegisterRes)gatewayResponse.getData();
        AppointmentRecordEntity appointmentRecordEntity = this.buildSuccessAppointmentRecordEntity(sysAppointmnetId, confirmRegisterRes, createOrderVoReq, getScheduleResItems, cardDetail);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(appointmentCreateOrderVoReq.getAdmTimeRange())).collect(Collectors.toList());
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u5348\u522b\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        for (GetScheduleResItems getScheduleResItems2 : scheduleResItemsList) {
            if (!appointmentCreateOrderVoReq.getScheduleHisId().equals(getScheduleResItems2.getScheduleId())) continue;
            return getScheduleResItems2;
        }
        return null;
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private GatewayRequest<ConfirmRegisterReq> buildConfirmRegisterReq(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setCardNo(appointmentCreateOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setRbasId(appointmentCreateOrderVoReq.getScheduleHisId());
        gatewayRequest.setBody((Object)confirmRegisterReq);
        gatewayRequest.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("appointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<LockOrderReq> buildLockOrderReq(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LockOrderReq lockOrderReq = new LockOrderReq();
        lockOrderReq.setCardNo(createOrderVoReq.getPatientCardNo());
        lockOrderReq.setScheduleCode(getScheduleResItem.getScheduleId());
        if (!CollectionUtils.isEmpty((Collection)getScheduleResItem.getTimeArrangeItems())) {
            List timeArrangeItems = getScheduleResItem.getTimeArrangeItems().stream().filter(timeArrangeItem -> timeArrangeItem.getTimeArrangeId().equals(createOrderVoReq.getTimeArrangeId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(timeArrangeItems)) {
                lockOrderReq.setBeginTime(((TimeArrangeItems)timeArrangeItems.get(0)).getStartTime());
                lockOrderReq.setEndTime(((TimeArrangeItems)timeArrangeItems.get(0)).getEndTime());
            } else {
                throw new AppointmentException("\u9501\u53f7\u672a\u627e\u5230\u5bf9\u5e94\u7684\u53f7\u6e90\uff01");
            }
        }
        lockOrderReq.setTradeDate(DateUtils.getCurrentDate((String)"yyyy-MM-dd"));
        lockOrderReq.setTradeTime(DateUtils.getCurrentDate((String)"HH:mm:ss"));
        gatewayRequest.setBody((Object)lockOrderReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(createOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("lockOrderReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes confirmRegisterRes, AppointmentCreateOrderVoReq createOrderVoReq, GetScheduleResItems getScheduleResItems, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(confirmRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeAddress(confirmRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(confirmRegisterRes.getTakeTime());
        if (!CollectionUtils.isEmpty((Collection)getScheduleResItems.getTimeArrangeItems())) {
            TimeArrangeItems timeArrangeItems = (TimeArrangeItems)getScheduleResItems.getTimeArrangeItems().get(0);
            appointmentRecordEntity.setAdmTimeRange(timeArrangeItems.getStartTime() + "-" + timeArrangeItems.getEndTime());
        }
        appointmentRecordEntity.setAppointmentNo(confirmRegisterRes.getNo());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINTED.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte(YES_TOPAY));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientId(cardDetailsInfoRespVO.getOrganPmi());
        appointmentRecordEntity.setPatientIdCard(cardDetailsInfoRespVO.getCredNo());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(cardDetailsInfoRespVO.getTel());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetailsInfoRespVO.getCredNo()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(getScheduleResItems.getRegFee()).add(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(confirmRegisterRes.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(getScheduleResItems.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItems.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItems.getScheduleLevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6210\u529f");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        QueryCardInfoResVO queryCardInfoResVO = this.getCardInfo(appointmentRecordEntity.getPatientCardNo(), dayAppointmentPayVoReq.getChannelCode());
        if (null == queryCardInfoResVO) {
            log.error("\u3010\u6302\u53f7\u652f\u4ed8\u3011====his\u83b7\u53d6\u5361\u4fe1\u606f\u5931\u8d25====");
            return BaseResponse.error((String)"his\u83b7\u53d6\u60a3\u8005\u5361\u4fe1\u606f\u5931\u8d25");
        }
        PayReq payReq = new PayReq();
        payReq.setType(HisPayBusinessTypeEnum.REG.getValue());
        payReq.setScheduleCode(appointmentRecordEntity.getScheduleHisId());
        payReq.setPatientCard(appointmentRecordEntity.getPatientIdCard());
        payReq.setPatientId(queryCardInfoResVO.getPatientNo());
        payReq.setOrgOrderNo(appointmentRecordEntity.getAppointmentId());
        payReq.setShouldPay(appointmentRecordEntity.getPayAmount());
        payReq.setDepartmentId(appointmentRecordEntity.getDeptCode());
        String result = "";
        if (dayAppointmentPayVoReq.getChannelCode().equals(ChannelEnum.USER_APPLETS.getValue())) {
            payReq.setOpenId(dayAppointmentPayVoReq.getOpenId());
            result = this.payUtil.weChatPay(payReq, dayAppointmentPayVoReq.getChannelCode());
        } else {
            result = this.payUtil.toPay(payReq, dayAppointmentPayVoReq.getChannelCode());
        }
        if (null == result) {
            return BaseResponse.error((String)"his\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
        return BaseResponse.success((Object)result);
    }

    public BaseResponse<String> appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(this.propertiesConstant.getAppointmentServiceCode());
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        BaseResponse baseResponse = this.payCreateOrder(appointmentPayVoReq);
        return baseResponse;
    }

    private String toPay(PayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(channelName);
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.appointApi.toPay(gatewayRequest);
        businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
        businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
        businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte(NOT_TOPAY));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private GatewayRequest<DayRegisterReq> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DayRegisterReq payRegistrationReq = new DayRegisterReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        if (PayChannelEnum.WECHAT.getValue().equals(responseNotifyRestVo.getPayChannel())) {
            payRegistrationReq.setPayChannel(HISPayChannelEnum.WECHAT.getValue());
        } else if (PayChannelEnum.ALIPAY.equals((Object)responseNotifyRestVo.getPayChannel())) {
            payRegistrationReq.setPayChannel(HISPayChannelEnum.ALIPAY.getValue());
        }
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setRbasId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setTransactionId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setQueueNo(appointmentRecordEntity.getAppointmentNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        DayRegisterMsg payRegistrationMsg = new DayRegisterMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationMsg.setPosid(responseNotifyRestVo.getMchId());
        payRegistrationMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payRegistrationMsg.setBusinessCode(responseNotifyRestVo.getServiceCode());
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private void updateScheduleSourceNo(GetScheduleResItems getScheduleResItems, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        UpdateScheduleDetailDTO updateScheduleDetailDTO = new UpdateScheduleDetailDTO();
        ArrayList<String> timeArrangeIdList = new ArrayList<String>();
        updateScheduleDetailDTO.setHospitalCode(appointmentCreateOrderVoReq.getHospitalCode());
        updateScheduleDetailDTO.setScheduleId(getScheduleResItems.getScheduleId());
        for (TimeArrangeItems timeArrangeItems : getScheduleResItems.getTimeArrangeItems()) {
            timeArrangeIdList.add(timeArrangeItems.getTimeArrangeId());
        }
        String timeArrangeId = "'" + StringUtils.join(timeArrangeIdList, (String)"','") + "'";
        updateScheduleDetailDTO.setTimeArrangeId(timeArrangeId);
        this.scheduleDetailRecordMapper.updateByGetScheduleResItems(updateScheduleDetailDTO);
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleVoReq getScheduleVoReq = new GetScheduleVoReq();
        getScheduleVoReq.setDeptCode(confirmAppointmentVo.getLocCode());
        getScheduleVoReq.setChannelName(confirmAppointmentVo.getChannelName());
        this.scheduleService.buildScheduleTimeArrangeItems((List)getScheduleResItemsList, getScheduleVoReq);
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(confirmAppointVo.getRegFee());
        confirmAppointmentVo.setDiagFee(confirmAppointVo.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!appointmentStatusList.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if (YES_TOPAY.equals(baseResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    private QueryCardInfoResVO getCardInfo(String cardNo, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCardNo(cardNo);
        queryCardInfoReqVO.setCredNo(cardNo);
        gatewayRequest.setBody((Object)queryCardInfoReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("QueryCardInfoReqVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.cardApi.queryCardInfo(gatewayRequest);
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011queryCardInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        QueryCardInfoResVO queryCardInfoResVO = (QueryCardInfoResVO)gatewayResponse.getData();
        return queryCardInfoResVO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void updatePayStatusByPollQuery(AppointmentRecordEntity appointmentRecordEntity) {
        boolean isPayed = false;
        AppointOrderStatusRes appointOrderStatusRes = null;
        try {
            Thread.sleep(2000L);
            for (int times = 600; times > 0; --times) {
                appointOrderStatusRes = this.payUtil.orderStatusQuery(appointmentRecordEntity.getAppointmentId(), appointmentRecordEntity.getChannelCode());
                if (null != appointOrderStatusRes && AppointOrderPayStatusCodeEnum.PAY_COMPLETED.getValue().equals(appointOrderStatusRes.getTradePayCode())) {
                    isPayed = true;
                    log.info("================\u6302\u53f7\u652f\u4ed8\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u6210\u529f==============");
                    break;
                }
                Thread.sleep(500L);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (isPayed) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
            appointmentRecordEntity.setPayAccdate(appointOrderStatusRes.getTradeDate() + " " + appointOrderStatusRes.getTradeTime());
            appointmentRecordEntity.setPayTransationId(appointOrderStatusRes.getTradeNo());
            GetRecipelReq getRecipelReq = new GetRecipelReq();
            getRecipelReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
            getRecipelReq.setTransactionId(appointmentRecordEntity.getAppointmentId());
            GetPayRecordsResItems getPayRecordsResItems = this.getCompletedPayInfo(getRecipelReq);
            if (null == getPayRecordsResItems) {
                log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u67e5\u8be2\u5931\u8d25\uff0c\u4ea4\u6613\u8ba2\u5355\u53f7\uff1a" + appointmentRecordEntity.getAppointmentId());
            } else {
                appointmentRecordEntity.setAdmId(getPayRecordsResItems.getAdmId());
                appointmentRecordEntity.setReceptId(getPayRecordsResItems.getReceiptId());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            if (null != appointmentPayorderEntity) {
                appointmentPayorderEntity.setOrderStatus(Byte.valueOf(Byte.parseByte("3")));
                this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
            }
        }
    }

    private GetPayRecordsResItems getCompletedPayInfo(GetRecipelReq getRecipelReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getRecipelReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setKeyWord("GetRecipelReq");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getValue());
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8bf7\u6c42\u53c2\u6570\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getCompletedPayInfo(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011\u8fd4\u56de\u53c2\u6570\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011getCompletedPayInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!YES_TOPAY.equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)((GetRecipelRes)gatewayResponse.getData()).getItems())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8bb0\u5f554905\u3011 getCompletedPayInfo -> his\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a");
            return null;
        }
        ArrayList payRecordsResItems = ((GetRecipelRes)gatewayResponse.getData()).getItems();
        return (GetPayRecordsResItems)payRecordsResItems.get(0);
    }
}

