/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.DocScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.TimeFrameItemVo;
import com.ebaiyihui.wisdommedical.service.DoctorScheduleService;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorScheduleServiceImpl
implements DoctorScheduleService {
    private static final Logger log = LoggerFactory.getLogger(DoctorScheduleServiceImpl.class);
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorService doctorService;

    public List<DocScheduleVoRes> getDoctorScheduleVoRes(String organCode, String doctorId) throws DoctorScheduleException {
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordEntity(doctorId, organCode);
        if (null == doctorRecordEntity || StringUtils.isEmpty((String)doctorRecordEntity.toString())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u533b\u9662\u8be5\u533b\u751fid \u7684\u533b\u751f\u7f16\u53f7: doctorId:{},organCode:{}", (Object)doctorId, (Object)organCode);
            return null;
        }
        Integer allowDays = 7;
        String scheduleDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        ArrayList<DocScheduleVoRes> getDoctorScheduleVoResList = new ArrayList<DocScheduleVoRes>();
        for (int i = 0; i < allowDays; ++i) {
            DocScheduleVoRes doctorScheduleVoRes = this.getGetDoctorScheduleVoResList(organCode, doctorRecordEntity.getDocCode(), scheduleDate);
            if (null == doctorScheduleVoRes) {
                scheduleDate = DateUtils.getNextDayToString((String)scheduleDate);
                continue;
            }
            scheduleDate = DateUtils.getNextDayToString((String)scheduleDate);
            getDoctorScheduleVoResList.add(doctorScheduleVoRes);
        }
        return getDoctorScheduleVoResList;
    }

    private TimeFrameItemVo getTimeFrameItemVo(String organCode, ScheduleRecordEntity scheduleRecordEntity) throws DoctorScheduleException {
        TimeFrameItemVo timeFrameItemVo = new TimeFrameItemVo();
        List detailRecordEntityList = this.scheduleDetailRecordMapper.selectByHisScheduleId(scheduleRecordEntity.getScheduleHisId(), organCode);
        Integer available = 0;
        if (null == detailRecordEntityList || detailRecordEntityList.isEmpty()) {
            return null;
        }
        String startTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(0)).getStartTime();
        String endTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(detailRecordEntityList.size() - 1)).getEndTime();
        String timeQuantum = startTime + "-" + endTime;
        timeFrameItemVo.setTimeQuantum(timeQuantum);
        BigDecimal totalFee = scheduleRecordEntity.getRegFee().add(scheduleRecordEntity.getDiagFee());
        timeFrameItemVo.setRegFee(totalFee.toString());
        timeFrameItemVo.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        timeFrameItemVo.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        timeFrameItemVo.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        return timeFrameItemVo;
    }

    private DocScheduleVoRes getGetDoctorScheduleVoResList(String organCode, String docCode, String scheduleDate) throws DoctorScheduleException {
        DocScheduleVoRes doctorScheduleVoRes = new DocScheduleVoRes();
        ArrayList<TimeFrameItemVo> listTimeFrame = new ArrayList<TimeFrameItemVo>();
        TimeFrameItemVo timeFrameItemVo = null;
        int tatolnum = 0;
        List recordEntityList = this.scheduleRecordMapper.selectByDocCodeAndDate(organCode, docCode, scheduleDate);
        if (null == recordEntityList || recordEntityList.isEmpty()) {
            return null;
        }
        for (ScheduleRecordEntity scheduleRecordEntity : recordEntityList) {
            timeFrameItemVo = this.getTimeFrameItemVo(organCode, scheduleRecordEntity);
            listTimeFrame.add(timeFrameItemVo);
            tatolnum += scheduleRecordEntity.getTotalCount().intValue();
        }
        doctorScheduleVoRes.setTimeFrameItemVos(listTimeFrame);
        doctorScheduleVoRes.setScheduleDate(scheduleDate + " " + DateUtils.getWeekZhou((String)scheduleDate));
        doctorScheduleVoRes.setTotalCount(Integer.valueOf(tatolnum));
        doctorScheduleVoRes.setDeptName(((ScheduleRecordEntity)recordEntityList.get(0)).getDeptName());
        doctorScheduleVoRes.setStatus(((ScheduleRecordEntity)recordEntityList.get(0)).getStatus().toString());
        doctorScheduleVoRes.setScheduleType(((ScheduleRecordEntity)recordEntityList.get(0)).getScheduleType().toString());
        doctorScheduleVoRes.setOrganName(((ScheduleRecordEntity)recordEntityList.get(0)).getHospitalName());
        return doctorScheduleVoRes;
    }
}

