/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.ScheduleDoctorDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorServiceImpl
implements DoctorService {
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;

    public DoctorRecordEntity getDoctorRecordEntity(String doctorId, String hospitalCode) {
        return this.doctorRecordMapper.selectByDoctorIdAndHospitalCode(doctorId, hospitalCode);
    }

    public List<DoctorRecordEntity> getDoctorIdList(String doctorCodes, String organId) {
        return this.doctorRecordMapper.getDoctorIdList(doctorCodes, organId);
    }

    public DoctorRecordEntity getDoctorRecordByDoctorCodeAndHosCode(String doctorCode, String organCode) {
        return this.doctorRecordMapper.getDoctorRecordByDoctorCodeAndHosCode(doctorCode, organCode);
    }

    public void updateDoctorIdByDoctorCode(String doctorId, String doctorCode, String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectOneByDocCodeAndHospitalCode(hospitalCode, doctorCode);
        if (doctorRecordEntity != null) {
            this.doctorRecordMapper.updateDoctorIdByDoctorCode(doctorId, doctorCode);
        }
    }

    public List<Long> getDoctorCodeListBydoctorIds(String doctorIds) {
        List doctorCodeList = this.doctorRecordMapper.getDoctorCodeList(doctorIds);
        List<Long> doctorIdList = doctorCodeList.stream().map(doctorRecordEntity -> {
            if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        return doctorIdList;
    }

    public List<ScheduleDoctorVoRes> getScheduleDoctor(ScheduleDoctorVoReq scheduleDoctorVoReq) {
        HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectByHospitalId(scheduleDoctorVoReq.getOrganId());
        if (null == hospitalAreaRecordEntity) {
            return new ArrayList<ScheduleDoctorVoRes>();
        }
        List scheduleDoctorDTOS = this.scheduleRecordMapper.selectByHospitalCodeAndDeptCode(hospitalAreaRecordEntity.getHospitalCode(), scheduleDoctorVoReq.getDeptCode());
        ArrayList<ScheduleDoctorVoRes> scheduleDoctorVoResList = new ArrayList<ScheduleDoctorVoRes>();
        for (ScheduleDoctorDTO scheduleDoctorDTO : scheduleDoctorDTOS) {
            if (!StringUtils.isNotBlank((CharSequence)scheduleDoctorDTO.getDoctorId())) continue;
            ScheduleDoctorVoRes scheduleDoctorVoRes = new ScheduleDoctorVoRes();
            scheduleDoctorVoRes.setDoctorId(Long.valueOf(scheduleDoctorDTO.getDoctorId()));
            scheduleDoctorVoRes.setDoctorCode(scheduleDoctorDTO.getDoctorCode());
            scheduleDoctorVoRes.setDoctorName(scheduleDoctorDTO.getDoctorName());
            scheduleDoctorVoRes.setDeptCode(scheduleDoctorDTO.getDeptCode());
            scheduleDoctorVoRes.setDeptName(scheduleDoctorDTO.getDeptName());
            scheduleDoctorVoResList.add(scheduleDoctorVoRes);
        }
        return scheduleDoctorVoResList;
    }
}

