/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HospitalizationApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusReq;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayReq;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointOrderPayStatusCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HisPayBusinessTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.HospStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetInpAdmissionItemsResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HospitalizationApi hospitalizationApi;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private MedicalCardApi cardApi;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private PayUtil payUtil;

    public List<GetInpAdmissionItemsResVO> getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO.getCardNo(), getInpAdmissionReqVO.getInHospNo());
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            return new ArrayList<GetInpAdmissionItemsResVO>();
        }
        String patientAge = "";
        if (null != ((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0)).getPatientAge() && !"".equals(((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0)).getPatientAge())) {
            try {
                int age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0)).getPatientAge()));
                patientAge = String.valueOf(age);
            }
            catch (ParseException e) {
                log.error("\u3010\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55\u3011\u5e74\u9f84\u8f6c\u6362\u5f02\u5e38: " + e.getMessage());
                throw new InHospitalException(e.getMessage());
            }
        }
        ArrayList<GetInpAdmissionItemsResVO> getInpAdmissionList = new ArrayList<GetInpAdmissionItemsResVO>();
        for (GetInpAdmissionResItems getInpAdmissionResItems : getInpAdmissionResItemsList) {
            GetInpAdmissionItemsResVO getInpAdmissionItemsResVO = new GetInpAdmissionItemsResVO();
            BeanUtils.copyProperties((Object)getInpAdmissionResItems, (Object)getInpAdmissionItemsResVO);
            if (HospStatusEnum.IN_HOSPITAL.getValue().equals(getInpAdmissionItemsResVO.getHospStatus())) {
                BigDecimal depost = new BigDecimal(getInpAdmissionItemsResVO.getTotalMoney()).add(new BigDecimal(getInpAdmissionItemsResVO.getCurrentMoney()));
                getInpAdmissionItemsResVO.setDepost(String.valueOf(depost));
            }
            getInpAdmissionItemsResVO.setPatientAge(patientAge);
            getInpAdmissionList.add(getInpAdmissionItemsResVO);
        }
        return getInpAdmissionList;
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        GatewayRequest getInpAdmissionReq = this.buildGetInpAdmissionReq(inHospitalRechargeDetailReqVO.getCardNo(), inHospitalRechargeDetailReqVO.getInHospNo());
        List inpAdmission = this.getInpAdmission(getInpAdmissionReq);
        if (CollectionUtils.isEmpty((Collection)inpAdmission)) {
            throw new InHospitalException("\u672a\u67e5\u5230\u60a3\u8005\u4f4f\u9662\u4fe1\u606f");
        }
        inHospitalRechargeDetailResVO.setHospStatus(((GetInpAdmissionResItems)inpAdmission.get(0)).getHospStatus());
        inHospitalRechargeDetailResVO.setCurrentMoney(((GetInpAdmissionResItems)inpAdmission.get(0)).getCurrentMoney());
        String admId = ((GetInpAdmissionResItems)inpAdmission.get(0)).getAdmId();
        BigDecimal detailTotalMoney = new BigDecimal("0");
        GatewayRequest gatewayRequest = this.buildGetRechargeDetailReq(admId);
        List rechargeDetailList = this.getRechargeDetail(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)rechargeDetailList)) {
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u9884\u4ea4\u91d1\u5145\u503c\u660e\u7ec6\u8bb0\u5f55");
        }
        for (GetIPDepositRecordsItems items : rechargeDetailList) {
            String amount_str;
            if ("\u5fae\u4fe1".equals(items.getPayChannel())) {
                items.setPayChannel(PayChannelEnum.WECHAT.getDisplay());
            }
            if ((amount_str = items.getAmout()).startsWith(".")) {
                amount_str = amount_str.replace(".", "0.");
            }
            items.setAmout(amount_str);
            detailTotalMoney = detailTotalMoney.add(new BigDecimal(amount_str));
        }
        inHospitalRechargeDetailResVO.setDetailTotalMoney(String.valueOf(detailTotalMoney));
        inHospitalRechargeDetailResVO.setDetailRechargeList(rechargeDetailList);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        GatewayRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        GetOrdItemsRes getOrdItemsRes = this.getInHospFeeDetail(getOrdItemsReqGatewayRequest);
        if (null == getOrdItemsRes) {
            new GetOrdItemsRes();
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        BeanUtils.copyProperties((Object)getOrdItemsRes, (Object)getIhHospitalOrderItemsResVo);
        List getOrdItemsResItemsList = getOrdItemsRes.getOrdItem();
        if (CollectionUtils.isEmpty((Collection)getOrdItemsResItemsList)) {
            return getIhHospitalOrderItemsResVo;
        }
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            String lastFreeDate = ((GetOrdItemsResItems)getOrdItemsResItemsList.stream().sorted(Comparator.comparing(GetOrdItemsResItems::getFeeDate).reversed()).collect(Collectors.toList()).get(0)).getFeeDate();
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(lastFreeDate.split(" ")[0])).collect(Collectors.toList());
        } else {
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(getHospitalOrderItemsReqVo.getFreeDate())).collect(Collectors.toList());
        }
        List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getAmount())).collect(Collectors.toList());
        BigDecimal totalMoney = new BigDecimal("0");
        for (BigDecimal amount : amountList) {
            totalMoney = totalMoney.add(amount);
        }
        getOrdItemsResItemsList.stream().forEach(getOrdItemsResItems -> {
            BigDecimal price = new BigDecimal(getOrdItemsResItems.getPrice());
            getOrdItemsResItems.setPrice(price.setScale(3, 4).toString());
        });
        Map<String, List<GetOrdItemsResItems>> getOrdItemsResItemsMap = getOrdItemsResItemsList.stream().collect(Collectors.groupingBy(GetOrdItemsResItems::getFeeType));
        ArrayList ihHospitalOrderFreeTypeVoList = new ArrayList();
        getOrdItemsResItemsMap.keySet().forEach(freeType -> {
            IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
            ihHospitalOrderFreeTypeVo.setFreeType(freeType);
            ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList((List)getOrdItemsResItemsMap.get(freeType));
            ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        });
        getIhHospitalOrderItemsResVo.setTotalMoney(totalMoney);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(inHospDepositCreateOrderReqVO.getInHospNo(), null);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            throw new InHospitalException("\u901a\u8fc7\u4f4f\u9662\u53f7\u672a\u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f,\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setOrganPmi(((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0)).getPatientId());
        cardDetailsInfoReqVO.setOrganCode(this.propertiesConstant.getOrganCode());
        cardDetailsInfoReqVO.setChannelCode("app");
        List cardDetailList = this.getCardInfoUtil.getCardDetailBypaitentId(cardDetailsInfoReqVO);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = new CardDetailsInfoRespVO();
        if (!CollectionUtils.isEmpty((Collection)cardDetailList)) {
            cardDetailsInfoRespVO = (CardDetailsInfoRespVO)cardDetailList.get(0);
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0), inHospDepositCreateOrderReqVO, cardDetailsInfoRespVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.buildInpatientPayorderEntity(inHospDepositCreateOrderReqVO, inpatientDepositDetailEntity.getId());
        try {
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new InHospitalException("pay\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        if (null == inpatientDepositDetailEntity) {
            return BaseResponse.error((String)("\u6ca1\u627e\u5230\u8be5\u5145\u503c\u8ba2\u5355: " + inHospDepositPayReqVO.getOrderSeq()));
        }
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        queryCardInfoResVO = this.getCardInfo(inpatientDepositDetailEntity.getCardNo(), inHospDepositPayReqVO.getChannelCode());
        if (null == queryCardInfoResVO) {
            return BaseResponse.error((String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5931\u8d25");
        }
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setPatientId(queryCardInfoResVO.getPatientNo());
        comfirmPayNewReq.setCardNo(inpatientDepositDetailEntity.getCardNo());
        comfirmPayNewReq.setId(inpatientDepositDetailEntity.getAdmissionNo());
        comfirmPayNewReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        comfirmPayNewReq.setFeeType(HisPayBusinessTypeEnum.INPATIENT_DEPOSIT.getValue());
        ComfirmPayNewRes comfirmPayNewRes = this.createHisOutPatOrder(comfirmPayNewReq, inHospDepositPayReqVO.getChannelCode());
        if (null == comfirmPayNewRes) {
            return BaseResponse.error((String)"his\u4f4f\u9662\u5145\u503c\u751f\u6210\u8ba2\u5355\u5931\u8d25");
        }
        inpatientDepositDetailEntity.setReceiptId(comfirmPayNewRes.getReceiptId());
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        if (null != inpatientPayorderEntity && inpatientPayorderEntity.getPayStatus().equals(PayStatusEnum.HAS_PAY_OR_REFUND.getValue())) {
            return BaseResponse.success();
        }
        String result = "";
        PayReq payReq = new PayReq();
        payReq.setType(HisPayBusinessTypeEnum.INPATIENT_DEPOSIT.getValue());
        payReq.setAdmId(inpatientDepositDetailEntity.getAdmissionNo());
        payReq.setOrgOrderNo(comfirmPayNewRes.getReceiptId());
        payReq.setShouldPay(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        payReq.setPatientId(queryCardInfoResVO.getPatientNo());
        payReq.setPatientCard(inpatientDepositDetailEntity.getCardNo());
        if (inHospDepositPayReqVO.getChannelCode().equals(ChannelEnum.USER_APPLETS.getValue())) {
            payReq.setOpenId(inHospDepositPayReqVO.getOpenId());
            result = this.weChatPay(payReq, inHospDepositPayReqVO.getChannelCode());
        } else {
            result = this.toPay(payReq, inHospDepositPayReqVO.getChannelCode());
        }
        if (null == result) {
            return BaseResponse.error((String)"his\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
        inpatientDepositDetailEntity.setChannel(inHospDepositPayReqVO.getChannelCode());
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        this.taskExecutor.execute(() -> this.updatePayStatusByPollQuery(inpatientDepositDetailEntity));
        return BaseResponse.success((Object)result);
    }

    private QueryCardInfoResVO getCardInfo(String cardNo, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCardNo(cardNo);
        queryCardInfoReqVO.setCredNo(cardNo);
        gatewayRequest.setBody((Object)queryCardInfoReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("QueryCardInfoReqVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.cardApi.queryCardInfo(gatewayRequest);
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011queryCardInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        QueryCardInfoResVO queryCardInfoResVO = (QueryCardInfoResVO)gatewayResponse.getData();
        return queryCardInfoResVO;
    }

    private ComfirmPayNewRes createHisOutPatOrder(ComfirmPayNewReq comfirmPayNewReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("ComfirmPayNewReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        log.info("\u3010his\u751f\u6210\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u3011\u8fd4\u56de\u53c2\u6570 comfirmPayNewRes -> " + JSON.toJSONString((Object)comfirmPayNewRes));
        return comfirmPayNewRes;
    }

    private String weChatPay(PayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.weChatPay(gatewayRequest);
        log.info("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u5fae\u4fe1\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    private String toPay(PayReq payReq, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)payReq);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("PayReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.toPay(gatewayRequest);
        log.info("\u3010\u53d1\u8d77\u652f\u4ed8\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u53d1\u8d77\u652f\u4ed8\u3011comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (String)gatewayResponse.getData();
    }

    private AppointOrderStatusRes orderStatusQuery(String hisTradeNo, String channel) {
        AppointOrderStatusReq appointOrderStatusReq = new AppointOrderStatusReq();
        appointOrderStatusReq.setHisTradeNo(hisTradeNo);
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)appointOrderStatusReq);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("orderStatusQueryVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.orderStatusQuery(gatewayRequest);
        log.info("\u3010\u8ba2\u5355\u72b6\u6001\u67e5\u8be2\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u8ba2\u5355\u72b6\u6001\u67e5\u8be2 AppointOrderStatusQuery -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u8ba2\u5355\u72b6\u6001\u67e5\u8be2 AppointOrderStatusQuery -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u8ba2\u5355\u72b6\u6001\u67e5\u8be2 AppointOrderStatusQuery -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return (AppointOrderStatusRes)gatewayResponse.getData();
    }

    private void updatePayStatusByPollQuery(InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        boolean isPayed = false;
        AppointOrderStatusRes appointOrderStatusRes = null;
        try {
            Thread.sleep(5000L);
            for (int times = 300; times > 0; --times) {
                appointOrderStatusRes = this.orderStatusQuery(inpatientDepositDetailEntity.getReceiptId(), inpatientDepositDetailEntity.getChannel());
                if (null != appointOrderStatusRes && appointOrderStatusRes.getTradePayCode() == AppointOrderPayStatusCodeEnum.PAY_COMPLETED.getValue().intValue()) {
                    isPayed = true;
                    break;
                }
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException e) {
            log.error("\u3010\u4f4f\u9662\u5145\u503c\u8ba2\u5355\u8be6\u60c5\u3011\u51fa\u9519\uff1a" + e.getMessage());
        }
        if (isPayed) {
            log.info("\u3010\u4f4f\u9662\u5145\u503c\u3011\u652f\u4ed8\u6210\u529f -> \u4fee\u6539\u4f4f\u9662\u8ba2\u5355\u8868\u652f\u4ed8\u72b6\u6001\uff1a" + JSON.toJSONString((Object)inpatientDepositDetailEntity));
            inpatientDepositDetailEntity.setStatus(Byte.valueOf(InpatientDepositDetailStatusEnum.PAID.getValue().byteValue()));
            InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
            if (null != inpatientPayorderEntity) {
                log.info("\u3010\u4f4f\u9662\u5145\u503c\u3011\u652f\u4ed8\u6210\u529f -> \u4fee\u6539\u4f4f\u9662\u652f\u4ed8\u8ba2\u5355\u8868\u652f\u4ed8\u72b6\u6001\uff1a" + JSON.toJSONString((Object)inpatientPayorderEntity));
                inpatientPayorderEntity.setPayStatus(Byte.valueOf(PayStatusEnum.HAS_PAY_OR_REFUND.getValue().byteValue()));
                this.inpatientPayorderEntityMapper.updateByPrimaryKey(inpatientPayorderEntity);
            }
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    public DepositRes InHospDeposit(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
        return this.getDepositRes(gatewayRequest);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        return depositCreateOrderResVO;
    }

    private GatewayRequest<GetInpAdmissionReq> buildGetInpAdmissionReq(String cardNo, String inHospNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCardNo(cardNo);
        getInpAdmissionReq.setInHospNo(inHospNo);
        gatewayRequest.setBody((Object)getInpAdmissionReq);
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getDisplay());
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInpAdmissionItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetIPDepositRecordsReq> buildGetRechargeDetailReq(String admId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setAdmId(admId);
        gatewayRequest.setBody((Object)getIPDepositRecordsReq);
        gatewayRequest.setChannelName(ChannelEnum.MANAGER.getDisplay());
        gatewayRequest.setChannel(ChannelEnum.MANAGER.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetRechargeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getCardNo());
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            getOrdItemsReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractMonth((Date)new Date(), (int)1)));
            getOrdItemsReq.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        } else {
            getOrdItemsReq.setStartDate(getHospitalOrderItemsReqVo.getFreeDate());
            getOrdItemsReq.setEndDate(getHospitalOrderItemsReqVo.getFreeDate());
        }
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInHospFeeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setPayChannel(responseNotifyRestVo.getPayChannel());
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getOutTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setSuccess("Y");
        depositRespmsg.setUsrmsg("");
        depositRespmsg.setPosId(responseNotifyRestVo.getMchId());
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        depositRespmsg.setBusinessCode(responseNotifyRestVo.getServiceCode());
        depositReq.setRespmsg(depositRespmsg);
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private List<GetInpAdmissionResItems> getInpAdmission(GatewayRequest<GetInpAdmissionReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getInpAdmission(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetInpAdmissionResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetInpAdmissionResItems>();
        }
        GetInpAdmissionRes getInpAdmissionRes = (GetInpAdmissionRes)gatewayResponse.getData();
        if (null == getInpAdmissionRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetInpAdmissionResItems>();
        }
        if (StringUtils.isEmpty((CharSequence)((GetInpAdmissionReq)gatewayRequest.getBody()).getCardNo()) && (getInpAdmissionRes.getItems() == null || getInpAdmissionRes.getItems().isEmpty())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            throw new InHospitalException("\u672a\u67e5\u5230\u76f8\u5173\u8bb0\u5f55 \u8bf7\u68c0\u67e5\u4f4f\u9662\u53f7\u662f\u5426\u6b63\u786e");
        }
        if (getInpAdmissionRes.getItems() == null || getInpAdmissionRes.getItems().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return new ArrayList<GetInpAdmissionResItems>();
        }
        if (getInpAdmissionRes.getItems() == null || getInpAdmissionRes.getItems().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return new ArrayList<GetInpAdmissionResItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8bb0\u5f55\u5217\u8868 Items:{}", (Object)getInpAdmissionRes.getItems());
        return getInpAdmissionRes.getItems();
    }

    private List<GetIPDepositRecordsItems> getRechargeDetail(GatewayRequest<GetIPDepositRecordsReq> gatewayRequest) {
        ArrayList rechargeDetailList = null;
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getIPDepositRecords(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = (GetIPDepositRecordsRes)gatewayResponse.getData();
        if (null == getIPDepositRecordsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        rechargeDetailList = getIPDepositRecordsRes.getItems();
        if (null == rechargeDetailList || rechargeDetailList.isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u65e0\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8fd4\u56dehis\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868 Items:{}", (Object)getIPDepositRecordsRes.getItems());
        return rechargeDetailList;
    }

    private GetOrdItemsRes getInHospFeeDetail(GatewayRequest<GetOrdItemsReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getOrdItems(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        GetOrdItemsRes getOrdItemsRes = (GetOrdItemsRes)gatewayResponse.getData();
        if (null == getOrdItemsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!CollectionUtils.isEmpty((Collection)getOrdItemsRes.getOrdItem())) {
            getOrdItemsRes.setAdmDate(((GetOrdItemsResItems)getOrdItemsRes.getOrdItem().get(0)).getFeeDate());
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8d39\u7528\u6e05\u5355 OrdItems:{}", (Object)getOrdItemsRes);
        return getOrdItemsRes;
    }

    private DepositRes getDepositRes(GatewayRequest<DepositReq> gatewayRequest) throws InHospitalException {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.deposit(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        DepositRes depositRes = (DepositRes)gatewayResponse.getData();
        if (null == depositRes) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8fd4\u56dehis\u5145\u503c\u6210\u529f\u51ed\u8bc1 depositRes:{}", (Object)depositRes);
        return depositRes;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(getInpAdmissionResItems.getAdmId());
        depositDetailEntity.setInpatientDate(DateUtils.stringToSimpleDate((String)getInpAdmissionResItems.getStartDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientOrganId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(cardDetailsInfoRespVO.getCardId());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getCardNo());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0"));
        BigDecimal preMoneyBalance = new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0").subtract(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyBalance(preMoneyBalance);
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, Long id) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(id);
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setDealSeq("");
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(DepositPayReqVO depositPayReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)depositPayReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("InHospitalServiceImpl.payCreateOrder\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }
}

