/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ElectronicReportApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsReq;
import com.ebaiyihui.his.pojo.vo.report.GetReportListsRes;
import com.ebaiyihui.his.pojo.vo.report.LisReportListReq;
import com.ebaiyihui.his.pojo.vo.report.LisReportListRes;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListReq;
import com.ebaiyihui.his.pojo.vo.report.PacsReportListRes;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsReq;
import com.ebaiyihui.wisdommedical.pojo.vo.CheckReportDetailsRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ListReportHosRes;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Resource
    private ElectronicReportApi electronicReportClient;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final int PACS_REPORT = 2;
    private final int LIS_REPOST = 1;
    private static final String DOC_START_WITH = "https:";
    private static final String DOC_URL = "mzjh-checkreport.chinachdu.com";

    public BaseResponse<ListReportHosRes> queryLisReportList(ListReportHosReq param) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005id\u5931\u8d25=====");
            return null;
        }
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(cardDetail.getCardNo());
        listReportParam.setPatientId(cardDetail.getOrganPmi());
        listReportParam.setBeginTime(param.getBeginDate());
        listReportParam.setEndTime(param.getEndDate());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = null;
        if (param.getReportType() == 1) {
            this.logger.info("his\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u6570\u636e \u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
            response = this.electronicReportClient.getlisReportLists(gatewayRequest);
        } else if (param.getReportType() == 2) {
            this.logger.info("his\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u5217\u8868\u6570\u636e \u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
            response = this.electronicReportClient.getpacsReportLists(gatewayRequest);
        }
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse(response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        this.logger.info("his\u67e5\u8be2\u62a5\u544a\u5217\u8868\u6570\u636e \u8bf7\u6c42\u51fa\u53c2\uff1a" + response.getData());
        List reportDataList = gateWayData.getDatas();
        if (reportDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        ListReportHosRes data = new ListReportHosRes();
        List reportInfoList = reportDataList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList();
        }
        int age = 0;
        try {
            age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetail.getBirth()));
        }
        catch (ParseException e) {
            this.logger.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\uff1a\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff0ce: " + e.getMessage());
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) {
                reportInfo.setReportDate(reportInfo.getReportTime());
            }
            if (String.valueOf(2).equals(reportInfo.getReportType())) {
                reportInfo.setDocUrl(this.getNewUrl(reportInfo.getDocUrl()));
            }
            reportInfo.setPatientName(cardDetail.getPatientName());
            reportInfo.setSex(Integer.valueOf(cardDetail.getGender().intValue()));
            reportInfo.setAge(Integer.valueOf(age));
        }
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    private String getNewUrl(String url) {
        String[] old_urlStr1;
        String[] old_urlStr = url.split("//");
        String new_url = "https://mzjh-checkreport.chinachdu.com";
        String new_url_end = "";
        if (old_urlStr.length > 1 && (old_urlStr1 = old_urlStr[1].split("/")).length >= 1) {
            for (int i = 1; i < old_urlStr1.length; ++i) {
                new_url_end = new_url_end + "/" + old_urlStr1[i];
            }
        }
        new_url = new_url + new_url_end;
        return new_url;
    }

    public BaseResponse<ReportDetailRes> queryReportDetail(ReportDetailReq param) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25=====");
            return null;
        }
        LisReportListReq lisReportListReq = new LisReportListReq();
        lisReportListReq.setReportNo(param.getReportNo());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)lisReportListReq);
        GatewayResponse response = this.electronicReportClient.lisReportList(gatewayRequest);
        LisReportListRes gateWayData = (LisReportListRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        ReportDetailRes reportDetail = new ReportDetailRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        List lisReportListResDataList = gateWayData.getDatas();
        if (lisReportListResDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        List reportDetailDataList = lisReportListResDataList.stream().map(arg_0 -> this.matchJyReportDetail(arg_0)).collect(Collectors.toList());
        reportDetail.setDatas(reportDetailDataList);
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date birthday = simpleDateFormat.parse(cardDetail.getBirth());
            String age = String.valueOf(DateUtils.getAgeByBirth((Date)birthday));
            reportDetail.setAge(age);
        }
        catch (ParseException e) {
            this.logger.info(e.toString());
        }
        reportDetail.setPatientName(cardDetail.getPatientName());
        reportDetail.setSex(String.valueOf(cardDetail.getGender()));
        return BaseResponse.success((Object)reportDetail);
    }

    public BaseResponse<ListReportHosRes> queryPacsReportList(ListReportHosReq param) {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005id\u5931\u8d25=====");
            return null;
        }
        GetReportListsReq listReportParam = new GetReportListsReq();
        listReportParam.setCardNo(cardDetail.getCardNo());
        listReportParam.setPatientId(cardDetail.getOrganPmi());
        listReportParam.setBeginTime(param.getBeginDate());
        listReportParam.setEndTime(param.getEndDate());
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)listReportParam);
        GatewayResponse response = this.electronicReportClient.getpacsReportLists(gatewayRequest);
        GetReportListsRes gateWayData = (GetReportListsRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        List reportDataList = gateWayData.getDatas();
        if (reportDataList == null) {
            this.logger.error("request his gateway error - \u6682\u65e0\u6570\u636e");
            return BaseResponse.success();
        }
        ListReportHosRes data = new ListReportHosRes();
        List reportInfoList = reportDataList.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).map(arg_0 -> this.matchReportData(arg_0)).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(reportInfoList)) {
            reportInfoList = new ArrayList();
        }
        for (ReportInfo reportInfo : reportInfoList) {
            if (!StringUtils.isBlank((CharSequence)reportInfo.getReportDate())) continue;
            reportInfo.setReportDate(reportInfo.getReportTime());
        }
        data.setReportList(reportInfoList);
        return BaseResponse.success((Object)data);
    }

    public BaseResponse<CheckReportDetailsRes> queryCheckReportDetail(CheckReportDetailsReq param) {
        PacsReportListReq pacsReportListReq = new PacsReportListReq();
        pacsReportListReq.setReportNo(param.getReportNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(param.getCardId());
        if (null == cardDetail) {
            this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u83b7\u53d6\u60a3\u8005\u4fe1\u606f\u5931\u8d25=====");
            return null;
        }
        GatewayRequest gatewayRequest = this.getGateWayParam((NetReportBaseRequest)param, (Object)pacsReportListReq);
        GatewayResponse response = this.electronicReportClient.pacsReportList(gatewayRequest);
        PacsReportListRes gateWayData = (PacsReportListRes)this.checkHisResponse((BaseResponse)response);
        if (gateWayData == null) {
            return BaseResponse.success();
        }
        CheckReportDetailsRes reportDetail = new CheckReportDetailsRes();
        BeanUtils.copyProperties((Object)gateWayData, (Object)reportDetail);
        reportDetail.setAdmType("O");
        Date birth = DateUtils.stringToSimpleDate((String)cardDetail.getBirth());
        int age = 0;
        try {
            age = DateUtils.getAgeByBirth((Date)birth);
            reportDetail.setAge(String.valueOf(age));
        }
        catch (ParseException e) {
            this.logger.error("\u3010\u68c0\u67e5\u62a5\u544a\u660e\u7ec6\u67e5\u8be2\u3011======\u8f6c\u6362\u60a3\u8005\u5e74\u9f84\u5931\u8d25=====", (Object)e.getMessage());
        }
        reportDetail.setPatientName(cardDetail.getPatientName());
        reportDetail.setSex(String.valueOf(cardDetail.getGender()));
        reportDetail.setAuthUser(gateWayData.getDoctorName());
        reportDetail.setCheckImages(gateWayData.getCheckImages());
        return BaseResponse.success((Object)reportDetail);
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setDeptName(hisReportData.getDeptName());
        reportData.setDiagnosis(hisReportData.getClinicalDiagnosis());
        reportData.setDoctorName(hisReportData.getReportDoctorName());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        reportData.setDocUrl(hisReportData.getDocUrl());
        return reportData;
    }

    private <T> T checkHisResponse(BaseResponse<T> response) {
        if (response == null) {
            this.logger.error("request his gateway error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!response.isSuccess()) {
            this.logger.error("request his gateway error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getData() == null) {
            this.logger.error("request his gateway error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        return (T)response.getData();
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }
}

