/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusReq;
import com.ebaiyihui.his.pojo.vo.appoint.AppointOrderStatusRes;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.pojo.vo.card.QueryCardInfoResVO;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordDetailItemsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordDetailReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordDetailRes;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetPayRecordsRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PrePayReq;
import com.ebaiyihui.his.pojo.vo.outpatient.PrePayRes;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.GetAdmissionItems;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.HISPayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.AdmStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.PayItemDatasDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetAdmissionRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ItemTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PayItemResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.CreateOutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final byte OUTPATIENT_DEPARTMENT = 1;
    public static final byte EMERGENCY_TREATMENT = 2;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String WECHAT = "WECHAT";
    public static final String ALIPAY = "ALIPAY";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private MedicalCardApi cardApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    public List<GetAdmissionRespVO> getAdmission(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = this.buildGetAdmissionGatewayReq(getAdmissionReqVO);
        log.info("OutpatientPaymentServiceImpl.getAdmission->\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List getAdmissionItemsList = this.getAdmission(gatewayRequest);
        return this.buildOutpatientPaymentRespVOList(getAdmissionItemsList, getAdmissionReqVO.getCardId());
    }

    private List<GetAdmissionItems> getAdmission(GatewayRequest<GetAdmissionReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getAdmission(gatewayRequest);
        log.info("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868:" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        GetAdmissionRes getAdmissionRes = (GetAdmissionRes)gatewayResponse.getData();
        if (null == getAdmissionRes.getItems() || getAdmissionRes.getItems().isEmpty()) {
            log.error("\u67e5\u8be2\u5f85\u7f34\u8d39\u95e8\u8bca\u5217\u8868 OutpatientPaymentServiceImpl.getAdmission -> his\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u5f85\u7f34\u8d39\u95e8\u8bca\u4fe1\u606f");
        }
        return getAdmissionRes.getItems();
    }

    private List<GetAdmissionRespVO> buildOutpatientPaymentRespVOList(List<GetAdmissionItems> getAdmissionItemsList, String cardId) {
        if (CollectionUtils.isEmpty(getAdmissionItemsList)) {
            return new ArrayList<GetAdmissionRespVO>();
        }
        List<GetAdmissionRespVO> listOutpatientPaymentRespVOs = getAdmissionItemsList.stream().filter(getAdmissionItems -> AdmStatusEnum.BEING_ADM.getValue().intValue() == Integer.valueOf(getAdmissionItems.getAdmStatus()).intValue()).map(getAdmissionItems -> {
            GetAdmissionRespVO getAdmissionRespVO = new GetAdmissionRespVO();
            BeanUtils.copyProperties((Object)getAdmissionItems, (Object)getAdmissionRespVO);
            getAdmissionRespVO.setCardId(cardId);
            getAdmissionRespVO.setPayStatus("0");
            return getAdmissionRespVO;
        }).collect(Collectors.toList());
        return listOutpatientPaymentRespVOs;
    }

    private GatewayRequest<GetAdmissionReq> buildGetAdmissionGatewayReq(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        GetAdmissionReq getAdmissionReq = new GetAdmissionReq();
        if (null == getAdmissionReq.getBgDate() || "".equals(getAdmissionReq.getBgDate()) || null == getAdmissionReq.getEdDate() || "".equals(getAdmissionReq.getEdDate())) {
            getAdmissionReq.setEdDate(LocalDate.now().toString());
            getAdmissionReq.setBgDate(DateUtils.dateToSimpleString((Date)DateUtils.getDateBefore((Date)new Date(), (int)2)));
        } else {
            getAdmissionReq.setBgDate(getAdmissionReqVO.getBgDate());
            getAdmissionReq.setEdDate(getAdmissionReqVO.getEdDate());
        }
        getAdmissionReq.setCardNo(getAdmissionReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("getAdmission");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAdmissionReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public GetPayItemRespVO getPayItem(GetPayItemReqVO getPayItemReqVO) throws OutpatientPaymentException {
        GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
        GatewayRequest gatewayRequest = this.buildPayItemGatewayReq(getPayItemReqVO);
        log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", (Object)gatewayRequest);
        List payItemResDatasList = this.payItem(gatewayRequest);
        log.info("OutpatientPaymentServiceImpl.getPayItem->\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee,\u8bf7\u6c42his\u51fa\u6570 payItemResDatasList:{}", (Object)payItemResDatasList);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(getPayItemReqVO.getCardId());
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
        getPayItemRespVO.setOutPatientId(outPatientId);
        this.buildPayItemDatasRespVO(getPayItemReqVO, getPayItemRespVO, payItemResDatasList, cardDetailsInfoRespVO);
        PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(outPatientId, getPayItemReqVO, payItemResDatasList, cardDetailsInfoRespVO);
        String payItemDatasDTOStr = JSON.toJSONString((Object)payItemDatasDTO);
        this.jedisCluster.set(outPatientId, payItemDatasDTOStr);
        this.jedisCluster.expire(outPatientId, 7200);
        return getPayItemRespVO;
    }

    private List<PayItemResDatas> payItem(GatewayRequest<PayItemReq> gatewayRequest) throws OutpatientPaymentException {
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.payItem(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (null == gatewayResponse.getData()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        PayItemRes payItemRes = (PayItemRes)gatewayResponse.getData();
        if (null == payItemRes.getDatas() || payItemRes.getDatas().isEmpty()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
            throw new OutpatientPaymentException("\u6682\u65e0\u95e8\u8bca\u6536\u8d39\u9879\u76ee\u4fe1\u606f");
        }
        return payItemRes.getDatas();
    }

    private void buildPayItemDatasRespVO(GetPayItemReqVO getPayItemReqVO, GetPayItemRespVO getPayItemRespVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        getPayItemRespVO.setName(cardDetailsInfoRespVO.getPatientName());
        getPayItemRespVO.setSex(cardDetailsInfoRespVO.getGender().toString());
        getPayItemRespVO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        getPayItemRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        getPayItemRespVO.setAmount(amount.toString());
        getPayItemRespVO.setPayItemResVoList(payItemResVos);
        getPayItemRespVO.setCardNo(getPayItemReqVO.getCardNo());
        getPayItemRespVO.setDeptName(getPayItemReqVO.getDeptName());
        getPayItemRespVO.setDocName(getPayItemReqVO.getDocName());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
    }

    private List<PayItemResVo> buildPayItemResVoList(List<PayItemResDatas> payItemResDatasList, String admId) {
        ArrayList<PayItemResVo> payItemResList = new ArrayList<PayItemResVo>();
        payItemResDatasList.forEach(payItemResDatas -> {
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setItemTypeName(payItemResDatas.getItemTypeName());
            BigDecimal amount = new BigDecimal(payItemResDatas.getAmount());
            payItemResVo.setAmount(amount.setScale(2, 4).toString());
            payItemResVo.setOrderNo(payItemResDatas.getOrderNo());
            payItemResVo.setItems((List)payItemResDatas.getItems());
            payItemResVo.getItems().forEach(payItemResItems -> {
                String sum_str = payItemResItems.getSum();
                BigDecimal sum = new BigDecimal(sum_str);
                payItemResItems.setSum(sum.setScale(2, 4).toString());
                String price_str = payItemResItems.getPrice();
                BigDecimal price = new BigDecimal(price_str);
                payItemResItems.setPrice(price.setScale(2, 4).toString());
            });
            payItemResList.add(payItemResVo);
        });
        return payItemResList;
    }

    private PayItemDatasDTO buildPayItemDatasDTOForRedis(String outPatientId, GetPayItemReqVO getPayItemReqVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        PayItemDatasDTO payItemDatasDTO = new PayItemDatasDTO();
        payItemDatasDTO.setOutPatientId(outPatientId);
        payItemDatasDTO.setUserId(getPayItemReqVO.getUserId());
        payItemDatasDTO.setCardNo(getPayItemReqVO.getCardNo());
        payItemDatasDTO.setCardId(getPayItemReqVO.getCardId());
        payItemDatasDTO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        payItemDatasDTO.setAdmDate(getPayItemReqVO.getAdmDate());
        payItemDatasDTO.setAdmType(getPayItemReqVO.getAdmType());
        payItemDatasDTO.setPatientOrganId(cardDetailsInfoRespVO.getOrganPmi());
        payItemDatasDTO.setIdCard(cardDetailsInfoRespVO.getCredNo());
        payItemDatasDTO.setName(cardDetailsInfoRespVO.getPatientName());
        payItemDatasDTO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        payItemDatasDTO.setSex(cardDetailsInfoRespVO.getGender().toString());
        payItemDatasDTO.setAdmId(getPayItemReqVO.getAdmId());
        payItemDatasDTO.setDeptName(getPayItemReqVO.getDeptName());
        payItemDatasDTO.setDeptCode(getPayItemReqVO.getDeptCode());
        payItemDatasDTO.setDocName(getPayItemReqVO.getDocName());
        payItemDatasDTO.setDocCode(getPayItemReqVO.getDocCode());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        payItemDatasDTO.setAmount(amount.toString());
        payItemDatasDTO.setPayItemResVoList(payItemResVos);
        return payItemDatasDTO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardDetailsInfoReqVO));
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private GatewayRequest<PayItemReq> buildPayItemGatewayReq(GetPayItemReqVO getPayItemReqVO) {
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getPayItemReqVO.getAdmId());
        payItemReq.setCardNo(getPayItemReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("payItem");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getPayItemReqVO.getChannelCode()));
        gatewayRequest.setChannel(getPayItemReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)payItemReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public String createOutpatientPayment(CreateOutpatientPaymentReqVO createOutpatientPaymentReqVO) {
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)createOutpatientPaymentReqVO.getOutPatientId());
        String payItemDatasDTOStr = this.jedisCluster.get(createOutpatientPaymentReqVO.getOutPatientId());
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        Date createDate = new Date();
        String outPatientId = String.valueOf(this.snowflakeIdWorker.nextId());
        return outPatientId;
    }

    private OpBusinessOrderEntity buildOpBusinessOrderEntity(Date createDate, PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setCreateTime(createDate);
        opBusinessOrderEntity.setUpdateTime(createDate);
        opBusinessOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opBusinessOrderEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
        opBusinessOrderEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        opBusinessOrderEntity.setOrganName(outpatientPaymentReqVO.getHospitalName());
        opBusinessOrderEntity.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderEntity.setAdmTime(payItemDatasDTO.getAdmDate());
        if ("E".equals(payItemDatasDTO.getAdmType())) {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)2));
        } else {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)1));
        }
        opBusinessOrderEntity.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderEntity.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderEntity.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderEntity.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderEntity.setPatientId(payItemDatasDTO.getPatientId());
        opBusinessOrderEntity.setPatientOrganId(payItemDatasDTO.getPatientOrganId());
        opBusinessOrderEntity.setPatientName(payItemDatasDTO.getName());
        if (null != payItemDatasDTO.getSex() && !"".equals(payItemDatasDTO.getSex())) {
            opBusinessOrderEntity.setPatientGender(Integer.valueOf(Integer.parseInt(payItemDatasDTO.getSex())));
        }
        opBusinessOrderEntity.setPatientAge(payItemDatasDTO.getAge());
        opBusinessOrderEntity.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderEntity.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderEntity.setIdCard(payItemDatasDTO.getIdCard());
        opBusinessOrderEntity.setUserId(payItemDatasDTO.getUserId());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.NOT_PAY.getValue());
        opBusinessOrderEntity.setMoney(new BigDecimal(payItemDatasDTO.getAmount()));
        String orderNo = ((PayItemResVo)payItemDatasDTO.getPayItemResVoList().get(0)).getOrderNo();
        opBusinessOrderEntity.setReceiptId(orderNo);
        return opBusinessOrderEntity;
    }

    private List<OpBusinessOrderDetailEntity> buildOpBusinessOrderDetailEntity(Date createDate, PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        ArrayList<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntityList = new ArrayList<OpBusinessOrderDetailEntity>();
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                OpBusinessOrderDetailEntity opBusinessOrderDetailEntity = new OpBusinessOrderDetailEntity();
                opBusinessOrderDetailEntity.setCreateTime(createDate);
                opBusinessOrderDetailEntity.setUpdateTime(createDate);
                opBusinessOrderDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
                opBusinessOrderDetailEntity.setOrganName(outpatientPaymentReqVO.getHospitalName());
                opBusinessOrderDetailEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
                opBusinessOrderDetailEntity.setItemName(payItemResItems.getDesc());
                opBusinessOrderDetailEntity.setItemType(payItemResItems.getItemType());
                opBusinessOrderDetailEntity.setItemId(payItemResItems.getItemTypeNo());
                opBusinessOrderDetailEntity.setQuantity(Double.valueOf(Double.parseDouble(payItemResItems.getQty())));
                opBusinessOrderDetailEntity.setUnit(payItemResItems.getUnit());
                opBusinessOrderDetailEntity.setPrice(new BigDecimal(payItemResItems.getPrice()));
                opBusinessOrderDetailEntity.setMoney(new BigDecimal(payItemResItems.getSum()));
                opBusinessOrderDetailEntity.setPrescriptionNo(payItemResItems.getPrescriptionNo());
                opBusinessOrderDetailEntityList.add(opBusinessOrderDetailEntity);
            }
        }
        return opBusinessOrderDetailEntityList;
    }

    public OutpatientPaymentOrderDetailRespVO getOutpatientSucssessDetail(OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(outpatientPaymentOrderDetailReqVO.getCardId());
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = new OutpatientPaymentOrderDetailRespVO();
        if (null != outpatientPaymentOrderDetailReqVO.getOutPatientId() && !"".equals(outpatientPaymentOrderDetailReqVO.getOutPatientId())) {
            OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
            if (null == opBusinessOrderEntity) {
                throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
            }
            List opBusinessOrderDetailEntitiesList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
            if (null == opBusinessOrderDetailEntitiesList) {
                throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
            }
            cardDetailsInfoRespVO = this.getCardDetail(opBusinessOrderEntity.getCardId());
            outpatientPaymentOrderDetailRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
            outpatientPaymentOrderDetailRespVO.setName(opBusinessOrderEntity.getPatientName());
            outpatientPaymentOrderDetailRespVO.setSex(opBusinessOrderEntity.getPatientGender());
            outpatientPaymentOrderDetailRespVO.setAge(opBusinessOrderEntity.getPatientAge());
            outpatientPaymentOrderDetailRespVO.setCardNo(opBusinessOrderEntity.getCardNo());
            outpatientPaymentOrderDetailRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
            List payItemResVos = this.buidPayItemResVoList(opBusinessOrderDetailEntitiesList);
            outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVos);
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResVo payItemResVo : payItemResVos) {
                amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
            }
            outpatientPaymentOrderDetailRespVO.setAmount(amount.toString());
            outpatientPaymentOrderDetailRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
            outpatientPaymentOrderDetailRespVO.setDocName(opBusinessOrderEntity.getDocName());
            outpatientPaymentOrderDetailRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
            outpatientPaymentOrderDetailRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
            outpatientPaymentOrderDetailRespVO.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
            outpatientPaymentOrderDetailRespVO.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        } else {
            GetPayRecordDetailRes getPayRecordDetailRes = this.getPaidRecordDetail(outpatientPaymentOrderDetailReqVO.getCardNo(), outpatientPaymentOrderDetailReqVO.getAdmId(), outpatientPaymentOrderDetailReqVO.getChannelName());
            if (null == getPayRecordDetailRes) {
                return null;
            }
            if (CollectionUtils.isEmpty((Collection)getPayRecordDetailRes.getGetPayRecordDetailItemsResList())) {
                return null;
            }
            outpatientPaymentOrderDetailRespVO.setAdmId(getPayRecordDetailRes.getAdmId());
            outpatientPaymentOrderDetailRespVO.setDeptName(getPayRecordDetailRes.getDeptName());
            if (null != cardDetailsInfoRespVO) {
                outpatientPaymentOrderDetailRespVO.setCardNo(outpatientPaymentOrderDetailReqVO.getCardNo());
                try {
                    int age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
                    outpatientPaymentOrderDetailRespVO.setAge(String.valueOf(age));
                }
                catch (ParseException e) {
                    log.error("\u3010\u67e5\u8be2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u8be6\u60c5\u3011\u5e74\u9f84\u8f6c\u6362\u5f02\u5e38: " + e.getMessage());
                    throw new OutpatientPaymentException(e.getMessage());
                }
                outpatientPaymentOrderDetailRespVO.setName(cardDetailsInfoRespVO.getPatientName());
                outpatientPaymentOrderDetailRespVO.setSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
            }
            ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
            ArrayList payItemResItemsList = new ArrayList();
            BigDecimal amount = new BigDecimal(0);
            for (GetPayRecordDetailItemsRes getPayRecordDetailItemsRes : getPayRecordDetailRes.getGetPayRecordDetailItemsResList()) {
                PayItemResVo payItemResVo = new PayItemResVo();
                PayItemResItems payItemResItems = new PayItemResItems();
                String resAmount_str = getPayRecordDetailItemsRes.getAmount();
                if (resAmount_str.startsWith(".")) {
                    resAmount_str = resAmount_str.replace(".", "0.");
                }
                BigDecimal resAmount = new BigDecimal(resAmount_str);
                payItemResVo.setAmount(resAmount.setScale(2, 4).toString());
                payItemResItems.setUnit(getPayRecordDetailItemsRes.getUnit());
                payItemResItems.setQty(getPayRecordDetailItemsRes.getNum());
                String price_str = getPayRecordDetailItemsRes.getPrice();
                if (price_str.startsWith(".")) {
                    price_str = price_str.replace(".", "0.");
                }
                BigDecimal price = new BigDecimal(price_str);
                payItemResItems.setPrice(price.setScale(2, 4).toString());
                String amount_str = getPayRecordDetailItemsRes.getAmount();
                if (amount_str.startsWith(".")) {
                    amount_str = amount_str.replace(".", "0.");
                }
                BigDecimal sum = new BigDecimal(amount_str);
                payItemResItems.setSum(sum.setScale(2, 4).toString());
                payItemResItems.setDesc(getPayRecordDetailItemsRes.getArcmiDesc());
                payItemResVo.setItems(Arrays.asList(payItemResItems));
                amount = amount.add(sum);
                payItemResVoList.add(payItemResVo);
            }
            outpatientPaymentOrderDetailRespVO.setAmount(String.valueOf(amount.setScale(2, 4)));
            outpatientPaymentOrderDetailRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
            outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVoList);
        }
        return outpatientPaymentOrderDetailRespVO;
    }

    private GetPayRecordDetailRes getPaidRecordDetail(String cardNo, String admId, String channel) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetPayRecordDetailReq getPayRecordDetailReq = new GetPayRecordDetailReq();
        getPayRecordDetailReq.setAdmId(admId);
        getPayRecordDetailReq.setCardNo(cardNo);
        gatewayRequest.setBody((Object)getPayRecordDetailReq);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetPayRecordDetailReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getPayRecordsDetail(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011getPayRecordsDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011getPayRecordsDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011getPayRecordsDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
        }
        GetPayRecordDetailRes getPayRecordDetailRes = (GetPayRecordDetailRes)gatewayResponse.getData();
        return getPayRecordDetailRes;
    }

    private List<PayItemResVo> buidPayItemResVoList(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
        Map<String, List<OpBusinessOrderDetailEntity>> map = opBusinessOrderDetailList.stream().collect(Collectors.groupingBy(OpBusinessOrderDetailEntity::getItemType));
        for (Map.Entry<String, List<OpBusinessOrderDetailEntity>> entry : map.entrySet()) {
            PayItemResVo treatmentPayItemResVo = this.buildPayItemResVoForDetail(entry.getValue());
            payItemResVoList.add(treatmentPayItemResVo);
        }
        return payItemResVoList;
    }

    private PayItemResVo buildPayItemResVoForDetail(List<OpBusinessOrderDetailEntity> payItemList) {
        if (!CollectionUtils.isEmpty(payItemList)) {
            List items = this.buildPayItemResItems(payItemList);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return null;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResItems payItemResItems : items) {
                amount = amount.add(new BigDecimal(payItemResItems.getSum()));
            }
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setAmount(amount.toString());
            payItemResVo.setItems(items);
            payItemResVo.setItemTypeName(((PayItemResItems)items.get(0)).getItemType());
            return payItemResVo;
        }
        return null;
    }

    private List<PayItemResItems> buildPayItemResItems(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntitiesList) {
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        if (null == opBusinessOrderDetailEntitiesList || opBusinessOrderDetailEntitiesList.isEmpty()) {
            return payItemResItemsList;
        }
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntitiesList) {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(opBusinessOrderDetailEntity.getItemId());
            payItemResItems.setDesc(opBusinessOrderDetailEntity.getItemName());
            payItemResItems.setUnit(opBusinessOrderDetailEntity.getUnit());
            payItemResItems.setPrice(opBusinessOrderDetailEntity.getPrice().toString());
            payItemResItems.setQty(opBusinessOrderDetailEntity.getQuantity().toString());
            payItemResItems.setSum(opBusinessOrderDetailEntity.getMoney().toString());
            payItemResItems.setItemType(opBusinessOrderDetailEntity.getItemType());
            payItemResItemsList.add(payItemResItems);
        }
        return payItemResItemsList;
    }

    public GetPayInfoRespVO getPayInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u83b7\u53d6\u5f85\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\u9519\u8bef");
        }
        GetPayInfoRespVO getPayInfoRespVO = new GetPayInfoRespVO();
        getPayInfoRespVO.setAmount(opBusinessOrderEntity.getMoney().toString());
        getPayInfoRespVO.setCreateTime(opBusinessOrderEntity.getCreateTime().getTime());
        getPayInfoRespVO.setOutPatientId(outPatientId);
        getPayInfoRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
        getPayInfoRespVO.setCardNo(opBusinessOrderEntity.getCardNo());
        return getPayInfoRespVO;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public BaseResponse<String> outpatientPayment(OutpatientPaymentReqVO outpatientPaymentReqVO) throws OutpatientPaymentException {
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)outpatientPaymentReqVO.getOutPatientId());
        String payItemDatasDTOStr = this.jedisCluster.get(outpatientPaymentReqVO.getOutPatientId());
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        Date createDate = new Date();
        OpBusinessOrderEntity opBusinessOrderEntity = this.buildOpBusinessOrderEntity(createDate, payItemDatasDTO, outpatientPaymentReqVO);
        this.opBusinessOrderEntityMapper.insertSelective(opBusinessOrderEntity);
        List opBusinessOrderDetailEntityList = this.buildOpBusinessOrderDetailEntity(createDate, payItemDatasDTO, outpatientPaymentReqVO);
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            this.opBusinessOrderDetailEntityMapper.insertSelective(opBusinessOrderDetailEntity);
        }
        PrePayRes prePayRes = this.hisPrePay(opBusinessOrderEntity, outpatientPaymentReqVO.getPayChannel(), outpatientPaymentReqVO.getChannelCode());
        OpRechargePaymentOrderEntity opRechargePaymentOrder = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(opBusinessOrderEntity, outpatientPaymentReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
        BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (!baseResponse.isSuccess()) {
            this.hisCancelPrePay(opBusinessOrderEntity, outpatientPaymentReqVO.getChannelCode());
        }
        opBusinessOrderEntity.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        if (null != opRechargePaymentOrder) {
            return baseResponse;
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.buildOpRechargePaymentOrderEntity(outpatientPaymentReqVO, opBusinessOrderEntity);
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntity);
        return baseResponse;
    }

    private PrePayRes hisPrePay(OpBusinessOrderEntity opBusinessOrderEntity, String payChannel, String channel) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PrePayReq prePayReq = new PrePayReq();
        prePayReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        prePayReq.setCardNo(opBusinessOrderEntity.getCardNo());
        prePayReq.setOrderNo(opBusinessOrderEntity.getReceiptId());
        if (PayChannelEnum.WECHAT.getValue().equals(payChannel)) {
            prePayReq.setPayChannel(HISPayChannelEnum.WECHAT.getValue());
        } else if (PayChannelEnum.ALIPAY.getValue().equals(payChannel)) {
            prePayReq.setPayChannel(HISPayChannelEnum.ALIPAY.getValue());
        }
        gatewayRequest.setBody((Object)prePayReq);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("prePay");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.prePay(gatewayRequest);
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u3011prePay -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u5931\u8d25");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u3011prePay -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a" + gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u3011prePay -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u9884\u7ed3\u7b97\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a" + gatewayResponse.getMsg());
        }
        PrePayRes prePayRes = (PrePayRes)gatewayResponse.getData();
        return prePayRes;
    }

    private void hisCancelPrePay(OpBusinessOrderEntity opBusinessOrderEntity, String channelCode) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PrePayReq prePayReq = new PrePayReq();
        prePayReq.setOrderNo(opBusinessOrderEntity.getReceiptId());
        prePayReq.setCardNo(opBusinessOrderEntity.getCardNo());
        gatewayRequest.setBody((Object)prePayReq);
        gatewayRequest.setChannelName(channelCode);
        gatewayRequest.setChannel(channelCode);
        gatewayRequest.setKeyWord("cancelPrePay");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.cancelPrePay(gatewayRequest);
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (null == gatewayResponse) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011cancelPrePay -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u5931\u8d25");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011cancelPrePay -> his\u67e5\u8be2\u5931\u8d25 err_code:{},msg:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u5931\u8d25, \u5931\u8d25\u4fe1\u606f\uff1a" + gatewayResponse.getMsg());
        }
    }

    private QueryCardInfoResVO getCardInfo(String cardNo, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCardNo(cardNo);
        queryCardInfoReqVO.setCredNo(cardNo);
        gatewayRequest.setBody((Object)queryCardInfoReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("QueryCardInfoReqVO");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.cardApi.queryCardInfo(gatewayRequest);
        log.info("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011queryCardInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u3011 queryCardInfo -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        QueryCardInfoResVO queryCardInfoResVO = (QueryCardInfoResVO)gatewayResponse.getData();
        return queryCardInfoResVO;
    }

    private OutpatientPayReqVO buildOutpatientPayReqVO(OpBusinessOrderEntity opBusinessOrderEntity, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OutpatientPayReqVO outpatientPayReqVO = new OutpatientPayReqVO();
        outpatientPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        outpatientPayReqVO.setOutTradeNo(outpatientPaymentReqVO.getOutPatientId());
        outpatientPayReqVO.setPayChannel(outpatientPaymentReqVO.getPayChannel());
        outpatientPayReqVO.setPayType(outpatientPaymentReqVO.getPayType());
        outpatientPayReqVO.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
        outpatientPayReqVO.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
        outpatientPayReqVO.setActuallyAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setTotalAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setUserSign(outpatientPaymentReqVO.getOpenId());
        return outpatientPayReqVO;
    }

    private OpRechargePaymentOrderEntity buildOpRechargePaymentOrderEntity(OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
        Date date = new Date();
        opRechargePaymentOrderEntity.setCreateTime(date);
        opRechargePaymentOrderEntity.setUpdateTime(date);
        opRechargePaymentOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opRechargePaymentOrderEntity.setOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue().byteValue()));
        opRechargePaymentOrderEntity.setDealMoney(opBusinessOrderEntity.getMoney());
        opRechargePaymentOrderEntity.setBizSysSeq(ServiceCodeEnum.OUTPATIENT.getValue());
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)0));
        opRechargePaymentOrderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        opRechargePaymentOrderEntity.setPaymentSeq(outpatientPaymentReqVO.getPayChannel());
        opRechargePaymentOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        return opRechargePaymentOrderEntity;
    }

    private BaseResponse<String> payCreateOrder(OutpatientPayReqVO outpatientPayReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)outpatientPayReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("OutpatientPaymentServiceImpl.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("OutpatientPaymentServiceImpl.payCreateOrder\u95e8\u8bca\u7f34\u8d39\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    public PaySuccessInfoRespVO getPaySuccessInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        List opBusinessOrderDetailList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || null == opRechargePaymentOrderEntity || CollectionUtils.isEmpty((Collection)opBusinessOrderDetailList)) {
            throw new OutpatientPaymentException();
        }
        return this.buildPaySuccessInfoRespVO(opBusinessOrderEntity, opRechargePaymentOrderEntity, opBusinessOrderDetailList);
    }

    private PaySuccessInfoRespVO buildPaySuccessInfoRespVO(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        PaySuccessInfoRespVO paySuccessInfoRespVO = new PaySuccessInfoRespVO();
        paySuccessInfoRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        paySuccessInfoRespVO.setDocName(opBusinessOrderEntity.getDocName());
        paySuccessInfoRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        paySuccessInfoRespVO.setAmount(opRechargePaymentOrderEntity.getDealMoney().toString());
        paySuccessInfoRespVO.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        paySuccessInfoRespVO.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        ArrayList itemTypes = new ArrayList();
        TreeSet<String> itemTypeSet = new TreeSet<String>();
        for (OpBusinessOrderDetailEntity opBusinessOrderDetail : opBusinessOrderDetailList) {
            if (StringUtils.isEmpty((Object)opBusinessOrderDetail.getItemType())) continue;
            itemTypeSet.add(opBusinessOrderDetail.getItemType());
        }
        itemTypeSet.forEach(itemType -> {
            ItemTypeVo itemTypeVo = new ItemTypeVo();
            itemTypeVo.setPayItem(itemType);
            itemTypes.add(itemTypeVo);
        });
        paySuccessInfoRespVO.setItemType(itemTypes);
        if (opRechargePaymentOrderEntity.getPaymentSeq() != null && WECHAT.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u5fae\u4fe1\u652f\u4ed8");
        } else if (opRechargePaymentOrderEntity.getPaymentSeq() != null && ALIPAY.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u652f\u4ed8\u5b9d\u652f\u4ed8");
        }
        return paySuccessInfoRespVO;
    }

    public List<OutpatientPaymentOrderRespVO> getOutpatientPaymentOrder(OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO) throws OutpatientPaymentException {
        ArrayList<OutpatientPaymentOrderRespVO> outpatientPaymentOrderRespVOList = new ArrayList<OutpatientPaymentOrderRespVO>();
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(outpatientPaymentOrderReqVO.getCardId());
        if (null == cardDetail) {
            throw new OutpatientPaymentException("\u67e5\u8be2\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff01");
        }
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setUserId(outpatientPaymentOrderReqVO.getUserId());
        opBusinessOrderEntity.setCardNo(outpatientPaymentOrderReqVO.getCardNo());
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByCardNoAndUserId(opBusinessOrderEntity);
        if (null == opBusinessOrderEntities || opBusinessOrderEntities.isEmpty()) {
            return outpatientPaymentOrderRespVOList;
        }
        for (OpBusinessOrderEntity opBusinessOrder : opBusinessOrderEntities) {
            OutpatientPaymentOrderRespVO outpatientPaymentOrderRespVO = new OutpatientPaymentOrderRespVO();
            outpatientPaymentOrderRespVO.setCreateTime(opBusinessOrder.getCreateTime().getTime());
            outpatientPaymentOrderRespVO.setDeptName(opBusinessOrder.getDeptName());
            outpatientPaymentOrderRespVO.setDocName(opBusinessOrder.getDocName());
            outpatientPaymentOrderRespVO.setOutPatientId(opBusinessOrder.getOutPatientId());
            outpatientPaymentOrderRespVO.setPayStatus(opBusinessOrder.getStatus().toString());
            outpatientPaymentOrderRespVO.setAmount(opBusinessOrder.getMoney().toString());
            outpatientPaymentOrderRespVOList.add(outpatientPaymentOrderRespVO);
        }
        return outpatientPaymentOrderRespVOList;
    }

    private GetPayRecordsRes getPaidRecords(String cardNo, String channelName) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetPayRecordsReq getPayRecordsReq = new GetPayRecordsReq();
        getPayRecordsReq.setCardNo(cardNo);
        getPayRecordsReq.setEndDate(DateUtils.getCurrentDate((String)"yyyy-MM-dd"));
        getPayRecordsReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractMonth((Date)DateUtils.getCurrentDate(), (int)3)));
        gatewayRequest.setBody((Object)getPayRecordsReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetPayRecordsReq");
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.getPayRecords(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u3011getPayRecords -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u3011getPayRecords -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u5df2\u7f34\u8d39\u5386\u53f2\u8ba2\u5355\u3011getPayRecords -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
        }
        GetPayRecordsRes getPayRecordsRes = (GetPayRecordsRes)gatewayResponse.getData();
        return getPayRecordsRes;
    }

    public AppointOrderStatusRes outPatHisOrderStatusQuery(String hisTradeNo, String channel) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        AppointOrderStatusReq appointOrderStatusReq = new AppointOrderStatusReq();
        appointOrderStatusReq.setHisTradeNo(hisTradeNo);
        gatewayRequest.setBody((Object)appointOrderStatusReq);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("AppointOrderStatusReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010his\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.appointApi.orderStatusQuery(gatewayRequest);
        log.info("\u3010his\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011\u8bf7\u6c42\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u3010his\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011orderStatusQuery -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u3010his\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011orderStatusQuery -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u3010his\u67e5\u8be2\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u3011orderStatusQuery -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        AppointOrderStatusRes appointOrderStatusRes = (AppointOrderStatusRes)gatewayResponse.getData();
        return appointOrderStatusRes;
    }
}

