/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterMsg;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.DayRegisterRes;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.his.pojo.vo.outpatient.PrePayReq;
import com.ebaiyihui.his.pojo.vo.outpatient.respmsg.ComfirmPayNewReqMsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.DayAppointRefundCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.HISPayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.IWaitingQueueService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IWaitingQueueService iWaitingQueueService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue() && AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = this.appointApi.dayRegister(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (null == dayRegisterGatewayRes) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!HIS_SUCCESS.equals(dayRegisterGatewayRes.getCode())) {
            String remark = DayAppointRefundCodeEnum.getDisplay((Integer)Integer.parseInt(dayRegisterGatewayRes.getErrCode()));
            if (StringUtils.isNotBlank((String)remark)) {
                BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo);
                if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                    appointmentRecordEntity.setRemark(remark);
                } else {
                    appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                    appointmentRecordEntity.setRemark(remark + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
                }
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINT_FAIL.getValue());
                appointmentRecordEntity.setRemark(AppointmentStatusEnum.APPOINT_FAIL.getDisplay());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            }
            log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        DayRegisterRes dayRegisterRes = (DayRegisterRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.scheduleRecordMapper.updateByhospitalCodeAndscheduleHisId(appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getScheduleHisId());
        this.scheduleDetailRecordMapper.updateByScheduleHisIdAndStartTime(appointmentRecordEntity.getScheduleHisId(), appointmentRecordEntity.getHospitalCode(), appointmentRecordEntity.getAdmTimeRange().substring(0, 5));
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal("0.01"));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal("0.01"));
        log.info("\u5f53\u65e5\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        return this.refund(requestRefundOrderVoReq);
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        payOrderEntity.setBizSysSeq(responseNotifyRestVo.getServiceCode());
        payOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, DayRegisterRes dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, DayRegisterRes dayRegisterRes) {
        List items = dayRegisterRes.getItems();
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAdmId(dayRegisterRes.getNo());
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getAppointId());
        appointmentRecordEntity.setAdmTimeRange(dayRegisterRes.getAdmitTimeRange());
        appointmentRecordEntity.setTakeAddress(dayRegisterRes.getTakeAddress());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getTakeAddress());
        appointmentRecordEntity.setTakeTime(dayRegisterRes.getTakeTime());
        appointmentRecordEntity.setAppointmentNo(dayRegisterRes.getAppointNo());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getAdmitAddress());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<DayRegisterReq> buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DayRegisterReq dayRegisterReq = new DayRegisterReq();
        dayRegisterReq.setTimeArrangeId(appointmentRecordEntity.getHisTimeArrangeId());
        dayRegisterReq.setAdmNo(appointmentRecordEntity.getAdmId());
        dayRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        dayRegisterReq.setPatientId(appointmentRecordEntity.getPatientId());
        dayRegisterReq.setDeptNo(appointmentRecordEntity.getDeptCode());
        dayRegisterReq.setDoctorNo(appointmentRecordEntity.getDocCode());
        dayRegisterReq.setTimeFlag(String.valueOf(appointmentRecordEntity.getAdmRange()));
        dayRegisterReq.setPayChannel(responseNotifyRestVo.getPayChannel());
        dayRegisterReq.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        dayRegisterReq.setRbasId(appointmentRecordEntity.getScheduleHisId());
        dayRegisterReq.setTransactionId(appointmentRecordEntity.getAppointmentId());
        dayRegisterReq.setQueueNo(appointmentRecordEntity.getAppointmentNo());
        dayRegisterReq.setRegFee(appointmentRecordEntity.getPayAmount());
        dayRegisterReq.setTimeArrangeId(appointmentRecordEntity.getHisTimeArrangeId());
        DayRegisterMsg dayRegisterMsg = new DayRegisterMsg();
        dayRegisterMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        dayRegisterMsg.setBusinessCode(responseNotifyRestVo.getServiceCode());
        dayRegisterMsg.setPayment(appointmentRecordEntity.getPayAmount());
        dayRegisterMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        dayRegisterMsg.setSuccess(SUCCESS);
        dayRegisterMsg.setPosid(responseNotifyRestVo.getMchId());
        dayRegisterReq.setRespMsg(dayRegisterMsg);
        gatewayRequest.setBody((Object)dayRegisterReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("dayRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue() && AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate);
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        GatewayRequest gatewayRequest = this.buildComfirmPayNewReq(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        GatewayResponse gatewayResponse = null;
        try {
            gatewayResponse = this.comfirmPayNew(gatewayRequest);
        }
        catch (OutpatientPaymentException e) {
            log.error("\u95e8\u8bca\u7f34\u8d39his\u786e\u8ba4\u652f\u4ed8\u5931\u8d25\uff1a" + e.getMessage());
            this.hisCancelPrePay(opBusinessOrderEntity, opBusinessOrderEntity.getChannelCode());
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u56de\u8c03\uff0c\u8bf7\u6c42his\u652f\u4ed8\u786e\u8ba4\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\uff1a" + e.getMessage());
        }
        this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToSimpleString((Date)opRechargePaymentOrderEntity.getPaymentTime())));
        OpGuideEntity opGuideEntity = this.buildOpGuideEntity(opBusinessOrderEntity, gatewayResponse);
        this.opGuideEntityMapper.insert(opGuideEntity);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setPayTime(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
        inHospDepostPayCallDTO.setBankTradeNo("");
        inHospDepostPayCallDTO.setMerchantId(responseNotifyRestVo.getMchId());
        inHospDepostPayCallDTO.setPaymentSeq(responseNotifyRestVo.getPayChannel());
        inHospDepostPayCallDTO.setPayBillNo(responseNotifyRestVo.getTradeNo());
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        DepositRes depositRes = this.inHospitalService.InHospDeposit(inpatientDepositDetailEntity, responseNotifyRestVo);
        inHospDepostPayCallDTO.setReceiptId(depositRes.getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private GatewayResponse<ComfirmPayNewRes> comfirmPayNew(GatewayRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 gatewayResponse ->{}" + gatewayResponse.toString() + gatewayResponse.getCode() + gatewayResponse.getMsg() + gatewayResponse.getData());
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        log.info("gatewayResponse:" + gatewayResponse.toString());
        return gatewayResponse;
    }

    private GatewayRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setId(opBusinessOrderEntity.getReceiptId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setAmount(opBusinessOrderEntity.getMoney().toString());
        if (PayChannelEnum.WECHAT.getValue().equals(responseNotifyRestVo.getPayChannel())) {
            comfirmPayNewReq.setPaychannel(HISPayChannelEnum.WECHAT.getValue());
        } else if (PayChannelEnum.ALIPAY.getValue().equals(responseNotifyRestVo.getPayChannel())) {
            comfirmPayNewReq.setPaychannel(HISPayChannelEnum.ALIPAY.getValue());
        }
        ComfirmPayNewReqMsg comfirmPayNewReqMsg = new ComfirmPayNewReqMsg();
        comfirmPayNewReqMsg.setOrderid(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReqMsg.setPayment(opRechargePaymentOrderEntity.getDealMoney().toString());
        comfirmPayNewReqMsg.setAccdate(DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime()));
        comfirmPayNewReqMsg.setPosid(responseNotifyRestVo.getMchId());
        comfirmPayNewReqMsg.setSuccess(SUCCESS);
        comfirmPayNewReqMsg.setUsrmsg("");
        comfirmPayNewReq.setRespmsg(comfirmPayNewReqMsg);
        comfirmPayNewReq.setPatientId(opBusinessOrderEntity.getPatientOrganId());
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)opBusinessOrderEntity.getChannelCode()));
        gatewayRequest.setChannel(opBusinessOrderEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private void hisCancelPrePay(OpBusinessOrderEntity opBusinessOrderEntity, String channelCode) throws OutpatientPaymentException {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PrePayReq prePayReq = new PrePayReq();
        prePayReq.setOrderNo(opBusinessOrderEntity.getReceiptId());
        prePayReq.setCardNo(opBusinessOrderEntity.getCardNo());
        gatewayRequest.setBody((Object)prePayReq);
        gatewayRequest.setChannelName(channelCode);
        gatewayRequest.setChannel(channelCode);
        gatewayRequest.setKeyWord("cancelPrePay");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.cancelPrePay(gatewayRequest);
        log.info("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011\u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (null == gatewayResponse) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011cancelPrePay -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u5931\u8d25");
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u3010\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u3011cancelPrePay -> his\u67e5\u8be2\u5931\u8d25 err_code:{},msg:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39his\u64a4\u9500\u9884\u7ed3\u7b97\u5931\u8d25, \u5931\u8d25\u4fe1\u606f\uff1a" + gatewayResponse.getMsg());
        }
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        refundCallBackReq.setPayType(responseRefundNotifyRestVo.getPayChannel());
        refundCallBackReq.setTrandNo(trandNo);
        refundCallBackReq.setRefundTime(DateUtils.dateToFullString((Date)responseRefundNotifyRestVo.getRefundTime()));
        refundCallBackReq.setRefundSerialNo(refundSerialNo);
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }
}

