/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundReason;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.RefundCallBackService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class RefundCallBackServiceImpl
implements RefundCallBackService {
    private static final Logger log = LoggerFactory.getLogger(RefundCallBackServiceImpl.class);
    public static final String HIS_SUCCESS = "1";
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private AppointApi appointApi;

    public void outpatientRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        String redisKey;
        String refundSerialNo;
        Date now = new Date();
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setUpdateTime(now);
        opBusinessOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.REFUND.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opRechargePaymentOrderEntity.setUpdateTime(now);
        opRechargePaymentOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        if (opRechargePaymentOrderEntity.getRefundType().equals(RefundChannelCodeEnum.HIS_REFUND.getValue()) && StringUtils.isNotEmpty((String)(refundSerialNo = this.jedisCluster.get(redisKey = responseNotifyRestVo.getOutTradeNo() + "_" + "hisRefund")))) {
            log.info("\u67e5\u8be2\u5230his\u9000\u6b3e\u6d41\u6c34\u53f7\uff1a" + refundSerialNo);
            this.outPatientRepeatCallBackHis(responseNotifyRestVo, opBusinessOrderEntity, opRechargePaymentOrderEntity, refundSerialNo);
        }
    }

    public void inHospitalRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        String redisKey;
        String refundSerialNo;
        Date now = new Date();
        String orderseq = responseNotifyRestVo.getOutTradeNo();
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderseq);
        inpatientDepositDetailEntity.setUpdateTime(now);
        inpatientDepositDetailEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientDepositDetailEntity.setStatus(Byte.valueOf((byte)InpatientDepositDetailStatusEnum.REFUND.getValue().intValue()));
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        inpatientPayorderEntity.setUpdateTime(now);
        inpatientPayorderEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKey(inpatientPayorderEntity);
        if (inpatientPayorderEntity.getRefundType().equals(RefundChannelCodeEnum.HIS_REFUND.getValue()) && StringUtils.isNotEmpty((String)(refundSerialNo = this.jedisCluster.get(redisKey = responseNotifyRestVo.getOutTradeNo() + "_" + "hisRefund")))) {
            log.info("\u67e5\u8be2\u5230his\u9000\u6b3e\u6d41\u6c34\u53f7\uff1a" + refundSerialNo);
            this.inHospRepeatCallBackHis(responseNotifyRestVo, inpatientDepositDetailEntity, inpatientPayorderEntity.getPayBillNo(), refundSerialNo);
        }
    }

    public void appointRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9000\u53f7\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue().equals(appointStatus)) {
            GatewayRequest gatewayRequest = new GatewayRequest();
            CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
            cancelRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentNo());
            cancelRegisterReq.setTransactionId(appointmentRecordEntity.getAppointmentId());
            gatewayRequest.setBody((Object)cancelRegisterReq);
            gatewayRequest.setChannelName(appointmentRecordEntity.getChannelCode());
            gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
            gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
            gatewayRequest.setKeyWord("cancelRegister");
            gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
            GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
            String message = "\u53d6\u6d88\u9501\u53f7 cancelRegister";
            if (gatewayResponse == null) {
                log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                throw new AppointmentException(gatewayResponse.getMsg());
            }
            if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
                log.error(message + " -> his\u53d6\u6d88\u9501\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
                throw new AppointmentException(gatewayResponse.getMsg());
            }
            this.refundCallBack(responseNotifyRestVo);
        }
        if (AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue().equals(appointStatus)) {
            this.refundCallBack(responseNotifyRestVo);
        }
        if (AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue().equals(appointStatus)) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setReturnTransationId(responseNotifyRestVo.getRefundNo());
            appointmentRecordEntity.setReturnAmount(responseNotifyRestVo.getTotalAmount());
            appointmentRecordEntity.setReturnPostId(responseNotifyRestVo.getMchId());
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f");
            appointmentRecordEntity.setReturnAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getRefundTime(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
            appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
            appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
            appointmentPayorderEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
            appointmentPayorderEntity.setRefundType(Byte.valueOf((byte)RefundReason.FEFUND_NUMBER.getValue().intValue()));
            appointmentPayorderEntity.setRefundMoney(responseNotifyRestVo.getTotalAmount());
            appointmentPayorderEntity.setRefundBillNo(responseNotifyRestVo.getRefundNo());
            appointmentPayorderEntity.setRefundRemrak("\u9000\u6b3e\u6210\u529f");
            appointmentPayorderEntity.setRemark("\u9000\u53f7\u9000\u6b3e\u6210\u529f");
            log.info("\u9000\u53f7\u56de\u8c03\u66f4\u65b0appointmentPayOrder\u5165\u53c2\uff1a------------appointmentPayorderEntity:{}", (Object)appointmentPayorderEntity);
            this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
            this.taskExecutor.execute(() -> this.pushService.appointmentCancelMsgPush(appointmentRecordEntity));
        }
    }

    public void dayRegistRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        this.refundCallBack(responseNotifyRestVo);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(responseNotifyRestVo.getOutTradeNo());
        if (null != appointmentPayorderEntity && appointmentPayorderEntity.getRefundChannelCode().equals(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue())) {
            String redisKey = responseNotifyRestVo.getOutTradeNo() + "_" + "hisRefund";
            String refundSerialNo = this.jedisCluster.get(redisKey);
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(responseNotifyRestVo.getOutTradeNo());
            if (StringUtils.isNotEmpty((String)refundSerialNo)) {
                log.info("\u67e5\u8be2\u5230his\u9000\u6b3e\u6d41\u6c34\u53f7\uff1a" + refundSerialNo);
                this.appointRepeatCallBackHis(responseNotifyRestVo, appointmentRecordEntity, refundSerialNo);
            }
        }
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        refundCallBackReq.setPayType(responseRefundNotifyRestVo.getPayChannel());
        refundCallBackReq.setTrandNo(trandNo);
        refundCallBackReq.setRefundTime(DateUtils.dateToFullString((Date)responseRefundNotifyRestVo.getRefundTime()));
        refundCallBackReq.setRefundSerialNo(refundSerialNo);
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }

    private void refundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        log.info("\u9000\u6b3e\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setReturnTransationId(responseNotifyRestVo.getRefundNo());
        appointmentRecordEntity.setReturnAmount(responseNotifyRestVo.getTotalAmount());
        appointmentRecordEntity.setReturnPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f");
        appointmentRecordEntity.setReturnAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getRefundTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        appointmentPayorderEntity.setRefundType(Byte.valueOf((byte)RefundReason.FEFUND_NUMBER.getValue().intValue()));
        appointmentPayorderEntity.setRefundMoney(responseNotifyRestVo.getTotalAmount());
        appointmentPayorderEntity.setRefundBillNo(responseNotifyRestVo.getRefundNo());
        appointmentPayorderEntity.setRefundRemrak("\u9000\u6b3e\u6210\u529f");
        appointmentPayorderEntity.setRemark("\u9000\u6b3e\u6210\u529f");
        log.info("\u81ea\u52a8\u9000\u6b3e\u66f4\u65b0appointmentPayOrder\u5165\u53c2\uff1a------------appointmentPayorderEntity:{}", (Object)appointmentPayorderEntity);
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
    }
}

