/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.DayDoctorScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RecommendedDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private DepartmentService departmentService;

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        List scheduleResItemsList = null;
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
        GatewayResponse gatewayResponse = null;
        if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
            log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
            gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        } else {
            log.info("\u5b9e\u65f6\u83b7\u53d6\u6bcf\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
            gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        }
        log.info("\u5b9e\u65f6\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        scheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
            return new ArrayList<GetScheduleVoRes>();
        }
        this.buildScheduleTimeArrangeItems(scheduleResItemsList, getScheduleVoReq);
        List doctorCodeList = scheduleResItemsList.stream().map(GetScheduleResItems::getDocCode).collect(Collectors.toList());
        log.info("\u6536\u96c6\u5230\u7684\u533b\u751fcode:{}", doctorCodeList);
        List doctorRecordEntityList = this.doctorService.getDoctorIdList(String.join((CharSequence)",", doctorCodeList), getScheduleVoReq.getOrganCode());
        List doctorIdList = doctorRecordEntityList.stream().map(doctorRecordEntity -> {
            if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                return Long.valueOf(doctorRecordEntity.getDoctorId());
            }
            return 0L;
        }).collect(Collectors.toList());
        Map<String, String> doctorMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, DoctorRecordEntity::getDoctorId));
        List doctorBaseInfoDTOList = this.getDoctorInfoList(getScheduleVoReq.getOrganId(), doctorIdList);
        Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfo.getXId().toString(), doctorBaseInfoDTO -> doctorBaseInfoDTO));
        List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u524d\uff1a" + scheduleResItemsList);
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u540e\uff1a" + getScheduleResItemsList);
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        log.info("\u6839\u636edoccode\u5206\u7ec4\u4e4b\u540e\uff1a" + getScheduleResItemsList);
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        getScheduleResItemMap.keySet().forEach(docCode -> {
            GetScheduleResItems getScheduleResItems = (GetScheduleResItems)((List)getScheduleResItemMap.get(docCode)).get(0);
            GetScheduleVoRes getScheduleVoRes = this.buildGetScheduleVoResVo(getScheduleResItems, getScheduleVoReq);
            String docId = (String)doctorMap.get(docCode);
            DoctorBaseInfoDTO doctorBaseInfoDTO = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(docId);
            if (doctorBaseInfoDTO != null) {
                getScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                getScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                getScheduleVoRes.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                getScheduleVoRes.setDoctorScore(new Double(5.0));
            }
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), getScheduleVoReq.getOrganCode());
            getScheduleVoRes.setAppointmentCount(appointmentCount);
            AppointmentRecordEntity entity = this.appointmentRecordMapper.selectLastAdmRecordByUserId(getScheduleVoReq.getOrganCode(), getScheduleVoReq.getUserId());
            if (null != entity && entity.getDocCode().equals(docCode)) {
                getScheduleVoRes.setIsLastSelect(Integer.valueOf(1));
            }
            List scheduleBaseInfoVoList = ((List)getScheduleResItemMap.get(docCode)).stream().map(scheduleResItem -> this.buildScheduleBaseInfoVo(scheduleResItem)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            getScheduleVoResList.add(getScheduleVoRes);
        });
        return getScheduleVoResList;
    }

    public void buildScheduleTimeArrangeItems(List<GetScheduleResItems> scheduleResItemsList, GetScheduleVoReq getScheduleVoReq) {
        List isArrangeScheduleResItemList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getIsTimeArrange() == 1).collect(Collectors.toList());
        HashMap<String, List> timeArrangeItemMap = new HashMap<String, List>();
        if (!CollectionUtils.isEmpty(isArrangeScheduleResItemList)) {
            log.info("\u5177\u6709\u5206\u65f6\u6bb5\u7684his\u53f7\u6e90\u4fe1\u606f\uff1a" + isArrangeScheduleResItemList);
            for (GetScheduleResItems getScheduleResItems2 : isArrangeScheduleResItemList) {
                GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
                getScheduleReqVO.setScheduleCode(getScheduleResItems2.getScheduleId());
                getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
                getScheduleReqVO.setDocCode(getScheduleResItems2.getDocCode());
                GetScheduleResItems getScheduleResItem = this.getScheduleTimeArrangeItems(getScheduleReqVO, getScheduleVoReq.getChannelName());
                if (null == getScheduleResItem) continue;
                timeArrangeItemMap.put(getScheduleResItems2.getScheduleId(), getScheduleResItem.getTimeArrangeItems());
            }
            for (GetScheduleResItems getScheduleResItems2 : scheduleResItemsList) {
                if (!timeArrangeItemMap.containsKey(getScheduleResItems2.getScheduleId())) continue;
                getScheduleResItems2.setTimeArrangeItems((List)timeArrangeItemMap.get(getScheduleResItems2.getScheduleId()));
            }
            log.info("\u5c01\u88c5\u5b8c\u6210\u7684his\u5206\u65f6\u6bb5\u53f7\u6e90\u4fe1\u606f\uff1a" + scheduleResItemsList);
        }
    }

    private GetScheduleResItems getScheduleTimeArrangeItems(GetScheduleReqVO getScheduleReqVO, String channel) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(channel);
        gatewayRequest.setChannel(channel);
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getScheduleTimeArrangeItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u5b9e\u65f6\u83b7\u53d6his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getScheduleTimeArrangeItems(gatewayRequest);
        log.info("\u5b9e\u65f6\u83b7\u53d6his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        if (gatewayResponse.getData() == null) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        GetScheduleResItems getScheduleResItems = (GetScheduleResItems)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItems.getTimeArrangeItems())) {
            log.error("his\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduleTimeArrangeItems -> his\u65e0\u5bf9\u5e94\u7684\u53f7\u6e90\u65f6\u6bb5\u4fe1\u606f");
        }
        return getScheduleResItems;
    }

    private GetScheduleVoRes buildGetScheduleVoResVo(GetScheduleResItems scheduleResItem, GetScheduleVoReq getScheduleVoReq) {
        GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
        getScheduleVoRes.setDocCode(scheduleResItem.getDocCode());
        getScheduleVoRes.setDocName(scheduleResItem.getDocName());
        getScheduleVoRes.setHospitalArea(scheduleResItem.getHospitalArea());
        getScheduleVoRes.setHospitalAreaCode(scheduleResItem.getHospitalAreaCode());
        getScheduleVoRes.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleVoRes.setLocName(scheduleResItem.getLocName());
        getScheduleVoRes.setRegTitleCode(scheduleResItem.getRegTitleCode());
        getScheduleVoRes.setRegTitleName(scheduleResItem.getRegTitleName());
        return getScheduleVoRes;
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        GatewayRequest gatewayRequest;
        List scheduleResItemsList;
        ArrayList scheduleListAll = new ArrayList();
        GatewayRequest dayGatewayRequest = this.buildDaySchduleReq(getDoctorScheduleVoReq);
        List dayScheduleResItemsList = this.getDocDaySchedule(dayGatewayRequest);
        if (!CollectionUtils.isEmpty((Collection)dayScheduleResItemsList)) {
            scheduleListAll.addAll(dayScheduleResItemsList);
        }
        if (!CollectionUtils.isEmpty((Collection)(scheduleResItemsList = this.getDocSchedule(gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq))))) {
            scheduleListAll.addAll(scheduleResItemsList);
        }
        GetScheduleVoReq getScheduleVoReq = new GetScheduleVoReq();
        getScheduleVoReq.setChannelName(getDoctorScheduleVoReq.getChannelName());
        getScheduleVoReq.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        this.buildScheduleTimeArrangeItems(scheduleListAll, getScheduleVoReq);
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleListAll.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        log.info("\u83b7\u53d6\u5230\u533b\u751f\u4e03\u5929\u6392\u73ed\uff1a" + dayScheduleResItemsList);
        List getScheduleResItemsList = scheduleListAll.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordByDoctorCodeAndHosCode(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        Long docId = 0L;
        if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
            docId = Long.valueOf(doctorRecordEntity.getDoctorId());
        }
        getDoctorScheduleVoRes.setDoctorId(docId);
        DoctorBaseInfoDTO doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfo(docId, getDoctorScheduleVoReq.getOrganId());
        if (doctorBaseInfoDTO != null) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
            getDoctorScheduleVoRes.setDoctorIntroduce(doctorBaseInfoDTO.getIntroduction());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorRecordEntityList = this.doctorService.getDoctorIdList(String.join((CharSequence)",", doctorCodeList), getDoctorScheduleVoReq.getOrganCode());
            List doctorIdList = doctorRecordEntityList.stream().map(doctorRecord -> {
                if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                    return Long.valueOf(doctorRecordEntity.getDoctorId());
                }
                return 0L;
            }).collect(Collectors.toList());
            Map<String, String> doctorMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, DoctorRecordEntity::getDoctorId));
            List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorIdList);
            Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfoDTO.getXId().toString(), doctorBaseInfo -> doctorBaseInfo));
            List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    String doctorId = (String)doctorMap.get(scheduleRecordEntity.getDocCode());
                    DoctorBaseInfoDTO doctorBaseInfo = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(doctorId);
                    if (doctorBaseInfo != null) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    private ScheduleBaseInfoVo buildScheduleBaseInfoVo(GetScheduleResItems scheduleResItem) {
        ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
        scheduleBaseInfoVo.setAdmDate(scheduleResItem.getAdmDate());
        scheduleBaseInfoVo.setAdmTimeRange(scheduleResItem.getAdmTimeRange());
        scheduleBaseInfoVo.setAppStartNo(scheduleResItem.getAppStartNo());
        scheduleBaseInfoVo.setIsTimeArrange(scheduleResItem.getIsTimeArrange());
        scheduleBaseInfoVo.setLocTypeCode(scheduleResItem.getLocTypeCode());
        scheduleBaseInfoVo.setLocTypeName(scheduleResItem.getLocTypeName());
        scheduleBaseInfoVo.setRegAvailable(scheduleResItem.getRegAvailable());
        scheduleBaseInfoVo.setRegFee(String.valueOf(new BigDecimal(scheduleResItem.getRegFee()).doubleValue()));
        scheduleBaseInfoVo.setDiagFee(scheduleResItem.getDiagFee());
        BigDecimal totalFee = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setTotalFee(String.valueOf(totalFee.doubleValue()));
        scheduleBaseInfoVo.setRegTotal(scheduleResItem.getRegTotal());
        scheduleBaseInfoVo.setReplaceScheduleId(scheduleResItem.getReplaceScheduleId());
        scheduleBaseInfoVo.setScheduleId(scheduleResItem.getScheduleId());
        scheduleBaseInfoVo.setScheduleLevelCode(scheduleResItem.getScheduleLevelCode());
        scheduleBaseInfoVo.setScheduleLevelName(scheduleResItem.getScheduleLevelName());
        scheduleBaseInfoVo.setScheduleStatus(scheduleResItem.getScheduleStatus());
        scheduleBaseInfoVo.setScheduleType(scheduleResItem.getScheduleType());
        scheduleBaseInfoVo.setIsAppend(scheduleResItem.getIsAppend());
        ArrayList timeArrangeItemsList = scheduleResItem.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList = new ArrayList();
        }
        scheduleBaseInfoVo.setTimeArrangeItems((List)timeArrangeItemsList);
        return scheduleBaseInfoVo;
    }

    private List<DoctorBaseInfoDTO> getDoctorInfoList(String organId, List<Long> doctorIdList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorIdList)) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + doctorIdList);
        List doctorBaseInfoDTOList = this.getDoctorInfoUtil.getDoctorInfoList(doctorIdList, organId);
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(DateUtils.getNextDayToString((String)getDoctorScheduleVoReq.getStartDate()));
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GetScheduleResItems buildGetScheduleResItems(ScheduleRecordEntity scheduleRecordEntity, List<TimeArrangeItems> timeArrangeItemsList) {
        GetScheduleResItems scheduleResItems = new GetScheduleResItems();
        scheduleResItems.setScheduleId(scheduleRecordEntity.getScheduleHisId());
        scheduleResItems.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().intValue()));
        scheduleResItems.setAdmDate(DateUtils.dateToString((Date)scheduleRecordEntity.getScheduleDate(), (String)"yyyy-MM-dd"));
        scheduleResItems.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        scheduleResItems.setHospitalArea(scheduleRecordEntity.getHospitalAreaName());
        scheduleResItems.setHospitalAreaCode(scheduleRecordEntity.getHospitalArea());
        scheduleResItems.setDocCode(scheduleRecordEntity.getDocCode());
        scheduleResItems.setDocName(scheduleRecordEntity.getDocName());
        scheduleResItems.setLocCode(scheduleRecordEntity.getDeptCode());
        scheduleResItems.setLocName(scheduleRecordEntity.getDeptName());
        scheduleResItems.setRegFee(scheduleRecordEntity.getRegFee().toString());
        scheduleResItems.setRegTitleCode(scheduleRecordEntity.getRegTitelCode());
        scheduleResItems.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        scheduleResItems.setScheduleLevelCode(scheduleRecordEntity.getScheduleLevelCode());
        scheduleResItems.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        scheduleResItems.setLocTypeCode(scheduleRecordEntity.getDeptCategoryCode());
        scheduleResItems.setLocTypeName(scheduleRecordEntity.getDeptCategoryName());
        scheduleResItems.setAdmLocation(scheduleRecordEntity.getAdmLocation());
        scheduleResItems.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        scheduleResItems.setRegTotal(scheduleRecordEntity.getTotalCount());
        scheduleResItems.setAppStartNo(String.valueOf(scheduleRecordEntity.getStartNo()));
        scheduleResItems.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
        scheduleResItems.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
        scheduleResItems.setIsTimeArrange(Integer.valueOf(scheduleRecordEntity.getIsPrecise().intValue()));
        scheduleResItems.setDiagFee(scheduleRecordEntity.getDiagFee().toString());
        scheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
        return scheduleResItems;
    }

    private List<TimeArrangeItems> buildTimeArrangeItems(List<ScheduleDetailRecordEntity> scheduleDetailRecordList) {
        List<TimeArrangeItems> TimeArrangeItemList = scheduleDetailRecordList.stream().map(scheduleDetailRecordEntity -> {
            TimeArrangeItems getTimeArrangeItems = new TimeArrangeItems();
            getTimeArrangeItems.setStartNo(scheduleDetailRecordEntity.getStartNo());
            getTimeArrangeItems.setEndNo(scheduleDetailRecordEntity.getEndNo());
            getTimeArrangeItems.setStartTime(scheduleDetailRecordEntity.getStartTime());
            getTimeArrangeItems.setEndTime(scheduleDetailRecordEntity.getEndTime());
            getTimeArrangeItems.setTimeArrangeId(scheduleDetailRecordEntity.getHisTimeArrangeId());
            getTimeArrangeItems.setBookedNos(scheduleDetailRecordEntity.getBookedNos());
            return getTimeArrangeItems;
        }).collect(Collectors.toList());
        return TimeArrangeItemList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    private List<GetScheduleResItems> getScheduleResItemsList(GetScheduleDTO getScheduleDTO) {
        List recordEntityList = this.getScheduleByScheduleDTO(getScheduleDTO);
        List filterRecordEntityList = recordEntityList.stream().filter(scheduleRecordEntity -> scheduleRecordEntity.getRegFee().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<GetScheduleResItems> scheduleResItemsList = filterRecordEntityList.stream().map(scheduleRecordEntity -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            List scheduleDetailRecordList = this.getScheduleDetailRecord(scheduleRecordEntity.getScheduleHisId(), scheduleRecordEntity.getHospitalCode());
            List TimeArrangeItems2 = this.buildTimeArrangeItems(scheduleDetailRecordList);
            getScheduleResItems = this.buildGetScheduleResItems(scheduleRecordEntity, TimeArrangeItems2);
            return getScheduleResItems;
        }).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u6392\u73ed\u4fe1\u606f \uff1a{}", (Object)JSON.toJSONString(scheduleResItemsList));
        return scheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocDaySchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getDoctorSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u7b2c\u4e00\u5929\u7684\u533b\u751f\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        return getScheduleResItemsList;
    }
}

