/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.his.api.WaitingQueueApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.wait.GetWaitingQueueReqVO;
import com.ebaiyihui.his.pojo.vo.wait.GetWaitingQueueResVO;
import com.ebaiyihui.his.pojo.vo.wait.WaitingReportReqVO;
import com.ebaiyihui.his.pojo.vo.wait.WaitingReportResVO;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.exception.WaitingQueueException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.pojo.vo.FetchPatientAwaitingQueueRes;
import com.ebaiyihui.wisdommedical.service.IWaitingQueueService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WaitingQueueServiceImpl
implements IWaitingQueueService {
    private static final Logger log = LoggerFactory.getLogger(WaitingQueueServiceImpl.class);
    @Autowired
    private WaitingQueueApi waitingQueueApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;

    public List<FetchPatientAwaitingQueueRes> getAwaitingQueue(String cardNo, String organCode, String channelName) throws WaitingQueueException {
        GatewayRequest gatewayRequest = this.buildGatewayRequest(cardNo, channelName, null);
        log.info("\u5019\u8bca\u67e5\u8be2\u8bf7\u6c42his\u53c2\u6570\uff1a" + gatewayRequest.toString());
        GatewayResponse gatewayResponse = this.waitingQueueApi.getWaitingQueue(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u5019\u8bca\u67e5\u8be2 getAwaitingQueue -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<FetchPatientAwaitingQueueRes>();
        }
        log.info("\u5019\u8bca\u67e5\u8be2\u63a5\u6536his\u53c2\u6570\uff1a" + gatewayResponse.toString());
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u5019\u8bca\u67e5\u8be2 getAwaitingQueue -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<FetchPatientAwaitingQueueRes>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u5019\u8bca\u67e5\u8be2 getAwaitingQueue -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<FetchPatientAwaitingQueueRes>();
        }
        GetWaitingQueueResVO hisData = (GetWaitingQueueResVO)gatewayResponse.getData();
        if (hisData.getItems() == null || CollectionUtils.isEmpty((Collection)hisData.getItems())) {
            log.error("\u5019\u8bca\u67e5\u8be2 getAwaitingQueue -> his\u65e0\u5019\u8bca\u4fe1\u606f");
            return new ArrayList<FetchPatientAwaitingQueueRes>();
        }
        List patientAwaitingQueueResList = this.getFetchPatientAwaitingQueueRes(gatewayResponse);
        return patientAwaitingQueueResList;
    }

    public WaitingReportResVO doWaitingReport(String appointId) {
        GatewayRequest gatewayRequest = this.buildDoWaitingRequest(appointId);
        GatewayResponse gatewayResponse = this.waitingQueueApi.doWaitingReport(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u5019\u8bca\u62a5\u9053 getAwaitingQueue -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u5019\u8bca\u62a5\u9053 getAwaitingQueue -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        WaitingReportResVO waitingReportResVO = (WaitingReportResVO)gatewayResponse.getData();
        if (waitingReportResVO == null) {
            log.error("\u5019\u8bca\u62a5\u9053 getAwaitingQueue -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        return waitingReportResVO;
    }

    private List<FetchPatientAwaitingQueueRes> getFetchPatientAwaitingQueueRes(GatewayResponse<GetWaitingQueueResVO> gatewayResponse) {
        GetWaitingQueueResVO getWaitingQueueResVO = (GetWaitingQueueResVO)gatewayResponse.getData();
        List getWaitingQueueResItemsList = getWaitingQueueResVO.getItems();
        ArrayList<FetchPatientAwaitingQueueRes> patientAwaitingQueueResList = new ArrayList<FetchPatientAwaitingQueueRes>();
        if (CollectionUtils.isEmpty((Collection)getWaitingQueueResItemsList)) {
            return patientAwaitingQueueResList;
        }
        getWaitingQueueResItemsList.stream().forEach(waitingQueueResItem -> {
            FetchPatientAwaitingQueueRes fetchPatientAwaitingQueueRes = new FetchPatientAwaitingQueueRes();
            fetchPatientAwaitingQueueRes.setAdmId(waitingQueueResItem.getAdmId());
            fetchPatientAwaitingQueueRes.setWaitingNum(waitingQueueResItem.getWaitingNum());
            fetchPatientAwaitingQueueRes.setAdmDate(DateUtils.getCurrentDate((String)"yyyy\u5e74MM\u6708dd\u65e5"));
            if (null != waitingQueueResItem.getAdmRange() && !"".equals(waitingQueueResItem.getAdmRange())) {
                fetchPatientAwaitingQueueRes.setAdmRange(Integer.valueOf(waitingQueueResItem.getAdmRange()).intValue());
            }
            fetchPatientAwaitingQueueRes.setDeptName(waitingQueueResItem.getDeptname());
            fetchPatientAwaitingQueueRes.setPatientName(waitingQueueResItem.getPatientName());
            fetchPatientAwaitingQueueRes.setDocName(waitingQueueResItem.getDoctorName());
            fetchPatientAwaitingQueueRes.setRegTitleName(waitingQueueResItem.getDoctorTitle());
            fetchPatientAwaitingQueueRes.setCallSeqNo(waitingQueueResItem.getCallSeqNo());
            fetchPatientAwaitingQueueRes.setCurrentCallNo(waitingQueueResItem.getCurrentCallNo());
            fetchPatientAwaitingQueueRes.setWaitingStatus(waitingQueueResItem.getWaitingStatus());
            patientAwaitingQueueResList.add(fetchPatientAwaitingQueueRes);
        });
        return patientAwaitingQueueResList;
    }

    private GatewayRequest buildGatewayRequest(String cardNo, String channelName, String patientId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetWaitingQueueReqVO getWaitingQueueReqVO = new GetWaitingQueueReqVO();
        getWaitingQueueReqVO.setCardNo(cardNo);
        getWaitingQueueReqVO.setPatientId(patientId);
        gatewayRequest.setBody((Object)getWaitingQueueReqVO);
        gatewayRequest.setChannel(channelName);
        gatewayRequest.setChannelName(channelName);
        gatewayRequest.setKeyWord("getAwaitingQueue");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest buildDoWaitingRequest(String appointId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        WaitingReportReqVO getWaitingQueueReqVO = new WaitingReportReqVO();
        getWaitingQueueReqVO.setAppointId(appointId);
        gatewayRequest.setBody((Object)getWaitingQueueReqVO);
        gatewayRequest.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getDisplay());
        gatewayRequest.setKeyWord("doAwaiting");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }
}

