/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GetDoctorInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(GetDoctorInfoUtil.class);
    @Autowired
    private ProPropertiesConstant constant;

    public DoctorBaseInfoDTO getDoctorInfo(Long doctorId, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorId", doctorId.toString());
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},mag:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            DoctorBaseInfoDTO doctorBaseInfoDTO = (DoctorBaseInfoDTO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> " + doctorBaseInfoDTO);
            return doctorBaseInfoDTO;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfo -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new DoctorBaseInfoDTO();
        }
    }

    public List<DoctorBaseInfoDTO> getDoctorInfoList(List<Long> doctorIdList, String organId) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("doctorIdList", doctorIdList.toString());
            params.put("organId", organId);
            String body = HttpKit.get((String)this.constant.getGetDoctorInfoListUrl(), params);
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u8fd4\u56debaseResponse\uff1a" + response);
            if (!response.isSuccess()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> \u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f err_code:{},msg:{}", (Object)response.getErrCode(), (Object)response.getMsg());
            }
            if (null == response.getData()) {
                log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> \u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            }
            List list = JSONObject.parseArray((String)JSONObject.toJSONString((Object)response.getData()), DoctorBaseInfoDTO.class);
            log.info("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011 getDoctorInfoList -> " + list);
            return list;
        }
        catch (Exception e) {
            log.error("\u3010\u67e5\u8be2\u533b\u751f\u57fa\u7840\u4fe1\u606f\u3011getDoctorInfoList -> doctorService\u8bf7\u6c42\u51fa\u9519");
            return new ArrayList<DoctorBaseInfoDTO>();
        }
    }
}

