/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.common.enums.GanderTypeEnums;
import com.ebaiyihui.his.mapper.MedicalCardMapper;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.model.card.QueryCardInfoResVO;
import com.ebaiyihui.his.model.card.RegisteredCardReqVO;
import com.ebaiyihui.his.model.card.RegisteredCardResVO;
import com.ebaiyihui.his.model.dto.QueryCardInfoReqDTO;
import com.ebaiyihui.his.model.dto.QueryCardInfoResDTO;
import com.ebaiyihui.his.model.request.BaseHisResquest;
import com.ebaiyihui.his.service.ICardService;
import com.ebaiyihui.his.utils.SubStrUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private MedicalCardMapper medicalCardMapper;
    @Autowired
    private SubStrUtil subStrUtil;

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
        try {
            QueryCardInfoReqDTO cardInfoReqDTO = new QueryCardInfoReqDTO();
            cardInfoReqDTO.setCredNo(((QueryCardInfoReqVO)param.getBody()).getCredNo());
            log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardInfoReqDTO));
            List queryCardInfoResDTOList = this.medicalCardMapper.queryCardInfo(cardInfoReqDTO);
            log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)queryCardInfoResDTOList));
            if (Objects.isNull(queryCardInfoResDTOList) || queryCardInfoResDTOList.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
            }
            QueryCardInfoResDTO queryCardInfoResDTO = new QueryCardInfoResDTO();
            if (queryCardInfoResDTOList.size() > 1) {
                queryCardInfoResDTOList.removeIf(q -> q.getCardNo().charAt(0) == '9');
                queryCardInfoResDTO = (QueryCardInfoResDTO)queryCardInfoResDTOList.get(0);
            } else {
                queryCardInfoResDTO = (QueryCardInfoResDTO)queryCardInfoResDTOList.get(0);
            }
            queryCardInfoResVO.setCardNo(queryCardInfoResDTO.getCardNo());
            queryCardInfoResVO.setAddress(queryCardInfoResDTO.getAddress());
            queryCardInfoResVO.setCredNo(queryCardInfoResDTO.getCredNo());
            queryCardInfoResVO.setDob(queryCardInfoResDTO.getDob());
            queryCardInfoResVO.setSex(queryCardInfoResDTO.getSex().equals("1") ? "\u7537" : "\u5973");
            queryCardInfoResVO.setName(queryCardInfoResDTO.getName());
            queryCardInfoResVO.setTelephone(queryCardInfoResDTO.getTelephone());
            queryCardInfoResVO.setPatientId(queryCardInfoResDTO.getCardNo());
            log.info("\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)queryCardInfoResVO));
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
        }
        return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
    }

    public FrontResponse<List<QueryCardInfoResVO>> queryCardInfoAll(QueryCardInfoReqVO param) {
        log.info("\u5165\u53c2\uff1a" + JSON.toJSONString((Object)param));
        ArrayList queryCardInfoResVOS = new ArrayList();
        try {
            QueryCardInfoReqDTO cardInfoReqDTO = new QueryCardInfoReqDTO();
            cardInfoReqDTO.setCredNo(param.getCredNo());
            log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardInfoReqDTO));
            List queryCardInfoResDTOList = this.medicalCardMapper.queryCardInfo(cardInfoReqDTO);
            log.info("\u67e5\u8be2\u60a3\u8005\u4fe1\u606f\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)queryCardInfoResDTOList));
            if (Objects.isNull(queryCardInfoResDTOList) || queryCardInfoResDTOList.size() <= 0) {
                return FrontResponse.error(null, (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
            }
            queryCardInfoResDTOList.stream().forEach(obj -> {
                QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
                queryCardInfoResVO.setCardNo(obj.getCardNo());
                queryCardInfoResVO.setAddress(obj.getAddress());
                queryCardInfoResVO.setCredNo(obj.getCredNo());
                queryCardInfoResVO.setDob(obj.getDob());
                queryCardInfoResVO.setSex(obj.getSex().equals("1") ? "\u7537" : "\u5973");
                queryCardInfoResVO.setName(obj.getName());
                queryCardInfoResVO.setTelephone(obj.getTelephone());
                queryCardInfoResVO.setPatientId(obj.getCardNo());
                queryCardInfoResVOS.add(queryCardInfoResVO);
            });
            log.info("\u51fa\u53c2\uff1a" + JSON.toJSONString(queryCardInfoResVOS));
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error(null, (String)"0", (String)"\u672a\u67e5\u8be2\u5230\u60a3\u8005\u4fe1\u606f");
        }
        return FrontResponse.success(null, queryCardInfoResVOS);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            String inputStr = body.getName() + "#" + body.getCredNo() + "#" + GanderTypeEnums.getValue((String)body.getSex()) + "#" + body.getDob() + "#" + body.getTelephone() + "########";
            BaseHisResquest baseHisResquest = new BaseHisResquest();
            baseHisResquest.setInputStr(inputStr);
            baseHisResquest.setCode("HIS_ATM_02120");
            this.medicalCardMapper.registerCard(baseHisResquest);
            if (StringUtils.isEmpty((Object)baseHisResquest.getOutputData())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u60a3\u8005\u4fe1\u606f\u5931\u8d25\uff0c\u8fd4\u56de\u503c\u4e3a\u7a7a");
            }
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361His\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseHisResquest));
            String[] results = baseHisResquest.getOutputData().split("#");
            if (!results[0].equals("0")) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)JSON.toJSONString((Object)baseHisResquest));
            }
            registeredCardResVO.setCardNo(results[1]);
        }
        catch (Exception e) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u6ce8\u518c\u60a3\u8005\u4fe1\u606f\u5f02\u5e38");
        }
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u51fa\u53c2\uff1a" + registeredCardResVO.getCardNo());
        return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
    }
}

