/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.ebaiyihui.his.mapper.ScheduleMapper;
import com.ebaiyihui.his.model.DeptModel;
import com.ebaiyihui.his.model.DoctorModel;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.response.QueryNumSourceRes;
import com.ebaiyihui.his.model.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.model.schedule.GetScheduleResVO;
import com.ebaiyihui.his.model.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.model.schedule.items.TimeArrangeItems;
import com.ebaiyihui.his.service.ScheduleService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.cxf.common.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private ScheduleMapper scheduleMapper;
    @Value(value="${filter.deptCode}")
    private String filterDept;

    public FrontResponse<List<DeptModel>> getDeptInfo() {
        List deptModels = new ArrayList();
        try {
            deptModels = this.scheduleMapper.getDeptInfo(this.filterDept);
            if (CollectionUtils.isEmpty(deptModels)) {
                return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u7684\u90e8\u95e8\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u7684\u90e8\u95e8\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        return FrontResponse.success(null, deptModels);
    }

    public FrontResponse<List<DoctorModel>> getDoctorInfo() {
        List doctorModels = new ArrayList();
        try {
            doctorModels = this.scheduleMapper.getDoctorInfo(this.filterDept);
            if (CollectionUtils.isEmpty(doctorModels)) {
                return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u7684\u533b\u751f\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u7684\u533b\u751f\u4fe1\u606f\u5f02\u5e38\uff01");
        }
        return FrontResponse.success(null, doctorModels);
    }

    public FrontResponse<GetScheduleResVO> getSchdule(FrontRequest<GetScheduleReqVO> param) {
        log.info("=========[getSchdule]\u67e5\u8be2\u53f7\u6e90\u5165\u53c2:{}", param);
        GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
        ArrayList list = new ArrayList();
        try {
            if (ObjectUtils.isEmpty((Object)param.getBody())) {
                return FrontResponse.error(null, (String)"0", (String)"\u67e5\u8be2\u53f7\u6e90\u5165\u53c2\u4e3a\u7a7a\uff01");
            }
            List sourceResList = this.scheduleMapper.getSchedule((GetScheduleReqVO)param.getBody());
            if (CollectionUtils.isEmpty((Collection)sourceResList)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u53f7\u6e90\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            Map<String, Map<String, List<QueryNumSourceRes>>> collect = sourceResList.stream().collect(Collectors.groupingBy(QueryNumSourceRes::getEmplCode, Collectors.groupingBy(QueryNumSourceRes::getNoonCode)));
            collect.keySet().forEach(docCode -> {
                Map doctorMap = (Map)collect.get(docCode);
                doctorMap.keySet().forEach(noonCode -> {
                    QueryNumSourceRes queryNumSourceRes = (QueryNumSourceRes)((List)doctorMap.get(noonCode)).get(0);
                    GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                    getScheduleResItems.setAdmDate(queryNumSourceRes.getSeeDate());
                    getScheduleResItems.setRegFee(queryNumSourceRes.getRegFee());
                    getScheduleResItems.setAdmTimeRange(queryNumSourceRes.getNoonCode());
                    getScheduleResItems.setDocCode(queryNumSourceRes.getEmplCode());
                    getScheduleResItems.setDocName(queryNumSourceRes.getDoctName());
                    getScheduleResItems.setLocCode(queryNumSourceRes.getDeptCode());
                    getScheduleResItems.setLocName(queryNumSourceRes.getDeptName());
                    getScheduleResItems.setScheduleLevelCode(queryNumSourceRes.getReglevlCode());
                    getScheduleResItems.setScheduleLevelName(queryNumSourceRes.getReglevlName());
                    getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
                    list.add(getScheduleResItems);
                });
            });
            list.stream().forEach(target -> {
                ArrayList timeArrangeItemsList = new ArrayList();
                sourceResList.stream().forEach(obj -> {
                    if (obj.getEmplCode().equals(target.getDocCode()) && obj.getNoonCode().equals(target.getAdmTimeRange()) && obj.getSeeDate().equals(target.getAdmDate())) {
                        TimeArrangeItems timeArrangeItems = new TimeArrangeItems();
                        timeArrangeItems.setTimeArrangeId(obj.getSeeSeq());
                        timeArrangeItems.setStartTime(obj.getBeginTime());
                        timeArrangeItems.setEndTime(obj.getEndTime());
                        timeArrangeItemsList.add(timeArrangeItems);
                    }
                });
                target.setTimeArrangeItems(timeArrangeItemsList);
            });
            if (CollectionUtils.isEmpty(list)) {
                return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u53f7\u6e90\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u53f7\u6e90\u5f02\u5e38\uff01");
        }
        getScheduleResVO.setItems(list);
        log.info("=========[getSchdule]\u67e5\u8be2\u53f7\u6e90\u51fa\u53c2:{}", (Object)getScheduleResVO);
        return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
    }
}

