/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.his.config.data.DBContextHolder;
import com.ebaiyihui.his.mapper.ElectronicReportMapper;
import com.ebaiyihui.his.mapper.MedicalCardMapper;
import com.ebaiyihui.his.model.InspectionReportVO;
import com.ebaiyihui.his.model.base.FrontRequest;
import com.ebaiyihui.his.model.base.FrontResponse;
import com.ebaiyihui.his.model.card.QueryCardInfoReqVO;
import com.ebaiyihui.his.model.card.QueryCardInfoResVO;
import com.ebaiyihui.his.model.report.GetReportListsReq;
import com.ebaiyihui.his.model.report.GetReportListsRes;
import com.ebaiyihui.his.model.report.GetReportUrlReq;
import com.ebaiyihui.his.model.report.GetReportUrlRes;
import com.ebaiyihui.his.model.report.LisReportListReq;
import com.ebaiyihui.his.model.report.LisReportListRes;
import com.ebaiyihui.his.model.report.datas.GetReportListsData;
import com.ebaiyihui.his.model.report.datas.LisReportListResData;
import com.ebaiyihui.his.service.ElectronicReportService;
import com.ebaiyihui.his.service.ICardService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ElectronicReportServiceImpl
implements ElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private MedicalCardMapper medicalCardMapper;
    @Autowired
    private ElectronicReportMapper electronicReportMapper;
    @Autowired
    private ICardService cardService;
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetReportListsRes> getReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        FrontResponse frontResponse = new FrontResponse();
        QueryCardInfoReqVO queryCardInfoReqVO = new QueryCardInfoReqVO();
        queryCardInfoReqVO.setCredNo(((GetReportListsReq)param.getBody()).getIdCard());
        FrontResponse res = this.cardService.queryCardInfoAll(queryCardInfoReqVO);
        if (SUCCESS_FLAG.equals(res.getCode())) {
            return FrontResponse.error(null, (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a!");
        }
        ArrayList inspectionReportVOList = new ArrayList();
        GetReportListsRes getReportListsRes = new GetReportListsRes();
        for (QueryCardInfoResVO obj : (List)res.getBody()) {
            GetReportListsReq paramBody = new GetReportListsReq();
            paramBody.setReportType("1");
            DBContextHolder.setDataSource((String)"2");
            paramBody.setPatientId(obj.getCardNo());
            List getReportListsResList = this.electronicReportMapper.getReportList(paramBody.getPatientId());
            inspectionReportVOList.addAll(getReportListsResList);
        }
        if (Objects.isNull(inspectionReportVOList) || inspectionReportVOList.size() <= 0) {
            frontResponse = FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u67e5\u8be2\u5230\u62a5\u544a");
            log.info("\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)frontResponse));
            return frontResponse;
        }
        ArrayList getReportListsDatas = new ArrayList();
        Map<String, List<InspectionReportVO>> getReportListsResListMap = inspectionReportVOList.stream().collect(Collectors.groupingBy(InspectionReportVO::getPatinfoID));
        getReportListsResListMap.forEach((s, inspectionModels) -> {
            InspectionReportVO getReportListsRes1 = (InspectionReportVO)inspectionModels.get(0);
            GetReportListsData getReportListsData = new GetReportListsData();
            getReportListsData.setReportNo(getReportListsRes1.getPatinfoID());
            getReportListsData.setReportName(getReportListsRes1.getReportName());
            getReportListsData.setReportType("1");
            getReportListsData.setReportDate(getReportListsRes1.getAudittime());
            getReportListsData.setReportTime(getReportListsRes1.getAudittime());
            getReportListsDatas.add(getReportListsData);
        });
        List collect = getReportListsDatas.stream().sorted(Comparator.comparing(GetReportListsData::getReportDate).reversed()).collect(Collectors.toList());
        getReportListsRes.setDatas(collect);
        getReportListsRes.setPatientID(((GetReportListsReq)param.getBody()).getPatientId());
        getReportListsRes.setPatientName(((InspectionReportVO)inspectionReportVOList.get(0)).getPatientName());
        frontResponse = FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        log.info("\u67e5\u8be2\u68c0\u67e5\u68c0\u9a8c\u62a5\u544a\u5217\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)frontResponse));
        return frontResponse;
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        FrontResponse frontResponse = new FrontResponse();
        LisReportListReq paramBody = (LisReportListReq)param.getBody();
        DBContextHolder.setDataSource((String)"2");
        List list = this.electronicReportMapper.lisReportList(paramBody.getReportNo());
        LisReportListRes lisReportListRes = new LisReportListRes();
        if (Objects.isNull(list) || list.size() <= 0) {
            frontResponse = FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u67e5\u8be2\u5230\u62a5\u544a\u8be6\u60c5");
            log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)frontResponse));
            return frontResponse;
        }
        InspectionReportVO inspectionModel = (InspectionReportVO)list.get(0);
        lisReportListRes.setPatientName(inspectionModel.getName());
        lisReportListRes.setSex(inspectionModel.getSex());
        lisReportListRes.setAge(inspectionModel.getAge().replaceAll("\u5c81", ""));
        lisReportListRes.setDeptName(inspectionModel.getDepartment());
        lisReportListRes.setDoctorName(inspectionModel.getDoctor());
        lisReportListRes.setBed(inspectionModel.getBedNum());
        lisReportListRes.setSpecName(inspectionModel.getSampleName());
        lisReportListRes.setRecTime(inspectionModel.getBarCodetime());
        lisReportListRes.setRecUser(inspectionModel.getOpter());
        lisReportListRes.setAuthTime(inspectionModel.getAudittime());
        lisReportListRes.setAuthUser(inspectionModel.getAuditopter());
        lisReportListRes.setColTime(inspectionModel.getSampleDate());
        lisReportListRes.setAdmType(inspectionModel.getPattype());
        lisReportListRes.setDiagnosis(inspectionModel.getLczd());
        if (Objects.nonNull(inspectionModel.getLczd())) {
            lisReportListRes.setDiagnosis(inspectionModel.getLczd().replaceAll("\n", "").replaceAll("\r", ""));
        }
        ArrayList<LisReportListResData> datas = new ArrayList<LisReportListResData>();
        for (InspectionReportVO inspectionModels : list) {
            LisReportListResData lisReportListResData = new LisReportListResData();
            lisReportListResData.setItmName(inspectionModels.getItemname());
            lisReportListResData.setItmEng(inspectionModels.getItemename());
            lisReportListResData.setItmRes(inspectionModels.getResult());
            lisReportListResData.setItmUnit(inspectionModels.getUnit());
            if (Objects.nonNull(inspectionModels.getResult())) {
                lisReportListResData.setItmRes(inspectionModels.getResult().replaceAll("\n", "").replaceAll("\r", ""));
            }
            lisReportListResData.setItmRanges(inspectionModels.getLimit());
            datas.add(lisReportListResData);
        }
        lisReportListRes.setDatas(datas);
        frontResponse = FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        log.info("\u83b7\u53d6\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)frontResponse));
        return frontResponse;
    }

    public FrontResponse<GetReportUrlRes> getReportUrl(FrontRequest<GetReportUrlReq> param) {
        return null;
    }
}

