/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.framework.utils.StringUtil;
import com.ebaiyihui.his.core.dto.CardInfoResDto;
import com.ebaiyihui.his.core.dto.QueryPrescriptionResDto;
import com.ebaiyihui.his.core.enums.MethodCodeEnum;
import com.ebaiyihui.his.core.enums.RequestEntityEnum;
import com.ebaiyihui.his.core.service.CardService;
import com.ebaiyihui.his.core.service.HisRemoteService;
import com.ebaiyihui.his.core.vo.AdmissionOrCancellationReqVo;
import com.ebaiyihui.his.core.vo.AdmissionOrCancellationResVo;
import com.ebaiyihui.his.core.vo.CardInfoReqVo;
import com.ebaiyihui.his.core.vo.CardInfoResVo;
import com.ebaiyihui.his.core.vo.CardVerificationAndInfoReqVo;
import com.ebaiyihui.his.core.vo.CardVerificationAndInfoResVo;
import com.ebaiyihui.his.core.vo.CardVerificationReqVo;
import com.ebaiyihui.his.core.vo.CardVerificationResVo;
import com.ebaiyihui.his.core.vo.GetHangRecordDisposalReqVo;
import com.ebaiyihui.his.core.vo.GetHangRecordDisposalResVo;
import com.ebaiyihui.his.core.vo.GetHangRecordReqVo;
import com.ebaiyihui.his.core.vo.GetHangRecordResVo;
import com.ebaiyihui.his.core.vo.HangUpItemVo;
import com.ebaiyihui.his.core.vo.PreSettlementReqVo;
import com.ebaiyihui.his.core.vo.PreSettlementResVo;
import com.ebaiyihui.his.core.vo.PrescriptionUploadReqVo;
import com.ebaiyihui.his.core.vo.PrescriptionUploadResVo;
import com.ebaiyihui.his.core.vo.QueryCardInfoReqVo;
import com.ebaiyihui.his.core.vo.QueryCardInfoResListVo;
import com.ebaiyihui.his.core.vo.QueryCardInfoResVo;
import com.ebaiyihui.his.core.vo.QueryFundCardInfoResp;
import com.ebaiyihui.his.core.vo.QueryPrescriptionReqVo;
import com.ebaiyihui.his.core.vo.QueryPrescriptionVo;
import com.ebaiyihui.his.core.vo.RegistCardReqVo;
import com.ebaiyihui.his.core.vo.RegisteCardResVo;
import com.ebaiyihui.his.core.vo.RegisteredSaveResVo;
import com.ebaiyihui.his.core.vo.RegistrationConfirmReqVo;
import com.ebaiyihui.his.core.vo.RegistrationConfirmResVo;
import com.ebaiyihui.his.core.vo.ResetPrescriptionReqVo;
import com.ebaiyihui.his.core.vo.ResetPrescriptionResVo;
import com.ebaiyihui.his.core.vo.UnregisterPayMethodReqVo;
import com.ebaiyihui.his.core.vo.UnregisterPayMethodResVo;
import com.ebaiyihui.his.core.vo.UnregisterReqVo;
import com.ebaiyihui.his.core.vo.UnregisterResVo;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.card.RegisteredCardResVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements CardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    @Autowired
    private HisRemoteService hisRemoteService;

    public FrontResponse<CardInfoResVo> getCardInfo(FrontRequest<CardInfoReqVo> cardInfoReqVo) {
        HashMap<String, CardInfoReqVo> map = new HashMap<String, CardInfoReqVo>();
        CardInfoReqVo cardInfoReq = (CardInfoReqVo)cardInfoReqVo.getBody();
        log.info("cardInfoReqVo\u5165\u53c2:" + cardInfoReqVo.toString());
        map.put(RequestEntityEnum.GET_CARD_INFO.getValue(), cardInfoReq);
        FrontResponse cardInfoFrontResponse = this.hisRemoteService.requestHis(cardInfoReqVo.getTransactionId(), MethodCodeEnum.GET_CARD_INFO.getValue(), map, CardInfoResDto.class);
        CardInfoResDto cardInfo = (CardInfoResDto)cardInfoFrontResponse.getBody();
        if (null == cardInfo) {
            return FrontResponse.error((String)cardInfoReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(cardInfo.getResult())) {
            return FrontResponse.error((String)cardInfoReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(cardInfo.getResult())) {
            return FrontResponse.success((String)cardInfoReqVo.getTransactionId(), null);
        }
        CardInfoResVo cardInfoResVo = cardInfo.getCardInfoResVo();
        return FrontResponse.success((String)cardInfoReqVo.getTransactionId(), (Object)cardInfoResVo);
    }

    public FrontResponse<PreSettlementResVo> preSettlement(FrontRequest<PreSettlementReqVo> preSettlementReqVo) {
        HashMap<String, PreSettlementReqVo> map = new HashMap<String, PreSettlementReqVo>();
        PreSettlementReqVo preSettlementReq = (PreSettlementReqVo)preSettlementReqVo.getBody();
        log.info("preSettlementReq\u5165\u53c2:" + preSettlementReq.toString());
        map.put(RequestEntityEnum.REGISTERED_PRE_SETTLEMENT.getValue(), preSettlementReq);
        FrontResponse preSettlementResponse = this.hisRemoteService.requestHis(preSettlementReqVo.getTransactionId(), MethodCodeEnum.PRE_SETTLEMENT.getValue(), map, PreSettlementResVo.class);
        PreSettlementResVo preSettlementResVo = (PreSettlementResVo)preSettlementResponse.getBody();
        if (null == preSettlementResVo) {
            return FrontResponse.error((String)preSettlementReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(preSettlementResVo.getResult())) {
            return FrontResponse.error((String)preSettlementReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(preSettlementResVo.getResult())) {
            return FrontResponse.success((String)preSettlementReqVo.getTransactionId(), null);
        }
        return FrontResponse.success((String)preSettlementReqVo.getTransactionId(), (Object)preSettlementResVo);
    }

    public FrontResponse<RegistrationConfirmResVo> registrationConfirmation(FrontRequest<RegistrationConfirmReqVo> registrationConfirmReqVo) {
        HashMap<String, RegistrationConfirmReqVo> map = new HashMap<String, RegistrationConfirmReqVo>();
        RegistrationConfirmReqVo registrationConfirm = (RegistrationConfirmReqVo)registrationConfirmReqVo.getBody();
        log.info("registrationConfirm\u5165\u53c2:" + registrationConfirm.toString());
        map.put(RequestEntityEnum.REGISTRATION_CONFIRMTION.getValue(), registrationConfirm);
        FrontResponse registrationConfirmResponse = this.hisRemoteService.requestHis(registrationConfirmReqVo.getTransactionId(), MethodCodeEnum.REGISTRATION_CONFIRMTION.getValue(), map, RegistrationConfirmResVo.class);
        RegistrationConfirmResVo registrationConfirmResVo = (RegistrationConfirmResVo)registrationConfirmResponse.getBody();
        if (null == registrationConfirmResVo) {
            return FrontResponse.error((String)registrationConfirmReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(registrationConfirmResVo.getResult())) {
            return FrontResponse.error((String)registrationConfirmReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(registrationConfirmResVo.getResult())) {
            return FrontResponse.success((String)registrationConfirmReqVo.getTransactionId(), null);
        }
        return FrontResponse.success((String)registrationConfirmReqVo.getTransactionId(), (Object)registrationConfirmResVo);
    }

    public FrontResponse<UnregisterResVo> unregister(FrontRequest<UnregisterReqVo> unregisterReqVo) {
        HashMap<String, UnregisterReqVo> map = new HashMap<String, UnregisterReqVo>();
        UnregisterReqVo unregisterReq = (UnregisterReqVo)unregisterReqVo.getBody();
        log.info("unregisterReq\u5165\u53c2:" + unregisterReq.toString());
        map.put(RequestEntityEnum.UNREGISTERREQ.getValue(), unregisterReq);
        FrontResponse unregisterResponse = this.hisRemoteService.requestHis(unregisterReqVo.getTransactionId(), MethodCodeEnum.UNREGISTERREQ.getValue(), map, UnregisterResVo.class);
        UnregisterResVo unregisterResVo = (UnregisterResVo)unregisterResponse.getBody();
        if (null == unregisterResVo) {
            return FrontResponse.error((String)unregisterReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(unregisterResVo.getResult())) {
            return FrontResponse.error((String)unregisterReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(unregisterResVo.getResult())) {
            return FrontResponse.success((String)unregisterReqVo.getTransactionId(), null);
        }
        return FrontResponse.success((String)unregisterReqVo.getTransactionId(), (Object)unregisterResVo);
    }

    public FrontResponse<RegisteredSaveResVo> registeredSave(FrontRequest<PreSettlementReqVo> registeredSaveReqVo) {
        HashMap<String, PreSettlementReqVo> map = new HashMap<String, PreSettlementReqVo>();
        PreSettlementReqVo registeredSaveReq = (PreSettlementReqVo)registeredSaveReqVo.getBody();
        log.info("registeredSaveReq\u5165\u53c2:" + registeredSaveReq.toString());
        map.put(RequestEntityEnum.REGISTERED_SAVE.getValue(), registeredSaveReq);
        FrontResponse registeredSaveResponse = this.hisRemoteService.requestHis(registeredSaveReqVo.getTransactionId(), MethodCodeEnum.REGISTERED_SAVE.getValue(), map, RegisteredSaveResVo.class);
        RegisteredSaveResVo registeredSaveResVo = (RegisteredSaveResVo)registeredSaveResponse.getBody();
        if (null == registeredSaveResVo) {
            return FrontResponse.error((String)registeredSaveReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(registeredSaveResVo.getResult())) {
            return FrontResponse.error((String)registeredSaveReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(registeredSaveResVo.getResult())) {
            return FrontResponse.success((String)registeredSaveReqVo.getTransactionId(), null);
        }
        return FrontResponse.success((String)registeredSaveReqVo.getTransactionId(), (Object)registeredSaveResVo);
    }

    public FrontResponse<HangUpItemVo> getHangRecord(FrontRequest<GetHangRecordReqVo> hangRecordReqVo) {
        HashMap<String, GetHangRecordReqVo> map = new HashMap<String, GetHangRecordReqVo>();
        GetHangRecordReqVo hangRecordReq = (GetHangRecordReqVo)hangRecordReqVo.getBody();
        log.info("hangRecordReq\u5165\u53c2:" + hangRecordReq.toString());
        map.put(RequestEntityEnum.HANG_RECORD.getValue(), hangRecordReq);
        FrontResponse hangRecordResponse = this.hisRemoteService.requestHis(hangRecordReqVo.getTransactionId(), MethodCodeEnum.HANG_RECORD.getValue(), map, GetHangRecordResVo.class);
        GetHangRecordResVo hangRecordResVo = (GetHangRecordResVo)hangRecordResponse.getBody();
        if (null == hangRecordResVo) {
            return FrontResponse.error((String)hangRecordReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(hangRecordResVo.getResult())) {
            return FrontResponse.error((String)hangRecordReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(hangRecordResVo.getResult())) {
            return FrontResponse.success((String)hangRecordReqVo.getTransactionId(), null);
        }
        HangUpItemVo hangUpItemVo = hangRecordResVo.getHangUpItemsVo().getHangUpItemVo();
        return FrontResponse.success((String)hangRecordReqVo.getTransactionId(), (Object)hangUpItemVo);
    }

    public FrontResponse<GetHangRecordDisposalResVo> gethangRecordDisposal(FrontRequest<GetHangRecordDisposalReqVo> hangRecordDisposalReqVo) {
        HashMap<String, GetHangRecordDisposalReqVo> map = new HashMap<String, GetHangRecordDisposalReqVo>();
        GetHangRecordDisposalReqVo hangRecordDisposal = (GetHangRecordDisposalReqVo)hangRecordDisposalReqVo.getBody();
        log.info("hangRecordDisposal\u5165\u53c2:" + hangRecordDisposal.toString());
        map.put(RequestEntityEnum.HANG_RECORD_DISPOSAL.getValue(), hangRecordDisposal);
        FrontResponse hangRecordDisposalResponse = this.hisRemoteService.requestHis(hangRecordDisposalReqVo.getTransactionId(), MethodCodeEnum.HANG_RECORD_DISPOSAL.getValue(), map, GetHangRecordDisposalResVo.class);
        GetHangRecordDisposalResVo hangRecordDisposalResVo = (GetHangRecordDisposalResVo)hangRecordDisposalResponse.getBody();
        if (null == hangRecordDisposalResVo) {
            return FrontResponse.error((String)hangRecordDisposalReqVo.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(hangRecordDisposalResVo.getResult())) {
            return FrontResponse.error((String)hangRecordDisposalReqVo.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(hangRecordDisposalResVo.getResult())) {
            return FrontResponse.success((String)hangRecordDisposalReqVo.getTransactionId(), null);
        }
        return FrontResponse.success((String)hangRecordDisposalReqVo.getTransactionId(), (Object)hangRecordDisposalResVo);
    }

    public FrontResponse<CardVerificationResVo> cardVerification(FrontRequest<CardVerificationReqVo> cardVerificationRequest) {
        HashMap<String, CardVerificationReqVo> map = new HashMap<String, CardVerificationReqVo>();
        CardVerificationReqVo cardVerificationReqVo = (CardVerificationReqVo)cardVerificationRequest.getBody();
        log.info("cardVerificationReqVo\u5165\u53c2:" + cardVerificationReqVo.toString());
        map.put(RequestEntityEnum.CARD_VERIFICATION.getValue(), cardVerificationReqVo);
        FrontResponse cardVerificationResponse = this.hisRemoteService.requestHis(cardVerificationRequest.getTransactionId(), MethodCodeEnum.CARD_VERIFICATION.getValue(), map, CardVerificationResVo.class);
        CardVerificationResVo cardVerificationResVo = (CardVerificationResVo)cardVerificationResponse.getBody();
        if (null == cardVerificationResVo) {
            return FrontResponse.error((String)cardVerificationRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(cardVerificationResVo.getResult())) {
            return FrontResponse.error((String)cardVerificationRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(cardVerificationResVo.getResult())) {
            return FrontResponse.success((String)cardVerificationRequest.getTransactionId(), null);
        }
        return FrontResponse.success((String)cardVerificationRequest.getTransactionId(), (Object)cardVerificationResVo);
    }

    public FrontResponse<AdmissionOrCancellationResVo> admissionOrCancellation(FrontRequest<AdmissionOrCancellationReqVo> admissionOrCancelRequest) {
        HashMap<String, AdmissionOrCancellationReqVo> map = new HashMap<String, AdmissionOrCancellationReqVo>();
        AdmissionOrCancellationReqVo admissionOrCancelReqVo = (AdmissionOrCancellationReqVo)admissionOrCancelRequest.getBody();
        log.info("admissionOrCancelReqVo\u5165\u53c2:" + admissionOrCancelReqVo.toString());
        map.put(RequestEntityEnum.ADMISSION_OR_CANCEL.getValue(), admissionOrCancelReqVo);
        FrontResponse admissionOrCancelResponse = this.hisRemoteService.requestHis(admissionOrCancelRequest.getTransactionId(), MethodCodeEnum.ADMISSION_OR_CANCEL.getValue(), map, AdmissionOrCancellationResVo.class);
        AdmissionOrCancellationResVo admissionOrCancelResVo = (AdmissionOrCancellationResVo)admissionOrCancelResponse.getBody();
        if (null == admissionOrCancelResVo) {
            return FrontResponse.error((String)admissionOrCancelRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(admissionOrCancelResVo.getResult())) {
            return FrontResponse.error((String)admissionOrCancelRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(admissionOrCancelResVo.getResult())) {
            return FrontResponse.success((String)admissionOrCancelRequest.getTransactionId(), null);
        }
        return FrontResponse.success((String)admissionOrCancelRequest.getTransactionId(), (Object)admissionOrCancelResVo);
    }

    public FrontResponse<QueryPrescriptionVo> queryPrescription(FrontRequest<QueryPrescriptionReqVo> queryPrescriptionRequest) {
        HashMap<String, QueryPrescriptionReqVo> map = new HashMap<String, QueryPrescriptionReqVo>();
        QueryPrescriptionReqVo queryPrescriptionReqVo = (QueryPrescriptionReqVo)queryPrescriptionRequest.getBody();
        log.info("queryPrescriptionReqVo\u5165\u53c2:" + queryPrescriptionReqVo.toString());
        map.put(RequestEntityEnum.QUERY_PRESCRIPTION.getValue(), queryPrescriptionReqVo);
        FrontResponse queryPrescriptionResponse = this.hisRemoteService.requestHis(queryPrescriptionRequest.getTransactionId(), MethodCodeEnum.QUERY_PRESCRIPTION.getValue(), map, QueryPrescriptionResDto.class);
        QueryPrescriptionResDto queryPrescriptionRes = (QueryPrescriptionResDto)queryPrescriptionResponse.getBody();
        if (null == queryPrescriptionRes) {
            log.error("============\u5904\u65b9\u67e5\u8be2  \u8c03\u7528his\u5931\u8d25=============");
            FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), null);
        }
        if ("-1".equals(queryPrescriptionRes.getResult())) {
            log.error("\"============\u5904\u65b9\u67e5\u8be2  \u67e5\u8be2\u5931\u8d25=============");
            return FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), null);
        }
        if ("0".equals(queryPrescriptionRes.getResult())) {
            return FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), null);
        }
        QueryPrescriptionVo queryPrescription = queryPrescriptionRes.getQueryPrescriptionVo();
        return FrontResponse.success((String)queryPrescriptionRequest.getTransactionId(), (Object)queryPrescription);
    }

    public FrontResponse<ResetPrescriptionResVo> resetPrescription(FrontRequest<ResetPrescriptionReqVo> resetPrescriptionRequest) {
        HashMap<String, ResetPrescriptionReqVo> map = new HashMap<String, ResetPrescriptionReqVo>();
        ResetPrescriptionReqVo resetPrescriptionReqVo = (ResetPrescriptionReqVo)resetPrescriptionRequest.getBody();
        log.info("resetPrescriptionReqVo\u5165\u53c2:" + resetPrescriptionReqVo.toString());
        map.put(RequestEntityEnum.RESET_PRESCRIPTION.getValue(), resetPrescriptionReqVo);
        FrontResponse resetPrescriptionResponse = this.hisRemoteService.requestHis(resetPrescriptionRequest.getTransactionId(), MethodCodeEnum.RESET_PRESCRIPTION.getValue(), map, ResetPrescriptionResVo.class);
        ResetPrescriptionResVo resetPrescriptionResVo = (ResetPrescriptionResVo)resetPrescriptionResponse.getBody();
        if (null == resetPrescriptionResVo) {
            return FrontResponse.error((String)resetPrescriptionRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(resetPrescriptionResVo.getResult())) {
            return FrontResponse.error((String)resetPrescriptionRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(resetPrescriptionResVo.getResult())) {
            return FrontResponse.success((String)resetPrescriptionRequest.getTransactionId(), null);
        }
        return FrontResponse.success((String)resetPrescriptionRequest.getTransactionId(), (Object)resetPrescriptionResVo);
    }

    public FrontResponse<PrescriptionUploadResVo> prescriptionUpload(FrontRequest<PrescriptionUploadReqVo> prescriptionUploadRequest) {
        HashMap<String, PrescriptionUploadReqVo> map = new HashMap<String, PrescriptionUploadReqVo>();
        PrescriptionUploadReqVo prescriptionUploadReqVo = (PrescriptionUploadReqVo)prescriptionUploadRequest.getBody();
        log.info("prescriptionUploadReqVo\u5165\u53c2:" + prescriptionUploadReqVo.toString());
        map.put(RequestEntityEnum.PRESCRIPTION_UPLOAD.getValue(), prescriptionUploadReqVo);
        FrontResponse prescriptionUploadResponse = this.hisRemoteService.requestHis(prescriptionUploadRequest.getTransactionId(), MethodCodeEnum.PRESCRIPTION_UPLOAD.getValue(), map, PrescriptionUploadResVo.class);
        PrescriptionUploadResVo prescriptionUploadResVo = (PrescriptionUploadResVo)prescriptionUploadResponse.getBody();
        if (null == prescriptionUploadResVo) {
            return FrontResponse.error((String)prescriptionUploadRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(prescriptionUploadResVo.getResult())) {
            return FrontResponse.error((String)prescriptionUploadRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(prescriptionUploadResVo.getResult())) {
            return FrontResponse.success((String)prescriptionUploadRequest.getTransactionId(), null);
        }
        return FrontResponse.success((String)prescriptionUploadRequest.getTransactionId(), (Object)prescriptionUploadResVo);
    }

    public FrontResponse<CardVerificationAndInfoResVo> getCardVerificationAndInfo(FrontRequest<CardVerificationAndInfoReqVo> cardVerificationAndInfoRequest) {
        CardVerificationReqVo cardVerificationReqVo = new CardVerificationReqVo();
        BeanUtils.copyProperties((Object)cardVerificationAndInfoRequest.getBody(), (Object)cardVerificationReqVo);
        log.info("\u5361\u6821\u9a8c\u5165\u53c2:" + JSON.toJSONString((Object)cardVerificationReqVo));
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)cardVerificationReqVo);
        FrontResponse cardVerificationResponse = this.cardVerification(frontRequest);
        CardInfoReqVo cardInfoReqVo = new CardInfoReqVo();
        BeanUtils.copyProperties((Object)cardVerificationAndInfoRequest.getBody(), (Object)cardInfoReqVo);
        if (null != cardVerificationResponse.getBody()) {
            cardInfoReqVo.setFundType(((CardVerificationResVo)cardVerificationResponse.getBody()).getFundType());
            cardInfoReqVo.setHospFlag("0");
        }
        if ("0".equals(cardInfoReqVo.getFundType())) {
            cardInfoReqVo.setMarkNO("");
        }
        FrontRequest frontRequest1 = new FrontRequest();
        frontRequest1.setBody((Object)cardInfoReqVo);
        log.info("cardInfoReqVo:" + JSON.toJSONString((Object)cardInfoReqVo));
        FrontResponse cardInfo = this.getCardInfo(frontRequest1);
        CardVerificationAndInfoResVo cardVerificationAndInfoResVo = new CardVerificationAndInfoResVo();
        if (null != cardInfo.getBody() && null != cardVerificationResponse.getBody()) {
            BeanUtils.copyProperties((Object)cardInfo.getBody(), (Object)cardVerificationAndInfoResVo);
            cardVerificationAndInfoResVo.setFundType(((CardVerificationResVo)cardVerificationResponse.getBody()).getFundType());
        }
        return FrontResponse.success((String)"\u5361\u8be6\u60c5\u548c\u5361\u6821\u9a8c\u5408\u5e76\u7684\u51fa\u53c2", (Object)cardVerificationAndInfoResVo);
    }

    public FrontResponse<UnregisterPayMethodResVo> unregisterPayMethod(FrontRequest<UnregisterPayMethodReqVo> unregisterPayMethodRequest) {
        HashMap<String, UnregisterPayMethodReqVo> map = new HashMap<String, UnregisterPayMethodReqVo>();
        UnregisterPayMethodReqVo unregisterPayMethodReqVo = (UnregisterPayMethodReqVo)unregisterPayMethodRequest.getBody();
        log.info("unregisterPayMethodReqVo\u5165\u53c2:" + unregisterPayMethodReqVo.toString());
        map.put(RequestEntityEnum.UNREGISTER_PAY_METHOD.getValue(), unregisterPayMethodReqVo);
        FrontResponse unregisterPayMethodResponse = this.hisRemoteService.requestHis(unregisterPayMethodRequest.getTransactionId(), MethodCodeEnum.UNREGISTER_PAY_METHOD.getValue(), map, UnregisterPayMethodResVo.class);
        UnregisterPayMethodResVo unregisterPayMethod = (UnregisterPayMethodResVo)unregisterPayMethodResponse.getBody();
        if (null == unregisterPayMethod) {
            return FrontResponse.error((String)unregisterPayMethodRequest.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(unregisterPayMethod.getResult())) {
            return FrontResponse.error((String)unregisterPayMethodRequest.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(unregisterPayMethod.getResult())) {
            return FrontResponse.success((String)unregisterPayMethodRequest.getTransactionId(), null);
        }
        return FrontResponse.success((String)unregisterPayMethodRequest.getTransactionId(), (Object)unregisterPayMethod);
    }

    public FrontResponse<CardInfoResVo> cardInfoTest(FrontRequest<CardInfoReqVo> cardInfoReqVoFont) {
        HashMap<String, CardInfoReqVo> map = new HashMap<String, CardInfoReqVo>();
        CardInfoReqVo cardInfoReq = (CardInfoReqVo)cardInfoReqVoFont.getBody();
        log.info("cardInfoReqVo\u5165\u53c2:" + cardInfoReqVoFont.toString());
        map.put(RequestEntityEnum.GET_CARD_INFO.getValue(), cardInfoReq);
        FrontResponse cardInfoFrontResponse = this.hisRemoteService.requestHis(cardInfoReqVoFont.getTransactionId(), MethodCodeEnum.GET_CARD_INFO.getValue(), map, CardInfoResDto.class);
        CardInfoResDto cardInfo = (CardInfoResDto)cardInfoFrontResponse.getBody();
        if (null == cardInfo) {
            return FrontResponse.error((String)cardInfoReqVoFont.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if ("-1".equals(cardInfo.getResult())) {
            return FrontResponse.error((String)cardInfoReqVoFont.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        if ("0".equals(cardInfo.getResult())) {
            return FrontResponse.success((String)cardInfoReqVoFont.getTransactionId(), null);
        }
        CardInfoResVo cardInfoResVo = cardInfo.getCardInfoResVo();
        return FrontResponse.success((String)cardInfoReqVoFont.getTransactionId(), (Object)cardInfoResVo);
    }

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegistCardReqVo> param) {
        HashMap<String, Object> map = new HashMap<String, Object>(1);
        map.put(RequestEntityEnum.REGIST_CARD.getValue(), param.getBody());
        FrontResponse registeredCardRes = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.REGIST_CARD.getValue(), map, RegisteCardResVo.class);
        RegisteCardResVo registeCardResVo = (RegisteCardResVo)registeredCardRes.getBody();
        if (null == registeCardResVo) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!"1".equals(registeCardResVo.getResult())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u67e5\u8be2\u5931\u8d25");
        }
        RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
        registeredCardResVO.setPatientId(registeCardResVo.getMarkNo());
        registeredCardResVO.setPatientNo(registeCardResVo.getMarkNo());
        registeredCardResVO.setAddress(((RegistCardReqVo)param.getBody()).getAdress());
        registeredCardResVO.setCardType(((RegistCardReqVo)param.getBody()).getCardType());
        registeredCardResVO.setCardNo(((RegistCardReqVo)param.getBody()).getCardNo());
        registeredCardResVO.setCredNo(((RegistCardReqVo)param.getBody()).getIdCardNo());
        registeredCardResVO.setCredType(((RegistCardReqVo)param.getBody()).getIdCardType());
        registeredCardResVO.setDob(((RegistCardReqVo)param.getBody()).getBirthday());
        registeredCardResVO.setName(((RegistCardReqVo)param.getBody()).getName());
        registeredCardResVO.setSex(((RegistCardReqVo)param.getBody()).getSex());
        registeredCardResVO.setTelephone(((RegistCardReqVo)param.getBody()).getPhone());
        return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
    }

    public FrontResponse<CardVerificationAndInfoResVo> queryCardInfo(FrontRequest<QueryCardInfoReqVo> param) {
        log.info("\u67e5\u8be2his\u5185,\u8be5\u60a3\u8005\u6240\u6709\u7684\u5361\u7c7b\u578b\u6570\u636e\u8bf7\u6c42\u53c2\u6570:" + JSON.toJSONString(param));
        QueryCardInfoReqVo queryCardInfoReqVo = (QueryCardInfoReqVo)param.getBody();
        if (!StringUtil.isBlank((String)queryCardInfoReqVo.getMarkNO())) {
            queryCardInfoReqVo.setMarkType("3");
        }
        HashMap<String, QueryCardInfoReqVo> map = new HashMap<String, QueryCardInfoReqVo>(1);
        map.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
        FrontResponse response = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.QUERY_UCARD_INFO.getValue(), map, QueryCardInfoResVo.class);
        log.info("his\u4e2d\u8be5\u60a3\u8005\u6240\u6709\u7684\u5361\u7c7b\u578b\u6570\u636e:" + JSON.toJSONString((Object)response));
        QueryCardInfoResVo queryCardInfoResVo = (QueryCardInfoResVo)response.getBody();
        if (Objects.isNull(queryCardInfoResVo)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        if (!Objects.equals(queryCardInfoResVo.getResult(), "1")) {
            if (StringUtil.isBlank((String)queryCardInfoReqVo.getMarkNO())) {
                return this.getCardVerificationAndInfoResVoFrontResponse(param, queryCardInfoReqVo);
            }
            HashMap<String, QueryCardInfoReqVo> map102 = new HashMap<String, QueryCardInfoReqVo>(1);
            map102.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
            FrontResponse response102 = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_CARD_INFO_FUND.getValue(), map102, QueryFundCardInfoResp.class);
            if (!Objects.equals(((QueryFundCardInfoResp)response102.getBody()).getResult(), "1")) {
                log.error("102:\u533b\u4fdd\u5361\u53f7\u67e5\u8be2\u5931\u8d25{}", (Object)JSON.toJSONString((Object)queryCardInfoReqVo));
                return FrontResponse.error((String)param.getTransactionId(), (IError)IError.DATA_NOT_EXIST);
            }
            HashMap<String, QueryCardInfoReqVo> map99 = new HashMap<String, QueryCardInfoReqVo>(1);
            String sex = queryCardInfoReqVo.getSex();
            if ("\u5973".equals(sex)) {
                queryCardInfoReqVo.setSex("2");
            } else if ("\u7537".equals(sex)) {
                queryCardInfoReqVo.setSex("1");
            }
            map99.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
            response = this.hisRemoteService.requestHis("99A", param.getTransactionId(), MethodCodeEnum.QUERY_UCARD_INFO.getValue(), map99, QueryCardInfoResVo.class);
            return this.fund(param, response);
        }
        List item = queryCardInfoResVo.getItem().getList();
        log.info("\u60a3\u8005\u5728his\u4e2d\u7684\u6240\u6709\u5361\u4fe1\u606f\u96c6\u5408:" + JSON.toJSONString((Object)item));
        if (CollectionUtil.isEmpty((Collection)item)) {
            if (StringUtil.isBlank((String)queryCardInfoReqVo.getMarkNO())) {
                return this.getCardVerificationAndInfoResVoFrontResponse(param, queryCardInfoReqVo);
            }
            HashMap<String, QueryCardInfoReqVo> map102 = new HashMap<String, QueryCardInfoReqVo>(1);
            map102.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
            FrontResponse response102 = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_CARD_INFO_FUND.getValue(), map102, QueryFundCardInfoResp.class);
            if (!Objects.equals(((QueryFundCardInfoResp)response102.getBody()).getResult(), "1")) {
                log.error("102:\u533b\u4fdd\u5361\u53f7\u67e5\u8be2\u5931\u8d25{}", (Object)JSON.toJSONString((Object)queryCardInfoReqVo));
                return FrontResponse.error((String)param.getTransactionId(), (IError)IError.DATA_NOT_EXIST);
            }
            HashMap<String, QueryCardInfoReqVo> map99 = new HashMap<String, QueryCardInfoReqVo>(1);
            map99.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
            response = this.hisRemoteService.requestHis("99A", param.getTransactionId(), MethodCodeEnum.QUERY_UCARD_INFO.getValue(), map99, QueryCardInfoResVo.class);
            return this.fund(param, response);
        }
        List stateList = item.stream().filter(s -> "1".equals(s.getState())).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(stateList)) {
            if (!StringUtil.isBlank((String)queryCardInfoReqVo.getMarkNO())) {
                HashMap<String, QueryCardInfoReqVo> map102 = new HashMap<String, QueryCardInfoReqVo>(1);
                map102.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
                FrontResponse response102 = this.hisRemoteService.requestHis(param.getTransactionId(), MethodCodeEnum.GET_CARD_INFO_FUND.getValue(), map102, QueryFundCardInfoResp.class);
                if (!Objects.equals(((QueryFundCardInfoResp)response102.getBody()).getResult(), "1")) {
                    log.error("102:\u533b\u4fdd\u5361\u53f7\u67e5\u8be2\u5931\u8d25{}", (Object)JSON.toJSONString((Object)queryCardInfoReqVo));
                    return FrontResponse.error((String)param.getTransactionId(), (IError)IError.DATA_NOT_EXIST);
                }
                HashMap<String, QueryCardInfoReqVo> map99 = new HashMap<String, QueryCardInfoReqVo>(1);
                map99.put(RequestEntityEnum.QUERY_UCARD_INFO.getValue(), queryCardInfoReqVo);
                response = this.hisRemoteService.requestHis("99A", param.getTransactionId(), MethodCodeEnum.QUERY_UCARD_INFO.getValue(), map99, QueryCardInfoResVo.class);
                return this.fund(param, response);
            }
            return this.getCardVerificationAndInfoResVoFrontResponse(param, queryCardInfoReqVo);
        }
        List collectType3 = stateList.stream().filter(cardInfoResListVo -> "3".equals(cardInfoResListVo.getType()) && cardInfoResListVo.getMarkNo().length() == 12).collect(Collectors.toList());
        QueryCardInfoResListVo queryCardInfoResListVo = null;
        CardInfoReqVo cardInfoReqVo = new CardInfoReqVo();
        String markType = "0";
        if (CollectionUtil.isNotEmpty(collectType3)) {
            queryCardInfoResListVo = (QueryCardInfoResListVo)collectType3.get(0);
            markType = "3";
        } else {
            queryCardInfoResListVo = (QueryCardInfoResListVo)stateList.get(0);
        }
        cardInfoReqVo.setIdCard(queryCardInfoReqVo.getIdCard());
        cardInfoReqVo.setName(queryCardInfoReqVo.getName());
        cardInfoReqVo.setBirthday(queryCardInfoResListVo.getBirthDay());
        cardInfoReqVo.setSex(queryCardInfoResListVo.getSexCode());
        cardInfoReqVo.setMarkNO(queryCardInfoResListVo.getMarkNo());
        cardInfoReqVo.setMarkType(markType);
        cardInfoReqVo.setFundType(markType);
        FrontResponse cardInfo = this.getCardInfo(cardInfoReqVo);
        if (!"1".equals(cardInfo.getCode()) || Objects.isNull(cardInfo.getBody())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
        }
        CardVerificationAndInfoResVo cardVerificationAndInfoBody = (CardVerificationAndInfoResVo)cardInfo.getBody();
        cardVerificationAndInfoBody.setMarkNo(queryCardInfoResListVo.getMarkNo());
        cardVerificationAndInfoBody.setMarkType(markType);
        log.info("\u5361\u8be6\u60c5\u65b9\u6cd5\u7684\u51fa\u53c2:" + JSON.toJSONString((Object)cardInfo));
        return FrontResponse.success((String)param.getTransactionId(), (Object)cardVerificationAndInfoBody);
    }

    public FrontResponse<CardVerificationAndInfoResVo> getCardVerificationAndInfoResVoFrontResponse(FrontRequest<QueryCardInfoReqVo> param, QueryCardInfoReqVo queryCardInfoReqVo) {
        RegistCardReqVo registCardReqVo = new RegistCardReqVo();
        registCardReqVo.setBirthday(IdCardUtil.getBirthByIdCard2((String)queryCardInfoReqVo.getCredNo()));
        registCardReqVo.setSex(this.getGenderByIdCard(queryCardInfoReqVo.getCredNo()));
        registCardReqVo.setAdress(queryCardInfoReqVo.getDetailAddress());
        registCardReqVo.setCardNo(queryCardInfoReqVo.getCredNo());
        registCardReqVo.setIdCardNo(queryCardInfoReqVo.getCredNo());
        registCardReqVo.setName(queryCardInfoReqVo.getName());
        registCardReqVo.setPhone(queryCardInfoReqVo.getTelephone());
        registCardReqVo.setIdCardType(queryCardInfoReqVo.getCredTypeCode());
        registCardReqVo.setCardType("0");
        registCardReqVo.setPactCode(queryCardInfoReqVo.getPactCode());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)registCardReqVo);
        FrontResponse registeredCardResVOFrontResponse = this.registerCard(frontRequest);
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u8fd4\u56de\u53c2\u6570:" + JSON.toJSONString((Object)registeredCardResVOFrontResponse));
        RegisteredCardResVO registeredCardResVOFrontResponseBody = (RegisteredCardResVO)registeredCardResVOFrontResponse.getBody();
        if (!"1".equals(registeredCardResVOFrontResponse.getCode()) || Objects.isNull(registeredCardResVOFrontResponseBody)) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u5f02\u5e38");
        }
        CardVerificationAndInfoResVo cardVerificationAndInfoResVo = new CardVerificationAndInfoResVo();
        cardVerificationAndInfoResVo.setIdNO(registeredCardResVOFrontResponseBody.getCredNo());
        cardVerificationAndInfoResVo.setBirthDay(registeredCardResVOFrontResponseBody.getDob());
        cardVerificationAndInfoResVo.setSex(registeredCardResVOFrontResponseBody.getSex());
        cardVerificationAndInfoResVo.setMarkNo(registeredCardResVOFrontResponseBody.getPatientId());
        cardVerificationAndInfoResVo.setName(registeredCardResVOFrontResponseBody.getName());
        cardVerificationAndInfoResVo.setPhone(registeredCardResVOFrontResponseBody.getTelephone());
        cardVerificationAndInfoResVo.setAddress(registeredCardResVOFrontResponseBody.getAddress());
        cardVerificationAndInfoResVo.setCardNO(registeredCardResVOFrontResponseBody.getPatientId());
        cardVerificationAndInfoResVo.setFundType("0");
        cardVerificationAndInfoResVo.setMarkType("0");
        return FrontResponse.success((String)param.getTransactionId(), (Object)cardVerificationAndInfoResVo);
    }

    private String getGenderByIdCard(String idCard) {
        String sGender = "99";
        if (idCard.length() == 15) {
            idCard = IdCardUtil.convert15CardTo18((String)idCard);
        }
        if (idCard == null) {
            return null;
        }
        String sCardNum = idCard.substring(16, 17);
        sGender = Integer.parseInt(sCardNum) % 2 != 0 ? "1" : "2";
        return sGender;
    }

    public FrontResponse<CardVerificationAndInfoResVo> getCardInfo(CardInfoReqVo cardInfoReqVo) {
        if ("0".equals(cardInfoReqVo.getFundType())) {
            cardInfoReqVo.setMarkNO("");
        }
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)cardInfoReqVo);
        FrontResponse cardInfo = this.getCardInfo(frontRequest);
        if ("0".equals(cardInfo.getCode())) {
            return FrontResponse.error((String)cardInfo.getTransactionId(), (IError)IError.DATA_NOT_EXIST);
        }
        CardVerificationAndInfoResVo cardVerificationAndInfoResVo = new CardVerificationAndInfoResVo();
        if (null != cardInfo.getBody()) {
            BeanUtils.copyProperties((Object)cardInfo.getBody(), (Object)cardVerificationAndInfoResVo);
        }
        return FrontResponse.success((String)cardInfo.getTransactionId(), (Object)cardVerificationAndInfoResVo);
    }

    private FrontResponse<CardVerificationAndInfoResVo> fund(FrontRequest<QueryCardInfoReqVo> param, FrontResponse<QueryCardInfoResVo> response) {
        QueryCardInfoResVo queryCardInfoResVo = (QueryCardInfoResVo)response.getBody();
        List item = queryCardInfoResVo.getItem().getList();
        List stateList = item.stream().filter(s -> "1".equals(s.getState())).collect(Collectors.toList());
        QueryCardInfoReqVo queryCardInfoReqVo = (QueryCardInfoReqVo)param.getBody();
        List collectType3 = stateList.stream().filter(cardInfoResListVo -> "3".equals(cardInfoResListVo.getType()) && cardInfoResListVo.getMarkNo().length() == 12).collect(Collectors.toList());
        QueryCardInfoResListVo queryCardInfoResListVo = null;
        CardInfoReqVo cardInfoReqVo = new CardInfoReqVo();
        String markType = "0";
        if (CollectionUtil.isNotEmpty(collectType3)) {
            queryCardInfoResListVo = (QueryCardInfoResListVo)collectType3.get(0);
            markType = "3";
        } else {
            queryCardInfoResListVo = (QueryCardInfoResListVo)stateList.get(0);
        }
        cardInfoReqVo.setIdCard(queryCardInfoReqVo.getIdCard());
        cardInfoReqVo.setName(queryCardInfoReqVo.getName());
        cardInfoReqVo.setBirthday(queryCardInfoResListVo.getBirthDay());
        cardInfoReqVo.setSex(queryCardInfoResListVo.getSexCode());
        cardInfoReqVo.setMarkNO(queryCardInfoResListVo.getMarkNo());
        cardInfoReqVo.setMarkType(markType);
        cardInfoReqVo.setFundType(queryCardInfoReqVo.getFundType());
        FrontResponse cardInfo = this.getCardInfo(cardInfoReqVo);
        if (!"1".equals(cardInfo.getCode()) || Objects.isNull(cardInfo.getBody())) {
            return FrontResponse.error((String)param.getTransactionId(), (String)"0", (String)"\u8c03\u7528his\u63a5\u53e3\u8fd4\u56de\u6570\u636e\u5f02\u5e38");
        }
        CardVerificationAndInfoResVo cardVerificationAndInfoBody = (CardVerificationAndInfoResVo)cardInfo.getBody();
        cardVerificationAndInfoBody.setMarkNo(queryCardInfoResListVo.getMarkNo());
        cardVerificationAndInfoBody.setMarkType(markType);
        log.info("\u5361\u8be6\u60c5\u65b9\u6cd5\u7684\u51fa\u53c2:" + JSON.toJSONString((Object)cardInfo));
        return FrontResponse.success((String)param.getTransactionId(), (Object)cardVerificationAndInfoBody);
    }
}

