/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.his.core.contoller;

import com.ebaiyihui.his.core.service.SettlementService;
import com.ebaiyihui.his.core.vo.GetPrescriptionStatusReqVo;
import com.ebaiyihui.his.core.vo.GetPriceInfoReqVo;
import com.ebaiyihui.his.core.vo.GetPriceInfoResVo;
import com.ebaiyihui.his.core.vo.PrescriptionPreSettlementReqVo;
import com.ebaiyihui.his.core.vo.PrescriptionPreSettlementResVo;
import com.ebaiyihui.his.core.vo.PrescriptionStatusItemResVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionReq;
import com.ebaiyihui.his.pojo.vo.outpatient.GetAdmissionRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u5904\u65b9\u7ed3\u7b97Api"})
@RequestMapping(value={"/api/v1/prescription"})
public class SettlementController {
    private static final Logger log = LoggerFactory.getLogger(SettlementController.class);
    @Autowired
    private SettlementService settlementService;

    @RequestMapping(value={"/getAdmission"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5c31\u8bca\u8bb0\u5f55\u67e5\u8be2", notes="\u83b7\u53d6\u7528\u6237\u5c31\u8bca\u8bb0\u5f55\u4fe1\u606f")
    public FrontResponse<GetAdmissionRes> getAdmission(@RequestBody FrontRequest<GetAdmissionReq> param) {
        return this.settlementService.getAdmission(param);
    }

    @ApiOperation(value="\u83b7\u53d6\u5212\u4ef7\u4fe1\u606f")
    @PostMapping(value={"/getPriceInfo"})
    public FrontResponse<GetPriceInfoResVo> getPriceInfo(@RequestBody FrontRequest<GetPriceInfoReqVo> reqVoFrontRequest) {
        return this.settlementService.getPriceInfo(reqVoFrontRequest);
    }

    @ApiOperation(value="\u5904\u65b9\u9884\u7ed3\u7b97")
    @PostMapping(value={"/preSettlement"})
    public FrontResponse<PrescriptionPreSettlementResVo> preSettlement(@RequestBody FrontRequest<PrescriptionPreSettlementReqVo> reqVoFrontRequest) {
        return this.settlementService.prescriptionPreSettlement(reqVoFrontRequest);
    }

    @ApiOperation(value="\u5904\u65b9\u7ed3\u7b97")
    @PostMapping(value={"/settlement"})
    public FrontResponse<PrescriptionPreSettlementResVo> settlement(@RequestBody FrontRequest<PrescriptionPreSettlementReqVo> reqVoFrontRequest) {
        return this.settlementService.prescriptionSettlement(reqVoFrontRequest);
    }

    @ApiOperation(value="\u67e5\u8be2\u5904\u65b9\u72b6\u6001")
    @PostMapping(value={"/getPrescriptionStatus"})
    public FrontResponse<PrescriptionStatusItemResVO> getPrescriptionStatus(@RequestBody FrontRequest<GetPrescriptionStatusReqVo> reqVoFrontRequest) {
        return this.settlementService.getPrescriptionStatus(reqVoFrontRequest);
    }
}

