/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.color;

import java.awt.Color;
import java.awt.Component;
import javax.swing.UIManager;

public abstract class DarkColorModel {
    private final String prefix;
    private final String[] labels;

    public DarkColorModel(String name, String ... labels) {
        this.prefix = "ColorChooser." + name;
        this.labels = labels;
    }

    public int getCount() {
        return this.labels.length;
    }

    public abstract int getMinimum(int var1);

    public abstract int getMaximum(int var1);

    public int getDefault(int index) {
        return this.getMinimum(index);
    }

    public final String getText(Component component, String suffix) {
        return UIManager.getString((Object)(this.prefix + suffix + "Text"), component.getLocale());
    }

    public abstract String toString();

    public abstract char[] getLabelDescriptorsBefore();

    public String[] getFullLabelDescriptorsBefore() {
        return this.labels;
    }

    public char[] getLabelDescriptorsAfter() {
        return new char[]{'\u0000', '\u0000', '\u0000', '\u0000'};
    }

    public int[] getValuesFromColor(Color color) {
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public Color getColorFromValues(int[] values) {
        return new Color(values[0], values[1], values[2]);
    }
}

