/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.components.color;

import com.github.weisj.darklaf.components.color.PopupColorChooser;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.SolidColorIcon;
import java.awt.Color;
import java.awt.FlowLayout;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class QuickColorChooser
extends JPanel {
    private final SolidColorIcon icon;
    private final JCheckBox checkBox = new JCheckBox();

    public QuickColorChooser(String title, Color color, Consumer<Color> onColorChange) {
        this(title, color, (b, c) -> onColorChange.accept((Color)c), false);
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange, boolean showCheckBox) {
        super(new FlowLayout(0, 0, 0));
        if (showCheckBox) {
            this.checkBox.addActionListener(e -> onStatusChange.accept(this.isSelected(), this.getColor()));
            this.add(this.checkBox);
        }
        this.icon = new SolidColorIcon(color);
        JLabel colorLabel = new JLabel((Icon)this.icon, 2);
        QuickColorChooser.attachToComponent(colorLabel, c -> {
            onStatusChange.accept(this.isSelected(), (Color)c);
            this.icon.setColor(c);
            colorLabel.repaint();
        }, () -> ((SolidColorIcon)this.icon).getColor());
        this.add(colorLabel);
        this.add(new JLabel(title, EmptyIcon.create((int)2, (int)2), 2));
    }

    public QuickColorChooser(String title, Color color, BiConsumer<Boolean, Color> onStatusChange) {
        this(title, color, onStatusChange, true);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier) {
        QuickColorChooser.attachToComponent(component, onStatusChange, supplier, Boolean.TRUE::booleanValue);
    }

    public static void attachToComponent(JComponent component, Consumer<Color> onStatusChange, Supplier<Color> supplier, Supplier<Boolean> activationCheck) {
        AtomicBoolean isShowing = new AtomicBoolean(false);
        component.addMouseListener(e -> {
            if (!component.isEnabled() || isShowing.get() || !((Boolean)activationCheck.get()).booleanValue()) {
                return;
            }
            isShowing.set(true);
            PopupColorChooser.showColorChooser(component, (Color)supplier.get(), c -> {
                if (c != null) {
                    onStatusChange.accept((Color)c);
                }
            }, event -> SwingUtilities.invokeLater(() -> isShowing.set(false)));
        });
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public Color getColor() {
        return this.icon.getColor();
    }
}

