/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.graphics;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.GraphicsUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.text.View;

public class PaintUtil {
    public static final Color TRANSPARENT_COLOR = new Color(0, true);
    private static AlphaComposite glowComposite = AlphaComposite.getInstance(3, 0.5f);
    private static AlphaComposite dropComposite = AlphaComposite.getInstance(3, 0.8f);
    private static AlphaComposite shadowComposite = AlphaComposite.getInstance(3, 0.1f);
    private static Color errorGlow;
    private static Color errorFocusGlow;
    private static Color focusGlow;
    private static Color focusInactiveGlow;
    private static Color warningGlow;

    public static void setGlowOpacity(float alpha) {
        glowComposite = glowComposite.derive(alpha);
    }

    public static void setShadowOpacity(float alpha) {
        shadowComposite = shadowComposite.derive(alpha);
    }

    public static void setDropOpacity(float alpha) {
        dropComposite = dropComposite.derive(alpha);
    }

    public static AlphaComposite getDropComposite() {
        return dropComposite;
    }

    public static AlphaComposite getShadowComposite() {
        return shadowComposite;
    }

    public static AlphaComposite getGlowComposite() {
        return glowComposite;
    }

    public static void setErrorGlow(Color errorGlow) {
        PaintUtil.errorGlow = errorGlow;
    }

    public static void setErrorFocusGlow(Color errorFocusGlow) {
        PaintUtil.errorFocusGlow = errorFocusGlow;
    }

    public static void setFocusGlow(Color focusGlow) {
        PaintUtil.focusGlow = focusGlow;
    }

    public static void setFocusInactiveGlow(Color focusInactiveGlow) {
        PaintUtil.focusInactiveGlow = focusInactiveGlow;
    }

    public static void setWarningGlow(Color warningGlow) {
        PaintUtil.warningGlow = warningGlow;
    }

    public static Color getErrorGlow() {
        return errorGlow;
    }

    public static Color getErrorFocusGlow() {
        return errorFocusGlow;
    }

    public static Color getFocusGlow() {
        return focusGlow;
    }

    public static Color getFocusInactiveGlow() {
        return focusInactiveGlow;
    }

    public static Color getWarningGlow() {
        return warningGlow;
    }

    private static void doPaint(Graphics2D g, float width, float height, float arc, float bw, boolean inside) {
        GraphicsContext context = GraphicsUtil.setupStrokePainting(g);
        float outerArc = inside ? arc : arc + bw;
        float innerArc = inside ? arc - bw : arc;
        RoundRectangle2D.Float outerRect = new RoundRectangle2D.Float(0.0f, 0.0f, width, height, outerArc, outerArc);
        RoundRectangle2D.Float innerRect = new RoundRectangle2D.Float(bw, bw, width - 2.0f * bw, height - 2.0f * bw, innerArc, innerArc);
        Path2D.Float path = new Path2D.Float(0);
        path.append(outerRect, false);
        path.append(innerRect, false);
        g.fill(path);
        context.restore();
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, float bw) {
        PaintUtil.paintFocusBorder(g, width, height, arc, bw, true);
    }

    public static void paintFocusBorder(Graphics2D g, int width, int height, float arc, float bw, boolean active) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        PaintUtil.paintOutlineBorder(g, width, height, arc, bw, active, Outline.focus);
        config.restore();
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, float bw, boolean hasFocus, Outline type) {
        PaintUtil.paintOutlineBorder(g, width, height, arc, bw, hasFocus, type, true);
    }

    public static void paintOutlineBorder(Graphics2D g, int width, int height, float arc, float bw, boolean hasFocus, Outline type, boolean withLineBorder) {
        type.setGraphicsColor(g, hasFocus);
        PaintUtil.doPaint(g, width, height, arc, withLineBorder ? bw + PaintUtil.getStrokeWidth(g) : bw, false);
    }

    public static void fillFocusRect(Graphics2D g, int x, int y, int width, int height) {
        PaintUtil.fillFocusRect(g, x, y, width, height, true);
    }

    public static void fillFocusRect(Graphics2D g, int x, int y, int width, int height, boolean active) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        Outline.focus.setGraphicsColor(g, active);
        g.fillRect(x, y, width, height);
        config.restore();
    }

    public static void paintFocusOval(Graphics2D g, int x, int y, int width, int height) {
        PaintUtil.paintFocusOval(g, (float)x, (float)y, (float)width, (float)height);
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height) {
        PaintUtil.paintFocusOval(g, x, y, width, height, true);
    }

    public static void paintFocusOval(Graphics2D g, float x, float y, float width, float height, boolean active) {
        GraphicsContext config = new GraphicsContext(g);
        g.setComposite(glowComposite);
        Outline.focus.setGraphicsColor(g, active);
        float blw = 3.0f;
        Path2D.Float shape = new Path2D.Float(0);
        shape.append(new Ellipse2D.Float(x - blw, y - blw, width + blw * 2.0f, height + blw * 2.0f), false);
        shape.append(new Ellipse2D.Float(x, y, width, height), false);
        g.fill(shape);
        config.restore();
    }

    public static float getStrokeWidth(Graphics2D g) {
        Stroke stroke = g.getStroke();
        return stroke instanceof BasicStroke ? ((BasicStroke)stroke).getLineWidth() : 1.0f;
    }

    public static void paintLineBorder(Graphics2D g, float x, float y, float width, float height, int arc) {
        float lw = PaintUtil.getStrokeWidth(g);
        g.translate(x, y);
        PaintUtil.doPaint(g, width, height, arc, lw, true);
        g.translate(-x, -y);
    }

    public static void fillRoundRect(Graphics2D g, float x, float y, float width, float height, int arc) {
        PaintUtil.fillRoundRect(g, x, y, width, height, arc, true);
    }

    public static void fillRoundRect(Graphics2D g, float x, float y, float width, float height, int arc, boolean adjustForBorder) {
        float lw = adjustForBorder ? PaintUtil.getStrokeWidth(g) / 2.0f : 0.0f;
        float arcSze = (float)arc - lw;
        g.fill(new RoundRectangle2D.Float(x + lw, y + lw, width - 2.0f * lw, height - 2.0f * lw, arcSze, arcSze));
    }

    public static Color blendColors(Color color1, Color color2, double percent) {
        if (percent == 1.0) {
            return color1;
        }
        if (percent == 0.0) {
            return color2;
        }
        double inverse_percent = 1.0 - percent;
        int redPart = (int)((double)color1.getRed() * percent + (double)color2.getRed() * inverse_percent);
        int greenPart = (int)((double)color1.getGreen() * percent + (double)color2.getGreen() * inverse_percent);
        int bluePart = (int)((double)color1.getBlue() * percent + (double)color2.getBlue() * inverse_percent);
        return new Color(redPart, greenPart, bluePart);
    }

    public static void drawRect(Graphics g, Rectangle rect, int thickness) {
        PaintUtil.drawRect(g, rect.x, rect.y, rect.width, rect.height, thickness);
    }

    public static void drawRect(Graphics g, int x, int y, int width, int height, int thickness) {
        g.fillRect(x, y, width, thickness);
        g.fillRect(x, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x + width - thickness, y + thickness, thickness, height - 2 * thickness);
        g.fillRect(x, y + height - thickness, width, thickness);
    }

    public static <T extends JComponent> void drawString(Graphics g, T c, String text, Rectangle textRect, FontMetrics fm, PaintMethod<T> paintMethod) {
        GraphicsContext context = GraphicsUtil.setupAntialiasing(g);
        g.clipRect(textRect.x, textRect.y, textRect.width, textRect.height);
        if (text != null && !text.equals("")) {
            View v = (View)PropertyUtil.getObject(c, (String)"html", View.class);
            if (v != null) {
                v.paint(g, textRect);
            } else {
                textRect.y += fm.getAscent();
                paintMethod.paintText(g, c, textRect, text);
            }
        }
        context.restore();
    }

    public static enum Outline {
        error{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(PaintUtil.getErrorFocusGlow());
                } else {
                    g.setColor(PaintUtil.getErrorGlow());
                }
            }
        }
        ,
        warning{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                g.setColor(PaintUtil.getWarningGlow());
            }
        }
        ,
        defaultButton{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean focused) {
                if (focused) {
                    g.setColor(PaintUtil.getFocusGlow());
                }
            }
        }
        ,
        focus{

            @Override
            public void setGraphicsColor(Graphics2D g, boolean active) {
                if (active) {
                    g.setColor(PaintUtil.getFocusGlow());
                } else {
                    g.setColor(PaintUtil.getFocusInactiveGlow());
                }
            }
        };


        public abstract void setGraphicsColor(Graphics2D var1, boolean var2);
    }

    public static interface PaintMethod<T extends JComponent> {
        public void paintText(Graphics var1, T var2, Rectangle var3, String var4);
    }
}

