/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.task;

import com.github.weisj.darklaf.color.DarkColorModelHSB;
import com.github.weisj.darklaf.task.ColorAdjustmentTask;
import com.github.weisj.darklaf.theme.Theme;
import com.github.weisj.darklaf.theme.info.AccentColorRule;
import com.github.weisj.darklaf.util.Pair;
import java.awt.Color;
import java.util.List;
import java.util.Properties;

public class ForegroundColorGenerationTask
extends ColorAdjustmentTask {
    private static final String FOREGROUND_LIST_KEY = "selectionForeground.propertyList";
    private static final String ACCENT_LIST_KEY = "accentForeground.propertyList";
    private static final double MIN_FOREGROUND_DIFFERENCE = 0.4;

    @Override
    protected void beforeTask(Theme currentTheme, Properties properties) {
        super.beforeTask(currentTheme, properties);
        DEFAULTS.putAll(properties);
    }

    @Override
    protected void runTask(Theme currentTheme, Properties properties) {
        Properties props = currentTheme.loadPropertyFile("accents", true);
        AccentColorRule accentColorRule = currentTheme.getAccentColorRule();
        if (accentColorRule.getAccentColor() != null) {
            this.adjust(ACCENT_LIST_KEY, props, list -> this.adjustForegroundList((List<?>)list, properties));
        }
        if (accentColorRule.getSelectionColor() != null) {
            this.adjust(FOREGROUND_LIST_KEY, props, list -> this.adjustForegroundList((List<?>)list, properties));
        }
    }

    private void adjustForegroundList(List<?> list, Properties properties) {
        for (Object o : list) {
            Pair pair;
            if (!(o instanceof Pair) || !((pair = (Pair)o).getFirst() instanceof Color)) continue;
            Color c = (Color)pair.getFirst();
            properties.put(pair.getSecond(), this.makeForeground(c));
        }
    }

    private Color makeForeground(Color c) {
        double[] hsb = DarkColorModelHSB.RGBtoHSBValues(c.getRed(), c.getGreen(), c.getBlue());
        double b = hsb[2];
        double brightness = 1.0 - b;
        double difference = Math.abs(brightness - b);
        if (difference < 0.4) {
            int bias = b < 0.5 ? 1 : -1;
            brightness += (double)bias * Math.abs(0.4 - difference);
        }
        return DarkColorModelHSB.getColorFromHSBValues(hsb[0], 0.0, brightness);
    }
}

