/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.filechooser;

import com.github.weisj.darklaf.components.OverlayScrollPane;
import com.github.weisj.darklaf.ui.filechooser.DarkFilePaneUIBridge;
import com.github.weisj.darklaf.ui.list.DarkListCellRenderer;
import com.github.weisj.darklaf.ui.table.TextTableCellEditorBorder;
import com.github.weisj.darklaf.util.DarkUIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.TableModelEvent;
import javax.swing.text.Position;
import sun.swing.SwingUtilities2;

public class DarkFilePane
extends DarkFilePaneUIBridge {
    public DarkFilePane(DarkFilePaneUIBridge.FileChooserUIAccessor fileChooserUIAccessor) {
        super(fileChooserUIAccessor);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.kiloByteString = UIManager.getString("FileChooser.fileSizeKiloBytes");
        this.megaByteString = UIManager.getString("FileChooser.fileSizeMegaBytes");
        this.gigaByteString = UIManager.getString("FileChooser.fileSizeGigaBytes");
        this.editCell = new JTextField();
        this.editCell.setBorder(new TextTableCellEditorBorder());
        this.editCell.putClientProperty("JTextField.listCellEditor", true);
    }

    @Override
    public JPanel createList() {
        JPanel p = new JPanel(new BorderLayout());
        final JFileChooser fileChooser = this.getFileChooser();
        final JList<Object> list = new JList<Object>(){

            @Override
            public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
                ListModel model = this.getModel();
                int max = model.getSize();
                if (prefix == null || startIndex < 0 || startIndex >= max) {
                    throw new IllegalArgumentException();
                }
                boolean backwards = bias == Position.Bias.Backward;
                int i = startIndex;
                while (backwards ? i >= 0 : i < max) {
                    String filename = fileChooser.getName((File)model.getElementAt(i));
                    if (filename.regionMatches(true, 0, prefix, 0, prefix.length())) {
                        return i;
                    }
                    i += backwards ? -1 : 1;
                }
                return -1;
            }
        };
        list.setCellRenderer(new DarkFileRenderer());
        list.setLayoutOrientation(1);
        LookAndFeel.installColors(list, "FileView.background", "FileView.foreground");
        list.putClientProperty("List.isFileList", Boolean.TRUE);
        list.putClientProperty("JList.fullRowSelection", this.fullRowSelection);
        if (this.listViewWindowsStyle) {
            list.addFocusListener(repaintListener);
        }
        this.updateListRowCount(list);
        this.getModel().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                DarkFilePane.this.updateListRowCount(list);
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                DarkFilePane.this.updateListRowCount(list);
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                if (DarkFilePane.this.isShowing()) {
                    DarkFilePane.this.clearSelection();
                }
                DarkFilePane.this.updateListRowCount(list);
            }
        });
        this.getModel().addPropertyChangeListener(this);
        if (fileChooser.isMultiSelectionEnabled()) {
            list.setSelectionMode(2);
        } else {
            list.setSelectionMode(0);
        }
        list.setModel(new DarkFilePaneUIBridge.SortableListModel(this));
        list.addListSelectionListener(this.createListSelectionListener());
        list.addMouseListener(this.getMouseHandler());
        OverlayScrollPane overlayScrollPane = new OverlayScrollPane(list);
        JScrollPane scrollPane = overlayScrollPane.getScrollPane();
        if (this.listViewBackground != null) {
            list.setBackground(this.listViewBackground);
        }
        if (this.listViewBorder != null) {
            scrollPane.setBorder(this.listViewBorder);
        }
        list.putClientProperty("AccessibleName", this.filesListAccessibleName);
        p.add((Component)overlayScrollPane, "Center");
        return p;
    }

    @Override
    public JPanel createDetailsView() {
        final JFileChooser chooser = this.getFileChooser();
        JPanel p = new JPanel(new BorderLayout());
        JTable detailsTable = new JTable(this.getDetailsTableModel()){

            @Override
            public void tableChanged(TableModelEvent e) {
                super.tableChanged(e);
                if (e.getFirstRow() == -1) {
                    DarkFilePane.this.updateDetailsColumnModel(this);
                }
            }

            @Override
            protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                if (e.getKeyCode() == 27 && this.getCellEditor() == null) {
                    chooser.dispatchEvent(e);
                    return true;
                }
                return super.processKeyBinding(ks, e, condition, pressed);
            }
        };
        int rowHeight = UIManager.getInt("FileChooser.rowHeight");
        if (rowHeight > 0) {
            detailsTable.setRowHeight(rowHeight);
        }
        detailsTable.setRowSorter(this.getRowSorter());
        detailsTable.setAutoCreateColumnsFromModel(false);
        detailsTable.setComponentOrientation(chooser.getComponentOrientation());
        detailsTable.setAutoResizeMode(3);
        detailsTable.setRowSelectionAllowed(true);
        detailsTable.setShowGrid(false);
        detailsTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        detailsTable.addKeyListener(this.detailsKeyListener);
        detailsTable.putClientProperty("JTable.rowFocusBorder", true);
        detailsTable.putClientProperty("JTable.fileChooserParent", this::getFileChooser);
        detailsTable.putClientProperty("JTable.fileNameColumnIndex", 0);
        Font font = this.list.getFont();
        detailsTable.setFont(font);
        DarkFilePaneUIBridge.AlignableTableHeaderRenderer headerRenderer = new DarkFilePaneUIBridge.AlignableTableHeaderRenderer(this, detailsTable.getTableHeader().getDefaultRenderer());
        detailsTable.getTableHeader().setDefaultRenderer(headerRenderer);
        DarkFilePaneUIBridge.DetailsTableCellRenderer cellRenderer = new DarkFilePaneUIBridge.DetailsTableCellRenderer(this, chooser);
        detailsTable.setDefaultRenderer(Object.class, cellRenderer);
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            detailsTable.setSelectionMode(2);
        } else {
            detailsTable.setSelectionMode(0);
        }
        detailsTable.addMouseListener(this.getMouseHandler());
        detailsTable.putClientProperty("Table.isFileList", Boolean.TRUE);
        if (this.listViewWindowsStyle) {
            detailsTable.addFocusListener(repaintListener);
        }
        ActionMap am = SwingUtilities.getUIActionMap(detailsTable);
        am.remove("selectNextRowCell");
        am.remove("selectPreviousRowCell");
        am.remove("selectNextColumnCell");
        am.remove("selectPreviousColumnCell");
        detailsTable.setFocusTraversalKeys(0, null);
        detailsTable.setFocusTraversalKeys(1, null);
        OverlayScrollPane overlayScrollPane = new OverlayScrollPane(detailsTable);
        JScrollPane scrollPane = overlayScrollPane.getScrollPane();
        scrollPane.setComponentOrientation(chooser.getComponentOrientation());
        LookAndFeel.installColors(scrollPane.getViewport(), "FileView.background", "FileView.foreground");
        LookAndFeel.installColors(detailsTable, "FileView.background", "FileView.foreground");
        scrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JScrollPane sp = (JScrollPane)e.getComponent();
                DarkFilePane.this.fixNameColumnWidth(sp.getViewport().getSize().width);
                sp.removeComponentListener(this);
            }
        });
        detailsTable.setForeground(this.list.getForeground());
        detailsTable.setBackground(this.list.getBackground());
        if (this.listViewBorder != null) {
            scrollPane.setBorder(this.listViewBorder);
        }
        p.add((Component)overlayScrollPane, "Center");
        this.detailsTableModel.fireTableStructureChanged();
        detailsTable.putClientProperty("AccessibleName", this.filesDetailsAccessibleName);
        return p;
    }

    @Override
    protected void cancelEdit() {
        if (this.editFile != null) {
            this.editFile = null;
            this.list.remove(this.editCell);
            this.list.putClientProperty("JList.isEditing", false);
            this.repaint();
        } else if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().cancelCellEditing();
        }
    }

    @Override
    protected void editFileName(int index) {
        JFileChooser chooser = this.getFileChooser();
        File currentDirectory = chooser.getCurrentDirectory();
        if (this.readOnly || !DarkFilePane.canWrite(currentDirectory, chooser)) {
            return;
        }
        this.ensureIndexIsVisible(index);
        switch (this.viewType) {
            case 0: {
                this.editFile = (File)this.getModel().getElementAt(this.getRowSorter().convertRowIndexToModel(index));
                Rectangle r = this.list.getCellBounds(index, index);
                if (this.editCell == null) {
                    this.editCell = new JTextField();
                    this.editCell.setName("Tree.cellEditor");
                    this.editCell.addActionListener(new DarkFilePaneUIBridge.EditActionListener(this));
                    this.editCell.addFocusListener(this.editorFocusListener);
                    this.editCell.setNextFocusableComponent(this.list);
                }
                this.list.add(this.editCell);
                this.editCell.setText(chooser.getName(this.editFile));
                ComponentOrientation orientation = this.list.getComponentOrientation();
                this.editCell.setComponentOrientation(orientation);
                Icon icon = chooser.getIcon(this.editFile);
                int editX = icon == null ? 20 : icon.getIconWidth() + 4;
                int gap = 0;
                ListCellRenderer renderer = this.list.getCellRenderer();
                if (renderer instanceof JLabel) {
                    gap = ((JLabel)((Object)renderer)).getIconTextGap() - 1;
                }
                if (orientation.isLeftToRight()) {
                    this.editCell.setBounds(editX + r.x + gap, r.y, r.width - editX - gap, r.height);
                } else {
                    this.editCell.setBounds(r.x, r.y, r.width - editX - gap, r.height);
                }
                this.list.putClientProperty("JList.isEditing", true);
                this.editCell.requestFocus();
                this.editCell.selectAll();
                break;
            }
            case 1: {
                this.detailsTable.editCellAt(index, 0);
            }
        }
    }

    @Override
    public JPopupMenu getComponentPopupMenu() {
        JPopupMenu popupMenu = this.getFileChooser().getComponentPopupMenu();
        if (popupMenu != null) {
            return popupMenu;
        }
        JMenu viewMenu = this.getViewMenu();
        if (this.contextMenu == null) {
            this.contextMenu = new JPopupMenu();
            if (viewMenu != null) {
                this.contextMenu.add(viewMenu);
                if (this.listViewWindowsStyle) {
                    this.contextMenu.addSeparator();
                }
            }
            ActionMap actionMap = this.getActionMap();
            Action refreshAction = actionMap.get("refresh");
            Action newFolderAction = actionMap.get("New Folder");
            Action renameAction = actionMap.get("editFileName");
            if (refreshAction != null) {
                this.contextMenu.add(refreshAction);
            }
            if (renameAction != null) {
                JMenuItem menuItem = new JMenuItem(renameAction);
                menuItem.setText("Rename");
                this.contextMenu.add(menuItem);
            }
            if (newFolderAction != null) {
                this.contextMenu.add(newFolderAction);
            }
        }
        if (viewMenu != null) {
            viewMenu.getPopupMenu().setInvoker(viewMenu);
        }
        return this.contextMenu;
    }

    @Override
    public JMenu getViewMenu() {
        if (this.viewMenu == null) {
            this.viewMenu = new JMenu(this.viewMenuLabelText);
            ButtonGroup viewButtonGroup = new ButtonGroup();
            for (int i = 0; i < 2; ++i) {
                JRadioButtonMenuItem mi = new JRadioButtonMenuItem(new DarkFilePaneUIBridge.ViewTypeAction(this, i));
                viewButtonGroup.add(mi);
                this.viewMenu.add(mi);
            }
            this.updateViewMenu();
        }
        return this.viewMenu;
    }

    @Override
    protected void updateViewMenu() {
        if (this.viewMenu != null) {
            Component[] comps;
            for (Component comp : comps = this.viewMenu.getMenuComponents()) {
                if (!(comp instanceof JRadioButtonMenuItem)) continue;
                JRadioButtonMenuItem mi = (JRadioButtonMenuItem)comp;
                if (((DarkFilePaneUIBridge.ViewTypeAction)mi.getAction()).viewType != this.viewType) continue;
                mi.setSelected(true);
            }
        }
    }

    @Override
    protected DarkFilePaneUIBridge.Handler getMouseHandler() {
        if (this.handler == null) {
            this.handler = new DarkHandler();
        }
        return this.handler;
    }

    public class DarkFileRenderer
    extends DarkListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component comp = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (comp instanceof JLabel) {
                File file = (File)value;
                String fileName = DarkFilePane.this.getFileChooser().getName(file);
                ((JLabel)comp).setText(fileName);
                Icon icon = DarkFilePane.this.getFileChooser().getIcon(file);
                if (icon != null) {
                    ((JLabel)comp).setIcon(icon);
                } else if (DarkFilePane.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                    ((JLabel)comp).setText(fileName + File.separator);
                }
            }
            return comp;
        }
    }

    protected class DarkHandler
    extends DarkFilePaneUIBridge.Handler {
        protected DarkHandler() {
            super(DarkFilePane.this);
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            int index;
            JComponent source = (JComponent)evt.getSource();
            if (source instanceof JList) {
                index = DarkFilePane.this.list.locationToIndex(evt.getPoint());
            } else if (source instanceof JTable) {
                JTable table = (JTable)source;
                Point p = evt.getPoint();
                index = table.rowAtPoint(p);
                boolean pointOutsidePrefSize = SwingUtilities2.pointOutsidePrefSize(table, index, table.columnAtPoint(p), p);
                if (pointOutsidePrefSize && !DarkFilePane.this.fullRowSelection) {
                    return;
                }
                if (index >= 0 && DarkFilePane.this.list != null && DarkFilePane.this.listSelectionModel.isSelectedIndex(index)) {
                    Rectangle r = DarkFilePane.this.list.getCellBounds(index, index);
                    MouseEvent newEvent = new MouseEvent(DarkFilePane.this.list, evt.getID(), evt.getWhen(), evt.getModifiersEx(), r.x + 1, r.y + r.height / 2, evt.getXOnScreen(), evt.getYOnScreen(), evt.getClickCount(), evt.isPopupTrigger(), evt.getButton());
                    SwingUtilities.convertMouseEvent(DarkFilePane.this.list, newEvent, DarkFilePane.this.list);
                    evt = newEvent;
                }
            } else {
                return;
            }
            if (index >= 0 && SwingUtilities.isLeftMouseButton(evt)) {
                JFileChooser fc = DarkFilePane.this.getFileChooser();
                if (evt.getClickCount() == 1 && source instanceof JList) {
                    if ((!fc.isMultiSelectionEnabled() || fc.getSelectedFiles().length <= 1) && DarkFilePane.this.listSelectionModel.isSelectedIndex(index) && DarkFilePane.this.getEditIndex() == index && DarkFilePane.this.editFile == null && DarkUIUtil.isOverText(evt, index, DarkFilePane.this.list)) {
                        DarkFilePane.this.editFileName(index);
                    } else {
                        DarkFilePane.this.setEditIndex(index);
                    }
                } else if (evt.getClickCount() == 2) {
                    DarkFilePane.this.resetEditIndex();
                }
            }
            if (this.getDoubleClickListener() != null) {
                DarkFilePane.this.list.putClientProperty("List.isFileList", false);
                this.getDoubleClickListener().mouseClicked(evt);
                DarkFilePane.this.list.putClientProperty("List.isFileList", true);
            }
        }
    }
}

