/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.filechooser;

import com.github.weisj.darklaf.ui.filechooser.MetalUIDefaults;
import com.github.weisj.darklaf.ui.list.DarkListCellRenderer;
import com.github.weisj.darklaf.ui.table.DarkTableCellEditor;
import com.github.weisj.darklaf.ui.table.DarkTableCellRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.DefaultKeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultListSelectionModel;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicDirectoryModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import sun.awt.shell.ShellFolder;
import sun.awt.shell.ShellFolderColumnInfo;

public abstract class DarkFilePaneUIBridge
extends JPanel
implements PropertyChangeListener {
    public static final String ACTION_APPROVE_SELECTION = "approveSelection";
    public static final String ACTION_CANCEL = "cancelSelection";
    public static final String ACTION_EDIT_FILE_NAME = "editFileName";
    public static final String ACTION_REFRESH = "refresh";
    public static final String ACTION_CHANGE_TO_PARENT_DIRECTORY = "Go Up";
    public static final String ACTION_NEW_FOLDER = "New Folder";
    public static final String ACTION_VIEW_LIST = "viewTypeList";
    public static final String ACTION_VIEW_DETAILS = "viewTypeDetails";
    public static final int VIEWTYPE_LIST = 0;
    public static final int VIEWTYPE_DETAILS = 1;
    protected static final int VIEWTYPE_COUNT = 2;
    protected static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    protected static final int COLUMN_FILENAME = 0;
    protected static final int COLUMN_SIZE = 1;
    protected static final FocusListener repaintListener = new FocusListener(){

        @Override
        public void focusGained(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        @Override
        public void focusLost(FocusEvent fe) {
            this.repaintSelection(fe.getSource());
        }

        protected void repaintSelection(Object source) {
            if (source instanceof JList) {
                this.repaintListSelection((JList)source);
            } else if (source instanceof JTable) {
                this.repaintTableSelection((JTable)source);
            }
        }

        protected void repaintListSelection(JList<?> list) {
            int[] indices;
            for (int i : indices = list.getSelectedIndices()) {
                Rectangle bounds = list.getCellBounds(i, i);
                list.repaint(bounds);
            }
        }

        protected void repaintTableSelection(JTable table) {
            int minRow = table.getSelectionModel().getMinSelectionIndex();
            int maxRow = table.getSelectionModel().getMaxSelectionIndex();
            if (minRow == -1 || maxRow == -1) {
                return;
            }
            int col0 = table.convertColumnIndexToView(0);
            Rectangle first = table.getCellRect(minRow, col0, false);
            Rectangle last = table.getCellRect(maxRow, col0, false);
            Rectangle dirty = first.union(last);
            table.repaint(dirty);
        }
    };
    protected Action[] actions;
    protected int viewType = -1;
    protected final JPanel[] viewPanels = new JPanel[2];
    protected JPanel currentViewPanel;
    protected String[] viewTypeActionNames;
    protected String filesListAccessibleName = null;
    protected String filesDetailsAccessibleName = null;
    protected JPopupMenu contextMenu;
    protected JMenu viewMenu;
    protected String viewMenuLabelText;
    protected String refreshActionLabelText;
    protected String newFolderActionLabelText;
    protected String kiloByteString;
    protected String megaByteString;
    protected String gigaByteString;
    protected String renameErrorTitleText;
    protected String renameErrorText;
    protected String renameErrorFileExistsText;
    protected final boolean smallIconsView = false;
    protected Border listViewBorder;
    protected Color listViewBackground;
    protected boolean listViewWindowsStyle;
    protected boolean readOnly;
    protected boolean fullRowSelection = true;
    protected ListSelectionModel listSelectionModel;
    protected JList<?> list;
    protected JTable detailsTable;
    protected File newFolderFile;
    protected final FileChooserUIAccessor fileChooserUIAccessor;
    protected DetailsTableModel detailsTableModel;
    protected DetailsTableRowSorter rowSorter;
    protected final KeyListener detailsKeyListener = new KeyAdapter(){
        protected final long timeFactor;
        protected final StringBuilder typedString = new StringBuilder();
        protected long lastTime = 1000L;
        {
            Long l = (Long)UIManager.get("Table.timeFactor");
            this.timeFactor = l != null ? l : 1000L;
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int index;
            BasicDirectoryModel model = DarkFilePaneUIBridge.this.getModel();
            int rowCount = model.getSize();
            if (DarkFilePaneUIBridge.this.detailsTable == null || rowCount == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                return;
            }
            InputMap inputMap = DarkFilePaneUIBridge.this.detailsTable.getInputMap(1);
            KeyStroke key = KeyStroke.getKeyStrokeForEvent(e);
            if (inputMap != null && inputMap.get(key) != null) {
                return;
            }
            int startIndex = DarkFilePaneUIBridge.this.detailsTable.getSelectionModel().getLeadSelectionIndex();
            if (startIndex < 0) {
                startIndex = 0;
            }
            if (startIndex >= rowCount) {
                startIndex = rowCount - 1;
            }
            char c = e.getKeyChar();
            long time = e.getWhen();
            if (time - this.lastTime < this.timeFactor) {
                if (this.typedString.length() == 1 && this.typedString.charAt(0) == c) {
                    ++startIndex;
                } else {
                    this.typedString.append(c);
                }
            } else {
                ++startIndex;
                this.typedString.setLength(0);
                this.typedString.append(c);
            }
            this.lastTime = time;
            if (startIndex >= rowCount) {
                startIndex = 0;
            }
            if ((index = this.getNextMatch(startIndex, rowCount - 1)) < 0 && startIndex > 0) {
                index = this.getNextMatch(0, startIndex - 1);
            }
            if (index >= 0) {
                DarkFilePaneUIBridge.this.detailsTable.getSelectionModel().setSelectionInterval(index, index);
                Rectangle cellRect = DarkFilePaneUIBridge.this.detailsTable.getCellRect(index, DarkFilePaneUIBridge.this.detailsTable.convertColumnIndexToView(0), false);
                DarkFilePaneUIBridge.this.detailsTable.scrollRectToVisible(cellRect);
            }
        }

        protected int getNextMatch(int startIndex, int finishIndex) {
            BasicDirectoryModel model = DarkFilePaneUIBridge.this.getModel();
            JFileChooser fileChooser = DarkFilePaneUIBridge.this.getFileChooser();
            DetailsTableRowSorter rowSorter = DarkFilePaneUIBridge.this.getRowSorter();
            String prefix = this.typedString.toString().toLowerCase();
            for (int index = startIndex; index <= finishIndex; ++index) {
                File file = (File)model.getElementAt(rowSorter.convertRowIndexToModel(index));
                String fileName = fileChooser.getName(file).toLowerCase();
                if (!fileName.startsWith(prefix)) continue;
                return index;
            }
            return -1;
        }
    };
    protected DetailsTableCellEditor tableCellEditor;
    protected Action newFolderAction;
    protected Handler handler;
    int lastIndex = -1;
    File editFile = null;
    JTextField editCell = null;
    protected final FocusListener editorFocusListener = new FocusAdapter(){

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                DarkFilePaneUIBridge.this.applyEdit();
            }
        }
    };

    public DarkFilePaneUIBridge(FileChooserUIAccessor fileChooserUIAccessor) {
        super(new BorderLayout());
        this.fileChooserUIAccessor = fileChooserUIAccessor;
        this.installDefaults();
        this.createActionMap();
    }

    protected static void recursivelySetInheritsPopupMenu(Container container, boolean b) {
        if (container instanceof JComponent) {
            ((JComponent)container).setInheritsPopupMenu(b);
        }
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            DarkFilePaneUIBridge.recursivelySetInheritsPopupMenu((Container)container.getComponent(i), b);
        }
    }

    public static void addActionsToMap(ActionMap map, Action[] actions) {
        if (map != null && actions != null) {
            for (Action a : actions) {
                String cmd = (String)a.getValue("ActionCommandKey");
                if (cmd == null) {
                    cmd = (String)a.getValue("Name");
                }
                map.put(cmd, a);
            }
        }
    }

    public static boolean canWrite(File f, JFileChooser chooser) {
        if (!f.exists()) {
            return false;
        }
        try {
            if (f instanceof ShellFolder) {
                return f.canWrite();
            }
            if (DarkFilePaneUIBridge.usesShellFolder(chooser)) {
                try {
                    return ShellFolder.getShellFolder(f).canWrite();
                }
                catch (FileNotFoundException ex) {
                    return false;
                }
            }
            return f.canWrite();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static boolean usesShellFolder(JFileChooser chooser) {
        Boolean prop = (Boolean)chooser.getClientProperty("FileChooser.useShellFolder");
        return prop == null ? chooser.getFileSystemView().equals(FileSystemView.getFileSystemView()) : prop.booleanValue();
    }

    public void uninstallUI() {
        if (this.getModel() != null) {
            this.getModel().removePropertyChangeListener(this);
        }
    }

    protected BasicDirectoryModel getModel() {
        return this.fileChooserUIAccessor.getModel();
    }

    public int getViewType() {
        return this.viewType;
    }

    public void setViewType(int viewType) {
        if (viewType == this.viewType) {
            return;
        }
        int oldValue = this.viewType;
        this.viewType = viewType;
        JPanel createdViewPanel = null;
        JComponent newFocusOwner = null;
        switch (viewType) {
            case 0: {
                if (this.viewPanels[viewType] == null) {
                    createdViewPanel = this.fileChooserUIAccessor.createList();
                    if (createdViewPanel == null) {
                        createdViewPanel = this.createList();
                    }
                    this.list = this.findChildComponent(createdViewPanel, JList.class);
                    if (this.listSelectionModel == null) {
                        this.listSelectionModel = this.list.getSelectionModel();
                        if (this.detailsTable != null) {
                            this.detailsTable.setSelectionModel(this.listSelectionModel);
                        }
                    } else {
                        this.list.setSelectionModel(this.listSelectionModel);
                    }
                }
                this.list.setLayoutOrientation(1);
                newFocusOwner = this.list;
                break;
            }
            case 1: {
                if (this.viewPanels[viewType] == null) {
                    createdViewPanel = this.fileChooserUIAccessor.createDetailsView();
                    if (createdViewPanel == null) {
                        createdViewPanel = this.createDetailsView();
                    }
                    this.detailsTable = this.findChildComponent(createdViewPanel, JTable.class);
                    if (this.listSelectionModel != null) {
                        this.detailsTable.setSelectionModel(this.listSelectionModel);
                    }
                }
                newFocusOwner = this.detailsTable;
            }
        }
        if (createdViewPanel != null) {
            this.viewPanels[viewType] = createdViewPanel;
            DarkFilePaneUIBridge.recursivelySetInheritsPopupMenu(createdViewPanel, true);
        }
        boolean isFocusOwner = false;
        if (this.currentViewPanel != null) {
            Component owner = DefaultKeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
            isFocusOwner = owner == this.detailsTable || owner == this.list;
            this.remove(this.currentViewPanel);
        }
        this.currentViewPanel = this.viewPanels[viewType];
        this.add((Component)this.currentViewPanel, "Center");
        if (isFocusOwner && newFocusOwner != null) {
            ((Component)newFocusOwner).requestFocusInWindow();
        }
        this.revalidate();
        this.repaint();
        this.updateViewMenu();
        this.firePropertyChange("viewType", oldValue, viewType);
    }

    public Action getViewTypeAction(int viewType) {
        return new ViewTypeAction(viewType);
    }

    protected void installDefaults() {
        Locale l = this.getFileChooser().getLocale();
        this.listViewBorder = UIManager.getBorder("FileChooser.listViewBorder");
        this.listViewBackground = UIManager.getColor("FileChooser.listViewBackground");
        this.listViewWindowsStyle = UIManager.getBoolean("FileChooser.listViewWindowsStyle");
        this.readOnly = UIManager.getBoolean("FileChooser.readOnly");
        UIDefaults metal = MetalUIDefaults.get();
        this.viewMenuLabelText = metal.getString("FileChooser.viewMenuLabelText", l);
        this.refreshActionLabelText = metal.getString("FileChooser.refreshActionLabelText", l);
        this.newFolderActionLabelText = metal.getString("FileChooser.newFolderActionLabelText", l);
        this.viewTypeActionNames = new String[2];
        this.viewTypeActionNames[0] = metal.getString("FileChooser.listViewActionLabelText", l);
        this.viewTypeActionNames[1] = metal.getString("FileChooser.detailsViewActionLabelText", l);
        this.kiloByteString = UIManager.getString((Object)"FileChooser.fileSizeKiloBytes", l);
        this.megaByteString = UIManager.getString((Object)"FileChooser.fileSizeMegaBytes", l);
        this.gigaByteString = UIManager.getString((Object)"FileChooser.fileSizeGigaBytes", l);
        this.fullRowSelection = UIManager.getBoolean("FileView.fullRowSelection");
        this.filesListAccessibleName = UIManager.getString((Object)"FileChooser.filesListAccessibleName", l);
        this.filesDetailsAccessibleName = UIManager.getString((Object)"FileChooser.filesDetailsAccessibleName", l);
        this.renameErrorTitleText = UIManager.getString((Object)"FileChooser.renameErrorTitleText", l);
        this.renameErrorText = UIManager.getString((Object)"FileChooser.renameErrorText", l);
        this.renameErrorFileExistsText = UIManager.getString((Object)"FileChooser.renameErrorFileExistsText", l);
    }

    public Action[] getActions() {
        if (this.actions == null) {
            ArrayList<Action> actionList = new ArrayList<Action>(8);
            class FilePaneAction
            extends AbstractAction {
                FilePaneAction(String name) {
                    this(name, name);
                }

                FilePaneAction(String name, String cmd) {
                    super(name);
                    this.putValue("ActionCommandKey", cmd);
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    String cmd = (String)this.getValue("ActionCommandKey");
                    if (Objects.equals(cmd, DarkFilePaneUIBridge.ACTION_CANCEL)) {
                        if (DarkFilePaneUIBridge.this.editFile != null) {
                            DarkFilePaneUIBridge.this.cancelEdit();
                        } else {
                            DarkFilePaneUIBridge.this.getFileChooser().cancelSelection();
                        }
                    } else if (Objects.equals(cmd, DarkFilePaneUIBridge.ACTION_EDIT_FILE_NAME)) {
                        JFileChooser fc = DarkFilePaneUIBridge.this.getFileChooser();
                        int index = DarkFilePaneUIBridge.this.listSelectionModel.getMinSelectionIndex();
                        if (!(index < 0 || DarkFilePaneUIBridge.this.editFile != null || fc.isMultiSelectionEnabled() && fc.getSelectedFiles().length > 1)) {
                            DarkFilePaneUIBridge.this.editFileName(index);
                        }
                    } else if (Objects.equals(cmd, DarkFilePaneUIBridge.ACTION_REFRESH)) {
                        DarkFilePaneUIBridge.this.getFileChooser().rescanCurrentDirectory();
                    }
                }

                @Override
                public boolean isEnabled() {
                    String cmd = (String)this.getValue("ActionCommandKey");
                    if (Objects.equals(cmd, DarkFilePaneUIBridge.ACTION_CANCEL)) {
                        return DarkFilePaneUIBridge.this.getFileChooser().isEnabled();
                    }
                    if (Objects.equals(cmd, DarkFilePaneUIBridge.ACTION_EDIT_FILE_NAME)) {
                        return !DarkFilePaneUIBridge.this.readOnly && DarkFilePaneUIBridge.this.getFileChooser().isEnabled();
                    }
                    return true;
                }
            }
            actionList.add(new FilePaneAction(ACTION_CANCEL));
            actionList.add(new FilePaneAction(ACTION_EDIT_FILE_NAME));
            actionList.add(new FilePaneAction(this.refreshActionLabelText, ACTION_REFRESH));
            Action action = this.fileChooserUIAccessor.getApproveSelectionAction();
            if (action != null) {
                actionList.add(action);
            }
            if ((action = this.fileChooserUIAccessor.getChangeToParentDirectoryAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getNewFolderAction()) != null) {
                actionList.add(action);
            }
            if ((action = this.getViewTypeAction(0)) != null) {
                actionList.add(action);
            }
            if ((action = this.getViewTypeAction(1)) != null) {
                actionList.add(action);
            }
            this.actions = actionList.toArray(new Action[0]);
        }
        return Arrays.copyOf(this.actions, this.actions.length);
    }

    protected void createActionMap() {
        DarkFilePaneUIBridge.addActionsToMap(super.getActionMap(), this.getActions());
    }

    protected void updateListRowCount(JList<?> list) {
        list.setVisibleRowCount(-1);
    }

    public abstract JPanel createList();

    protected DetailsTableModel getDetailsTableModel() {
        if (this.detailsTableModel == null) {
            this.detailsTableModel = new DetailsTableModel(this.getFileChooser());
        }
        return this.detailsTableModel;
    }

    protected void updateDetailsColumnModel(JTable table) {
        if (table != null) {
            ShellFolderColumnInfo[] columns = this.detailsTableModel.getColumns();
            DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
            for (int i = 0; i < columns.length; ++i) {
                String uiTitle;
                ShellFolderColumnInfo dataItem = columns[i];
                TableColumn column = new TableColumn(i);
                String title = dataItem.getTitle();
                if (title != null && title.startsWith("FileChooser.") && title.endsWith("HeaderText") && (uiTitle = MetalUIDefaults.get().getString(title, table.getLocale())) != null) {
                    title = uiTitle;
                }
                column.setHeaderValue(title);
                Integer width = dataItem.getWidth();
                if (width != null) {
                    column.setPreferredWidth(width);
                }
                columnModel.addColumn(column);
            }
            if (!this.readOnly && columnModel.getColumnCount() > 0) {
                columnModel.getColumn(0).setCellEditor(this.getDetailsTableCellEditor());
            }
            table.setColumnModel(columnModel);
            table.getColumnModel().setColumnMargin(0);
        }
    }

    protected DetailsTableCellEditor getDetailsTableCellEditor() {
        if (this.tableCellEditor == null) {
            this.tableCellEditor = new DetailsTableCellEditor(new JTextField(){

                @Override
                public void setBorder(Border border) {
                }
            });
        }
        return this.tableCellEditor;
    }

    public abstract JPanel createDetailsView();

    protected void fixNameColumnWidth(int viewWidth) {
        TableColumn nameCol = this.detailsTable.getColumnModel().getColumn(0);
        int tableWidth = this.detailsTable.getPreferredSize().width;
        if (tableWidth < viewWidth) {
            nameCol.setPreferredWidth(nameCol.getPreferredWidth() + viewWidth - tableWidth);
        }
    }

    public ListSelectionListener createListSelectionListener() {
        return this.fileChooserUIAccessor.createListSelectionListener();
    }

    protected int getEditIndex() {
        return this.lastIndex;
    }

    protected void setEditIndex(int i) {
        this.lastIndex = i;
    }

    protected void resetEditIndex() {
        this.lastIndex = -1;
    }

    protected abstract void cancelEdit();

    protected abstract void editFileName(int var1);

    protected void applyEdit() {
        if (this.editFile != null && this.editFile.exists()) {
            JFileChooser chooser = this.getFileChooser();
            String oldDisplayName = chooser.getName(this.editFile);
            String oldFileName = this.editFile.getName();
            String newDisplayName = this.editCell.getText().trim();
            if (!newDisplayName.equals(oldDisplayName)) {
                FileSystemView fsv;
                File f2;
                int i2;
                String newFileName = newDisplayName;
                int i1 = oldFileName.length();
                if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                    newFileName = newDisplayName + oldFileName.substring(i2);
                }
                if ((f2 = (fsv = chooser.getFileSystemView()).createFileObject(this.editFile.getParentFile(), newFileName)).exists()) {
                    JOptionPane.showMessageDialog(chooser, MessageFormat.format(this.renameErrorFileExistsText, oldFileName), this.renameErrorTitleText, 0);
                } else if (this.getModel().renameFile(this.editFile, f2)) {
                    if (fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                        if (chooser.isMultiSelectionEnabled()) {
                            chooser.setSelectedFiles(new File[]{f2});
                        } else {
                            chooser.setSelectedFile(f2);
                        }
                    }
                } else {
                    JOptionPane.showMessageDialog(chooser, MessageFormat.format(this.renameErrorText, oldFileName), this.renameErrorTitleText, 0);
                }
            }
        }
        if (this.detailsTable != null && this.detailsTable.isEditing()) {
            this.detailsTable.getCellEditor().stopCellEditing();
        }
        this.cancelEdit();
    }

    public Action getNewFolderAction() {
        if (!this.readOnly && this.newFolderAction == null) {
            this.newFolderAction = new AbstractAction(this.newFolderActionLabelText){
                protected Action basicNewFolderAction;
                {
                    this.putValue("ActionCommandKey", DarkFilePaneUIBridge.ACTION_NEW_FOLDER);
                    File currentDirectory = DarkFilePaneUIBridge.this.getFileChooser().getCurrentDirectory();
                    if (currentDirectory != null) {
                        this.setEnabled(DarkFilePaneUIBridge.canWrite(currentDirectory, DarkFilePaneUIBridge.this.getFileChooser()));
                    }
                }

                @Override
                public void actionPerformed(ActionEvent ev) {
                    if (this.basicNewFolderAction == null) {
                        this.basicNewFolderAction = DarkFilePaneUIBridge.this.fileChooserUIAccessor.getNewFolderAction();
                    }
                    JFileChooser fc = DarkFilePaneUIBridge.this.getFileChooser();
                    File oldFile = fc.getSelectedFile();
                    this.basicNewFolderAction.actionPerformed(ev);
                    File newFile = fc.getSelectedFile();
                    if (newFile != null && !newFile.equals(oldFile) && newFile.isDirectory()) {
                        DarkFilePaneUIBridge.this.newFolderFile = newFile;
                    }
                }
            };
        }
        return this.newFolderAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFileSelected() {
        if (this.getFileChooser().isMultiSelectionEnabled() && !this.isDirectorySelected()) {
            Object[] files = this.getFileChooser().getSelectedFiles();
            Object[] selectedObjects = this.list.getSelectedValues();
            this.listSelectionModel.setValueIsAdjusting(true);
            try {
                int lead = this.listSelectionModel.getLeadSelectionIndex();
                int anchor = this.listSelectionModel.getAnchorSelectionIndex();
                Arrays.sort(files);
                Arrays.sort(selectedObjects);
                int shouldIndex = 0;
                int actuallyIndex = 0;
                while (shouldIndex < files.length && actuallyIndex < selectedObjects.length) {
                    int comparison = ((File)files[shouldIndex]).compareTo((File)selectedObjects[actuallyIndex]);
                    if (comparison < 0) {
                        this.doSelectFile((File)files[shouldIndex++]);
                        continue;
                    }
                    if (comparison > 0) {
                        this.doDeselectFile(selectedObjects[actuallyIndex++]);
                        continue;
                    }
                    ++shouldIndex;
                    ++actuallyIndex;
                }
                while (shouldIndex < files.length) {
                    this.doSelectFile((File)files[shouldIndex++]);
                }
                while (actuallyIndex < selectedObjects.length) {
                    this.doDeselectFile(selectedObjects[actuallyIndex++]);
                }
                if (!(this.listSelectionModel instanceof DefaultListSelectionModel)) return;
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(lead);
                this.listSelectionModel.setAnchorSelectionIndex(anchor);
                return;
            }
            finally {
                this.listSelectionModel.setValueIsAdjusting(false);
            }
        } else {
            int i;
            JFileChooser chooser = this.getFileChooser();
            File f = this.isDirectorySelected() ? this.getDirectory() : chooser.getSelectedFile();
            if (f != null && (i = this.getModel().indexOf(f)) >= 0) {
                int viewIndex = this.getRowSorter().convertRowIndexToView(i);
                this.listSelectionModel.setSelectionInterval(viewIndex, viewIndex);
                this.ensureIndexIsVisible(viewIndex);
                return;
            } else {
                this.clearSelection();
            }
        }
    }

    protected void doSelectFile(File fileToSelect) {
        int index = this.getModel().indexOf(fileToSelect);
        if (index >= 0) {
            index = this.getRowSorter().convertRowIndexToView(index);
            this.listSelectionModel.addSelectionInterval(index, index);
        }
    }

    protected void doDeselectFile(Object fileToDeselect) {
        int index = this.getRowSorter().convertRowIndexToView(this.getModel().indexOf(fileToDeselect));
        this.listSelectionModel.removeSelectionInterval(index, index);
    }

    protected void doSelectedFileChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File f = (File)e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (f != null && (fc.isFileSelectionEnabled() && !f.isDirectory() || f.isDirectory() && fc.isDirectorySelectionEnabled())) {
            this.setFileSelected();
        }
    }

    protected void doSelectedFilesChanged(PropertyChangeEvent e) {
        this.applyEdit();
        File[] files = (File[])e.getNewValue();
        JFileChooser fc = this.getFileChooser();
        if (files != null && files.length > 0 && (files.length > 1 || fc.isDirectorySelectionEnabled() || !files[0].isDirectory())) {
            this.setFileSelected();
        }
    }

    protected void doDirectoryChanged(PropertyChangeEvent e) {
        this.getDetailsTableModel().updateColumnInfo();
        JFileChooser fc = this.getFileChooser();
        FileSystemView fsv = fc.getFileSystemView();
        this.applyEdit();
        this.resetEditIndex();
        this.ensureIndexIsVisible(0);
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            if (!this.readOnly) {
                this.getNewFolderAction().setEnabled(DarkFilePaneUIBridge.canWrite(currentDirectory, this.getFileChooser()));
            }
            this.fileChooserUIAccessor.getChangeToParentDirectoryAction().setEnabled(!fsv.isRoot(currentDirectory));
        }
        if (this.list != null) {
            this.list.clearSelection();
        }
    }

    protected void doFilterChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    protected void doFileSelectionModeChanged(PropertyChangeEvent e) {
        this.applyEdit();
        this.resetEditIndex();
        this.clearSelection();
    }

    protected void doMultiSelectionChanged(PropertyChangeEvent e) {
        if (this.getFileChooser().isMultiSelectionEnabled()) {
            this.listSelectionModel.setSelectionMode(2);
        } else {
            this.listSelectionModel.setSelectionMode(0);
            this.clearSelection();
            this.getFileChooser().setSelectedFiles(null);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String s;
        if (this.viewType == -1) {
            this.setViewType(0);
        }
        switch (s = e.getPropertyName()) {
            case "SelectedFileChangedProperty": {
                this.doSelectedFileChanged(e);
                break;
            }
            case "SelectedFilesChangedProperty": {
                this.doSelectedFilesChanged(e);
                break;
            }
            case "directoryChanged": {
                this.doDirectoryChanged(e);
                break;
            }
            case "fileFilterChanged": {
                this.doFilterChanged(e);
                break;
            }
            case "fileSelectionChanged": {
                this.doFileSelectionModeChanged(e);
                break;
            }
            case "MultiSelectionEnabledChangedProperty": {
                this.doMultiSelectionChanged(e);
                break;
            }
            case "CancelSelection": {
                this.applyEdit();
                break;
            }
            case "busy": {
                this.setCursor((Boolean)e.getNewValue() != false ? waitCursor : null);
                break;
            }
            case "componentOrientation": {
                ComponentOrientation o = (ComponentOrientation)e.getNewValue();
                JFileChooser cc = (JFileChooser)e.getSource();
                if (o != e.getOldValue()) {
                    cc.applyComponentOrientation(o);
                }
                if (this.detailsTable == null) break;
                this.detailsTable.setComponentOrientation(o);
                this.detailsTable.getParent().getParent().setComponentOrientation(o);
            }
        }
    }

    public void ensureFileIsVisible(JFileChooser fc, File f) {
        int modelIndex = this.getModel().indexOf(f);
        if (modelIndex >= 0) {
            this.ensureIndexIsVisible(this.getRowSorter().convertRowIndexToView(modelIndex));
        }
    }

    protected void ensureIndexIsVisible(int i) {
        if (i >= 0) {
            if (this.list != null) {
                this.list.ensureIndexIsVisible(i);
            }
            if (this.detailsTable != null) {
                this.detailsTable.scrollRectToVisible(this.detailsTable.getCellRect(i, 0, true));
            }
        }
    }

    protected DetailsTableRowSorter getRowSorter() {
        if (this.rowSorter == null) {
            this.rowSorter = new DetailsTableRowSorter();
        }
        return this.rowSorter;
    }

    public void rescanCurrentDirectory() {
        this.getModel().validateFileCache();
    }

    public void clearSelection() {
        if (this.listSelectionModel != null) {
            this.listSelectionModel.clearSelection();
            if (this.listSelectionModel instanceof DefaultListSelectionModel) {
                ((DefaultListSelectionModel)this.listSelectionModel).moveLeadSelectionIndex(-1);
                this.listSelectionModel.setAnchorSelectionIndex(-1);
            }
        }
    }

    @Override
    public abstract JPopupMenu getComponentPopupMenu();

    protected JFileChooser getFileChooser() {
        return this.fileChooserUIAccessor.getFileChooser();
    }

    public abstract JMenu getViewMenu();

    protected abstract void updateViewMenu();

    protected abstract Handler getMouseHandler();

    protected boolean isDirectorySelected() {
        return this.fileChooserUIAccessor.isDirectorySelected();
    }

    protected File getDirectory() {
        return this.fileChooserUIAccessor.getDirectory();
    }

    protected <T> T findChildComponent(Container container, Class<T> cls) {
        int n = container.getComponentCount();
        for (int i = 0; i < n; ++i) {
            T c;
            Component comp = container.getComponent(i);
            if (cls.isInstance(comp)) {
                return cls.cast(comp);
            }
            if (!(comp instanceof Container) || (c = this.findChildComponent((Container)comp, cls)) == null) continue;
            return c;
        }
        return null;
    }

    protected abstract class Handler
    implements MouseListener {
        protected MouseListener doubleClickListener;

        protected Handler() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mousePressed(evt);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseReleased(evt);
            }
        }

        @Override
        public void mouseEntered(MouseEvent evt) {
            JComponent source = (JComponent)evt.getSource();
            if (source instanceof JTable) {
                boolean dragEnabled;
                TransferHandler th2;
                JTable table = (JTable)evt.getSource();
                TransferHandler th1 = DarkFilePaneUIBridge.this.getFileChooser().getTransferHandler();
                if (th1 != (th2 = table.getTransferHandler())) {
                    table.setTransferHandler(th1);
                }
                if ((dragEnabled = DarkFilePaneUIBridge.this.getFileChooser().getDragEnabled()) != table.getDragEnabled()) {
                    table.setDragEnabled(dragEnabled);
                }
            } else if (source instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseEntered(evt);
            }
        }

        @Override
        public void mouseExited(MouseEvent evt) {
            if (evt.getSource() instanceof JList && this.getDoubleClickListener() != null) {
                this.getDoubleClickListener().mouseExited(evt);
            }
        }

        protected MouseListener getDoubleClickListener() {
            if (this.doubleClickListener == null && DarkFilePaneUIBridge.this.list != null) {
                this.doubleClickListener = DarkFilePaneUIBridge.this.fileChooserUIAccessor.createDoubleClickListener(DarkFilePaneUIBridge.this.list);
            }
            return this.doubleClickListener;
        }
    }

    protected class FileRenderer
    extends DarkListCellRenderer {
        protected FileRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (DarkFilePaneUIBridge.this.listViewWindowsStyle && !list.isFocusOwner()) {
                isSelected = false;
            }
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            File file = (File)value;
            String fileName = DarkFilePaneUIBridge.this.getFileChooser().getName(file);
            this.setText(fileName);
            this.setFont(list.getFont());
            Icon icon = DarkFilePaneUIBridge.this.getFileChooser().getIcon(file);
            if (icon != null) {
                this.setIcon(icon);
            } else if (DarkFilePaneUIBridge.this.getFileChooser().getFileSystemView().isTraversable(file).booleanValue()) {
                this.setText(fileName + File.separator);
            }
            return this;
        }
    }

    class EditActionListener
    implements ActionListener {
        EditActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarkFilePaneUIBridge.this.applyEdit();
        }
    }

    protected class DelayedSelectionUpdater
    implements Runnable {
        File editFile;

        DelayedSelectionUpdater() {
            this(null);
        }

        DelayedSelectionUpdater(File editFile) {
            this.editFile = editFile;
            if (DarkFilePaneUIBridge.this.isShowing()) {
                SwingUtilities.invokeLater(this);
            }
        }

        @Override
        public void run() {
            DarkFilePaneUIBridge.this.setFileSelected();
            if (this.editFile != null) {
                DarkFilePaneUIBridge.this.editFileName(DarkFilePaneUIBridge.this.getRowSorter().convertRowIndexToView(DarkFilePaneUIBridge.this.getModel().indexOf(this.editFile)));
                this.editFile = null;
            }
        }
    }

    protected class AlignableTableHeaderRenderer
    implements TableCellRenderer {
        final TableCellRenderer wrappedRenderer;

        public AlignableTableHeaderRenderer(TableCellRenderer wrappedRenderer) {
            this.wrappedRenderer = wrappedRenderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = this.wrappedRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int modelColumn = table.convertColumnIndexToModel(column);
            ShellFolderColumnInfo columnInfo = DarkFilePaneUIBridge.this.detailsTableModel.getColumns()[modelColumn];
            Integer alignment = columnInfo.getAlignment();
            if (alignment == null) {
                alignment = 0;
            }
            if (c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(alignment);
            }
            return c;
        }
    }

    public class DetailsTableCellRenderer
    extends DarkTableCellRenderer {
        final JFileChooser chooser;
        final DateFormat df;

        public DetailsTableCellRenderer(JFileChooser chooser) {
            this.chooser = chooser;
            this.df = DateFormat.getDateTimeInstance(3, 3, chooser.getLocale());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String text;
            if ((table.convertColumnIndexToModel(column) != 0 || DarkFilePaneUIBridge.this.listViewWindowsStyle && !table.isFocusOwner()) && !DarkFilePaneUIBridge.this.fullRowSelection) {
                isSelected = false;
            }
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setIcon(null);
            int modelColumn = table.convertColumnIndexToModel(column);
            ShellFolderColumnInfo columnInfo = DarkFilePaneUIBridge.this.detailsTableModel.getColumns()[modelColumn];
            Integer alignment = columnInfo.getAlignment();
            if (alignment == null) {
                alignment = value instanceof Number ? 4 : 10;
            }
            this.setHorizontalAlignment(alignment);
            if (value == null) {
                text = "";
            } else if (value instanceof File) {
                File file = (File)value;
                text = this.chooser.getName(file);
                Icon icon = this.chooser.getIcon(file);
                this.setIcon(icon);
            } else if (value instanceof Long) {
                long len = (Long)value / 1024L;
                text = DarkFilePaneUIBridge.this.listViewWindowsStyle ? MessageFormat.format(DarkFilePaneUIBridge.this.kiloByteString, len + 1L) : (len < 1024L ? MessageFormat.format(DarkFilePaneUIBridge.this.kiloByteString, len == 0L ? 1L : len) : ((len /= 1024L) < 1024L ? MessageFormat.format(DarkFilePaneUIBridge.this.megaByteString, len) : MessageFormat.format(DarkFilePaneUIBridge.this.gigaByteString, len /= 1024L)));
            } else {
                text = value instanceof Date ? this.df.format((Date)value) : value.toString();
            }
            this.setText(text);
            return this;
        }
    }

    protected class DetailsTableCellEditor
    extends DarkTableCellEditor {
        public DetailsTableCellEditor(JTextField tf) {
            super(tf);
            tf.addFocusListener(DarkFilePaneUIBridge.this.editorFocusListener);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Component comp = super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof File) {
                this.delegate.setValue(DarkFilePaneUIBridge.this.getFileChooser().getName((File)value));
            }
            if (this.editorComponent instanceof JTextField) {
                SwingUtilities.invokeLater(() -> {
                    ((JTextField)this.editorComponent).selectAll();
                    this.editorComponent.requestFocus();
                });
            }
            return comp;
        }
    }

    protected class DirectoriesFirstComparatorWrapper
    implements Comparator<File> {
        protected final Comparator<Object> comparator;
        protected final int column;

        public DirectoriesFirstComparatorWrapper(int column, Comparator<?> comparator) {
            this.column = column;
            this.comparator = comparator;
        }

        @Override
        public int compare(File f1, File f2) {
            if (f1 != null && f2 != null) {
                boolean traversable1 = DarkFilePaneUIBridge.this.getFileChooser().isTraversable(f1);
                boolean traversable2 = DarkFilePaneUIBridge.this.getFileChooser().isTraversable(f2);
                if (traversable1 && !traversable2) {
                    return -1;
                }
                if (!traversable1 && traversable2) {
                    return 1;
                }
            }
            if (DarkFilePaneUIBridge.this.detailsTableModel.getColumns()[this.column].isCompareByColumn()) {
                return this.comparator.compare(DarkFilePaneUIBridge.this.getDetailsTableModel().getFileColumnValue(f1, this.column), DarkFilePaneUIBridge.this.getDetailsTableModel().getFileColumnValue(f2, this.column));
            }
            return this.comparator.compare(f1, f2);
        }
    }

    protected class DetailsTableRowSorter
    extends TableRowSorter<TableModel> {
        public DetailsTableRowSorter() {
            SorterModelWrapper modelWrapper = new SorterModelWrapper();
            this.setModelWrapper(modelWrapper);
            modelWrapper.getModel().addTableModelListener(e -> this.modelStructureChanged());
        }

        public void updateComparators(ShellFolderColumnInfo[] columns) {
            for (int i = 0; i < columns.length; ++i) {
                DirectoriesFirstComparatorWrapper c = columns[i].getComparator();
                if (c != null) {
                    c = new DirectoriesFirstComparatorWrapper(i, c);
                }
                this.setComparator(i, c);
            }
        }

        @Override
        public void sort() {
            ShellFolder.invoke(() -> {
                DetailsTableRowSorter.super.sort();
                return null;
            });
        }

        @Override
        public void modelStructureChanged() {
            super.modelStructureChanged();
            this.updateComparators(DarkFilePaneUIBridge.this.detailsTableModel.getColumns());
        }

        protected class SorterModelWrapper
        extends DefaultRowSorter.ModelWrapper<TableModel, Integer> {
            protected SorterModelWrapper() {
            }

            @Override
            public TableModel getModel() {
                return DarkFilePaneUIBridge.this.getDetailsTableModel();
            }

            @Override
            public int getColumnCount() {
                return DarkFilePaneUIBridge.this.getDetailsTableModel().getColumnCount();
            }

            @Override
            public int getRowCount() {
                return DarkFilePaneUIBridge.this.getDetailsTableModel().getRowCount();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return DarkFilePaneUIBridge.this.getModel().getElementAt(row);
            }

            @Override
            public Integer getIdentifier(int row) {
                return row;
            }
        }
    }

    class DetailsTableModel
    extends AbstractTableModel
    implements ListDataListener {
        final JFileChooser chooser;
        final BasicDirectoryModel directoryModel;
        ShellFolderColumnInfo[] columns;
        int[] columnMap;

        DetailsTableModel(JFileChooser fc) {
            this.chooser = fc;
            this.directoryModel = DarkFilePaneUIBridge.this.getModel();
            this.directoryModel.addListDataListener(this);
            this.updateColumnInfo();
        }

        void updateColumnInfo() {
            File dir = this.chooser.getCurrentDirectory();
            if (dir != null && DarkFilePaneUIBridge.usesShellFolder(this.chooser)) {
                try {
                    dir = ShellFolder.getShellFolder(dir);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            ShellFolderColumnInfo[] allColumns = ShellFolder.getFolderColumns(dir);
            ArrayList<ShellFolderColumnInfo> visibleColumns = new ArrayList<ShellFolderColumnInfo>();
            this.columnMap = new int[allColumns.length];
            for (int i = 0; i < allColumns.length; ++i) {
                ShellFolderColumnInfo column = allColumns[i];
                if (!column.isVisible()) continue;
                this.columnMap[visibleColumns.size()] = i;
                visibleColumns.add(column);
            }
            this.columns = new ShellFolderColumnInfo[visibleColumns.size()];
            visibleColumns.toArray(this.columns);
            this.columnMap = Arrays.copyOf(this.columnMap, this.columns.length);
            List<RowSorter.SortKey> sortKeys = DarkFilePaneUIBridge.this.rowSorter == null ? null : DarkFilePaneUIBridge.this.rowSorter.getSortKeys();
            this.fireTableStructureChanged();
            this.restoreSortKeys(sortKeys);
        }

        protected void restoreSortKeys(List<? extends RowSorter.SortKey> sortKeys) {
            if (sortKeys != null) {
                for (int i = 0; i < sortKeys.size(); ++i) {
                    RowSorter.SortKey sortKey = sortKeys.get(i);
                    if (sortKey.getColumn() < this.columns.length) continue;
                    sortKeys = null;
                    break;
                }
                if (sortKeys != null) {
                    DarkFilePaneUIBridge.this.rowSorter.setSortKeys(sortKeys);
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.directoryModel.getSize();
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.getFileColumnValue((File)this.directoryModel.getElementAt(row), col);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            File currentDirectory = DarkFilePaneUIBridge.this.getFileChooser().getCurrentDirectory();
            return !DarkFilePaneUIBridge.this.readOnly && column == 0 && DarkFilePaneUIBridge.canWrite(currentDirectory, DarkFilePaneUIBridge.this.getFileChooser());
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 0) {
                JFileChooser chooser = DarkFilePaneUIBridge.this.getFileChooser();
                File f = (File)this.getValueAt(row, col);
                if (f != null) {
                    String oldDisplayName = chooser.getName(f);
                    String oldFileName = f.getName();
                    String newDisplayName = ((String)value).trim();
                    if (!newDisplayName.equals(oldDisplayName)) {
                        FileSystemView fsv;
                        File f2;
                        int i2;
                        String newFileName = newDisplayName;
                        int i1 = oldFileName.length();
                        if (i1 > (i2 = oldDisplayName.length()) && oldFileName.charAt(i2) == '.') {
                            newFileName = newDisplayName + oldFileName.substring(i2);
                        }
                        if ((f2 = (fsv = chooser.getFileSystemView()).createFileObject(f.getParentFile(), newFileName)).exists()) {
                            JOptionPane.showMessageDialog(chooser, MessageFormat.format(DarkFilePaneUIBridge.this.renameErrorFileExistsText, oldFileName), DarkFilePaneUIBridge.this.renameErrorTitleText, 0);
                        } else if (DarkFilePaneUIBridge.this.getModel().renameFile(f, f2)) {
                            if (fsv.isParent(chooser.getCurrentDirectory(), f2)) {
                                SwingUtilities.invokeLater(() -> {
                                    if (chooser.isMultiSelectionEnabled()) {
                                        chooser.setSelectedFiles(new File[]{f2});
                                    } else {
                                        chooser.setSelectedFile(f2);
                                    }
                                });
                            }
                        } else {
                            JOptionPane.showMessageDialog(chooser, MessageFormat.format(DarkFilePaneUIBridge.this.renameErrorText, oldFileName), DarkFilePaneUIBridge.this.renameErrorTitleText, 0);
                        }
                    }
                }
            }
        }

        protected Object getFileColumnValue(File f, int col) {
            if (col == 1) {
                return f.isDirectory() ? null : Long.valueOf(f.length());
            }
            return col == 0 ? f : ShellFolder.getFolderColumnValue(f, this.columnMap[col]);
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            File file;
            int i1;
            int i0 = e.getIndex0();
            if (i0 == (i1 = e.getIndex1()) && (file = (File)DarkFilePaneUIBridge.this.getModel().getElementAt(i0)).equals(DarkFilePaneUIBridge.this.newFolderFile)) {
                new DelayedSelectionUpdater(file);
                DarkFilePaneUIBridge.this.newFolderFile = null;
            }
            this.fireTableRowsInserted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireTableRowsDeleted(e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            new DelayedSelectionUpdater();
            this.fireTableDataChanged();
        }

        public ShellFolderColumnInfo[] getColumns() {
            return this.columns;
        }
    }

    protected class SortableListModel
    extends AbstractListModel<Object>
    implements TableModelListener,
    RowSorterListener {
        public SortableListModel() {
            DarkFilePaneUIBridge.this.getDetailsTableModel().addTableModelListener(this);
            DarkFilePaneUIBridge.this.getRowSorter().addRowSorterListener(this);
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }

        @Override
        public int getSize() {
            return DarkFilePaneUIBridge.this.getModel().getSize();
        }

        @Override
        public Object getElementAt(int index) {
            return DarkFilePaneUIBridge.this.getModel().getElementAt(DarkFilePaneUIBridge.this.getRowSorter().convertRowIndexToModel(index));
        }

        @Override
        public void sorterChanged(RowSorterEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    protected class ViewTypeAction
    extends AbstractAction {
        protected final int viewType;

        ViewTypeAction(int viewType) {
            String cmd;
            super(DarkFilePaneUIBridge.this.viewTypeActionNames[viewType]);
            this.viewType = viewType;
            switch (viewType) {
                case 0: {
                    cmd = DarkFilePaneUIBridge.ACTION_VIEW_LIST;
                    break;
                }
                case 1: {
                    cmd = DarkFilePaneUIBridge.ACTION_VIEW_DETAILS;
                    break;
                }
                default: {
                    cmd = (String)this.getValue("Name");
                }
            }
            this.putValue("ActionCommandKey", cmd);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarkFilePaneUIBridge.this.setViewType(this.viewType);
        }
    }

    public static interface FileChooserUIAccessor {
        public JFileChooser getFileChooser();

        public BasicDirectoryModel getModel();

        public JPanel createList();

        public JPanel createDetailsView();

        public boolean isDirectorySelected();

        public File getDirectory();

        public Action getApproveSelectionAction();

        public Action getChangeToParentDirectoryAction();

        public Action getNewFolderAction();

        public MouseListener createDoubleClickListener(JList<?> var1);

        public ListSelectionListener createListSelectionListener();
    }
}

