/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.internalframe;

import com.github.weisj.darklaf.components.uiresource.JButtonUIResource;
import com.github.weisj.darklaf.icons.EmptyIcon;
import com.github.weisj.darklaf.icons.ToggleIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import sun.swing.SwingUtilities2;

public class DarkInternalFrameTitlePane
extends BasicInternalFrameTitlePane {
    protected static final int PAD = 5;
    protected static final int BAR_HEIGHT = 28;
    protected static final int BUTTON_WIDTH = 46;
    protected static final int IMAGE_HEIGHT = 16;
    protected static final int IMAGE_WIDTH = 16;
    private JMenuBar menu;
    private JLabel label;
    private Color border;
    private Color buttonColor;
    private Color selectedButtonColor;
    private Color buttonColorClick;
    private Color buttonColorHover;
    private Color selectedButtonColorHover;
    private Color selectedButtonColorClick;
    private ToggleIcon minimizeIcon;
    private ToggleIcon maximizeIcon;
    private ToggleIcon iconifyIcon;
    private PropertyChangeListener propertyChangeListener2;

    public DarkInternalFrameTitlePane(JInternalFrame f) {
        super(f);
    }

    @Override
    protected void addSubComponents() {
        super.addSubComponents();
        this.label = new JLabel();
        this.label.setOpaque(false);
        if (this.menu != null) {
            this.menu = this.frame.getJMenuBar();
            this.frame.getRootPane().setJMenuBar(null);
        }
        if (this.menu != null) {
            this.add(this.menu);
        }
        this.add(this.label);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener2 = e -> {
            Object menuBar = e.getNewValue();
            if (menuBar instanceof JMenuBar) {
                this.frame.getRootPane().setJMenuBar(null);
                this.menu = (JMenuBar)menuBar;
                this.add(this.menu);
            }
        };
        this.frame.addPropertyChangeListener("JMenuBar", this.propertyChangeListener2);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.frame.removePropertyChangeListener(this.propertyChangeListener2);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.closeIcon = UIManager.getIcon("InternalFrameTitlePane.close.icon");
        this.minimizeIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.minimize.icon"), EmptyIcon.create((int)16));
        this.maximizeIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.maximize.icon"), EmptyIcon.create((int)16));
        this.iconifyIcon = new ToggleIcon(UIManager.getIcon("InternalFrameTitlePane.iconify.icon"), EmptyIcon.create((int)16));
        this.minIcon = this.minimizeIcon;
        this.maxIcon = this.maximizeIcon;
        this.iconIcon = this.iconifyIcon;
        this.selectedTitleColor = UIManager.getColor("InternalFrameTitlePane.selectedBackgroundColor");
        this.selectedTextColor = UIManager.getColor("InternalFrameTitlePane.selectedTextForeground");
        this.notSelectedTitleColor = UIManager.getColor("InternalFrameTitlePane.backgroundColor");
        this.notSelectedTextColor = UIManager.getColor("InternalFrameTitlePane.textForeground");
        this.selectedButtonColor = UIManager.getColor("InternalFrameTitlePane.selectedButtonColor");
        this.selectedButtonColorHover = UIManager.getColor("InternalFrameTitlePane.selectedButtonHoverColor");
        this.selectedButtonColorClick = UIManager.getColor("InternalFrameTitlePane.selectedButtonClickColor");
        this.buttonColor = UIManager.getColor("InternalFrameTitlePane.buttonColor");
        this.buttonColorHover = UIManager.getColor("InternalFrameTitlePane.buttonHoverColor");
        this.buttonColorClick = UIManager.getColor("InternalFrameTitlePane.buttonClickColor");
        this.border = UIManager.getColor("InternalFrameTitlePane.borderColor");
    }

    @Override
    protected void createButtons() {
        this.iconButton = DarkInternalFrameTitlePane.createButton(UIManager.getString("InternalFrameTitlePane.iconifyButtonAccessibleName"));
        this.iconButton.addActionListener(this.iconifyAction);
        this.maxButton = DarkInternalFrameTitlePane.createButton(UIManager.getString("InternalFrameTitlePane.maximizeButtonAccessibleName"));
        this.maxButton.addActionListener(e -> {
            if (this.maximizeAction.isEnabled()) {
                this.maximizeAction.actionPerformed(e);
            } else {
                this.restoreAction.actionPerformed(e);
            }
        });
        this.closeButton = DarkInternalFrameTitlePane.createButton(UIManager.getString("InternalFrameTitlePane.closeButtonAccessibleName"));
        this.closeButton.addActionListener(this.closeAction);
        this.setButtonIcons();
    }

    @Override
    protected void addSystemMenuItems(JMenu systemMenu) {
        JMenuItem mi = systemMenu.add(this.restoreAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("restore"));
        mi.setIcon((Icon)this.minimizeIcon);
        mi.setDisabledIcon((Icon)this.minimizeIcon);
        mi = systemMenu.add(this.iconifyAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("minimize"));
        mi.setIcon((Icon)this.iconifyIcon);
        mi.setDisabledIcon((Icon)this.iconifyIcon);
        mi = systemMenu.add(this.maximizeAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("maximize"));
        mi.setIcon((Icon)this.maximizeIcon);
        mi.setDisabledIcon((Icon)this.maximizeIcon);
        systemMenu.add(new JSeparator());
        mi = systemMenu.add(this.closeAction);
        mi.setMnemonic(DarkInternalFrameTitlePane.getButtonMnemonic("close"));
        mi.setIcon(this.closeIcon);
    }

    private static int getButtonMnemonic(String button) {
        try {
            return Integer.parseInt(UIManager.getString("InternalFrameTitlePane." + button + "Button.mnemonic"));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(this.getTitleBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(this.border);
        g.fillRect(0, this.getHeight() - 1, this.getWidth(), 1);
    }

    @Override
    protected void enableActions() {
        super.enableActions();
        this.iconifyIcon.setActive(this.iconifyAction.isEnabled());
        this.maximizeIcon.setActive(this.maximizeAction.isEnabled());
        this.minimizeIcon.setActive(this.restoreAction.isEnabled());
    }

    @Override
    protected LayoutManager createLayout() {
        return new DarkTitlePaneLayout();
    }

    protected Color getTitleBackground() {
        return this.frame.isSelected() ? this.selectedTitleColor : this.notSelectedTitleColor;
    }

    private static JButton createButton(String accessibleName) {
        JButtonUIResource button = new JButtonUIResource(){

            @Override
            public boolean isRolloverEnabled() {
                return true;
            }
        };
        button.setFocusable(false);
        button.setOpaque(true);
        button.putClientProperty("JButton.variant", "borderlessRectangular");
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", accessibleName);
        button.setText(null);
        return button;
    }

    @Override
    protected void paintChildren(Graphics g) {
        this.label.setText(this.frame.getTitle());
        Color colorClick = this.frame.isSelected() ? this.selectedButtonColorClick : this.buttonColorClick;
        Color colorHover = this.frame.isSelected() ? this.selectedButtonColorHover : this.buttonColorHover;
        Color bg = this.frame.isSelected() ? this.selectedButtonColor : this.buttonColor;
        this.iconButton.setBackground(bg);
        this.closeButton.setBackground(bg);
        this.maxButton.setBackground(bg);
        this.menu.setBackground(bg);
        this.menu.setOpaque(false);
        this.iconButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.closeButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.maxButton.putClientProperty("JButton.borderless.hover", colorHover);
        this.iconButton.putClientProperty("JButton.borderless.click", colorClick);
        this.closeButton.putClientProperty("JButton.borderless.click", colorClick);
        this.maxButton.putClientProperty("JButton.borderless.click", colorClick);
        super.paintChildren(g);
    }

    @Override
    protected void paintBorder(Graphics g) {
    }

    protected class DarkTitlePaneLayout
    implements LayoutManager {
        protected DarkTitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            return this.minimumLayoutSize(c);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            int title_length;
            int width = 10;
            if (DarkInternalFrameTitlePane.this.frame.isClosable()) {
                width += 46;
            }
            if (DarkInternalFrameTitlePane.this.frame.isMaximizable()) {
                width += 46;
            }
            if (DarkInternalFrameTitlePane.this.frame.isIconifiable()) {
                width += 46;
            }
            FontMetrics fm = DarkInternalFrameTitlePane.this.frame.getFontMetrics(DarkInternalFrameTitlePane.this.getFont());
            String frameTitle = DarkInternalFrameTitlePane.this.frame.getTitle();
            int title_w = frameTitle != null ? SwingUtilities2.stringWidth(DarkInternalFrameTitlePane.this.frame, fm, frameTitle) : 0;
            int n = title_length = frameTitle != null ? frameTitle.length() : 0;
            if (title_length > 3) {
                int subtitle_w = SwingUtilities2.stringWidth(DarkInternalFrameTitlePane.this.frame, fm, frameTitle.substring(0, 3) + "...");
                width += Math.min(title_w, subtitle_w);
            } else {
                width += title_w;
            }
            if (DarkInternalFrameTitlePane.this.menu != null) {
                width += ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).menu.getPreferredSize().width + 5;
            }
            Icon icon = DarkInternalFrameTitlePane.this.frame.getFrameIcon();
            int fontHeight = fm.getHeight();
            fontHeight += 2;
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = Math.min(icon.getIconHeight(), 16);
            }
            int height = Math.max(fontHeight, iconHeight += 2);
            height = Math.max(height, 28);
            Dimension dim = new Dimension(width, height);
            if (DarkInternalFrameTitlePane.this.getBorder() != null) {
                Insets insets = DarkInternalFrameTitlePane.this.getBorder().getBorderInsets(c);
                dim.height += insets.top + insets.bottom;
                dim.width += insets.left + insets.right;
            }
            return dim;
        }

        @Override
        public void layoutContainer(Container c) {
            int x2;
            boolean leftToRight = DarkInternalFrameTitlePane.this.frame.getComponentOrientation().isLeftToRight();
            int w = DarkInternalFrameTitlePane.this.getWidth();
            int h = DarkInternalFrameTitlePane.this.getHeight() - 1;
            Icon icon = DarkInternalFrameTitlePane.this.frame.getFrameIcon();
            int iconHeight = 0;
            if (icon != null) {
                iconHeight = icon.getIconHeight();
            }
            int x1 = leftToRight ? 5 : w - 16 - 5;
            DarkInternalFrameTitlePane.this.menuBar.setBounds(x1, (h - iconHeight) / 2, 16, 16);
            x1 += leftToRight ? 16 : -16;
            x1 += leftToRight ? 5 : -5;
            if (DarkInternalFrameTitlePane.this.menu != null) {
                int width = ((DarkInternalFrameTitlePane)DarkInternalFrameTitlePane.this).menu.getPreferredSize().width;
                if (leftToRight) {
                    DarkInternalFrameTitlePane.this.menu.setBounds(x1, 0, width, h + 1);
                    x1 += width + 5;
                } else {
                    DarkInternalFrameTitlePane.this.menu.setBounds(x1 -= width, 0, width, h + 1);
                    x1 -= 5;
                }
            }
            int n = x2 = leftToRight ? w - 46 : 0;
            if (DarkInternalFrameTitlePane.this.frame.isClosable()) {
                DarkInternalFrameTitlePane.this.closeButton.setBounds(x2, 0, 46, h);
                x2 += leftToRight ? -46 : 46;
            }
            if (DarkInternalFrameTitlePane.this.frame.isMaximizable()) {
                DarkInternalFrameTitlePane.this.maxButton.setBounds(x2, 0, 46, h);
                x2 += leftToRight ? -46 : 46;
            }
            if (DarkInternalFrameTitlePane.this.frame.isIconifiable()) {
                DarkInternalFrameTitlePane.this.iconButton.setBounds(x2, 0, 46, h);
            }
            x2 += leftToRight ? -5 : 5;
            if (leftToRight) {
                DarkInternalFrameTitlePane.this.label.setBounds(x1, 0, x2 - x1, h);
            } else {
                DarkInternalFrameTitlePane.this.label.setBounds(x2, 0, x1 - x2, h);
            }
        }
    }
}

