/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.text;

import com.github.weisj.darklaf.graphics.GraphicsContext;
import com.github.weisj.darklaf.graphics.PaintUtil;
import com.github.weisj.darklaf.ui.text.DarkPasswordFieldUIBridge;
import com.github.weisj.darklaf.ui.text.DarkTextBorder;
import com.github.weisj.darklaf.ui.text.DarkTextFieldUI;
import com.github.weisj.darklaf.util.DarkUIUtil;
import com.github.weisj.darklaf.util.PropertyUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.JTextComponent;

public class DarkPasswordFieldUI
extends DarkPasswordFieldUIBridge {
    protected static final String KEY_PREFIX = "JPasswordField.";
    public static final String KEY_SHOW_VIEW_BUTTON = "JPasswordField.showViewIcon";
    protected Icon show;
    protected Icon showPressed;
    protected int borderSize;
    protected int arc;
    private char echo_dot = (char)42;
    private boolean showTriggered = false;

    public static ComponentUI createUI(JComponent c) {
        return new DarkPasswordFieldUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.borderSize = UIManager.getInt("PasswordField.borderThickness");
        this.arc = UIManager.getInt("PasswordField.arc");
        this.show = UIManager.getIcon("PasswordField.show.icon");
        this.showPressed = UIManager.getIcon("PasswordField.showPressed.icon");
    }

    @Override
    protected void adjustTextRect(JTextComponent c, Rectangle r) {
        int end = r.x + r.width;
        boolean ltr = c.getComponentOrientation().isLeftToRight();
        if (this.doPaintRightIcon(c)) {
            Point p;
            boolean eye = DarkPasswordFieldUI.hasShowIcon(c);
            Point point = p = eye ? this.getShowIconCoord() : this.getClearIconCoord();
            if (ltr) {
                end = p.x;
            } else {
                r.x = p.x + (eye ? this.getShowIcon() : DarkPasswordFieldUI.getClearIcon(false)).getIconWidth();
            }
        }
        r.width = end - r.x;
    }

    @Override
    protected boolean doPaintLeftIcon(JTextComponent c) {
        return false;
    }

    @Override
    protected void paintBackground(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        JTextComponent c = this.getComponent();
        Container parent = c.getParent();
        if (parent != null) {
            g.setColor(parent.getBackground());
            g.fillRect(0, 0, c.getWidth(), c.getHeight());
        }
        Border border = c.getBorder();
        GraphicsContext config = new GraphicsContext(g);
        if (border instanceof DarkTextBorder) {
            if (c.isEnabled() && c.isEditable()) {
                g.setColor(c.getBackground());
            }
            int width = c.getWidth();
            int height = c.getHeight();
            int w = this.borderSize;
            PaintUtil.fillRoundRect(g, w, w, width - 2 * w, height - 2 * w, this.arc);
            if (DarkPasswordFieldUI.hasShowIcon(c) && this.showShowIcon()) {
                this.paintShowIcon(g);
            }
        } else {
            super.paintBackground(g);
        }
        config.restore();
    }

    @Override
    protected boolean doPaintRightIcon(JTextComponent c) {
        return super.doPaintRightIcon(c) || DarkPasswordFieldUI.hasShowIcon(c);
    }

    @Override
    protected void paintRightIcon(Graphics g) {
        if (DarkPasswordFieldUI.hasShowIcon(this.getComponent())) {
            this.paintShowIcon(g);
        } else {
            super.paintRightIcon(g);
        }
    }

    private void paintShowIcon(Graphics g) {
        Point p = this.getShowIconCoord();
        if (this.showTriggered || !this.editor.isEnabled() || !this.editor.isEditable()) {
            this.getShowTriggeredIcon().paintIcon(this.getComponent(), g, p.x, p.y);
        } else {
            this.getShowIcon().paintIcon(this.getComponent(), g, p.x, p.y);
        }
    }

    protected Icon getShowTriggeredIcon() {
        return this.showPressed;
    }

    public static boolean hasShowIcon(Component c) {
        return PropertyUtil.getBooleanProperty((Component)c, (String)KEY_SHOW_VIEW_BUTTON);
    }

    private Point getShowIconCoord() {
        Rectangle r = this.getDrawingRect(this.getComponent());
        int w = this.getShowIcon().getIconWidth();
        return DarkUIUtil.adjustForOrientation(new Point(r.x + r.width - w - this.borderSize, r.y + (r.height - w) / 2), w, this.editor);
    }

    private boolean isOverEye(Point p) {
        return this.showShowIcon() && DarkTextFieldUI.isOver(this.getShowIconCoord(), this.getShowIcon(), p);
    }

    protected Icon getShowIcon() {
        return this.show;
    }

    private boolean showShowIcon() {
        JPasswordField c = (JPasswordField)this.getComponent();
        char[] pw = c.getPassword();
        boolean show = pw.length > 0;
        Arrays.fill(pw, '\u0000');
        return show;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        if (c instanceof JPasswordField) {
            this.echo_dot = ((JPasswordField)c).getEchoChar();
        }
    }

    @Override
    protected DarkTextFieldUI.ClickAction getActionUnder(Point p) {
        DarkTextFieldUI.ClickAction action = super.getActionUnder(p);
        if (this.isOverEye(p) && DarkPasswordFieldUI.hasShowIcon(this.editor)) {
            action = DarkTextFieldUI.ClickAction.RIGHT_ACTION;
        }
        return action;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (DarkPasswordFieldUI.hasShowIcon(this.getComponent())) {
            return;
        }
        super.mouseClicked(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (DarkPasswordFieldUI.hasShowIcon(this.editor) && this.isOverEye(e.getPoint())) {
            ((JPasswordField)this.getComponent()).setEchoChar('\u0000');
            this.showTriggered = true;
            this.getComponent().repaint();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.showTriggered) {
            ((JPasswordField)this.getComponent()).setEchoChar(this.echo_dot);
            this.showTriggered = false;
            this.getComponent().repaint();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        String key = evt.getPropertyName();
        if (KEY_SHOW_VIEW_BUTTON.equals(key)) {
            this.editor.doLayout();
            Container parent = this.editor.getParent();
            if (parent instanceof JComponent) {
                ((Component)parent).doLayout();
            }
            this.editor.repaint();
        }
    }
}

