/*
 * Decompiled with CFR 0.152.
 */
package com.hankcs.hanlp.model.perceptron;

import com.hankcs.hanlp.corpus.document.sentence.Sentence;
import com.hankcs.hanlp.model.perceptron.PerceptronTrainer;
import com.hankcs.hanlp.model.perceptron.feature.FeatureMap;
import com.hankcs.hanlp.model.perceptron.instance.Instance;
import com.hankcs.hanlp.model.perceptron.instance.NERInstance;
import com.hankcs.hanlp.model.perceptron.tagset.NERTagSet;
import com.hankcs.hanlp.model.perceptron.tagset.TagSet;

public class NERTrainer
extends PerceptronTrainer {
    public NERTagSet tagSet;

    public NERTrainer(NERTagSet tagSet) {
        this.tagSet = tagSet;
    }

    public NERTrainer() {
        this.tagSet = new NERTagSet();
        this.tagSet.nerLabels.add("nr");
        this.tagSet.nerLabels.add("ns");
        this.tagSet.nerLabels.add("nt");
    }

    @Override
    protected TagSet createTagSet() {
        return this.tagSet;
    }

    @Override
    protected Instance createInstance(Sentence sentence, FeatureMap featureMap) {
        return NERInstance.create(sentence, featureMap);
    }
}

