/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.IMSyncMsgApi;
import com.hxgy.im.pojo.vo.IMCommonAccessRspVO;
import com.hxgy.im.pojo.vo.IMMixtedFlowCallbackReqVO;
import com.hxgy.im.pojo.vo.IMQueryMsgReqVO;
import com.hxgy.im.pojo.vo.IMQueryNoReadMsgReqVO;
import com.hxgy.im.pojo.vo.IMRecallMsgReqVO;
import com.hxgy.im.pojo.vo.IMSingleMsgResultVO;
import com.hxgy.im.pojo.vo.IMTencentCallBackReqVO;
import com.hxgy.im.pojo.vo.IMTencentCallBackRspVO;
import com.hxgy.im.pojo.vo.tencentVo.IMC2cMsgBeforeSendCallbackRespVO;
import com.hxgy.im.service.IMCommonService;
import com.hxgy.im.service.IMMsgService;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IMMsgController
implements IMSyncMsgApi {
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private IMMsgService imMsgService;
    private static final Logger log = LoggerFactory.getLogger(IMMsgController.class);
    @Autowired
    private IMCommonService imCommonService;

    public IMTencentCallBackRspVO syncTencentMsg(@RequestParam(name="SdkAppid", required=false) String sdkAppid, @RequestParam(name="CallbackCommand", required=false) String callbackCommand, @RequestParam(name="ClientIP", required=false) String clientIP, @RequestParam(name="OptPlatform", required=false) String optPlatform, @RequestBody IMTencentCallBackReqVO reqVO) {
        reqVO.setCallbackCommand(callbackCommand);
        reqVO.setSdkAppId(sdkAppid);
        reqVO.setOptPlatform(optPlatform);
        if ("C2C.CallbackAfterSendMsg".equals(callbackCommand)) {
            this.c2cMsgCallback(reqVO);
        } else if ("C2C.CallbackBeforeSendMsg".equals(callbackCommand)) {
            this.c2cBeforeSendMsgCallback(reqVO);
        } else if ("State.StateChange".equals(callbackCommand)) {
            this.statusChangeCallback(reqVO);
        } else if ("Group.CallbackAfterSendMsg".equals(callbackCommand)) {
            this.groupMsgCallback(reqVO);
        } else if ("Group.CallbackAfterCreateGroup".equals(callbackCommand)) {
            this.groupCreateCallback(reqVO);
        } else {
            this.c2cMsgCallback(reqVO);
        }
        return new IMTencentCallBackRspVO("OK", "", Integer.valueOf(0));
    }

    public IMCommonAccessRspVO mixtesFlowCallback(@RequestBody IMMixtedFlowCallbackReqVO reqVO) {
        int event_type = reqVO.getEvent_type();
        if (0 == event_type) {
            log.error("\u53d1\u751f\u3010\u65ad\u6d41\u3011\u4e8b\u4ef6\uff1a{}", (Object)event_type);
        } else if (1 == event_type) {
            log.info("\u53d1\u751f\u3010\u63a8\u6d41\u3011\u4e8b\u4ef6\uff1a{}", (Object)event_type);
        } else if (100 == event_type) {
            log.info("\u65b0\u7684\u3010\u5f55\u5236\u6587\u4ef6\u3011\u5df2\u751f\u6210\uff1a{}", (Object)event_type);
            this.mixtedFlowVedioEndCallback(reqVO);
        } else if (200 == event_type) {
            log.info("\u65b0\u7684\u3010\u622a\u56fe\u6587\u4ef6\u3011\u5df2\u751f\u6210\uff1a{}", (Object)event_type);
        } else {
            log.error("\u65e0\u6cd5\u8bc6\u522b\u7684event_type\uff1a{}", (Object)event_type);
        }
        return IMCommonAccessRspVO.SUCCESS();
    }

    private void c2cMsgCallback(IMTencentCallBackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u5355\u804a\u6d88\u606f\u53d1\u9001\u4e4b\u540e \u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.c2c.msg", (Object)data);
    }

    private IMC2cMsgBeforeSendCallbackRespVO c2cBeforeSendMsgCallback(IMTencentCallBackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u5355\u804a\u6d88\u606f\u53d1\u9001\u4e4b\u524d \u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        return this.imMsgService.tencentC2CMsgSendBefore(reqVO);
    }

    private void statusChangeCallback(IMTencentCallBackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u72b6\u6001\u66f4\u6539\u6d88\u606f\u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.changestate", (Object)data);
    }

    private void groupMsgCallback(IMTencentCallBackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u7fa4\u7ec4\u6d88\u606f\u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.group.msg", (Object)data);
    }

    private void groupCreateCallback(IMTencentCallBackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u72b6\u6001\u66f4\u6539\u6d88\u606f\u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.group.create.msg", (Object)data);
    }

    private void mixtedFlowVedioEndCallback(IMMixtedFlowCallbackReqVO reqVO) {
        String data = JSON.toJSONString((Object)reqVO);
        log.info("\u817e\u8baf\u4e91-\u89c6\u9891\u5b8c\u6210\u6df7\u6d41\u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)data);
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.mixted.flow.video.end", (Object)data);
    }

    public BaseResponse<List<IMSingleMsgResultVO>> queryImMsg(@RequestBody IMQueryMsgReqVO reqVO) {
        return this.imMsgService.getImMsg(reqVO);
    }

    public BaseResponse<List<IMSingleMsgResultVO>> queryImNoReadMsg(@RequestBody IMQueryNoReadMsgReqVO reqVO) {
        return this.imMsgService.queryImNoReadMsg(reqVO);
    }

    public BaseResponse<?> recallImMsg(@RequestBody @Valid IMRecallMsgReqVO reqVO) {
        return this.imMsgService.recallImMsg(reqVO);
    }
}

