/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.MediaProcessApi;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaReqVo;
import com.hxgy.im.service.MediaProcessService;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MediaProcessController
implements MediaProcessApi {
    private static final Logger log = LoggerFactory.getLogger((String)"MediaProcessApi");
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private MediaProcessService mediaProcessService;

    public BaseResponse<?> EditMedia(@RequestBody @Valid IMEditMediaReqVo editMediaVo) {
        return this.mediaProcessService.EditMedia(editMediaVo);
    }

    public void callbackProcessVideo(@RequestBody JSONObject jsonObject) {
        log.info("\u817e\u8baf\u4e91\u70b9\u64ad-\u89c6\u9891\u5904\u7406 \u56de\u8c03\u6536\u5230\u7684\u6d88\u606f\u5185\u5bb9: {}", (Object)jsonObject.toJSONString());
        String eventType = jsonObject.getString("EventType");
        if ("ProcedureStateChanged".equalsIgnoreCase(eventType)) {
            this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.routeKey.procedureStateChanged", (Object)jsonObject.toJSONString());
        } else if ("EditMediaComplete".equalsIgnoreCase(eventType)) {
            this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.routeKey.editMediaComplete", (Object)jsonObject.toJSONString());
        }
    }

    public BaseResponse<?> mediaTranscode(@RequestParam(value="fileId") String fileId) {
        return this.mediaProcessService.mediaTranscode(fileId, null);
    }
}

