/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.MultiChannelMixedRecordingApi;
import com.hxgy.im.pojo.MultiChannelMixedReqVO;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.IMProductTypeEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.IMProductTypeRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.util.MD5Utils;
import com.hxgy.im.util.UUIDUtil;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.trtc.v20190722.TrtcClient;
import com.tencentcloudapi.trtc.v20190722.models.EncodeParams;
import com.tencentcloudapi.trtc.v20190722.models.LayoutParams;
import com.tencentcloudapi.trtc.v20190722.models.OutputParams;
import com.tencentcloudapi.trtc.v20190722.models.StartMCUMixTranscodeRequest;
import com.tencentcloudapi.trtc.v20190722.models.StartMCUMixTranscodeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class MultiChannelMixedRecordingController
implements MultiChannelMixedRecordingApi {
    private static final Logger log = LoggerFactory.getLogger(MultiChannelMixedRecordingController.class);
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private IMProductTypeRepository productTypeRepository;

    @Transactional(rollbackFor={Exception.class})
    public BaseResponse multiChannelMixed(@RequestBody MultiChannelMixedReqVO multiChannelMixedReqVO) {
        String busiCode = multiChannelMixedReqVO.getBusiCode();
        String treatmentId = multiChannelMixedReqVO.getTreatmentId();
        String productCode = multiChannelMixedReqVO.getProductCode();
        ImSessionEntity imSessionEntity = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (imSessionEntity == null) {
            return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        IMMixtedFlowEntity imMixtedFlowEntity = new IMMixtedFlowEntity();
        IMProductTypeEntity imProductTypeEntity = this.productTypeRepository.findByProductCode(productCode);
        if (imMixtedFlowEntity != null) {
            imMixtedFlowEntity.setProductId(imProductTypeEntity.getId());
        }
        imMixtedFlowEntity.setSessionId(imSessionEntity.getId());
        Long roomId = imSessionEntity.getRoomNum();
        String streamId = MD5Utils.string2MD5((String)(roomId + "" + UUIDUtil.getUUID()));
        imMixtedFlowEntity.setStreamId(streamId);
        this.mixtedFlowRepository.saveAndFlush((Object)imMixtedFlowEntity);
        try {
            Credential cred = new Credential("AKIDN0ECtPKg17wBAtrIq7j4HI2V1LOAlvqU", "XoOjnaU7TYLqiSDh5TaQz2pMdr42jMwl");
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("trtc.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            TrtcClient client = new TrtcClient(cred, "ap-beijing", clientProfile);
            StartMCUMixTranscodeRequest mcuMixTranscodeRequest = new StartMCUMixTranscodeRequest();
            OutputParams outputParams = new OutputParams();
            outputParams.setStreamId(streamId);
            outputParams.setPureAudioStream(Long.valueOf(0L));
            outputParams.setRecordId(streamId + "record_id");
            outputParams.setRecordAudioOnly(Long.valueOf(0L));
            mcuMixTranscodeRequest.setOutputParams(outputParams);
            EncodeParams encodeParams = new EncodeParams();
            encodeParams.setVideoWidth(Long.valueOf(1280L));
            encodeParams.setVideoHeight(Long.valueOf(720L));
            encodeParams.setVideoBitrate(Long.valueOf(1560L));
            encodeParams.setVideoFramerate(Long.valueOf(15L));
            encodeParams.setVideoGop(Long.valueOf(2L));
            encodeParams.setBackgroundColor(Long.valueOf(0L));
            encodeParams.setAudioSampleRate(Long.valueOf(48000L));
            encodeParams.setAudioBitrate(Long.valueOf(64L));
            encodeParams.setAudioChannels(Long.valueOf(2L));
            mcuMixTranscodeRequest.setEncodeParams(encodeParams);
            LayoutParams layoutParams = new LayoutParams();
            layoutParams.setTemplate(Long.valueOf(2L));
            layoutParams.setMainVideoUserId("main_pc");
            layoutParams.setMainVideoStreamType(Long.valueOf(1L));
            mcuMixTranscodeRequest.setLayoutParams(layoutParams);
            mcuMixTranscodeRequest.setSdkAppId(Long.valueOf(1400088738L));
            mcuMixTranscodeRequest.setRoomId(roomId);
            log.info("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u53c2\u6570{}", (Object)StartMCUMixTranscodeRequest.toJsonString((AbstractModel)mcuMixTranscodeRequest));
            StartMCUMixTranscodeResponse startMCUMixTranscodeResponse = client.StartMCUMixTranscode(mcuMixTranscodeRequest);
            if (startMCUMixTranscodeResponse == null) {
                throw new RuntimeException("\u817e\u8bafIM mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            log.info("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u7ed3\u679c{}", (Object)StartMCUMixTranscodeResponse.toJsonString((AbstractModel)startMCUMixTranscodeResponse));
        }
        catch (TencentCloudSDKException e) {
            log.error("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01");
        }
        return BaseResponse.success();
    }
}

