/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.group.service.Impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.hxgy.im.config.ProjProperties;
import com.hxgy.im.enums.BusiCodeEnum;
import com.hxgy.im.group.service.IMGroupService;
import com.hxgy.im.group.vo.creatgroup.IMCreatGroupRspVO;
import com.hxgy.im.group.vo.creatgroup.IMForbidSendMsgReqVO;
import com.hxgy.im.group.vo.member.TxAddMemberReqVO;
import com.hxgy.im.group.vo.member.TxAddMemberRspVO;
import com.hxgy.im.group.vo.member.TxDelMemberReqVO;
import com.hxgy.im.group.vo.member.TxMemReqVO;
import com.hxgy.im.pojo.IMGroupDestroyVO;
import com.hxgy.im.pojo.bo.CheckGroupMembersBO;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.bo.IMSaveSessionBO;
import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.bo.TencentBaseRsp;
import com.hxgy.im.pojo.dto.AutoGenerationStreamidDTO;
import com.hxgy.im.pojo.entity.IMLiveApplicationEntity;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.IMProductTypeEntity;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImMemberEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.vo.IMChangeMemVO;
import com.hxgy.im.pojo.vo.IMChangeMemberReqVO;
import com.hxgy.im.pojo.vo.IMCreatGroupMemVO;
import com.hxgy.im.pojo.vo.IMCreatGroupReqVO;
import com.hxgy.im.pojo.vo.IMCreateGroupRspVO;
import com.hxgy.im.pojo.vo.IMGroupListVO;
import com.hxgy.im.pojo.vo.IMGroupMemberManagerVO;
import com.hxgy.im.pojo.vo.IMGroupMemberReqVO;
import com.hxgy.im.pojo.vo.IMGroupMemberVO;
import com.hxgy.im.pojo.vo.IMOptSpeakReqVO;
import com.hxgy.im.pojo.vo.ImGroup;
import com.hxgy.im.pojo.vo.TencentMembersVO;
import com.hxgy.im.repository.IMLiveApplicationRepository;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.IMProductTypeRepository;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImMemberRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.repository.dao.IMMsgDao;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMPushAccountService;
import com.hxgy.im.service.IMSessionService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.task.AsyncTask;
import com.hxgy.im.util.DateTimeUtil;
import com.hxgy.im.util.HeadImageUtil;
import com.hxgy.im.util.MD5Utils;
import com.hxgy.im.util.RandomUtil;
import com.hxgy.im.util.RestTemplateUtils;
import com.hxgy.im.util.oss.OssManageUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class IMGroupServiceImpl
implements IMGroupService {
    private static final Logger log = LoggerFactory.getLogger(IMGroupServiceImpl.class);
    @Autowired
    private ProjProperties properties;
    @Autowired
    private ImSessionRepository imSessionRepository;
    @Autowired
    private ImMemberRepository imMemberRepository;
    @Autowired
    private ImApplicationRepository imApplicationRepository;
    @Autowired
    private ImAccountRepository imAccountRepository;
    @Autowired
    @Lazy
    private IMSessionService imSessionService;
    @Autowired
    private IMPushAccountService imPushAccountService;
    @Autowired
    private IMSigService sigService;
    @Autowired
    private IMAccountService imAccountService;
    @Autowired
    private AsyncTask asyncTask;
    @Autowired
    private IMLiveApplicationRepository liveAppRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private IMProductTypeRepository productTypeRepository;
    @Autowired
    private IMMsgDao imMsgDao;

    public BaseResponse<IMCreateGroupRspVO> creatGroup(IMCreatGroupReqVO reqVO) {
        log.info("\u521b\u5efa\u7fa4\u7ec4 \u8bf7\u6c42\u53c2\u6570IMCreatGroupReqVO\uff1a{}", (Object)JSON.toJSONString((Object)reqVO));
        if (reqVO.getImGroup() == null && reqVO.getMembers() == null) {
            log.error("\u521b\u5efa\u7fa4\u7ec4 \u8bf7\u6c42\u53c2\u6570\u9519\u8bef ImGroup \u548c Members \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u975e\u6cd5\u53c2\u6570 ImGroup \u548c Members \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        String busiCode = reqVO.getBusiCode();
        List members = reqVO.getMembers();
        String treatmentId = reqVO.getTreatmentId();
        IMSaveSessionBO bo = new IMSaveSessionBO(busiCode, treatmentId, reqVO.getCreateUser(), "2");
        ImSessionEntity session = this.imSessionService.findMaxRoomNumAndSave(bo);
        log.info("\u521b\u5efa\u7fa4\u7ec4 \u65b0\u5efa\u4f1a\u8bdd\u5e76\u4fdd\u5b58\uff1a{}", (Object)session);
        String sessionId = session.getId();
        ArrayList forbidAccounts = new ArrayList();
        ArrayList txMembersList = new ArrayList();
        ArrayList pushAccount2Tencent = new ArrayList();
        ArrayList urls = new ArrayList();
        HashMap<String, ImApplicationEntity> mapApp = new HashMap<String, ImApplicationEntity>(16);
        HashMap<String, String> mapId = new HashMap<String, String>(16);
        String appKey = "app";
        String appIdKey = "appId";
        if (members != null) {
            Map<String, List<IMCreatGroupMemVO>> map = members.stream().collect(Collectors.groupingBy(IMCreatGroupMemVO::getAppCode));
            map.forEach((key, value) -> {
                ImApplicationEntity application = this.imApplicationRepository.findByAppCode(key);
                if (application == null) {
                    log.error("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", key);
                    return;
                }
                if (mapApp.isEmpty()) {
                    mapApp.put(appKey, application);
                    mapId.put(appIdKey, application.getId());
                }
                value.stream().forEach(mem -> {
                    TencentMembersVO txtMembersVO = new TencentMembersVO();
                    String userId = mem.getUserId();
                    String appCode = mem.getAppCode();
                    String formNick = mem.getPerName();
                    String headLogo = mem.getHeadLogo();
                    urls.add(headLogo);
                    String appId = application.getId();
                    IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, appCode, userId, formNick, headLogo);
                    ImAccountEntity accountEntity = this.imAccountService.saveOrQueryAccount(accountBO);
                    String accountId = accountEntity.getId();
                    String sdkAccount = accountEntity.getSdkAccount();
                    IMSaveSigBO sigBO = new IMSaveSigBO(application.getAppSdkId(), sdkAccount, accountId);
                    ImSigEntity sigEntity = this.sigService.saveSig(sigBO);
                    ImMemberEntity member = new ImMemberEntity();
                    member.setSessionId(sessionId);
                    member.setAccountId(accountId);
                    member.setTalkPermiss(mem.getPermission());
                    this.imMemberRepository.saveAndFlush((Object)member);
                    pushAccount2Tencent.add(sdkAccount);
                    txtMembersVO.setMemberAccount(sdkAccount);
                    txMembersList.add(txtMembersVO);
                    if ("0".equals(mem.getPermission())) {
                        forbidAccounts.add(sdkAccount);
                    }
                });
            });
            if (!pushAccount2Tencent.isEmpty()) {
                log.info("\u521b\u5efa\u7fa4\u7ec4 \u4e0a\u4f20\u6210\u5458\u8d26\u53f7\u5230\u817e\u8baf\u4e91\uff1a{}", pushAccount2Tencent);
                this.imPushAccountService.pushAccount(((ImApplicationEntity)mapApp.get(appKey)).getAppSdkId(), pushAccount2Tencent);
            }
        }
        if (reqVO.getImGroup() != null && reqVO.getImGroup().getAppCode() != null) {
            ImApplicationEntity application = this.imApplicationRepository.findByAppCode(reqVO.getImGroup().getAppCode());
            if (application == null) {
                log.error("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)reqVO.getImGroup().getAppCode());
            }
            mapApp.put(appKey, application);
            mapId.put(appIdKey, application.getId());
        }
        try {
            IMCreatGroupRspVO rsp;
            if (reqVO.getImGroup() == null || reqVO.getImGroup().getGroupType() == null || reqVO.getImGroup().getAppCode() == null) {
                rsp = this.txCreateGroup(null, (ImApplicationEntity)mapApp.get(appKey), txMembersList);
            } else {
                log.info("\u817e\u8baf\u4e91\u521b\u5efa\u7fa4\u7ec4\u4f1a\u8bdd ===\u7fa4\u7ec4\u7c7b\u578b\uff1a{}===", (Object)reqVO.getImGroup().getGroupType());
                rsp = this.txCreateGroup(reqVO.getImGroup(), (ImApplicationEntity)mapApp.get(appKey), txMembersList);
            }
            if (rsp == null) {
                return BaseResponse.error((String)"\u5411\u817e\u8baf\u4e91\u8bf7\u6c42\u521b\u5efa\u7fa4\u7ec4\u65f6\u5931\u8d25,\u9700\u91cd\u8bd5!");
            }
            if ("FAIL".equalsIgnoreCase(rsp.getActionStatus())) {
                return BaseResponse.error((String)rsp.getErrorInfo());
            }
            session.setGroupId(rsp.getGroupId());
            this.imSessionRepository.saveAndFlush((Object)session);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u7fa4\u7ec4\u5f02\u5e38\uff1a{}", (Throwable)e);
            return BaseResponse.error((String)"\u521b\u5efa\u7fa4\u7ec4\u5f02\u5e38!");
        }
        if (!forbidAccounts.isEmpty()) {
            IMForbidSendMsgReqVO forbidReqVO = new IMForbidSendMsgReqVO();
            forbidReqVO.setGroupId(session.getGroupId());
            forbidReqVO.setMembersAccount(forbidAccounts);
            forbidReqVO.setShutUpTime(Integer.valueOf(172800));
            try {
                TencentBaseRsp baseRsp = this.txForbid((ImApplicationEntity)mapApp.get(appKey), forbidReqVO);
                if (baseRsp == null) {
                    return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5931\u8d25!");
                }
                if ("FAIL".equalsIgnoreCase(baseRsp.getActionStatus())) {
                    return BaseResponse.error((String)baseRsp.getErrorInfo());
                }
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5f02\u5e38!");
            }
        }
        this.asyncTask.checkMembers(new CheckGroupMembersBO(sessionId, session.getGroupId(), (String)mapId.get(appIdKey)));
        IMCreateGroupRspVO rspBusiness = new IMCreateGroupRspVO();
        rspBusiness.setGroupId(session.getGroupId());
        rspBusiness.setRoomNum(session.getRoomNum());
        try {
            if (BusiCodeEnum.YCJX.getBusiCodeEnumValue().equalsIgnoreCase(busiCode) || BusiCodeEnum.YCHY.getBusiCodeEnumValue().equalsIgnoreCase(busiCode)) {
                AutoGenerationStreamidDTO dto = new AutoGenerationStreamidDTO();
                dto.setAppCode(reqVO.getImGroup().getAppCode());
                dto.setUserId(reqVO.getCreateUser());
                dto.setBusiCode(busiCode);
                dto.setGroupId(session.getGroupId());
                dto.setRoomNum(session.getRoomNum());
                dto.setSessionId(sessionId);
                String streamid = this.autoGenerationStreamid(dto);
                log.info("\u8fdc\u7a0b\u6559\u5b66/\u4f1a\u8bae\u521b\u5efa\u623f\u95f4\u53f7,\u751f\u6210streamID:{}", (Object)streamid);
            }
        }
        catch (Exception e) {
            log.error("\u8fdc\u7a0b\u6559\u5b66/\u4f1a\u8bae\u521b\u5efa\u623f\u95f4\u53f7\uff0c\u5f02\u5e38 " + e.getMessage());
        }
        String headsUrl = this.getHeadsUrl(urls, rspBusiness);
        rspBusiness.setHeadsUrl(headsUrl);
        if (null != reqVO.getImGroup() && StringUtils.isNotEmpty((CharSequence)reqVO.getImGroup().getGroupName())) {
            session.setGroupName(reqVO.getImGroup().getGroupName());
        }
        session.setGroupLogo(headsUrl);
        this.imSessionRepository.saveAndFlush((Object)session);
        return BaseResponse.success((Object)rspBusiness);
    }

    private String getHeadsUrl(List<String> urls, IMCreateGroupRspVO rspBusiness) {
        String logurl = "http://tupian201805.oss-cn-beijing.aliyuncs.com/2019/0/25/1548382195565_a8f889794b454136ac0de6341fc1f52d.png";
        try {
            if (null != urls && urls.size() > 0) {
                String picDir;
                MockMultipartFile multipartFile;
                ByteArrayOutputStream byteArrayOutputStream = HeadImageUtil.getCombinationOfHead(urls);
                String rootDir = DateTimeUtil.getYear((Date)new Date()) + "/" + DateTimeUtil.getMonth((Date)new Date()) + 1 + "/" + DateTimeUtil.getDayOfMonth((Date)new Date());
                Map map = OssManageUtil.uploadFile((String)rootDir, (MultipartFile)(multipartFile = new MockMultipartFile("temp.jpg", "temp.jpg", "", (InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()))));
                if (null != map && map.size() > 0 && (picDir = map.get("urlpath").toString()) != null && !"".equals(picDir)) {
                    logurl = picDir;
                }
            }
        }
        catch (Exception e) {
            log.info("======\u56fe\u7247\u5408\u6210\u5931\u8d25=======");
            e.printStackTrace();
        }
        return logurl;
    }

    private IMCreatGroupRspVO txCreateGroup(ImGroup imGroup, ImApplicationEntity application, List<TencentMembersVO> txMembersList) {
        log.info("\u521b\u5efa\u7fa4\u7ec4 \u521b\u5efa\u817e\u8baf\u4e91\u7fa4\u7ec4\u4f1a\u8bdd imGroup\uff1a{}; application:{}; txMembersList:{}", new Object[]{imGroup, application, txMembersList});
        String TX_CREATE_GROUP = this.properties.getTencentImUrl().concat("/v4/group_open_http_svc/create_group");
        String creatUrl = this.createPostTencentUrl(TX_CREATE_GROUP, application);
        log.info("\u817e\u8baf\u4e91\u7fa4\u7ec4url:{}", (Object)creatUrl);
        JSONObject jsonObject = new JSONObject();
        if (imGroup != null) {
            if (imGroup.getGroupName() != null) {
                jsonObject.put("Name", (Object)imGroup.getGroupName());
            } else {
                jsonObject.put("Name", (Object)RandomUtil.getRandom8Length());
            }
            jsonObject.put("Type", (Object)imGroup.getGroupType());
            if (imGroup.getOwnerAccount() != null) {
                jsonObject.put("Owner_Account", (Object)imGroup.getOwnerAccount());
            }
            if (imGroup.getIntroduction() != null) {
                jsonObject.put("Introduction", (Object)imGroup.getIntroduction());
            }
            if (imGroup.getNotification() != null) {
                jsonObject.put("Notification", (Object)imGroup.getNotification());
            }
            if (imGroup.getFaceUrl() != null) {
                jsonObject.put("FaceUrl", (Object)imGroup.getFaceUrl());
            }
            if (imGroup.getApplyJoinOption() != null) {
                jsonObject.put("ApplyJoinOption", (Object)imGroup.getApplyJoinOption());
            }
            if (imGroup.getMaxMemberCount() != null && imGroup.getMaxMemberCount() != 0) {
                jsonObject.put("MaxMemberCount", (Object)imGroup.getMaxMemberCount());
            }
        } else {
            jsonObject.put("Name", (Object)RandomUtil.getRandom8Length());
            jsonObject.put("Type", (Object)"Public");
        }
        if (txMembersList != null && txMembersList.size() > 0) {
            ArrayList jsonObjectList = new ArrayList();
            txMembersList.stream().forEach(m -> {
                JSONObject mem = new JSONObject();
                mem.put("Member_Account", (Object)m.getMemberAccount());
                jsonObjectList.add(mem);
            });
            jsonObject.put("MemberList", jsonObjectList);
        }
        String createResult = RestTemplateUtils.post((String)creatUrl, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        log.info("\u8bf7\u6c42URL ---{} ,\u8bf7\u6c42\u6570\u636e---{},\u817e\u8baf\u4e91\u521b\u5efa\u7fa4\u7ec4\u8fd4\u56de\u4fe1\u606f---{}", new Object[]{creatUrl, JsonUtil.convertObject((Object)jsonObject), createResult});
        if (StringUtils.isEmpty((CharSequence)createResult)) {
            return null;
        }
        return (IMCreatGroupRspVO)JSON.parseObject((String)createResult, IMCreatGroupRspVO.class);
    }

    private TencentBaseRsp txForbid(ImApplicationEntity application, IMForbidSendMsgReqVO reqVO) {
        String TX_FORBID_SEND_MSG = this.properties.getTencentImUrl().concat("/v4/group_open_http_svc/forbid_send_msg");
        String forbidUrl = this.createPostTencentUrl(TX_FORBID_SEND_MSG, application);
        log.info("\u817e\u8baf\u4e91\u8bbe\u7f6e\u7981\u8a00url:{}", (Object)forbidUrl);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("GroupId", (Object)reqVO.getGroupId());
        jsonObject.put("Members_Account", (Object)reqVO.getMembersAccount());
        jsonObject.put("ShutUpTime", (Object)reqVO.getShutUpTime());
        String createResult = RestTemplateUtils.post((String)forbidUrl, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        log.info("\u8bf7\u6c42\u7684url---{},\u8bf7\u6c42\u7684\u6570\u636e---{}\uff0c\u8bbe\u7f6e\u7981\u8a00\u817e\u8baf\u4e91\u8fd4\u56de\u4fe1\u606f---{}", new Object[]{forbidUrl, JsonUtil.convertObject((Object)jsonObject), createResult});
        if (StringUtils.isEmpty((CharSequence)createResult)) {
            return null;
        }
        return (TencentBaseRsp)JSON.parseObject((String)createResult, TencentBaseRsp.class);
    }

    public BaseResponse<?> optMember(IMChangeMemberReqVO reqVO) {
        TencentBaseRsp baseRsp;
        String treatmentId = reqVO.getTreatmentId();
        String busiCode = reqVO.getBusiCode();
        List memReqList = reqVO.getMembers();
        IMSaveSessionBO sessionBO = new IMSaveSessionBO(busiCode, treatmentId, "", "2");
        ImSessionEntity session = this.imSessionService.findMaxRoomNumAndSave(sessionBO);
        List members = this.imMemberRepository.findBySessionId(session.getId());
        ArrayList addMembers = new ArrayList();
        ArrayList delMembers = new ArrayList();
        ArrayList addSdkAccount = new ArrayList();
        ArrayList delSdkAccount = new ArrayList();
        ArrayList pushAccount = new ArrayList();
        ArrayList forbidAccounts = new ArrayList();
        HashMap map = new HashMap(16);
        String appKey = "app";
        Map<String, List<IMChangeMemVO>> mapByActionType = memReqList.stream().collect(Collectors.groupingBy(IMChangeMemVO::getActionType));
        mapByActionType.forEach((Key2, Value) -> {
            if ("ADD".equals(Key2)) {
                Map<String, List<IMChangeMemVO>> mapByAppCode = Value.stream().collect(Collectors.groupingBy(IMChangeMemVO::getAppCode));
                mapByAppCode.forEach((Keys, Values2) -> {
                    String appCode = Keys;
                    ImApplicationEntity application = this.imApplicationRepository.findByAppCode(appCode);
                    if (application == null) {
                        log.info("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)appCode);
                        return;
                    }
                    if (map.isEmpty()) {
                        map.put(appKey, application);
                    }
                    String appId = application.getId();
                    List memReqVOList = Values2;
                    memReqVOList.stream().forEach(mem -> {
                        String userId = mem.getUserId();
                        String formNick = mem.getFromNick();
                        String headLogo = mem.getHeadLogo();
                        IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, appCode, userId, formNick, headLogo);
                        ImAccountEntity account = this.imAccountService.saveOrQueryAccount(accountBO);
                        String sdkAccount = account.getSdkAccount();
                        pushAccount.add(sdkAccount);
                        long check = members.stream().filter(me -> {
                            String checkAccountId = me.getAccountId();
                            return checkAccountId.equals(account.getId());
                        }).count();
                        if (check != 0L) {
                            log.info("\u8be5sessionID -- {} \u4e0b\u6210\u5458\u5217\u8868\u4e2d\u5df2\u5b58\u5728\u8be5\u8d26\u53f7 -- {} ,\u4e0d\u6267\u884c\u65b0\u589e\u64cd\u4f5c! ", (Object)session.getId(), (Object)sdkAccount);
                            return;
                        }
                        ImMemberEntity member = new ImMemberEntity();
                        member.setSessionId(session.getId());
                        member.setAccountId(account.getId());
                        member.setDoctorId(mem.getDoctorId());
                        member.setPatientId(mem.getPatientId());
                        member.setTalkPermiss(mem.getPermission());
                        member.setPatIdCard(mem.getPatIdCardNo());
                        addMembers.add(member);
                        TxMemReqVO txMemReqVO = new TxMemReqVO();
                        txMemReqVO.setMemberAccount(sdkAccount);
                        addSdkAccount.add(txMemReqVO);
                        if (mem.getPermission().equals("0")) {
                            forbidAccounts.add(sdkAccount);
                        }
                    });
                });
            } else if ("DEL".equals(Key2)) {
                Map<String, List<IMChangeMemVO>> mapByAppCode = Value.stream().collect(Collectors.groupingBy(IMChangeMemVO::getAppCode));
                mapByAppCode.forEach((Keys, Values2) -> {
                    String appCode = Keys;
                    ImApplicationEntity application = this.imApplicationRepository.findByAppCode(appCode);
                    if (application == null) {
                        log.info("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)appCode);
                        return;
                    }
                    if (map.isEmpty()) {
                        map.put(appKey, application);
                    }
                    List memReqVOList = Values2;
                    memReqVOList.stream().forEach(mem -> {
                        String userId = mem.getUserId();
                        ImAccountEntity account = this.imAccountRepository.findByAppIdAndUserId(application.getId(), userId);
                        if (account == null) {
                            log.info("\u6267\u884c\u5220\u9664\u6210\u5458\u65f6\uff0c\u7ecf\u67e5\u8be2\uff0c\u8be5accountId = {} \u4e3a\u7a7a\uff0c\u6267\u884c\u8df3\u8fc7!");
                            return;
                        }
                        String sdkAccount = account.getSdkAccount();
                        members.stream().forEach(mems -> {
                            String checkAccountId = mems.getAccountId();
                            if (checkAccountId.equals(account.getId())) {
                                delMembers.add(mems);
                                delSdkAccount.add(sdkAccount);
                            } else {
                                log.info("\u8be5sessionID:--{} \u4e0b\u6210\u5458\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\u8be5\u8d26\u53f7 -- {} ,\u4e0d\u6267\u884c\u5220\u9664\u64cd\u4f5c! ", (Object)session.getId(), (Object)sdkAccount);
                            }
                        });
                    });
                });
            } else {
                log.info("\u65e0\u6cd5\u8bc6\u522bActionType =  {} \uff0c\u4e0d\u6267\u884c\u4efb\u4f55\u64cd\u4f5c\uff01", Key2);
            }
        });
        if (!pushAccount.isEmpty()) {
            this.imPushAccountService.pushAccount(((ImApplicationEntity)map.get(appKey)).getAppSdkId(), pushAccount);
        }
        if (!addMembers.isEmpty()) {
            this.imMemberRepository.saveAll(addMembers);
            TxAddMemberReqVO txAddMemberReq = new TxAddMemberReqVO();
            txAddMemberReq.setGroupId(session.getGroupId());
            txAddMemberReq.setMemberList(addSdkAccount);
            try {
                TxAddMemberRspVO rspVO = this.post2TencentAddMember((ImApplicationEntity)map.get(appKey), txAddMemberReq);
                if (rspVO == null) {
                    return BaseResponse.error((String)"\u5411\u817e\u8baf\u4e91\u8bf7\u6c42\u6dfb\u52a0\u7fa4\u7ec4\u6210\u5458\u5931\u8d25\uff01");
                }
                if ("FAIL".equalsIgnoreCase(rspVO.getActionStatus())) {
                    return BaseResponse.error((String)rspVO.getErrorInfo());
                }
            }
            catch (Exception e) {
                log.info("\u6dfb\u52a0\u7fa4\u7ec4\u6210\u5458\u5f02\u5e38\uff1a{}", (Throwable)e);
                return BaseResponse.error((String)"\u6dfb\u52a0\u7fa4\u7ec4\u6210\u5458\u5f02\u5e38\uff01");
            }
        }
        if (!delMembers.isEmpty()) {
            this.imMemberRepository.deleteAll(delMembers);
            TxDelMemberReqVO delMemberReqVO = new TxDelMemberReqVO();
            delMemberReqVO.setGroupId(session.getGroupId());
            delMemberReqVO.setMemberToDelAccount(delSdkAccount);
            try {
                baseRsp = this.post2TencentDelMember((ImApplicationEntity)map.get(appKey), delMemberReqVO);
                if (baseRsp == null) {
                    return BaseResponse.error((String)"\u5411\u817e\u8baf\u4e91\u8bf7\u6c42\u5220\u9664\u6210\u5458\u5931\u8d25\uff01");
                }
                if ("FAIL".equalsIgnoreCase(baseRsp.getActionStatus())) {
                    return BaseResponse.error((String)baseRsp.getErrorInfo());
                }
            }
            catch (Exception e) {
                log.info("\u6dfb\u52a0\u7fa4\u7ec4\u6210\u5458\u5f02\u5e38\uff01");
                return BaseResponse.error((String)"\u6dfb\u52a0\u7fa4\u7ec4\u6210\u5458\u5f02\u5e38\uff01");
            }
        }
        if (!forbidAccounts.isEmpty()) {
            IMForbidSendMsgReqVO forbidReqVO = new IMForbidSendMsgReqVO();
            forbidReqVO.setGroupId(session.getGroupId());
            forbidReqVO.setMembersAccount(forbidAccounts);
            forbidReqVO.setShutUpTime(Integer.valueOf(172800));
            try {
                baseRsp = this.txForbid((ImApplicationEntity)map.get(appKey), forbidReqVO);
                if (baseRsp == null) {
                    return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5931\u8d25!");
                }
                if ("FAIL".equalsIgnoreCase(baseRsp.getActionStatus())) {
                    return BaseResponse.error((String)baseRsp.getErrorInfo());
                }
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5f02\u5e38!");
            }
        }
        return BaseResponse.success((Object)"\u6267\u884c\u6210\u529f\uff01");
    }

    public TxAddMemberRspVO post2TencentAddMember(ImApplicationEntity application, TxAddMemberReqVO txAddMemberReq) {
        String TX_ADD_MEMBER = this.properties.getTencentImUrl().concat("/v4/group_open_http_svc/add_group_member");
        String addMemberUrl = this.createPostTencentUrl(TX_ADD_MEMBER, application);
        log.info("\u65b0\u589e\u6210\u5458URL:{}", (Object)addMemberUrl);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("GroupId", (Object)txAddMemberReq.getGroupId());
        jsonObject.put("Silence", (Object)1);
        ArrayList memList = new ArrayList();
        txAddMemberReq.getMemberList().stream().forEach(mem -> {
            JSONObject memAccount = new JSONObject();
            memAccount.put("Member_Account", (Object)mem.getMemberAccount());
            memList.add(memAccount);
        });
        jsonObject.put("MemberList", memList);
        String addResult = RestTemplateUtils.post((String)addMemberUrl, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        if (StringUtils.isBlank((CharSequence)addResult)) {
            return null;
        }
        return (TxAddMemberRspVO)JSON.parseObject((String)addResult, TxAddMemberRspVO.class);
    }

    private TencentBaseRsp post2TencentDelMember(ImApplicationEntity application, TxDelMemberReqVO delMemberReqVO) {
        String TX_DEL_MEMBER = this.properties.getTencentImUrl().concat("/v4/group_open_http_svc/delete_group_member");
        String delMember = this.createPostTencentUrl(TX_DEL_MEMBER, application);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("GroupId", (Object)delMemberReqVO.getGroupId());
        jsonObject.put("Silence", (Object)1);
        jsonObject.put("Reason", (Object)"\u4e1a\u52a1\u89e6\u53d1");
        jsonObject.put("MemberToDel_Account", (Object)delMemberReqVO.getMemberToDelAccount());
        String delResult = RestTemplateUtils.post((String)delMember, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        if (StringUtils.isBlank((CharSequence)delResult)) {
            return null;
        }
        return (TencentBaseRsp)JSON.parseObject((String)delResult, TencentBaseRsp.class);
    }

    public BaseResponse<?> optAuth(IMOptSpeakReqVO reqVO) {
        TencentBaseRsp baseRsp;
        IMForbidSendMsgReqVO forbidSendMsgReq;
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        List SpeakMembers = reqVO.getSpeakMembers();
        IMSaveSessionBO saveSessionBO = new IMSaveSessionBO(busiCode, treatmentId, "", "2");
        ImSessionEntity session = this.imSessionService.findMaxRoomNumAndSave(saveSessionBO);
        List members = this.imMemberRepository.findBySessionId(session.getId());
        if (members.isEmpty()) {
            return BaseResponse.error((String)"\u8be5\u4f1a\u8bdd\u91cc\u6ca1\u6709\u6210\u5458\uff01");
        }
        ArrayList openSpeak = new ArrayList();
        ArrayList closeSpeak = new ArrayList();
        HashMap map = new HashMap(16);
        String appKey = "app";
        SpeakMembers.stream().forEach(speakMem -> {
            String appCode = speakMem.getAppCode();
            String userId = speakMem.getUserId();
            String speakPermiss = speakMem.getSpeakPermiss();
            ImApplicationEntity application = this.imApplicationRepository.findByAppCode(appCode);
            if (application == null) {
                log.info("\u6839\u636e\u7f16\u7801[{}]\u67e5\u8be2\u5e94\u7528\u65f6\u4e3a\u7a7a!", (Object)appCode);
                return;
            }
            if (map.isEmpty()) {
                map.put(appKey, application);
            }
            IMSaveAccountBO accountBO = new IMSaveAccountBO(application.getId(), appCode, userId, "", "");
            ImAccountEntity speakMemAccount = this.imAccountService.saveOrQueryAccount(accountBO);
            String speakMemSdkAccount = speakMemAccount.getSdkAccount();
            members.stream().forEach(mem -> {
                String TalkPermiss = mem.getTalkPermiss();
                String checkAccountId = mem.getAccountId();
                if (checkAccountId.equals(speakMemAccount.getId())) {
                    if (TalkPermiss.equals(speakPermiss)) {
                        log.info("sdkAccount\u4e3a\uff1a{} \u7684\u53d1\u8a00\u6743\u9650\u672a\u6539\u53d8\uff01", (Object)speakMemSdkAccount);
                        return;
                    }
                    if ("1".equals(speakPermiss) && "0".equals(TalkPermiss)) {
                        mem.setTalkPermiss(speakPermiss);
                        openSpeak.add(speakMemSdkAccount);
                        log.info("sdkAccount\u4e3a\uff1a{} \u7684\u53d1\u8a00\u6743\u9650\u7531 {} \u53d8\u4e3a {}", new Object[]{speakMemAccount, TalkPermiss, speakPermiss});
                    } else if ("0".equals(speakPermiss) && "1".equals(TalkPermiss)) {
                        mem.setTalkPermiss(speakPermiss);
                        closeSpeak.add(speakMemSdkAccount);
                        log.info("sdkAccount\u4e3a\uff1a{} \u7684\u53d1\u8a00\u6743\u9650\u7531 {} \u53d8\u4e3a {}", new Object[]{speakMemAccount, TalkPermiss, speakPermiss});
                    }
                }
            });
        });
        if (!openSpeak.isEmpty()) {
            forbidSendMsgReq = new IMForbidSendMsgReqVO();
            forbidSendMsgReq.setGroupId(session.getGroupId());
            forbidSendMsgReq.setMembersAccount(openSpeak);
            forbidSendMsgReq.setShutUpTime(Integer.valueOf(0));
            try {
                baseRsp = this.txForbid((ImApplicationEntity)map.get(appKey), forbidSendMsgReq);
                if (baseRsp == null) {
                    return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5931\u8d25\uff01");
                }
                if ("FAIL".equals(baseRsp.getActionStatus())) {
                    return BaseResponse.error((String)baseRsp.getErrorInfo());
                }
                this.imMemberRepository.saveAll((Iterable)members);
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5f02\u5e38!");
            }
        }
        if (!closeSpeak.isEmpty()) {
            forbidSendMsgReq = new IMForbidSendMsgReqVO();
            forbidSendMsgReq.setGroupId(session.getGroupId());
            forbidSendMsgReq.setMembersAccount(closeSpeak);
            forbidSendMsgReq.setShutUpTime(Integer.valueOf(172800));
            try {
                baseRsp = this.txForbid((ImApplicationEntity)map.get(appKey), forbidSendMsgReq);
                if (baseRsp == null) {
                    return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5931\u8d25\uff01");
                }
                if ("FAIL".equals(baseRsp.getActionStatus())) {
                    return BaseResponse.error((String)baseRsp.getErrorInfo());
                }
                this.imMemberRepository.saveAll((Iterable)members);
            }
            catch (Exception e) {
                return BaseResponse.error((String)"\u8bbe\u7f6e\u7981\u8a00\u5f02\u5e38!");
            }
        }
        return BaseResponse.success((Object)"\u6267\u884c\u6210\u529f\uff01");
    }

    private String createPostTencentUrl(String prefixUrl, ImApplicationEntity app) {
        String appId = app.getId();
        String userId = app.getSysAdmin();
        IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, "", userId, "\u7ba1\u7406\u5458", "");
        ImAccountEntity accountEntity = this.imAccountService.saveOrQueryAccount(accountBO);
        String accountId = accountEntity.getId();
        IMSaveSigBO sigBo = new IMSaveSigBO(app.getAppSdkId(), userId, accountId);
        ImSigEntity sig = this.sigService.saveSig(sigBo);
        StringBuilder urlBuilder = new StringBuilder(prefixUrl);
        urlBuilder.append("?usersig=");
        urlBuilder.append(sig.getAccountSig());
        urlBuilder.append("&");
        urlBuilder.append("identifier=");
        urlBuilder.append(userId);
        urlBuilder.append("&");
        urlBuilder.append("sdkappid=");
        urlBuilder.append(app.getAppSdkId());
        urlBuilder.append("&");
        urlBuilder.append("random=");
        urlBuilder.append(99999999);
        urlBuilder.append("&");
        urlBuilder.append("contenttype=");
        urlBuilder.append("json");
        return urlBuilder.toString();
    }

    @Async
    public String autoGenerationStreamid(AutoGenerationStreamidDTO autoGenerationStreamidDTO) {
        log.info("====\u751f\u6210streamId==, \u5165\u53c2\uff1aautoGenerationStreamidDTO:{}", (Object)JSON.toJSONString((Object)autoGenerationStreamidDTO));
        long timeStamp = System.currentTimeMillis() / 1000L;
        long timeOffset = timeStamp + 60L;
        List list = this.liveAppRepository.findAll();
        IMLiveApplicationEntity liveApp = (IMLiveApplicationEntity)list.get(0);
        String sign = MD5Utils.string2MD5((String)(liveApp.getApiKey() + timeOffset));
        if (StringUtils.isEmpty((CharSequence)autoGenerationStreamidDTO.getUserId())) {
            log.error("====\u751f\u6210streamId== \u4f20\u5165\u521b\u5efa\u8005\u4fe1\u606f\u4e3a\u7a7a doctorid\uff1a{}");
            throw new RuntimeException("\u975e\u6cd5\u53c2\u6570,CreateUser\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ImApplicationEntity app = this.appRepository.findByAppCode(autoGenerationStreamidDTO.getAppCode());
        ImAccountEntity accountEntity = this.accountRepository.findByAppIdAndUserId(app.getId(), autoGenerationStreamidDTO.getUserId());
        log.info("====\u751f\u6210streamId==--\u521b\u5efa\u8005userid\uff1a{} \u548c\u4e92\u8054\u7f51\u533b\u9662\u533b\u751f\u7aefappid:{} \u67e5\u8be2\u6570\u636e\u5e93\uff0c\u83b7\u53d6\u8d26\u6237\u4fe1\u606faccountEntity\uff1a{}", new Object[]{autoGenerationStreamidDTO.getUserId(), app.getId(), accountEntity});
        if (accountEntity == null) {
            IMSaveAccountBO accountBO = new IMSaveAccountBO(app.getId(), autoGenerationStreamidDTO.getAppCode(), autoGenerationStreamidDTO.getUserId(), "\u6682\u65e0", "");
            accountEntity = this.imAccountService.saveOrQueryAccount(accountBO);
            IMSaveSigBO sigBO = new IMSaveSigBO(app.getAppSdkId(), accountEntity.getSdkAccount(), accountEntity.getId());
            this.sigService.saveSig(sigBO);
            ArrayList<String> pushAccount2Tencentlist = new ArrayList<String>();
            pushAccount2Tencentlist.add(accountEntity.getSdkAccount());
            if (!pushAccount2Tencentlist.isEmpty()) {
                log.info("====\u751f\u6210streamId==\u521b\u5efa\u7fa4\u7ec4 \u4e0a\u4f20\u6210\u5458\u8d26\u53f7\u5230\u817e\u8baf\u4e91\uff1a{}", pushAccount2Tencentlist);
                this.imPushAccountService.pushAccount(app.getAppSdkId(), pushAccount2Tencentlist);
            }
        }
        String sdkAccount = accountEntity.getSdkAccount();
        String streamId = liveApp.getBizId().concat("_").concat(MD5Utils.string2MD5((String)(autoGenerationStreamidDTO.getRoomNum() + "_" + sdkAccount + "_main")));
        log.info("====\u751f\u6210streamId== \u751f\u6210streamId  \u5b8c\u6210 streamId\uff1a{}", (Object)streamId);
        String mix_stream_session_id = "common_access" + sdkAccount;
        IMMixtedFlowEntity mf = new IMMixtedFlowEntity();
        IMProductTypeEntity productTypeEntity = this.productTypeRepository.findByBusiCode(autoGenerationStreamidDTO.getBusiCode());
        if (productTypeEntity == null) {
            log.error("\u6839\u636ebusicode\u67e5\u8be2\u5ba2\u6237\u7aef\u4fe1\u606f \u5ba2\u6237\u7aef\u4fe1\u606f\u4e0d\u5b58\u5728,busiCode:" + autoGenerationStreamidDTO.getBusiCode());
        }
        mf.setProductId(productTypeEntity == null ? "2" : productTypeEntity.getId());
        mf.setMixStreamSessionId(mix_stream_session_id);
        mf.setSign(sign);
        mf.setTimestamp(Long.valueOf(timeStamp));
        mf.setSessionId(autoGenerationStreamidDTO.getSessionId());
        mf.setStreamId(streamId);
        this.mixtedFlowRepository.saveAndFlush((Object)mf);
        log.info("====\u751f\u6210streamId==  \u6210\u529f  \u623f\u95f4\u53f7:{}, streamId:{},", (Object)autoGenerationStreamidDTO.getRoomNum(), (Object)streamId);
        return streamId;
    }

    public BaseResponse<IMGroupMemberManagerVO> groupMember(IMGroupMemberReqVO reqVO) {
        List imGroupMemberVOS = this.imMsgDao.groupMember(reqVO);
        IMGroupMemberManagerVO imGroupMemberManagerVO = new IMGroupMemberManagerVO();
        imGroupMemberManagerVO.setImGroupMemberVOS(imGroupMemberVOS);
        if (null != imGroupMemberVOS && imGroupMemberVOS.size() > 0) {
            imGroupMemberManagerVO.setUserId(((IMGroupMemberVO)imGroupMemberVOS.get(0)).getCreateUser());
            imGroupMemberManagerVO.setTreatmentId(((IMGroupMemberVO)imGroupMemberVOS.get(0)).getTreatmentId());
            imGroupMemberManagerVO.setRoomNum(((IMGroupMemberVO)imGroupMemberVOS.get(0)).getRoomNum());
        }
        return BaseResponse.success((Object)imGroupMemberManagerVO);
    }

    public BaseResponse<List<IMGroupListVO>> groupList(String userId) {
        return BaseResponse.success((Object)this.imMsgDao.groupList(userId));
    }

    public BaseResponse<Boolean> updateGroupLogoAndName(IMGroupListVO imGroupListVO) {
        ImSessionEntity byGroupIdAndRoomNum = this.imSessionRepository.findByGroupIdAndRoomNum(imGroupListVO.getGroupId(), Long.valueOf(imGroupListVO.getRoomNum()));
        if (null == byGroupIdAndRoomNum) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u7fa4\u7ec4");
        }
        if (StringUtils.isNotEmpty((CharSequence)imGroupListVO.getGroupLogo())) {
            byGroupIdAndRoomNum.setGroupLogo(imGroupListVO.getGroupLogo());
        }
        if (StringUtils.isNotEmpty((CharSequence)imGroupListVO.getGroupName())) {
            byGroupIdAndRoomNum.setGroupName(imGroupListVO.getGroupName());
        }
        ImSessionEntity save = (ImSessionEntity)this.imSessionRepository.saveAndFlush((Object)byGroupIdAndRoomNum);
        log.info("\u4fee\u6539\u7fa4\u540d\u79f0\u6216logo\u8fd4\u56de\uff1a{}", (Object)JsonUtil.convertObject((Object)save));
        return BaseResponse.success((Object)true);
    }

    public BaseResponse<Boolean> destroyGroup(IMGroupDestroyVO imGroupDestroyVO) {
        ImSessionEntity byGroupIdAndRoomNum = this.imSessionRepository.findByGroupIdAndRoomNum(imGroupDestroyVO.getGroupId(), Long.valueOf(imGroupDestroyVO.getRoomNum()));
        if (null == byGroupIdAndRoomNum) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u8be5\u7fa4\u7ec4");
        }
        ImApplicationEntity application = this.imApplicationRepository.findByAppCode(imGroupDestroyVO.getAppCode());
        String TX_CREATE_GROUP = this.properties.getTencentImUrl().concat("/v4/group_open_http_svc/destroy_group");
        String creatUrl = this.createPostTencentUrl(TX_CREATE_GROUP, application);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("GroupId", (Object)imGroupDestroyVO.getGroupId());
        String createResult = RestTemplateUtils.post((String)creatUrl, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        log.info("\u8bf7\u6c42URL ---{} ,\u8bf7\u6c42\u6570\u636e---{},\u817e\u8baf\u4e91\u89e3\u6563\u7fa4\u7ec4\u8fd4\u56de\u4fe1\u606f---{}", new Object[]{creatUrl, JsonUtil.convertObject((Object)jsonObject), createResult});
        if (StringUtils.isEmpty((CharSequence)createResult)) {
            return BaseResponse.error((String)"fail");
        }
        TencentBaseRsp tencentBaseRsp = (TencentBaseRsp)JSON.parseObject((String)createResult, TencentBaseRsp.class);
        if ("OK".equals(tencentBaseRsp.getActionStatus())) {
            byGroupIdAndRoomNum.setGroupDie("2");
            this.imSessionRepository.saveAndFlush((Object)byGroupIdAndRoomNum);
            return BaseResponse.success((Object)true);
        }
        return BaseResponse.error((String)"fail");
    }
}

