/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.IMCommonApi;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.IMProductTypeEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.vo.IMStartMixedFlowReqVO;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.IMProductTypeRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.util.MD5Utils;
import com.hxgy.im.util.RedisUtil;
import com.hxgy.im.util.UUIDUtil;
import com.tencentcloudapi.common.AbstractModel;
import com.tencentcloudapi.common.Credential;
import com.tencentcloudapi.common.exception.TencentCloudSDKException;
import com.tencentcloudapi.common.profile.ClientProfile;
import com.tencentcloudapi.common.profile.HttpProfile;
import com.tencentcloudapi.trtc.v20190722.TrtcClient;
import com.tencentcloudapi.trtc.v20190722.models.EncodeParams;
import com.tencentcloudapi.trtc.v20190722.models.LayoutParams;
import com.tencentcloudapi.trtc.v20190722.models.OutputParams;
import com.tencentcloudapi.trtc.v20190722.models.StartMCUMixTranscodeRequest;
import com.tencentcloudapi.trtc.v20190722.models.StartMCUMixTranscodeResponse;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@CrossOrigin
public class IMCommonController
implements IMCommonApi {
    private static final Logger log = LoggerFactory.getLogger(IMCommonController.class);
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private IMProductTypeRepository productTypeRepository;
    @Autowired
    private RedissonClient redissonClient;
    @Autowired
    private RedisUtil redisUtil;
    private static final Long LOCK_TIME = 3L;
    private static final Long WAIT_TIME = 3L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public BaseResponse<?> tencentCloudMixedFlow(@RequestBody IMStartMixedFlowReqVO reqVO) {
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        String productCode = reqVO.getProductCode();
        ImSessionEntity imSessionEntity = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (imSessionEntity == null) {
            return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        IMMixtedFlowEntity imMixtedFlowEntity = new IMMixtedFlowEntity();
        IMProductTypeEntity imProductTypeEntity = this.productTypeRepository.findByProductCode(productCode);
        if (imProductTypeEntity != null) {
            imMixtedFlowEntity.setProductId(imProductTypeEntity.getId());
        }
        imMixtedFlowEntity.setSessionId(imSessionEntity.getId());
        Long roomId = imSessionEntity.getRoomNum();
        if (roomId == null) {
            return BaseResponse.error((String)"\u623f\u95f4\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        RLock rLock = this.redissonClient.getLock(roomId + "mix");
        try {
            boolean tryLock = rLock.tryLock(WAIT_TIME.longValue(), LOCK_TIME.longValue(), TimeUnit.SECONDS);
            if (!tryLock) {
                BaseResponse baseResponse = BaseResponse.error((String)"\u83b7\u53d6\u9501\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u8c03\u7528\uff01");
                return baseResponse;
            }
            long expire = this.redisUtil.getExpire(roomId + "mix:mark");
            if (expire > 0L) {
                log.info("\u623f\u95f4\u5df2\u7ecf\u88ab\u6807\u8bb0 roomId = {}", (Object)roomId);
                BaseResponse baseResponse = BaseResponse.success();
                return baseResponse;
            }
            this.mix(imMixtedFlowEntity, roomId);
            this.redisUtil.set(roomId + "mix:mark", (Object)"123", 648000L);
            rLock.unlock();
        }
        catch (InterruptedException e) {
            log.error("\u83b7\u53d6\u9501\u5931\u8d25\u6216\u4e1a\u52a1\u5904\u7406\u5f02\u5e38", (Throwable)e);
            BaseResponse baseResponse = BaseResponse.error((String)"\u83b7\u53d6\u9501\u5931\u8d25\u6216\u4e1a\u52a1\u5904\u7406\u5f02\u5e38\uff01");
            return baseResponse;
        }
        finally {
            boolean locked = rLock.isLocked();
            if (locked) {
                rLock.unlock();
            }
        }
        return BaseResponse.success();
    }

    private void mix(IMMixtedFlowEntity imMixtedFlowEntity, Long roomId) {
        String streamId = MD5Utils.string2MD5((String)(roomId + "" + UUIDUtil.getUUID()));
        imMixtedFlowEntity.setStreamId("1400088738_" + streamId);
        this.mixtedFlowRepository.saveAndFlush((Object)imMixtedFlowEntity);
        try {
            Credential cred = new Credential("AKIDN0ECtPKg17wBAtrIq7j4HI2V1LOAlvqU", "XoOjnaU7TYLqiSDh5TaQz2pMdr42jMwl");
            HttpProfile httpProfile = new HttpProfile();
            httpProfile.setEndpoint("trtc.tencentcloudapi.com");
            ClientProfile clientProfile = new ClientProfile();
            clientProfile.setHttpProfile(httpProfile);
            TrtcClient client = new TrtcClient(cred, "ap-beijing", clientProfile);
            StartMCUMixTranscodeRequest mcuMixTranscodeRequest = new StartMCUMixTranscodeRequest();
            OutputParams outputParams = new OutputParams();
            outputParams.setStreamId(streamId);
            outputParams.setPureAudioStream(Long.valueOf(0L));
            outputParams.setRecordId(streamId + "record_id");
            outputParams.setRecordAudioOnly(Long.valueOf(0L));
            mcuMixTranscodeRequest.setOutputParams(outputParams);
            EncodeParams encodeParams = new EncodeParams();
            encodeParams.setVideoWidth(Long.valueOf(1280L));
            encodeParams.setVideoHeight(Long.valueOf(720L));
            encodeParams.setVideoBitrate(Long.valueOf(1560L));
            encodeParams.setVideoFramerate(Long.valueOf(15L));
            encodeParams.setVideoGop(Long.valueOf(2L));
            encodeParams.setBackgroundColor(Long.valueOf(0L));
            encodeParams.setAudioSampleRate(Long.valueOf(48000L));
            encodeParams.setAudioBitrate(Long.valueOf(64L));
            encodeParams.setAudioChannels(Long.valueOf(2L));
            mcuMixTranscodeRequest.setEncodeParams(encodeParams);
            LayoutParams layoutParams = new LayoutParams();
            layoutParams.setTemplate(Long.valueOf(1L));
            layoutParams.setMainVideoUserId("main_pc");
            layoutParams.setMainVideoStreamType(Long.valueOf(1L));
            mcuMixTranscodeRequest.setLayoutParams(layoutParams);
            mcuMixTranscodeRequest.setSdkAppId(Long.valueOf(1400088738L));
            mcuMixTranscodeRequest.setRoomId(roomId);
            log.info("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u53c2\u6570{}", (Object)StartMCUMixTranscodeRequest.toJsonString((AbstractModel)mcuMixTranscodeRequest));
            StartMCUMixTranscodeResponse startMCUMixTranscodeResponse = client.StartMCUMixTranscode(mcuMixTranscodeRequest);
            if (startMCUMixTranscodeResponse == null) {
                throw new RuntimeException("\u817e\u8bafIM mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u8fd4\u56de\u7ed3\u679c\u4e3a\u7a7a\uff01");
            }
            log.info("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u7ed3\u679c{}", (Object)StartMCUMixTranscodeResponse.toJsonString((AbstractModel)startMCUMixTranscodeResponse));
        }
        catch (TencentCloudSDKException e) {
            log.error("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("mcu\u6df7\u6d41\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01");
        }
    }
}

