/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.enums.BusiPushStatusEnum;
import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.pojo.bo.mixflow.IMMixFlow2BusinessBO;
import com.hxgy.im.pojo.entity.IMBusiPushConfigEntity;
import com.hxgy.im.pojo.entity.IMLiveApplicationEntity;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.IMProductTypeEntity;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImMediaProcessEntity;
import com.hxgy.im.pojo.entity.ImMemberEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.vo.IMMixtedFlowCallbackReqVO;
import com.hxgy.im.pojo.vo.IMStartMixedFlowReqVO;
import com.hxgy.im.repository.IMLiveApplicationRepository;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.IMProductTypeRepository;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImBusiPushConfigRepository;
import com.hxgy.im.repository.ImMemberRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.repository.mapper.ImMixtedFlowMapper;
import com.hxgy.im.service.BaseService;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.service.IMCommonService;
import com.hxgy.im.service.MediaProcessService;
import com.hxgy.im.util.MD5Utils;
import com.hxgy.im.util.RandomUtil;
import com.hxgy.im.util.RestTemplateUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.http.MediaType;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class IMCommonServiceImpl
extends BaseService
implements IMCommonService {
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private ImMemberRepository memberRepository;
    @Autowired
    private IMLiveApplicationRepository liveAppRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private ImMixtedFlowMapper imMixtedFlowMapper;
    @Autowired
    private IMProductTypeRepository productTypeRepository;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private MediaProcessService mediaProcessService;
    @Autowired
    private ImBusiPushConfigRepository pushConfigRepository;
    @Resource(name="toTestAsyncPool")
    private ThreadPoolTaskExecutor toTestAsyncPool;
    @Autowired
    private IMBusiPushService imBusiPushService;
    private static final Logger log = LoggerFactory.getLogger(IMCommonServiceImpl.class);

    public BaseResponse<?> startMixedFlow(IMStartMixedFlowReqVO reqVO) {
        String treatmentId;
        String TX_COMMON_ACCESS = this.txVideoUrl.concat("/common_access");
        String busiCode = reqVO.getBusiCode();
        ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId = reqVO.getTreatmentId());
        if (session == null) {
            log.error("\u6839\u636ebusiCode = {}, treatmentId = {} \u67e5\u8be2session\u65f6\u4e3a\u7a7a!", (Object)busiCode, (Object)treatmentId);
            return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728");
        }
        long timeStamp = System.currentTimeMillis() / 1000L;
        long timeOffset = timeStamp + 60L;
        List list = this.liveAppRepository.findAll();
        IMLiveApplicationEntity liveApp = (IMLiveApplicationEntity)list.get(0);
        String sign = MD5Utils.string2MD5((String)(liveApp.getApiKey() + timeOffset));
        int random = RandomUtil.getMin2MaxBetweenRandom((Integer)1, (Integer)Integer.MAX_VALUE);
        String postUrl = TX_COMMON_ACCESS.concat("?").concat("appid=").concat(liveApp.getAppId()).concat("&interface=Mix_StreamV2").concat("&t=").concat(timeOffset + "").concat("&sign=").concat(sign);
        List members = this.memberRepository.findBySessionId(session.getId());
        Map<String, ImMemberEntity> map = members.stream().collect(Collectors.toMap(ImMemberEntity::getMixFlowType, a -> a, (k1, k2) -> k1));
        ImMemberEntity master = map.get("master");
        ImMemberEntity slave = map.get("slave");
        ImAccountEntity masterAccount = (ImAccountEntity)this.accountRepository.findById((Object)master.getAccountId()).get();
        ImAccountEntity slaveAccount = (ImAccountEntity)this.accountRepository.findById((Object)slave.getAccountId()).get();
        String masterIo = MD5Utils.string2MD5((String)(session.getRoomNum() + "_" + masterAccount.getSdkAccount() + "_main"));
        String slaveIo = MD5Utils.string2MD5((String)(session.getRoomNum() + "_" + slaveAccount.getSdkAccount() + "_main"));
        String mix_stream_session_id = "common_access".concat(masterIo);
        JSONObject params = this.createParamAccess(masterIo, slaveIo, mix_stream_session_id, timeStamp, Integer.valueOf(random), liveApp.getAppId());
        log.info("\u6df7\u6d41 \u751f\u6210streamID:{}", (Object)masterIo);
        log.info("\u6df7\u6d41\u8bf7\u6c42\u53c2\u6570:{}   \u5927\u5c0f\u5c4f-------\u6a21\u5f0f", (Object)params.toString());
        String result = RestTemplateUtils.post((String)postUrl, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
        log.info("\u817e\u8baf\u8fd4\u56de\u53c2\u6570:{}", (Object)result);
        if (StringUtils.isBlank((CharSequence)result)) {
            return BaseResponse.error((String)"\u817e\u8baf\u8fd4\u56de\u7a7a!");
        }
        JSONObject resultConvert = JSON.parseObject((String)result);
        int code = resultConvert.getIntValue("code");
        if (0 != code) {
            return BaseResponse.error((String)resultConvert.getString("message"));
        }
        IMMixtedFlowEntity mf = new IMMixtedFlowEntity();
        mf.setEventId(resultConvert.getString("event_id"));
        mf.setMixStreamSessionId(mix_stream_session_id);
        IMProductTypeEntity product = this.productTypeRepository.findByProductCode(reqVO.getProductCode());
        if (product != null) {
            mf.setProductId(product.getId());
        } else {
            log.error("product is null ", (Object)product);
        }
        mf.setSign(sign);
        mf.setRequestParams(JSON.toJSONString((Object)reqVO));
        mf.setTimestamp(Long.valueOf(timeStamp));
        mf.setTxResult(result);
        mf.setSessionId(session.getId());
        mf.setStreamId("1400088738_" + masterIo);
        this.mixtedFlowRepository.saveAndFlush((Object)mf);
        return BaseResponse.success((Object)result);
    }

    private JSONObject createParamAccess(String master, String slave, String mix_stream_session_id, long timeStamp, Integer random, String appid) {
        JSONObject list1 = new JSONObject();
        JSONObject list2 = new JSONObject();
        JSONObject image_layer1 = new JSONObject();
        JSONObject image_layer2 = new JSONObject();
        image_layer1.put("image_layer", (Object)1);
        image_layer2.put("image_layer", (Object)2);
        list1.put("input_stream_id", (Object)master);
        list1.put("layout_params", (Object)image_layer1);
        list2.put("input_stream_id", (Object)slave);
        list2.put("layout_params", (Object)image_layer2);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        list.add(list1);
        list.add(list2);
        JSONObject para = new JSONObject();
        para.put("interface", (Object)"mix_streamv2.start_mix_stream_advanced");
        para.put("app_id", (Object)appid);
        para.put("domain", (Object)"");
        para.put("path", (Object)"");
        para.put("mix_stream_template_id", (Object)20);
        para.put("mix_stream_session_id", (Object)mix_stream_session_id);
        para.put("output_stream_id", (Object)master);
        para.put("input_stream_list", list);
        JSONObject interfaceParam = new JSONObject();
        interfaceParam.put("interfaceName", (Object)"Mix_StreamV2");
        interfaceParam.put("para", (Object)para);
        JSONObject param = new JSONObject();
        param.put("timestamp", (Object)Integer.parseInt(String.valueOf(timeStamp)));
        param.put("eventId", (Object)random);
        param.put("interface", (Object)interfaceParam);
        return param;
    }

    private JSONObject createParamAccessRL(String master, String slave, String mix_stream_session_id, long timeStamp, Integer random, String appid) {
        JSONObject jsonContent = new JSONObject();
        Long timestamp = System.currentTimeMillis() / 1000L;
        jsonContent.put("timestamp", (Object)timestamp);
        jsonContent.put("eventId", (Object)random);
        JSONObject jsonObject1 = new JSONObject();
        jsonContent.put("interface", (Object)jsonObject1);
        jsonObject1.put("interfaceName", (Object)"Mix_StreamV2");
        JSONObject jsonObject2 = new JSONObject();
        jsonObject2.put("interface", (Object)"mix_streamv2.start_mix_stream_advanced");
        jsonObject2.put("app_id", (Object)appid);
        jsonObject2.put("domain", (Object)"");
        jsonObject2.put("path", (Object)"");
        jsonObject2.put("mix_stream_template_id", (Object)390);
        jsonObject2.put("mix_stream_session_id", (Object)mix_stream_session_id);
        jsonObject2.put("output_stream_id", (Object)master);
        jsonObject1.put("para", (Object)jsonObject2);
        JSONArray jsonArray = new JSONArray();
        JSONObject jsonObject3 = new JSONObject();
        jsonObject3.put("input_stream_id", (Object)"canvas1");
        JSONObject jsonObject4 = new JSONObject();
        jsonObject4.put("image_layer", (Object)1);
        jsonObject4.put("input_type", (Object)2);
        jsonObject4.put("color", (Object)"0x000000");
        jsonObject3.put("layout_params", (Object)jsonObject4);
        jsonArray.add((Object)jsonObject3);
        JSONObject jsonObject5 = new JSONObject();
        jsonObject5.put("input_stream_id", (Object)master);
        JSONObject jsonObject6 = new JSONObject();
        jsonObject6.put("image_layer", (Object)2);
        jsonObject6.put("picture_id", (Object)"425078");
        jsonObject5.put("layout_params", (Object)jsonObject6);
        jsonArray.add((Object)jsonObject5);
        JSONObject jsonObject7 = new JSONObject();
        jsonObject7.put("input_stream_id", (Object)slave);
        JSONObject jsonObject8 = new JSONObject();
        jsonObject8.put("image_layer", (Object)3);
        jsonObject8.put("picture_id", (Object)"425078");
        jsonObject7.put("layout_params", (Object)jsonObject8);
        jsonArray.add((Object)jsonObject7);
        jsonObject2.put("input_stream_list", (Object)jsonArray);
        return jsonContent;
    }

    public void endMixedFlow2Business(IMMixtedFlowCallbackReqVO reqVO) {
        IMMixtedFlowEntity flowEntity;
        boolean flag = false;
        String channelId = reqVO.getChannel_id();
        if (!channelId.contains("1400088738_")) {
            flag = true;
        }
        String streamId = reqVO.getStream_id();
        log.info("\u89c6\u9891\u6df7\u6d41\u56de\u8c03\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)reqVO, (boolean)true));
        List mixtedFlows = this.mixtedFlowRepository.findAll((Specification & Serializable)(root, query, cb) -> {
            ArrayList<Predicate> filters = new ArrayList<Predicate>();
            filters.add(cb.like((Expression)root.get("streamId"), "%" + streamId));
            filters.add(root.get("fileId").isNull());
            query.where(filters.toArray(new Predicate[filters.size()]));
            return null;
        });
        log.info("//////////=1=//////////");
        if (mixtedFlows == null || mixtedFlows.isEmpty()) {
            log.info("//////////=2=//////////");
            log.info("\u6839\u636e fileId= null \u548c streamId = {} ,\u67e5\u627e\u6570\u636e\u4e3a\u7a7a!", (Object)streamId);
            flowEntity = this.imMixtedFlowMapper.findOneByStreamIdAndFileId(streamId, reqVO.getFile_id());
            if (flowEntity != null) {
                log.info("\u6839\u636e fileId= {} \u548c streamId = {} ,\u67e5\u627e\u6570\u636e\u5df2\u5b58\u5728!", (Object)reqVO.getFile_id(), (Object)streamId);
                return;
            }
            IMMixtedFlowEntity flowDataEntity = this.imMixtedFlowMapper.findOneByStreamId(streamId);
            if (flowDataEntity == null) {
                this.toTestAsyncPool.execute(() -> this.medioCallbackProToTest(reqVO));
                return;
            }
            flowDataEntity.setId(UUID.randomUUID().toString().replaceAll("-", ""));
            flowDataEntity.setCallBackBusiness("1");
            flowDataEntity.setCallBackedTencent("1");
            flowDataEntity.setVideoId(reqVO.getVideo_id());
            flowDataEntity.setCallBackParams(JSON.toJSONString((Object)reqVO));
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            flowDataEntity.setUpdateDateTime(format.format(new Date()));
            flowDataEntity.setFileId(reqVO.getFile_id());
            log.info("\u65b0\u63d2\u5165\u56de\u8c03\u89c6\u9891\u6570\u636e--" + JSON.toJSONString((Object)flowDataEntity));
            this.imMixtedFlowMapper.insert(flowDataEntity);
            flag = true;
        } else {
            log.info("//////////=3=//////////");
            flowEntity = mixtedFlows.iterator();
            if (flowEntity.hasNext()) {
                IMMixtedFlowEntity flowData = (IMMixtedFlowEntity)flowEntity.next();
                flowData.setCallBackBusiness("1");
                flowData.setCallBackedTencent("1");
                flowData.setCallBackParams(JSON.toJSONString((Object)reqVO));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                flowData.setUpdateDateTime(format.format(new Date()));
                flowData.setVideoId(reqVO.getVideo_id());
                flowData.setFileId(reqVO.getFile_id());
                log.info("\u66f4\u65b0\u56de\u8c03\u89c6\u9891\u6570\u636e--" + JSON.toJSONString((Object)flowData));
                this.imMixtedFlowMapper.update(flowData);
            }
        }
        log.info("//////////=4=//////////");
        if (!reqVO.getVideo_url().toLowerCase().endsWith("mp4")) {
            ImMediaProcessEntity mediaProcessEntity = new ImMediaProcessEntity();
            mediaProcessEntity.setFileId(reqVO.getFile_id());
            mediaProcessEntity.setDuration(Long.valueOf(reqVO.getDuration().intValue()));
            mediaProcessEntity.setSize(Long.valueOf(reqVO.getFile_size().intValue()));
            mediaProcessEntity.setVideoUrl(reqVO.getVideo_url());
            mediaProcessEntity.setEndTime(Long.valueOf(reqVO.getEnd_time().intValue()));
            mediaProcessEntity.setStartTime(Long.valueOf(reqVO.getStart_time().intValue()));
            mediaProcessEntity.setVideoId(reqVO.getVideo_id());
            mediaProcessEntity.setFileId(reqVO.getFile_id());
            this.mediaProcessService.save(mediaProcessEntity);
            log.info("//////////=5=//////////");
            this.pushMediaToBusiness(reqVO, flag);
        }
    }

    private void pushToMq(IMMixtedFlowEntity flowData, IMMixtedFlowCallbackReqVO reqVO) {
        ImSessionEntity sessionEntity = (ImSessionEntity)this.sessionRepository.findById((Object)flowData.getSessionId()).get();
        IMMixFlow2BusinessBO bo = new IMMixFlow2BusinessBO();
        bo.setBusiCode(sessionEntity.getBusiCode());
        bo.setTreatmentId(sessionEntity.getTreatmentId());
        bo.setEndTime((long)reqVO.getEnd_time().intValue());
        bo.setStartTime((long)reqVO.getStart_time().intValue());
        bo.setVideoUrl(reqVO.getVideo_url());
        String productId = flowData.getProductId();
        IMProductTypeEntity product = (IMProductTypeEntity)this.productTypeRepository.findById((Object)productId).get();
        if (product == null) {
            log.error("\u6b64\u4ea7\u54c1\u5ba2\u6237\u7aef\u4e0d\u5b58\u5728\uff1a{}", (Object)productId);
            return;
        }
        if ("mq".equalsIgnoreCase(product.getEnableType())) {
            log.info("\u56de\u8c03\u6a21\u5f0f\uff1a{}", (Object)product.getEnableType());
            this.rabbitTemplate.convertAndSend(product.getExchange(), product.getRouteKey(), (Object)JSON.toJSONString((Object)bo));
            log.info("mq\u6d88\u606f\u53d1\u9001\uff1a{}", (Object)bo);
        }
    }

    private void medioCallbackProToTest(IMMixtedFlowCallbackReqVO reqVO) {
        IMBusiPushConfigEntity configEntity = this.pushConfigRepository.findByPushTypeAndBusiCode("mediaToTest", "im_test");
        if (configEntity != null && BusiPushStatusEnum.ON.getValue().equals(configEntity.getStatus())) {
            String url = configEntity.getDomain() + "/cloud" + configEntity.getUri();
            log.info("\u5355\u804a\u6d88\u606f\u8f6c\u81f3\u6d4b\u8bd5\u73af\u5883IM,\u8bf7\u6c42params:{}", (Object)JSON.toJSONString((Object)reqVO));
            JSONObject object = JSONObject.parseObject((String)JSON.toJSONString((Object)reqVO));
            String result = RestTemplateUtils.post((String)url, (JSONObject)object, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u5355\u804a\u6d88\u606f\u8f6c\u53d1\u81f3\u6d4b\u8bd5\u73af\u5883IM\u670d\u52a1\u5668 \u54cd\u5e94={}", (Object)result);
        }
    }

    private void pushMediaToBusiness(IMMixtedFlowCallbackReqVO reqVO, boolean flag) {
        ImMediaProcessEntity imMediaProcessEntity = new ImMediaProcessEntity();
        imMediaProcessEntity.setDuration(Long.valueOf(reqVO.getDuration().longValue()));
        imMediaProcessEntity.setFileId(reqVO.getFile_id());
        imMediaProcessEntity.setSize(Long.valueOf(reqVO.getFile_size().longValue()));
        imMediaProcessEntity.setVideoUrl(reqVO.getVideo_url());
        imMediaProcessEntity.setEndTime(Long.valueOf(reqVO.getEnd_time().longValue()));
        imMediaProcessEntity.setStartTime(Long.valueOf(reqVO.getStart_time().longValue()));
        imMediaProcessEntity.setType(Short.valueOf(reqVO.getEvent_type().shortValue()));
        imMediaProcessEntity.setVideoId(reqVO.getVideo_id());
        imMediaProcessEntity.setTaskId(reqVO.getTask_id());
        log.info("pushMediaToBusiness\u91cc\u9762\u63a5\u6536\u5230\u7684\u53c2\u6570{}", (Object)JSON.toJSONString((Object)reqVO));
        this.imBusiPushService.mediaProcessPushToBusinessNew(imMediaProcessEntity, BusiPushTypeEnum.MEDIA_TRANSCODE, flag);
    }
}

