/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.controller;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.IMClientApi;
import com.hxgy.im.pojo.bo.ValidationResultBO;
import com.hxgy.im.pojo.vo.IMBatchGetSessionReqVO;
import com.hxgy.im.pojo.vo.IMBatchGetStatusReqVO;
import com.hxgy.im.pojo.vo.IMBusiDataSyncReqVO;
import com.hxgy.im.pojo.vo.IMQueryTargetSdkAccountReqVO;
import com.hxgy.im.pojo.vo.IMQueryTargetSdkAccountRspVO;
import com.hxgy.im.pojo.vo.IMQueryUserLoginReqVO;
import com.hxgy.im.pojo.vo.IMQueryUserLoginRspVO;
import com.hxgy.im.pojo.vo.IMSaveSessionReqVO;
import com.hxgy.im.pojo.vo.IMSessionRspVO;
import com.hxgy.im.pojo.vo.IMUpdateOnlineStatusReqVO;
import com.hxgy.im.pojo.vo.SdkAccountVo;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMBusiDataService;
import com.hxgy.im.service.IMSessionService;
import com.hxgy.im.util.ParamsValidationUtils;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class IMSessionController
implements IMClientApi {
    private static final Logger log = LoggerFactory.getLogger(IMSessionController.class);
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private IMSessionService imSessionService;
    @Autowired
    private IMBusiDataService busiDataService;
    @Autowired
    private IMAccountService accountService;
    @Autowired
    private RabbitTemplate rabbitTemplate;

    @ApiOperation(value="\u521b\u5efa\u5355\u804a\u4f1a\u8bdd\u5c5e\u6027", httpMethod="POST", notes="\u521b\u5efa\u5355\u804a\u4f1a\u8bdd\u5c5e\u6027")
    public BaseResponse<Object> saveIMSession(@RequestBody IMSaveSessionReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        boolean saveType = reqVO.getSaveType();
        if (!saveType) {
            this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.single.session.msg", (Object)JSON.toJSONString((Object)reqVO));
            return BaseResponse.success();
        }
        return this.imSessionService.saveSingleIMSession(reqVO);
    }

    public BaseResponse<List<IMSessionRspVO>> batchGetSession(@RequestBody IMBatchGetSessionReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        return this.imSessionService.batchGetSession(reqVO);
    }

    @ApiOperation(value="\u540c\u6b65\u4e1a\u52a1\u6709\u6548\u5c31\u8bca\u6570\u636e", httpMethod="POST", notes="\u540c\u6b65\u4e1a\u52a1\u6709\u6548\u5c31\u8bca\u6570\u636e")
    public BaseResponse<Object> saveBusinessApply(@RequestBody IMBusiDataSyncReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        return this.busiDataService.saveBusinessApply(reqVO);
    }

    @ApiOperation(value="\u67e5\u8be2\u7528\u6237\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM", httpMethod="POST", notes="\u67e5\u8be2\u7528\u6237\u662f\u6216\u5426\u9700\u8981\u767b\u9646IM")
    public BaseResponse<IMQueryUserLoginRspVO> queryUserLogin(@RequestBody IMQueryUserLoginReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        return this.busiDataService.queryUserLogin(reqVO);
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u7528\u6237\u662f\u5426\u5728\u7ebf\u72b6\u6001", httpMethod="POST", notes="\u6279\u91cf\u67e5\u8be2\u7528\u6237\u662f\u5426\u5728\u7ebf\u72b6\u6001")
    public BaseResponse<Object> batchGetStatus(@RequestBody IMBatchGetStatusReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        return this.imSessionService.batchGetStatus(reqVO);
    }

    public BaseResponse<Object> testMqSend() {
        String msg = "{\"createUser\":\"mdhtest\",\"memberList\":[{\"appCode\":\"EHOS_DOCTOR\",\"doctorId\":\"docIdtest1\",\"userId\":\"docuserid1\"},{\"appCode\":\"EHOS_PATIENT\",\"patIdCard\":\"513029197211030048\",\"patientId\":\"patuserid1\",\"userId\":\"patuserid1\"}],\"saveType\":false,\"treatmentId\":\"mdhtest\",\"busiCode\":\"test\"}";
        this.rabbitTemplate.convertAndSend("ehos-im-topic", "im.msg.single.session.msg", (Object)msg);
        return BaseResponse.success();
    }

    @ApiOperation(value="\u5355\u4e2a\u67e5\u8be2\u5bf9\u65b9IM\u8d26\u53f7", httpMethod="POST", notes="\u5355\u4e2a\u67e5\u8be2\u5bf9\u65b9IM\u8d26\u53f7")
    public BaseResponse<IMQueryTargetSdkAccountRspVO> qeuryTagetSdkAccount(@RequestBody IMQueryTargetSdkAccountReqVO reqVO) {
        ValidationResultBO vlidateReulst = ParamsValidationUtils.validateEntity((Object)reqVO);
        if (vlidateReulst.isHasErrors()) {
            return BaseResponse.error((String)vlidateReulst.getErrorMsg().toString());
        }
        return this.imSessionService.qeuryTagetSdkAccount(reqVO);
    }

    public BaseResponse<Map<String, List<SdkAccountVo>>> querySdkAccountList(@RequestBody Map<String, List<String>> map) {
        return this.accountService.querySdkAccountList(map);
    }

    public BaseResponse<Object> updateOnlineStatus(@RequestBody @Valid IMUpdateOnlineStatusReqVO reqVO) {
        return this.imSessionService.updateOnlineStatus(reqVO);
    }

    public BaseResponse<String> checkHealth() {
        Optional byId = this.accountRepository.findById((Object)"1");
        return byId.map(imAccountEntity -> BaseResponse.success((Object)imAccountEntity.getSdkAccount())).orElseGet(BaseResponse::success);
    }
}

