/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.config.SnowIdConfig;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.vo.SdkAccountVo;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMApplicationService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.SdkAccountUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.redisson.api.RLock;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMAccountServiceImpl
implements IMAccountService {
    @Autowired
    private RedissonClient redissonClient;
    private static final Logger log = LoggerFactory.getLogger(IMAccountServiceImpl.class);
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private IMApplicationService applicationService;
    @Autowired
    private IMSigService sigService;
    @Autowired
    private SnowIdConfig snowIdConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ImAccountEntity saveOrQueryAccount(IMSaveAccountBO accountBO) {
        ImAccountEntity account;
        block16: {
            RLock lock = null;
            account = null;
            try {
                log.info("saveOrQueryAccount redissonClient =" + this.redissonClient);
                lock = this.redissonClient.getLock("im_create_account");
                log.info("saveOrQueryAccount lock =" + lock);
                lock.lock(10L, TimeUnit.SECONDS);
                log.info("\u521b\u5efa\u8d26\u53f7\u83b7\u53d6\u9501\u6210\u529f = {} ", (Object)lock.getName());
                String appId = accountBO.getAppId();
                String userId = accountBO.getUserId();
                String formNick = accountBO.getFormNick();
                String appCode = accountBO.getAppCode();
                String headLogo = accountBO.getHeadLogo();
                account = this.accountRepository.findByAppIdAndUserId(appId, userId);
                if (account == null) {
                    account = new ImAccountEntity();
                    account.setAppId(appId);
                    account.setFromNick(formNick);
                    account.setHeadUrl(headLogo);
                    long nextId = this.snowIdConfig.nextId();
                    if (StringUtils.isNotBlank((CharSequence)appCode)) {
                        String sdkAccount = SdkAccountUtils.convertSdkAccount((String)String.valueOf(nextId), (String)appCode);
                        account.setSdkAccount(sdkAccount);
                    } else {
                        account.setSdkAccount(userId);
                    }
                    account.setLineStatus(Integer.valueOf(0));
                    account.setUserId(userId);
                    this.accountRepository.saveAndFlush((Object)account);
                } else if (StringUtils.isNotEmpty((CharSequence)formNick) && StringUtils.isNotEmpty((CharSequence)headLogo)) {
                    account.setFromNick(formNick);
                    account.setHeadUrl(headLogo);
                    this.accountRepository.saveAndFlush((Object)account);
                }
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5!");
            }
            catch (Exception e) {
                log.error("\u4fdd\u5b58\u8d26\u53f7\u51fa\u73b0\u5f02\u5e38:{}", (Throwable)e);
                break block16;
            }
            try {
                this.unRedisLock(lock);
            }
            catch (Exception e) {
                log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
            }
            break block16;
            finally {
                log.info("\u67e5\u8be2\u6216\u65b0\u589e\u8d26\u53f7\u6267\u884c\u5b8c\u6bd5!");
                try {
                    this.unRedisLock(lock);
                }
                catch (Exception e) {
                    log.info("\u91ca\u653e\u9501\u5931\u8d25 {}", (Throwable)e);
                }
            }
        }
        log.info("\u4fdd\u5b58\u8d26\u53f7\u5b8c\u6210:{}", account);
        return account;
    }

    public ImAccountEntity queryAccountByAppIdAndUserId(String appId, String userId) {
        this.accountRepository.findByAppIdAndUserId(appId, userId);
        return null;
    }

    private void unRedisLock(RLock lock) {
        if (lock != null) {
            if (!lock.isHeldByCurrentThread()) {
                log.warn("redis\u8d85\u65f6\u81ea\u52a8\u91ca\u653e\u9501!");
            } else {
                log.info("\u903b\u8f91\u6267\u884c\u5b8c\u6210\u4e3b\u52a8\u91ca\u653e\u9501\uff1a{}", (Object)lock.getName());
                lock.unlock();
            }
        } else {
            log.info("lock\u5bf9\u8c61\u4e3a\u7a7a!");
        }
    }

    public BaseResponse<Map<String, List<SdkAccountVo>>> querySdkAccountList(Map<String, List<String>> map) {
        log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f \u5165\u53c2:{}", (Object)JSONObject.toJSONString(map));
        HashMap sdkAccountMap = new HashMap(16);
        if (map.isEmpty()) {
            return BaseResponse.success(sdkAccountMap);
        }
        Set<String> appCodeSet = map.keySet();
        for (String appCode : appCodeSet) {
            ImApplicationEntity applicationEntity = this.applicationService.findAppByAppcode(appCode);
            if (applicationEntity == null) {
                sdkAccountMap.put(appCode, null);
                continue;
            }
            String appId = applicationEntity.getId();
            List<String> userIdList = map.get(appCode);
            ArrayList<SdkAccountVo> list = new ArrayList<SdkAccountVo>(userIdList.size());
            for (String userId : userIdList) {
                SdkAccountVo vo;
                ImAccountEntity imAccount = this.accountRepository.findByAppIdAndUserId(appId, userId);
                if (imAccount == null) {
                    SdkAccountVo vo2 = new SdkAccountVo(userId, "", "");
                    list.add(vo2);
                    continue;
                }
                ImSigEntity imSigEntity = this.sigService.findSigByAccountId(imAccount.getId());
                if (imSigEntity == null) {
                    vo = new SdkAccountVo(imAccount.getUserId(), imAccount.getSdkAccount(), "");
                    list.add(vo);
                    continue;
                }
                vo = new SdkAccountVo(imAccount.getUserId(), imAccount.getSdkAccount(), imSigEntity.getAccountSig());
                list.add(vo);
            }
            sdkAccountMap.put(appCode, list);
        }
        log.info("\u6279\u91cf\u67e5\u8be2\u7528\u6237\u7684IM\u8d26\u53f7\u4fe1\u606f \u6210\u529f \u54cd\u5e94:{}", (Object)JSONObject.toJSONString(sdkAccountMap));
        return BaseResponse.success(sdkAccountMap);
    }
}

