/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.ebaiyihui.framework.response.BaseResponse;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImBusinessDataEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.vo.IMBusiDataSyncReqVO;
import com.hxgy.im.pojo.vo.IMQueryUserLoginReqVO;
import com.hxgy.im.pojo.vo.IMQueryUserLoginRspVO;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImBusinessDataRepository;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMBusiDataService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IMBusiDataServiceImpl
implements IMBusiDataService {
    private static final Logger log = LoggerFactory.getLogger(IMBusiDataServiceImpl.class);
    @Autowired
    private ImBusinessDataRepository busiDataRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private IMAccountService accountService;
    @Autowired
    private IMSigService sigService;

    public BaseResponse<Object> saveBusinessApply(IMBusiDataSyncReqVO reqVO) {
        String treatmentId;
        String busiCode;
        String userId = reqVO.getUserId();
        ImBusinessDataEntity busiData = this.busiDataRepository.findBusiData(userId, busiCode = reqVO.getBusiCode(), treatmentId = reqVO.getTreatmentId());
        if (busiData == null) {
            busiData = new ImBusinessDataEntity();
        }
        busiData.setAdmEndDate(reqVO.getAdmEndDate());
        busiData.setAdmStartDate(reqVO.getAdmStartDate());
        busiData.setAppointmentId(treatmentId);
        busiData.setBusiCode(busiCode);
        busiData.setUserId(userId);
        this.busiDataRepository.saveAndFlush((Object)busiData);
        return BaseResponse.success();
    }

    public BaseResponse<IMQueryUserLoginRspVO> queryUserLogin(IMQueryUserLoginReqVO reqVO) {
        String currentDate = DateUtils.getCurrentDateSimpleToString();
        String userId = reqVO.getUserId();
        String appCode = reqVO.getAppCode();
        Long count = this.busiDataRepository.countUserBusiData(userId, currentDate, currentDate);
        ImApplicationEntity app = this.appRepository.findByAppCode(appCode);
        String appId = app.getId();
        IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, appCode, userId, "");
        ImAccountEntity imAccount = this.accountService.saveOrQueryAccount(accountBO);
        String accountId = imAccount.getId();
        IMSaveSigBO sigBo = new IMSaveSigBO(app.getAppSdkId(), imAccount.getSdkAccount(), accountId);
        ImSigEntity sig = this.sigService.saveSig(sigBo);
        IMQueryUserLoginRspVO rsp = new IMQueryUserLoginRspVO();
        if (count != null && count > 0L) {
            rsp.setLogin(Short.valueOf((short)1));
        } else {
            rsp.setLogin(Short.valueOf((short)0));
        }
        rsp.setSdkAccount(imAccount.getSdkAccount());
        rsp.setSig(sig.getAccountSig());
        return BaseResponse.success((Object)rsp);
    }
}

