/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.hxgy.im.enums.AppCodeEnum;
import com.hxgy.im.enums.BusiCodeEnum;
import com.hxgy.im.enums.BusiPushStatusEnum;
import com.hxgy.im.enums.BusiPushTypeEnum;
import com.hxgy.im.enums.IMOnlineStatusEnum;
import com.hxgy.im.enums.PushBusiMsgTypeEnum;
import com.hxgy.im.pojo.dto.CyclePushTimer;
import com.hxgy.im.pojo.dto.IMSessionRecorder;
import com.hxgy.im.pojo.entity.IMBusiPushConfigEntity;
import com.hxgy.im.pojo.entity.IMBusiPushLogEntity;
import com.hxgy.im.pojo.entity.IMMixtedFlowEntity;
import com.hxgy.im.pojo.entity.ImMediaProcessEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.vo.IMBusiPushRespVo;
import com.hxgy.im.pojo.vo.TencentMedia.IMEditMediaRespVo;
import com.hxgy.im.repository.IMMixtedFlowRepository;
import com.hxgy.im.repository.ImBusiPushConfigRepository;
import com.hxgy.im.repository.ImBusiPushLogRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.service.IMBusiPushService;
import com.hxgy.im.service.impl.IMPushMsgServiceImpl;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.RedisUtil;
import com.hxgy.im.util.RestTemplateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IMBusiPushServiceImpl
implements IMBusiPushService {
    @Autowired
    private ImBusiPushConfigRepository pushConfigRepository;
    private static String SESSION_RECORDER = "IMSessionRecorder";
    private static String TIMER_NAME = "circularPush";
    String templateCode_10 = "treatment_notify";
    String templateCode_120 = "treatment_notify_overtime";
    private static final String TEMPLATE_CODE = "templateCode";
    private static final String EHOS_DOCTOR = "EHOS_DOCTOR";
    private static final String NO_FIRST = "**NoFirst";
    private static final String ROUTE_KEY = ", RouteKey:";
    private static final String MQ_EXCHANGE = "\u63a8\u9001\u65b9\u5f0f:mq,Exchange:";
    private static final String UNKNOW_PUSH_TYPE = "(\u540e\u53f0\u914d\u7f6e\u4e0d\u6b63\u786e)\u672a\u77e5\u7684\u63a8\u9001\u7c7b\u578b";
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private IMMixtedFlowRepository mixtedFlowRepository;
    @Autowired
    private ImBusiPushConfigRepository imBusiPushConfigRepository;
    @Autowired
    private ImBusiPushLogRepository busiPushLogRepository;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${byh.domain}")
    private String byhDomain;
    private static final Logger log = LoggerFactory.getLogger(IMPushMsgServiceImpl.class);

    public Boolean pushToBusiness(AppCodeEnum pushTo, PushBusiMsgTypeEnum typeEnum, String businessCode, String treatmentId, BusiPushTypeEnum busiPushTypeEnum) {
        if (PushBusiMsgTypeEnum.OFFLINE_MSG == typeEnum) {
            ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(businessCode, treatmentId);
            if (session == null || StringUtils.isEmpty((CharSequence)session.getBusiNodeCode())) {
                log.info("\u4f1a\u8bdd\u4e0d\u5b58\u5728==businessCode={},=====treatmentId={}", (Object)businessCode, (Object)treatmentId);
                return false;
            }
            JSONObject jsonObject = new JSONObject();
            String busiURL = "";
            String result = "";
            if (BusiCodeEnum.ZXZX.getBusiCodeEnumValue().equals(businessCode)) {
                if (AppCodeEnum.EHOS_PATIENT.equals((Object)pushTo)) {
                    busiURL = this.byhDomain.concat("/").concat(session.getBusiNodeCode()).concat("/netinquiry/inform/seekMedicalAdvice?");
                    jsonObject.put("admissionId", (Object)treatmentId);
                    jsonObject.put("type", (Object)busiPushTypeEnum.getValue());
                    if (BusiPushTypeEnum.WX_OFFLINE_3_MIN_VAL.equals((Object)busiPushTypeEnum)) {
                        jsonObject.put(TEMPLATE_CODE, (Object)this.templateCode_10);
                    } else if (BusiPushTypeEnum.PUSH_INTERVAL_10_MIN_VAL.equals((Object)busiPushTypeEnum)) {
                        jsonObject.put(TEMPLATE_CODE, (Object)this.templateCode_10);
                    } else if (BusiPushTypeEnum.PUSH_INTERVAL_120_MIN_VAL.equals((Object)busiPushTypeEnum)) {
                        jsonObject.put(TEMPLATE_CODE, (Object)this.templateCode_120);
                    }
                    log.info("\u53d1\u8d77\u4e1a\u52a1\u63a8\u9001 ==\u300bbusiURL:{},\u53c2\u6570:{}", (Object)busiURL, (Object)jsonObject.toJSONString());
                    result = RestTemplateUtils.get((String)busiURL, (JSONObject)jsonObject);
                } else if (AppCodeEnum.EHOS_DOCTOR.equals((Object)pushTo)) {
                    busiURL = this.byhDomain.concat("/").concat(session.getBusiNodeCode()).concat("/netinquiry/inform/doctorNoResponse");
                    jsonObject.put("admId", (Object)treatmentId);
                    jsonObject.put("type", (Object)busiPushTypeEnum.getValue());
                    log.info("\u53d1\u8d77\u4e1a\u52a1\u63a8\u9001 ==\u300bbusiURL:{},\u53c2\u6570:{}", (Object)busiURL, (Object)jsonObject.toJSONString());
                    result = RestTemplateUtils.post((String)busiURL, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
                }
            } else {
                IMBusiPushConfigEntity pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(busiPushTypeEnum.getValue(), businessCode);
                if (pushConfig == null || BusiPushStatusEnum.OFF.getValue().equals(pushConfig.getStatus())) {
                    log.info("--\u63a8\u9001\u5173\u95ed--\u7c7b\u578b\uff1a{}---\u4e1a\u52a1code\uff1a", (Object)busiPushTypeEnum.getValue(), (Object)businessCode);
                    return true;
                }
                IMBusiPushRespVo imBusiPushRespVo = new IMBusiPushRespVo();
                imBusiPushRespVo.setPushType(busiPushTypeEnum.getValue());
                imBusiPushRespVo.setTreatmentId(treatmentId);
                imBusiPushRespVo.setPushTo(pushTo);
                jsonObject = JSONObject.parseObject((String)JSON.toJSONString((Object)imBusiPushRespVo));
                busiURL = pushConfig.getDomain() + "/" + session.getBusiNodeCode() + pushConfig.getUri();
                if ("post".equalsIgnoreCase(pushConfig.getMethod())) {
                    log.info("\u53d1\u8d77\u4e1a\u52a1\u63a8\u9001 ==\u300b\u8bf7\u6c42\u65b9\u5f0f:post , busiURL:{},\u53c2\u6570:{}", (Object)busiURL, (Object)jsonObject.toJSONString());
                    result = RestTemplateUtils.post((String)busiURL, (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
                } else if ("get".equalsIgnoreCase(pushConfig.getMethod())) {
                    log.info("\u53d1\u8d77\u4e1a\u52a1\u63a8\u9001 ==\u300b\u8bf7\u6c42\u65b9\u5f0f:get , busiURL:{},\u53c2\u6570:{}", (Object)busiURL, (Object)jsonObject.toJSONString());
                    result = RestTemplateUtils.get((String)busiURL, (JSONObject)jsonObject);
                } else {
                    log.info("--------\u8bf7\u6c42\u65b9\u5f0f\u914d\u7f6e\u4e0d\u6b63\u786e-------");
                }
            }
            log.info("\u53d1\u8d77\u4e1a\u52a1\u63a8\u9001 ==\u300b\u54cd\u5e94:{}", (Object)result);
            if (StringUtils.isEmpty((CharSequence)result)) {
                log.info("\u5411[{}]\u8282\u70b9[{}]\u4e1a\u52a1\u63a8\u9001\u6d88\u606f[{}],\u8fd4\u56de\u7a7a", new Object[]{session.getBusiNodeCode(), businessCode, jsonObject.toJSONString()});
                return false;
            }
            JSONObject object = JSONObject.parseObject((String)result);
            if (object != null) {
                String status = object.getString("status");
                String code = object.getString("code");
                if (StringUtils.isNotEmpty((CharSequence)status) && "200".equals(status)) {
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)code) && "1".equals(code)) {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    @Async
    public void pushOfflineMsg(String toAccount, String businessCode, String treatmentId) {
        String doctor = EHOS_DOCTOR;
        if (toAccount.endsWith(doctor)) {
            log.info("\u4e09\u5206\u949f\u6d88\u606f\u89c4\u5219\u63a8\u9001,\u533b\u751f\u672a\u56de\u590d\u6d88\u606f\uff0c\u4e0d\u63a8\u9001\uff0ctoAccount:{}", (Object)toAccount);
            return;
        }
        String statusKey = toAccount + "_" + IMOnlineStatusEnum.OFFLINE.name();
        Object offlineStatus = this.redisUtil.get(statusKey);
        boolean offline = IMOnlineStatusEnum.OFFLINE.name().equalsIgnoreCase((String)offlineStatus);
        log.info("\u7528\u6237[{}]\u662f\u5426\u79bb\u7ebf:{}", (Object)toAccount, (Object)offline);
        if (offlineStatus != null && offline) {
            String pushMsgKey = PushBusiMsgTypeEnum.OFFLINE_MSG.name().concat(toAccount);
            boolean hasKey = this.redisUtil.hasKey(pushMsgKey);
            String cacheValue = (String)this.redisUtil.get(pushMsgKey);
            if (hasKey && !cacheValue.contains("NoFirst")) {
                this.redisUtil.set(pushMsgKey, (Object)toAccount.concat(NO_FIRST), 180L);
                this.pushToBusiness(AppCodeEnum.EHOS_PATIENT, PushBusiMsgTypeEnum.OFFLINE_MSG, businessCode, treatmentId, BusiPushTypeEnum.WX_OFFLINE_3_MIN_VAL);
                log.info("\u7528\u6237[{}]\u79bb\u7ebf\uff0c\u53d1\u8d77\u7b2c\u4e00\u6761\u6d88\u606f\u63d0\u9192\u5b8c\u6210,\u8ba2\u5355\u53f7:{}", (Object)toAccount, (Object)treatmentId);
            }
            if (!hasKey) {
                log.info("\u7528\u6237[{}]\u79bb\u7ebf,\u95f4\u9694\u4e09\u5206\u949f\uff0c\u53d1\u8d77\u6d88\u606f\u63d0\u9192,\u8ba2\u5355\u53f7:{}", (Object)toAccount, (Object)treatmentId);
                this.redisUtil.set(pushMsgKey, (Object)toAccount.concat(NO_FIRST), 180L);
                this.pushToBusiness(AppCodeEnum.EHOS_PATIENT, PushBusiMsgTypeEnum.OFFLINE_MSG, businessCode, treatmentId, BusiPushTypeEnum.WX_OFFLINE_3_MIN_VAL);
            }
        }
    }

    public void pushOfflineMsgV2(String toAccount, String busiCode, String treatmentId) {
        log.info("\u8fdb\u5165\u4e09\u5206\u949f\u6d88\u606f\u89c4\u5219\u63a8\u9001===>toAccount:{},businessCode:{},treatmentId:{}", new Object[]{toAccount, busiCode, treatmentId});
        if (!this.isPush(BusiPushTypeEnum.WX_OFFLINE_3_MIN, busiCode).booleanValue()) {
            log.info("--\u63a8\u9001\u5173\u95ed--\u7c7b\u578b\uff1awx_offline_3_min---\u4e1a\u52a1code\uff1a" + busiCode);
            return;
        }
        String doctor = EHOS_DOCTOR;
        if (toAccount.endsWith(doctor)) {
            log.info("\u4e09\u5206\u949f\u6d88\u606f\u89c4\u5219\u63a8\u9001,\u533b\u751f\u672a\u56de\u590d\u6d88\u606f\uff0c\u4e0d\u63a8\u9001\uff0ctoAccount:{}", (Object)toAccount);
            return;
        }
        String statusKey = toAccount + "_" + IMOnlineStatusEnum.OFFLINE.name();
        Object offlineStatus = this.redisUtil.get(statusKey);
        boolean offline = IMOnlineStatusEnum.OFFLINE.name().equalsIgnoreCase((String)offlineStatus);
        log.info("\u7528\u6237[{}]\u662f\u5426\u79bb\u7ebf:{}", (Object)toAccount, (Object)offline);
        if (offlineStatus != null && offline) {
            String pushMsgKey = PushBusiMsgTypeEnum.OFFLINE_MSG.name().concat(toAccount);
            boolean hasKey = this.redisUtil.hasKey(pushMsgKey);
            String cacheValue = (String)this.redisUtil.get(pushMsgKey);
            log.info("\u7528\u6237[{}]\u79bb\u7ebf,\u53d1\u9001\u6d88\u606f\u524d\u5224\u65ad\uff0c\u662f\u5426\u6b63\u5728\u4e09\u5206\u949f\u5012\u8ba1\u65f6:{},\u662f\u5426\u662f\u7b2c\u4e00\u6761\u63a8\u9001:{}", new Object[]{toAccount, hasKey, cacheValue});
            if (hasKey && !cacheValue.contains("NoFirst")) {
                this.redisUtil.set(pushMsgKey, (Object)toAccount.concat(NO_FIRST), 180L);
                log.info("\u7528\u6237[{}]\u79bb\u7ebf\uff0c\u8fdb\u5165\u53d1\u8d77\u7b2c\u4e00\u6761\u6d88\u606f\u63d0\u9192,\u8ba2\u5355\u53f7:{}", (Object)toAccount, (Object)treatmentId);
                this.pushToBusiness(AppCodeEnum.EHOS_PATIENT, PushBusiMsgTypeEnum.OFFLINE_MSG, busiCode, treatmentId, BusiPushTypeEnum.WX_OFFLINE_3_MIN);
                log.info("\u7528\u6237[{}]\u79bb\u7ebf\uff0c\u53d1\u8d77\u7b2c\u4e00\u6761\u6d88\u606f\u63d0\u9192\u5b8c\u6210,\u8ba2\u5355\u53f7:{}", (Object)toAccount, (Object)treatmentId);
            }
            if (!hasKey) {
                log.info("\u7528\u6237[{}]\u79bb\u7ebf,\u95f4\u9694\u4e09\u5206\u949f\uff0c\u53d1\u8d77\u6d88\u606f\u63d0\u9192,\u8ba2\u5355\u53f7:{}", (Object)toAccount, (Object)treatmentId);
                this.redisUtil.set(pushMsgKey, (Object)toAccount.concat(NO_FIRST), 180L);
                this.pushToBusiness(AppCodeEnum.EHOS_PATIENT, PushBusiMsgTypeEnum.OFFLINE_MSG, busiCode, treatmentId, BusiPushTypeEnum.WX_OFFLINE_3_MIN);
            }
        }
    }

    private Boolean isPush(BusiPushTypeEnum pushTypeEnum, String busiCode) {
        IMBusiPushConfigEntity imBusiPushConfigEntity = this.pushConfigRepository.findByPushTypeAndBusiCode(pushTypeEnum.getValue(), busiCode);
        if (imBusiPushConfigEntity != null && BusiPushStatusEnum.ON.getValue().equals(imBusiPushConfigEntity.getStatus())) {
            return true;
        }
        return false;
    }

    @Async
    public void sessionRecorder(String fromAccount, String toAccount, String businessCode, String treatmentId, Long msgTime) {
        log.info("\u7f13\u5b58\u4f1a\u8bdd\u8bb0\u5f55\u8005==sessionRecorder" + treatmentId + "/" + fromAccount + "/" + toAccount + "/" + msgTime);
        String doctor = EHOS_DOCTOR;
        String patient = "EHOS_PATIENT";
        List timerList = this.redisUtil.lGet(TIMER_NAME, 0L, -1L);
        log.info("sessionRecorder===\u603b\u5bb9\u91cf={}", (Object)timerList.size());
        boolean isInsert = true;
        for (Object object : timerList) {
            List IMrecorderList;
            ArrayList<IMSessionRecorder> frushRecorderList = new ArrayList<IMSessionRecorder>();
            CyclePushTimer cyclePushTimer = (CyclePushTimer)JSONObject.parseObject((String)JSON.toJSONString(object), CyclePushTimer.class);
            if (cyclePushTimer == null || StringUtils.isEmpty((CharSequence)cyclePushTimer.getTimerName())) continue;
            String recorderKey = cyclePushTimer.getTimerName();
            List recorderList = this.redisUtil.lGet(recorderKey, 0L, -1L);
            String recorderListArr = JSON.toJSONString((Object)recorderList);
            if (recorderListArr.startsWith("[[") && recorderListArr.endsWith("]]")) {
                String substring = recorderListArr.substring(1, recorderListArr.length() - 1);
                log.info("sessionRecorder=\u8bb0\u5f55\u5bb9\u5668\u5b57\u7b26\u4e32\u622a\u53d6[[]]=" + substring);
                IMrecorderList = JSON.parseArray((String)substring, IMSessionRecorder.class);
            } else {
                IMrecorderList = JSON.parseArray((String)recorderListArr, IMSessionRecorder.class);
            }
            if (IMrecorderList == null || IMrecorderList.isEmpty()) continue;
            this.redisUtil.del(new String[]{recorderKey});
            for (IMSessionRecorder imRecorder : IMrecorderList) {
                if (treatmentId.equals(imRecorder.getTreatmentId())) {
                    isInsert = false;
                    imRecorder.setLastMsgTime(msgTime);
                    if (fromAccount.endsWith(doctor)) {
                        imRecorder.setDoctorToPatientLastMsgTime(msgTime);
                    } else if (fromAccount.endsWith(patient)) {
                        imRecorder.setPatientToDoctorLastMsgTime(msgTime);
                    }
                }
                frushRecorderList.add(imRecorder);
                this.redisUtil.lSet(recorderKey, (Object)imRecorder, 172800L);
            }
            long l = this.redisUtil.lGetListSize(recorderKey);
        }
        if (isInsert) {
            log.info("\u8fdb\u5165\u65b0\u589e\u8bb0\u5f55");
            String imSessionRecorderCreateTime = DateUtils.getCurrentDateTimeToMinuteString();
            String newRecorderKey = SESSION_RECORDER.concat("_").concat(imSessionRecorderCreateTime);
            boolean flag = true;
            for (Object object : timerList) {
                String recorderKey;
                CyclePushTimer cyclePushTimer = (CyclePushTimer)JSONObject.parseObject((String)JSON.toJSONString(object), CyclePushTimer.class);
                if (cyclePushTimer == null || StringUtils.isEmpty((CharSequence)cyclePushTimer.getTimerName()) || !(recorderKey = cyclePushTimer.getTimerName()).equals(newRecorderKey)) continue;
                flag = false;
                log.info("recorderKey={}\u5bb9\u5668\u5df2\u5b58\u5728\uff0c\u4e0d\u65b0\u589e\u5bb9\u5668newRecorderKey={}", (Object)recorderKey, (Object)newRecorderKey);
            }
            IMSessionRecorder addRecorder = this.addrecorder(fromAccount, toAccount, businessCode, treatmentId, msgTime, imSessionRecorderCreateTime);
            log.info("\u5f53\u524d\u5206\u949f\u4e0b\uff0c\u4fdd\u5b58\u7684\u65b0\u4f1a\u8bdd\u8bb0\u5f55,\u7f13\u5b58\u4f1a\u8bdd\u8bb0\u5f55\u8005==sessionRecorder:{}", (Object)JSON.toJSONString((Object)addRecorder));
            this.redisUtil.lSet(newRecorderKey, (Object)addRecorder, 172800L);
            if (flag) {
                this.addRecorderToTimer(imSessionRecorderCreateTime);
            }
            long getListSize = this.redisUtil.lGetListSize(newRecorderKey);
            log.info("newRecorderKey={},\u8bb0\u5f55\u6570:{}", (Object)newRecorderKey, (Object)getListSize);
        }
    }

    public String circularPush() {
        List timerList = this.redisUtil.lGet(TIMER_NAME, 0L, -1L);
        log.info("----------------------\u5b9a\u65f6\u5668-----------------==\u603b\u5bb9\u91cf={}", (Object)timerList.size());
        this.redisUtil.del(new String[]{TIMER_NAME});
        for (Object object : timerList) {
            List list;
            ArrayList<IMSessionRecorder> frushRecorderList = new ArrayList<IMSessionRecorder>();
            CyclePushTimer cyclePushTimer = (CyclePushTimer)JSONObject.parseObject((String)JSON.toJSONString(object), CyclePushTimer.class);
            if (cyclePushTimer == null || StringUtils.isEmpty((CharSequence)cyclePushTimer.getTimerName())) continue;
            String recorderKey = cyclePushTimer.getTimerName();
            List recorderList = this.redisUtil.lGet(recorderKey, 0L, -1L);
            String recorderListArr = JSON.toJSONString((Object)recorderList);
            if (recorderListArr.startsWith("[[") && recorderListArr.endsWith("]]")) {
                String substring = recorderListArr.substring(1, recorderListArr.length() - 1);
                log.info("====\u4e0d\u5e94\u8be5\u770b\u5230\u8fd9\u884c\u65e5\u5fd7====\u5b57\u7b26\u4e32\u622a\u53d6[[]]========" + (String)substring);
                list = JSON.parseArray((String)substring, IMSessionRecorder.class);
            } else {
                list = JSON.parseArray((String)recorderListArr, IMSessionRecorder.class);
            }
            if (CollectionUtils.isEmpty((Collection)recorderList) || recorderList.isEmpty()) {
                log.info("\u5bb9\u5668\u4e3a\u7a7a==\u300bsessionRecorder==recorderKey:{}==\u8bb0\u5f55\u5bb9\u5668\u5bb9\u91cf={},\u5bb9\u5668recorderList={}", new Object[]{recorderKey, "0", recorderListArr});
                continue;
            }
            this.redisUtil.del(new String[]{recorderKey});
            for (IMSessionRecorder imRecorder : list) {
                long doctorToPatientLastMsgTime = imRecorder.getDoctorToPatientLastMsgTime();
                long patientToDoctorLastMsgTime = imRecorder.getPatientToDoctorLastMsgTime();
                long docToPatTime = doctorToPatientLastMsgTime - patientToDoctorLastMsgTime;
                long currentSecond = System.currentTimeMillis() / 1000L;
                long lastPushTime = imRecorder.getLastPushTime();
                int pushInterval = imRecorder.getPushInterval();
                int toDoctorPushInterval = imRecorder.getToDoctorPushInterval();
                int toPatientPushInterval = imRecorder.getToPatientPushInterval();
                if (patientToDoctorLastMsgTime == 0L || doctorToPatientLastMsgTime == 0L) {
                    long firstMsgTime = imRecorder.getFirstMsgTime();
                    long docMsgTimeLength = currentSecond - firstMsgTime;
                    if (doctorToPatientLastMsgTime != 0L) {
                        if (toPatientPushInterval == 0 && docMsgTimeLength > 600L) {
                            this.push10Minutes(AppCodeEnum.EHOS_PATIENT, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                        } else if (toPatientPushInterval == 10 && docMsgTimeLength >= 7200L) {
                            Boolean aBoolean1 = this.push120Minutes(AppCodeEnum.EHOS_PATIENT, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                            if (aBoolean1.booleanValue()) {
                                continue;
                            }
                        } else {
                            frushRecorderList.add(imRecorder);
                        }
                    } else if (patientToDoctorLastMsgTime != 0L) {
                        long patMsgTimeLength = currentSecond - firstMsgTime;
                        if (toDoctorPushInterval == 0 && patMsgTimeLength > 600L) {
                            this.push10Minutes(AppCodeEnum.EHOS_DOCTOR, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                        } else if (toDoctorPushInterval == 10 && patMsgTimeLength >= 7200L) {
                            Boolean aBoolean1 = this.push120Minutes(AppCodeEnum.EHOS_DOCTOR, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                            if (aBoolean1.booleanValue()) {
                                continue;
                            }
                        } else {
                            frushRecorderList.add(imRecorder);
                        }
                    }
                } else if (doctorToPatientLastMsgTime > patientToDoctorLastMsgTime) {
                    long docMsgTimeLen = currentSecond - doctorToPatientLastMsgTime;
                    if (toPatientPushInterval == 0 && docMsgTimeLen >= 600L) {
                        this.push10Minutes(AppCodeEnum.EHOS_PATIENT, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                    } else if (toPatientPushInterval == 10 && docMsgTimeLen >= 7200L) {
                        Boolean aBoolean1 = this.push120Minutes(AppCodeEnum.EHOS_PATIENT, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                        if (aBoolean1.booleanValue()) {
                            continue;
                        }
                    } else {
                        frushRecorderList.add(imRecorder);
                    }
                } else {
                    long patMsgTimeLen = currentSecond - patientToDoctorLastMsgTime;
                    if (toDoctorPushInterval == 0 && patMsgTimeLen >= 600L) {
                        this.push10Minutes(AppCodeEnum.EHOS_DOCTOR, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                    } else if (toDoctorPushInterval == 10 && patMsgTimeLen >= 7200L) {
                        Boolean aBoolean1 = this.push120Minutes(AppCodeEnum.EHOS_DOCTOR, frushRecorderList, imRecorder, Long.valueOf(currentSecond));
                        if (aBoolean1.booleanValue()) {
                            continue;
                        }
                    } else {
                        frushRecorderList.add(imRecorder);
                    }
                }
                this.redisUtil.lSet(recorderKey, (Object)imRecorder, 172800L);
            }
            if (frushRecorderList.isEmpty()) continue;
            CyclePushTimer timer = new CyclePushTimer();
            timer.setTimerName(recorderKey);
            this.redisUtil.lSet(TIMER_NAME, (Object)timer);
        }
        long l = this.redisUtil.lGetListSize(TIMER_NAME);
        log.info("\u63a8\u9001\u5b8c\u6bd5, \u5237\u65b0\u5b9a\u65f6\u5668\u5bb9\u5668,\u5237\u65b0\u524d:{}, \u5237\u65b0\u540efrushTimerList:{}", (Object)timerList.size(), (Object)l);
        return "\u63a8\u9001\u5b8c\u6bd5,\u5b9a\u65f6\u5bb9\u5668\u6267\u884c\u524d\u5bb9\u91cf=" + timerList.size() + ",\u6267\u884c\u540e\u5bb9\u91cf=" + l;
    }

    public IMSessionRecorder addrecorder(String fromAccount, String toAccount, String businessCode, String treatmentId, Long msgTime, String imSessionRecorderCreateTime) {
        String doctor = EHOS_DOCTOR;
        String patient = "EHOS_PATIENT";
        IMSessionRecorder recorder = new IMSessionRecorder();
        if (fromAccount.endsWith(doctor)) {
            recorder.setBusiCode(businessCode);
            recorder.setTreatmentId(treatmentId);
            recorder.setDoctor(fromAccount);
            recorder.setPatient(toAccount);
            recorder.setFirstMsgTime(msgTime);
            recorder.setLastMsgTime(msgTime);
            if (imSessionRecorderCreateTime != null) {
                recorder.setImSessionRecorderCreateTime(imSessionRecorderCreateTime);
            }
            recorder.setDoctorToPatientLastMsgTime(msgTime);
        } else if (fromAccount.endsWith(patient)) {
            recorder.setBusiCode(businessCode);
            recorder.setTreatmentId(treatmentId);
            recorder.setDoctor(toAccount);
            recorder.setPatient(fromAccount);
            recorder.setFirstMsgTime(msgTime);
            recorder.setLastMsgTime(msgTime);
            if (imSessionRecorderCreateTime != null) {
                recorder.setImSessionRecorderCreateTime(imSessionRecorderCreateTime);
            }
            recorder.setPatientToDoctorLastMsgTime(msgTime);
        }
        return recorder;
    }

    public void addRecorderToTimer(String imSessionRecorderCreateTime) {
        log.info("\u6dfb\u52a0\u4f1a\u8bdd\u8bb0\u5f55\u8005\u5230\u5faa\u73af\u5b9a\u65f6\u5668\u5bb9\u5668\u4e2d TimerName={}", (Object)SESSION_RECORDER.concat("_").concat(imSessionRecorderCreateTime));
        CyclePushTimer cyclePushTimer = new CyclePushTimer();
        cyclePushTimer.setTimerName(SESSION_RECORDER.concat("_").concat(imSessionRecorderCreateTime));
        this.redisUtil.lSet(TIMER_NAME, (Object)cyclePushTimer);
    }

    private void push10Minutes(AppCodeEnum pushTo, List<IMSessionRecorder> frushRecorderList, IMSessionRecorder imRecorder, Long currentSecond) {
        log.info("\u8fdb\u516510\u5206\u949f\u63a8\u9001");
        try {
            Boolean aBoolean;
            BusiPushTypeEnum pushTypeEnum = BusiPushTypeEnum.MSG_INTERVAL_10_MIN;
            if (BusiCodeEnum.ZXZX.getBusiCodeEnumValue().equalsIgnoreCase(imRecorder.getBusiCode())) {
                pushTypeEnum = BusiPushTypeEnum.PUSH_INTERVAL_10_MIN_VAL;
            }
            if ((aBoolean = this.pushToBusiness(pushTo, PushBusiMsgTypeEnum.OFFLINE_MSG, imRecorder.getBusiCode(), imRecorder.getTreatmentId(), pushTypeEnum)).booleanValue()) {
                if (AppCodeEnum.EHOS_DOCTOR.equals((Object)pushTo)) {
                    imRecorder.setToDoctorPushInterval(10);
                } else if (AppCodeEnum.EHOS_PATIENT.equals((Object)pushTo)) {
                    imRecorder.setToPatientPushInterval(10);
                }
                imRecorder.setPushInterval(10);
                imRecorder.setLastPushTime(currentSecond);
            }
            log.info("10\u5206\u949f-->\u7ed9\u60a3\u8005\u63a8\u6d88\u606f \u63a8\u9001\u7ed3\u679c:{}", (Object)aBoolean);
        }
        catch (Exception e) {
            log.info("10\u5206\u949f\u63a8\u9001\u5931\u8d25" + e.getMessage() + "====:" + e.getCause());
        }
        frushRecorderList.add(imRecorder);
    }

    private Boolean push120Minutes(AppCodeEnum pushTo, List<IMSessionRecorder> frushRecorderList, IMSessionRecorder imRecorder, Long currentSecond) {
        log.info("\u8fdb\u5165120\u5206\u949f\u63a8\u9001");
        try {
            Boolean aBoolean;
            BusiPushTypeEnum pushTypeEnum = BusiPushTypeEnum.MSG_INTERVAL_120_MIN;
            if (BusiCodeEnum.ZXZX.getBusiCodeEnumValue().equalsIgnoreCase(imRecorder.getBusiCode())) {
                pushTypeEnum = BusiPushTypeEnum.PUSH_INTERVAL_120_MIN_VAL;
            }
            if ((aBoolean = this.pushToBusiness(pushTo, PushBusiMsgTypeEnum.OFFLINE_MSG, imRecorder.getBusiCode(), imRecorder.getTreatmentId(), pushTypeEnum)).booleanValue()) {
                if (AppCodeEnum.EHOS_DOCTOR.equals((Object)pushTo)) {
                    imRecorder.setToDoctorPushInterval(110);
                } else if (AppCodeEnum.EHOS_PATIENT.equals((Object)pushTo)) {
                    imRecorder.setToPatientPushInterval(110);
                }
                imRecorder.setPushInterval(110);
                imRecorder.setLastPushTime(currentSecond);
                if (imRecorder.getToDoctorPushInterval() == 110 && imRecorder.getToPatientPushInterval() == 110) {
                    return true;
                }
                frushRecorderList.add(imRecorder);
                return false;
            }
            log.info("120\u5206\u949f-->\u7ed9\u60a3\u8005\u63a8\u6d88\u606f \u63a8\u9001\u5931\u8d25\uff0c\u52a0\u5165\u7f13\u5b58\u8bb0\u5f55\u4e2d\uff0c\u4e0b\u4e00\u6b21\u5728\u63a8\u9001");
            frushRecorderList.add(imRecorder);
            return false;
        }
        catch (Exception e) {
            log.info("10\u5206\u949f\u63a8\u9001\u5931\u8d25getMessage=" + e.getMessage() + "===getCause=" + e.getCause());
            frushRecorderList.add(imRecorder);
            return false;
        }
    }

    @Async
    public void mediaProcessPushToBusiness(ImMediaProcessEntity mediaProcessEntity, BusiPushTypeEnum pushType) {
        log.info("mediaProcessPushToBusiness\u91cc\u9762\u63a5\u6536\u5230\u7684ImMediaProcessEntity\u53c2\u6570{}", (Object)JSON.toJSONString((Object)mediaProcessEntity));
        log.info("mediaProcessPushToBusiness\u91cc\u9762\u63a5\u6536\u5230\u7684pushType\u53c2\u6570{}", (Object)pushType);
        String fileId = mediaProcessEntity.getFileId();
        List imMixtedFlowEntities = this.mixtedFlowRepository.selectByFileId(fileId);
        if (imMixtedFlowEntities == null || imMixtedFlowEntities.isEmpty()) {
            log.info("---\u89c6\u9891\u63a8\u9001--IMMixtedFlowEntity\u4e3a\u7a7a\uff0cfileId:" + fileId);
            return;
        }
        Optional optional = this.sessionRepository.findById((Object)((IMMixtedFlowEntity)imMixtedFlowEntities.get(0)).getSessionId());
        if (!optional.isPresent()) {
            log.info("---\u89c6\u9891\u63a8\u9001--ImSessionEntity\u4e3a\u7a7a\uff0cfileId:" + ((IMMixtedFlowEntity)imMixtedFlowEntities.get(0)).getSessionId());
            return;
        }
        ImSessionEntity sessionEntity = (ImSessionEntity)optional.get();
        IMBusiPushConfigEntity pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(pushType.getValue(), sessionEntity.getBusiCode());
        if (null == pushConfig) {
            log.info("---\u89c6\u9891\u63a8\u9001--IMBusiPushConfigEntity\u4e3a\u7a7a\uff0cpushType:{},BusiCode:{}", (Object)pushType.getValue(), (Object)sessionEntity.getBusiCode());
            pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(pushType.getValue(), BusiCodeEnum.YCHZ.getBusiCodeEnumValue());
        }
        IMBusiPushRespVo respVo = new IMBusiPushRespVo();
        BeanUtils.copyProperties((Object)mediaProcessEntity, (Object)respVo);
        respVo.setPushType(pushType.getValue());
        respVo.setTreatmentId(sessionEntity.getTreatmentId());
        JSONObject params = JSONObject.parseObject((String)JSON.toJSONString((Object)respVo));
        IMBusiPushLogEntity pushLog = new IMBusiPushLogEntity();
        if ("mq".equalsIgnoreCase(pushConfig.getEnableType())) {
            this.rabbitTemplate.convertAndSend(pushConfig.getExchange(), pushConfig.getRouteKey(), (Object)JSON.toJSONString((Object)respVo));
            pushLog.setUrl(MQ_EXCHANGE + pushConfig.getExchange() + ROUTE_KEY + pushConfig.getRouteKey());
            pushLog.setResponseResult(null);
            log.info("mediaProcessPushToBusiness\u63a8\u9001---mq--Exchange:{},RouteKey:{}", (Object)pushConfig.getExchange(), (Object)pushConfig.getRouteKey());
        } else if ("http".equalsIgnoreCase(pushConfig.getEnableType())) {
            String result = "";
            String pushUrl = pushConfig.getDomain() + "/" + sessionEntity.getBusiNodeCode() + pushConfig.getUri();
            if ("post".equalsIgnoreCase(pushConfig.getMethod())) {
                log.info("----\u53d1\u8d77\u8bf7\u6c42---mediaProcessPushToBusiness\u63a8\u9001-----pushUrl:{},params:{},", (Object)pushUrl, (Object)JSON.toJSONString((Object)respVo));
                result = RestTemplateUtils.post((String)pushUrl, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            } else if ("get".equalsIgnoreCase(pushConfig.getMethod())) {
                result = RestTemplateUtils.get((String)pushUrl, (JSONObject)params);
            }
            pushLog.setUrl(pushUrl);
            pushLog.setResponseResult(result);
            log.info("mediaProcessPushToBusiness\u63a8\u9001---http--result:{}", (Object)result);
        } else {
            log.info(UNKNOW_PUSH_TYPE + pushConfig.getEnableType());
        }
        pushLog.setRequestParams(JSON.toJSONString((Object)respVo));
        pushLog.setCreateDateTime(new Date());
        this.busiPushLogRepository.save((Object)pushLog);
    }

    @Async
    public void editMediaCompletePushToBusiness(IMEditMediaRespVo vo, BusiPushTypeEnum mediaEdit) {
        IMBusiPushConfigEntity pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(mediaEdit.getValue(), vo.getBusiCode());
        if (null == pushConfig) {
            log.info("---\u89c6\u9891\u7f16\u8f91\u5b8c\u6210\u63a8\u9001--IMBusiPushConfigEntity\u4e3a\u7a7a\uff0cpushType:{},BusiCode:{}", (Object)mediaEdit.getValue(), (Object)vo.getBusiCode());
            return;
        }
        IMBusiPushLogEntity pushLog = new IMBusiPushLogEntity();
        if ("mq".equalsIgnoreCase(pushConfig.getEnableType())) {
            this.rabbitTemplate.convertAndSend(pushConfig.getExchange(), pushConfig.getRouteKey(), (Object)JSON.toJSONString((Object)vo));
            pushLog.setUrl(MQ_EXCHANGE + pushConfig.getExchange() + ROUTE_KEY + pushConfig.getRouteKey());
        } else if ("http".equalsIgnoreCase(pushConfig.getEnableType())) {
            String result = "";
            String pushUrl = pushConfig.getDomain() + "/cloud" + pushConfig.getUri();
            result = RestTemplateUtils.post((String)pushUrl, (JSONObject)JSONObject.parseObject((String)JSON.toJSONString((Object)vo)), (MediaType)MediaType.APPLICATION_JSON_UTF8);
            pushLog.setUrl(pushUrl);
            pushLog.setResponseResult(result);
            log.info("editMediaCompletePushToBusiness \u63a8\u9001---http--result:{}", (Object)result);
        } else {
            log.info(UNKNOW_PUSH_TYPE + pushConfig.getEnableType());
        }
        pushLog.setRequestParams(JSON.toJSONString((Object)vo));
        pushLog.setCreateDateTime(new Date());
        this.busiPushLogRepository.save((Object)pushLog);
    }

    public void mediaProcessPushToBusinessNew(ImMediaProcessEntity mediaProcessEntity, BusiPushTypeEnum pushType, boolean flag) {
        log.info("mediaProcessPushToBusiness\u91cc\u9762\u63a5\u6536\u5230\u7684ImMediaProcessEntity\u53c2\u6570{}", (Object)JSON.toJSONString((Object)mediaProcessEntity));
        log.info("mediaProcessPushToBusiness\u91cc\u9762\u63a5\u6536\u5230\u7684pushType\u53c2\u6570{}", (Object)pushType);
        String fileId = mediaProcessEntity.getFileId();
        List imMixtedFlowEntities = this.mixtedFlowRepository.selectByFileId(fileId);
        if (imMixtedFlowEntities == null || imMixtedFlowEntities.isEmpty()) {
            log.info("---\u89c6\u9891\u63a8\u9001--IMMixtedFlowEntity\u4e3a\u7a7a\uff0cfileId:" + fileId);
            return;
        }
        Optional optional = this.sessionRepository.findById((Object)((IMMixtedFlowEntity)imMixtedFlowEntities.get(0)).getSessionId());
        if (!optional.isPresent()) {
            log.info("---\u89c6\u9891\u63a8\u9001--ImSessionEntity\u4e3a\u7a7a\uff0cfileId:" + ((IMMixtedFlowEntity)imMixtedFlowEntities.get(0)).getSessionId());
            return;
        }
        ImSessionEntity sessionEntity = (ImSessionEntity)optional.get();
        IMBusiPushConfigEntity pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(pushType.getValue(), sessionEntity.getBusiCode());
        if (null == pushConfig) {
            log.info("---\u89c6\u9891\u63a8\u9001--IMBusiPushConfigEntity\u4e3a\u7a7a\uff0cpushType:{},BusiCode:{}", (Object)pushType.getValue(), (Object)sessionEntity.getBusiCode());
            pushConfig = this.imBusiPushConfigRepository.findByPushTypeAndBusiCode(pushType.getValue(), BusiCodeEnum.YCHZ.getBusiCodeEnumValue());
        }
        IMBusiPushRespVo respVo = new IMBusiPushRespVo();
        BeanUtils.copyProperties((Object)mediaProcessEntity, (Object)respVo);
        respVo.setPushType(pushType.getValue());
        respVo.setTreatmentId(sessionEntity.getTreatmentId());
        JSONObject params = JSONObject.parseObject((String)JSON.toJSONString((Object)respVo));
        if (flag) {
            params.put("isMix", (Object)"mixed");
        } else {
            params.put("isMix", (Object)"noMixed");
        }
        IMBusiPushLogEntity pushLog = new IMBusiPushLogEntity();
        if ("mq".equalsIgnoreCase(pushConfig.getEnableType())) {
            this.rabbitTemplate.convertAndSend(pushConfig.getExchange(), pushConfig.getRouteKey(), (Object)JSON.toJSONString((Object)respVo));
            pushLog.setUrl(MQ_EXCHANGE + pushConfig.getExchange() + ROUTE_KEY + pushConfig.getRouteKey());
            pushLog.setResponseResult(null);
            log.info("mediaProcessPushToBusiness\u63a8\u9001---mq--Exchange:{},RouteKey:{}", (Object)pushConfig.getExchange(), (Object)pushConfig.getRouteKey());
        } else if ("http".equalsIgnoreCase(pushConfig.getEnableType())) {
            String result = "";
            String pushUrl = pushConfig.getDomain() + "/" + sessionEntity.getBusiNodeCode() + pushConfig.getUri();
            if ("post".equalsIgnoreCase(pushConfig.getMethod())) {
                log.info("----\u53d1\u8d77\u8bf7\u6c42---mediaProcessPushToBusiness\u63a8\u9001-----pushUrl:{},params:{},", (Object)pushUrl, (Object)JSON.toJSONString((Object)respVo));
                result = RestTemplateUtils.post((String)pushUrl, (JSONObject)params, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            } else if ("get".equalsIgnoreCase(pushConfig.getMethod())) {
                result = RestTemplateUtils.get((String)pushUrl, (JSONObject)params);
            }
            pushLog.setUrl(pushUrl);
            pushLog.setResponseResult(result);
            log.info("mediaProcessPushToBusiness\u63a8\u9001---http--result:{}", (Object)result);
        } else {
            log.info(UNKNOW_PUSH_TYPE + pushConfig.getEnableType());
        }
        pushLog.setRequestParams(JSON.toJSONString((Object)respVo));
        pushLog.setCreateDateTime(new Date());
        this.busiPushLogRepository.save((Object)pushLog);
    }
}

