/*
 * Decompiled with CFR 0.152.
 */
package com.hxgy.im.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.response.IError;
import com.ebaiyihui.framework.utils.JsonUtil;
import com.hxgy.im.enums.ErrorEnum;
import com.hxgy.im.pojo.bo.IMSaveAccountBO;
import com.hxgy.im.pojo.bo.IMSaveSigBO;
import com.hxgy.im.pojo.bo.TencentSendMsgRspBO;
import com.hxgy.im.pojo.entity.ImAccountEntity;
import com.hxgy.im.pojo.entity.ImApplicationEntity;
import com.hxgy.im.pojo.entity.ImGroupMsgEntity;
import com.hxgy.im.pojo.entity.ImGroupMsgRelationEntity;
import com.hxgy.im.pojo.entity.ImMemberEntity;
import com.hxgy.im.pojo.entity.ImMessageEntity;
import com.hxgy.im.pojo.entity.ImSessionEntity;
import com.hxgy.im.pojo.entity.ImSigEntity;
import com.hxgy.im.pojo.entity.ImSingleMsgRelationEntity;
import com.hxgy.im.pojo.vo.AccountVO;
import com.hxgy.im.pojo.vo.PushGroupMsgDataVO;
import com.hxgy.im.pojo.vo.PushGroupMsgReqVO;
import com.hxgy.im.pojo.vo.PushSingleMsgDataVO;
import com.hxgy.im.pojo.vo.PushSingleMsgReqVO;
import com.hxgy.im.repository.ImAccountRepository;
import com.hxgy.im.repository.ImApplicationRepository;
import com.hxgy.im.repository.ImGroupMsgRelationRepository;
import com.hxgy.im.repository.ImGroupMsgRepository;
import com.hxgy.im.repository.ImMemberRepository;
import com.hxgy.im.repository.ImMessageRepository;
import com.hxgy.im.repository.ImSessionRepository;
import com.hxgy.im.repository.ImSingleMsgRelationRepository;
import com.hxgy.im.service.BaseService;
import com.hxgy.im.service.IMAccountService;
import com.hxgy.im.service.IMPushAccountService;
import com.hxgy.im.service.IMPushMsgService;
import com.hxgy.im.service.IMSigService;
import com.hxgy.im.service.impl.IMPushMsgServiceImpl;
import com.hxgy.im.util.DateUtils;
import com.hxgy.im.util.EmojiConvertUtil;
import com.hxgy.im.util.RandomUtil;
import com.hxgy.im.util.RestTemplateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class IMPushMsgServiceImpl
extends BaseService
implements IMPushMsgService {
    @Autowired
    private ImSessionRepository sessionRepository;
    @Autowired
    private ImApplicationRepository appRepository;
    @Autowired
    private IMAccountService accountService;
    @Autowired
    private IMSigService sigService;
    @Autowired
    private ImMessageRepository messageRepository;
    @Autowired
    private IMPushAccountService pushAccountService;
    @Autowired
    private ImSingleMsgRelationRepository singleMsgRelationRepository;
    @Autowired
    private ImAccountRepository accountRepository;
    @Autowired
    private ImGroupMsgRepository groupMsgRepository;
    @Autowired
    private ImGroupMsgRelationRepository groupMsgRelationRepository;
    @Autowired
    private ImMemberRepository memberRepository;
    private static final Logger log = LoggerFactory.getLogger(IMPushMsgServiceImpl.class);
    private static final String SEND_MSG_URL = "sendmsgurl";
    private static final String MSG_TYPE = "MsgType";
    private static final String MSG_CONTENT = "MsgContent";
    private static final String MSG_BODY = "MsgBody";

    public BaseResponse<Object> pushSingleMsg(PushSingleMsgReqVO reqVO) {
        log.info("\u5355\u804a\u6d88\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getUniqueId();
        ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (session == null) {
            log.error("\u4f1a\u8bdd\u4e0d\u5b58\u5728:busiCode={},treatmentId={}", (Object)busiCode, (Object)treatmentId);
            return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
        }
        List msgDatas = reqVO.getMsgData();
        String sessionId = session.getId();
        Map<String, List<PushSingleMsgDataVO>> mapByActionType = msgDatas.stream().collect(Collectors.groupingBy(PushSingleMsgDataVO::getActionType));
        mapByActionType.forEach((actionType, msg) -> {
            if ("user".equalsIgnoreCase((String)actionType)) {
                this.pushUserSingleMsg(sessionId, msg);
            } else if ("system".equalsIgnoreCase((String)actionType)) {
                this.pushSystemSingleMsg(sessionId, msg);
            }
        });
        return BaseResponse.success();
    }

    private void pushUserSingleMsg(String sessionId, List<PushSingleMsgDataVO> msgData) {
        String TENCENT_SEND_MSG_SINGLE_URL = this.txImUrl.concat("/v4/openim/sendmsg");
        HashMap postMap = new HashMap(16);
        String sendmsgurl = SEND_MSG_URL;
        msgData.stream().forEach(msg -> {
            String post2TxResult;
            AccountVO fromAccount = msg.getFromAccount();
            AccountVO toAccount = msg.getToAccount();
            JSONObject jsonObject = new JSONObject();
            String fromAppCode = fromAccount.getAppCode();
            String toAppCode = toAccount.getAppCode();
            String fromUserId = fromAccount.getUserId();
            String toUserId = toAccount.getUserId();
            ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
            String fromAppId = fromApp.getId();
            IMSaveAccountBO fAccBo = new IMSaveAccountBO(fromAppId, fromAppCode, fromUserId, null);
            ImAccountEntity fAccount = this.accountService.saveOrQueryAccount(fAccBo);
            jsonObject.put("From_Account", (Object)fAccount.getSdkAccount());
            ImApplicationEntity toApp = this.appRepository.findByAppCode(toAppCode);
            IMSaveAccountBO toAccBo = new IMSaveAccountBO(toApp.getId(), toAppCode, toUserId, null);
            ImAccountEntity tAccount = this.accountService.saveOrQueryAccount(toAccBo);
            jsonObject.put("To_Account", (Object)tAccount.getSdkAccount());
            if (postMap.isEmpty()) {
                postMap.put(sendmsgurl, this.createPostTencentUrl(TENCENT_SEND_MSG_SINGLE_URL, toApp));
            }
            jsonObject.put("SyncOtherMachine", (Object)2);
            jsonObject.put("MsgRandom", (Object)RandomUtil.getMin2MaxBetweenRandom((Integer)1, (Integer)99999));
            jsonObject.put("MsgTimeStamp", (Object)DateUtils.getSecondTimestamp((Date)DateUtils.getCurrentDate()));
            ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
            JSONObject msgBody = new JSONObject();
            msgBody.put(MSG_TYPE, (Object)"TIMTextElem");
            JSONObject msgContent = new JSONObject();
            msgContent.put("Text", (Object)msg.getMessage());
            msgBody.put(MSG_CONTENT, (Object)msgContent);
            bodyList.add(msgBody);
            jsonObject.put(MSG_BODY, bodyList);
            Long syncFlag = msg.getSyncFlag();
            if (syncFlag != null && syncFlag > 0L) {
                try {
                    Thread.sleep(syncFlag);
                }
                catch (InterruptedException e) {
                    log.error("pushUserSingleMsg=\u53d1\u9001\u5355\u804a\u6d88\u606f\u7a0b\u5e8f\u7761\u7720\u5f02\u5e38:{}", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (StringUtils.isEmpty((CharSequence)(post2TxResult = RestTemplateUtils.post((String)((String)postMap.get(sendmsgurl)), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8)))) {
                log.error("\u53d1\u9001\u5355\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de\u7a7a:{}", (Object)post2TxResult);
                return;
            }
            log.info("\u53d1\u9001\u5355\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de \uff1a {}", (Object)post2TxResult);
            TencentSendMsgRspBO rspBO = (TencentSendMsgRspBO)JSON.parseObject((String)post2TxResult, TencentSendMsgRspBO.class);
            if ("FAIL".equalsIgnoreCase(rspBO.getActionStatus())) {
                log.info("\u53d1\u9001\u5355\u804a\u6d88\u606f\u5931\u8d25!");
                return;
            }
            ImMessageEntity singleMsg = new ImMessageEntity();
            singleMsg.setApiMsgId(rspBO.getMsgSeq());
            singleMsg.setMessage(msg.getMessage());
            singleMsg.setMsgType("TIMTextElem");
            singleMsg.setOptPlatform("Linux");
            singleMsg.setReceiverId(tAccount.getId());
            singleMsg.setSenderId(fAccount.getId());
            singleMsg.setSessionId(sessionId);
            singleMsg.setTimeStamp(Long.valueOf(rspBO.getMsgTime().longValue()));
            singleMsg.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)((long)rspBO.getMsgTime().intValue() * 1000L)));
            this.messageRepository.saveAndFlush((Object)singleMsg);
        });
    }

    private void pushSystemSingleMsg(String sessionId, List<PushSingleMsgDataVO> msgData) {
        String TENCENT_SEND_MSG_SINGLE_URL = this.txImUrl.concat("/v4/openim/sendmsg");
        HashMap postMap = new HashMap(16);
        String sendmsgurl = SEND_MSG_URL;
        msgData.stream().forEach(msg -> {
            AccountVO toAccount = msg.getToAccount();
            JSONObject jsonObject = new JSONObject();
            String toAppCode = toAccount.getAppCode();
            String toUserId = toAccount.getUserId();
            ImApplicationEntity toApp = this.appRepository.findByAppCode(toAppCode);
            if (toApp == null) {
                log.error("\u63a8\u9001\u6d88\u606f\u63a5\u6536\u65b9\u7684\u5e94\u7528\u7f16\u7801toAppCode = {},\u67e5\u8be2\u65f6\u4e3a\u7a7a!", (Object)toAppCode);
                return;
            }
            String sysAdmin = toApp.getSysAdmin();
            IMSaveAccountBO toAccBO = new IMSaveAccountBO(toApp.getId(), toApp.getAppCode(), toUserId, null);
            ImAccountEntity tAccount = this.accountService.saveOrQueryAccount(toAccBO);
            String sdkAccount = tAccount.getSdkAccount();
            1 accounts = new /* Unavailable Anonymous Inner Class!! */;
            log.info("\u53d1\u9001\u7cfb\u7edf\u6d88\u606f\u65f6\u4e0a\u4f20\u8d26\u53f7:{}", (Object)sdkAccount);
            this.pushAccountService.pushAccount(toApp.getAppSdkId(), (List)accounts);
            jsonObject.put("To_Account", (Object)sdkAccount);
            if (postMap.isEmpty()) {
                postMap.put(sendmsgurl, this.createPostTencentUrl(TENCENT_SEND_MSG_SINGLE_URL, toApp));
            }
            Integer random = RandomUtil.getMin2MaxBetweenRandom((Integer)1, (Integer)Integer.MAX_VALUE);
            jsonObject.put("SyncOtherMachine", (Object)2);
            jsonObject.put("MsgRandom", (Object)random);
            jsonObject.put("MsgTimeStamp", (Object)DateUtils.getSecondTimestamp((Date)DateUtils.getCurrentDate()));
            ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
            JSONObject msgBody = new JSONObject();
            msgBody.put(MSG_TYPE, (Object)"TIMCustomElem");
            JSONObject msgContent = new JSONObject();
            msgContent.put("Data", (Object)msg.getMessage());
            msgBody.put(MSG_CONTENT, (Object)msgContent);
            bodyList.add(msgBody);
            jsonObject.put(MSG_BODY, bodyList);
            Long syncFlag = msg.getSyncFlag();
            if (syncFlag != null && syncFlag > 0L) {
                try {
                    Thread.sleep(syncFlag);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("pushUserSingleMsg=\u53d1\u9001\u5355\u804a\u6d88\u606f\u7a0b\u5e8f\u7761\u7720\u5f02\u5e38:{}", (Throwable)e);
                }
            }
            log.info("\u6700\u7ec8\u53d1\u9001\u6570\u636e:{}", (Object)JSON.toJSONString((Object)jsonObject, (boolean)true));
            String post2TxResult = RestTemplateUtils.post((String)((String)postMap.get(sendmsgurl)), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u8bf7\u6c42\u8fd4\u56de\u7ed3\u679c:{}", (Object)post2TxResult);
            if (StringUtils.isEmpty((CharSequence)post2TxResult)) {
                log.error("\u53d1\u9001\u5355\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de\u7a7a:{}", (Object)post2TxResult);
                return;
            }
            log.info("\u53d1\u9001\u5355\u804a\u7cfb\u7edf\u6d88\u606f\u817e\u8baf\u8fd4\u56de: {}", (Object)post2TxResult);
            TencentSendMsgRspBO rspBO = (TencentSendMsgRspBO)JSON.parseObject((String)post2TxResult, TencentSendMsgRspBO.class);
            if ("FAIL".equalsIgnoreCase(rspBO.getActionStatus())) {
                log.info("\u53d1\u9001\u5355\u804a\u6d88\u606f\u5931\u8d25!");
                return;
            }
            ImMessageEntity singleMsg = new ImMessageEntity();
            singleMsg.setApiMsgId(String.valueOf(random));
            singleMsg.setMessage(msg.getMessage());
            singleMsg.setMsgType("system");
            singleMsg.setOptPlatform("Linux");
            singleMsg.setReceiverId(tAccount.getId());
            IMSaveAccountBO fromAccBO = new IMSaveAccountBO(toApp.getId(), toApp.getAppCode(), sysAdmin, "\u7ba1\u7406\u5458");
            ImAccountEntity fAccount = this.accountService.saveOrQueryAccount(fromAccBO);
            singleMsg.setSenderId(fAccount.getId());
            singleMsg.setSessionId(sessionId);
            singleMsg.setTimeStamp(Long.valueOf(rspBO.getMsgTime().longValue()));
            singleMsg.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)((long)rspBO.getMsgTime().intValue() * 1000L)));
            this.messageRepository.saveAndFlush((Object)singleMsg);
            ImSingleMsgRelationEntity msgRelation = new ImSingleMsgRelationEntity();
            msgRelation.setReceiverId(tAccount.getId());
            msgRelation.setSingleMsgId(singleMsg.getId());
            this.singleMsgRelationRepository.saveAndFlush((Object)msgRelation);
        });
    }

    public BaseResponse<Object> pushGroupMsg(PushGroupMsgReqVO reqVO) {
        log.info("\u53d1\u9001\u7fa4\u7ec4\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JsonUtil.convertObject((Object)reqVO));
        String busiCode = reqVO.getBusiCode();
        String treatmentId = reqVO.getTreatmentId();
        ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (session == null) {
            return BaseResponse.error((String)"\u4f1a\u8bdd\u4e0d\u5b58\u5728!");
        }
        List msgDatas = reqVO.getMsgData();
        Map<String, List<PushGroupMsgDataVO>> mapByActionType = msgDatas.stream().collect(Collectors.groupingBy(PushGroupMsgDataVO::getActionType));
        mapByActionType.forEach((actionType, msg) -> {
            if ("user".equalsIgnoreCase((String)actionType)) {
                this.pushUserGroupMsg(session, msg);
            } else if ("system".equalsIgnoreCase((String)actionType)) {
                this.pushSystemGroupMsg(session, msg);
            }
        });
        return BaseResponse.success();
    }

    public void pushUserGroupMsg(ImSessionEntity session, List<PushGroupMsgDataVO> msgData) {
        String TENCENT_SEND_MSG_GROUP_COMMON_URL = this.txImUrl.concat("/v4/group_open_http_svc/send_group_msg");
        HashMap postMap = new HashMap(16);
        String sendmsgurl = SEND_MSG_URL;
        msgData.stream().forEach(msg -> {
            String post2TxResult;
            ImGroupMsgEntity groupMsg = new ImGroupMsgEntity();
            JSONObject jsonObject = new JSONObject();
            AccountVO account = msg.getFromAccount();
            if (account != null) {
                String fromAppCode = account.getAppCode();
                String fromUserId = account.getUserId();
                ImApplicationEntity fromApp = this.appRepository.findByAppCode(fromAppCode);
                if (postMap.isEmpty()) {
                    postMap.put(sendmsgurl, this.createPostTencentUrl(TENCENT_SEND_MSG_GROUP_COMMON_URL, fromApp));
                }
                IMSaveAccountBO accountBO = new IMSaveAccountBO(fromApp.getId(), fromAppCode, fromUserId, "");
                ImAccountEntity fromAccount = this.accountService.saveOrQueryAccount(accountBO);
                jsonObject.put("From_Account", (Object)fromAccount.getSdkAccount());
                groupMsg.setSenderId(fromAccount.getId());
            } else {
                log.info("\u6ca1\u6709\u6307\u5b9a\u53d1\u9001\u8005\uff01");
                ImApplicationEntity tempApplication = this.getApplication(session);
                IMSaveAccountBO accountBO = new IMSaveAccountBO(tempApplication.getId(), tempApplication.getAppCode(), tempApplication.getSysAdmin(), "\u7ba1\u7406\u5458");
                ImAccountEntity tempAccount = this.accountService.saveOrQueryAccount(accountBO);
                groupMsg.setSenderId(tempAccount.getId());
                if (postMap.isEmpty()) {
                    postMap.put(sendmsgurl, this.createPostTencentUrl(TENCENT_SEND_MSG_GROUP_COMMON_URL, tempApplication));
                }
            }
            jsonObject.put("GroupId", (Object)session.getGroupId());
            jsonObject.put("Random", (Object)RandomUtil.getMin2MaxBetweenRandom((Integer)1, (Integer)99999));
            ArrayList<JSONObject> bodyList = new ArrayList<JSONObject>();
            JSONObject msgBody = new JSONObject();
            msgBody.put(MSG_TYPE, (Object)"TIMTextElem");
            JSONObject msgContent = new JSONObject();
            msgContent.put("Text", (Object)msg.getMessage());
            msgBody.put(MSG_CONTENT, (Object)msgContent);
            bodyList.add(msgBody);
            jsonObject.put(MSG_BODY, bodyList);
            ArrayList<String> forBidList = new ArrayList<String>();
            forBidList.add("ForbidBeforeSendMsgCallback");
            forBidList.add("ForbidAfterSendMsgCallback");
            jsonObject.put("ForbidCallbackControl", forBidList);
            jsonObject.put("OnlineOnlyFlag", (Object)1);
            log.info("{}---\u7ec4\u88c5\u53d1\u9001\u7684\u6570\u636e\uff1a---{}", (Object)msg.getActionType(), (Object)JSON.toJSONString((Object)jsonObject, (boolean)true));
            Long syncFlag = msg.getSyncFlag();
            if (syncFlag != null && syncFlag > 0L) {
                try {
                    Thread.sleep(syncFlag);
                }
                catch (InterruptedException e) {
                    log.error("pushUserGroupMsg=\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u7a0b\u5e8f\u7761\u7720\u5f02\u5e38:{}", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            if (StringUtils.isEmpty((CharSequence)(post2TxResult = RestTemplateUtils.post((String)((String)postMap.get(sendmsgurl)), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8)))) {
                log.error("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de\u7a7a:{}", (Object)post2TxResult);
                return;
            }
            log.info("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de \uff1a {}", (Object)post2TxResult);
            TencentSendMsgRspBO rspBO = (TencentSendMsgRspBO)JSON.parseObject((String)post2TxResult, TencentSendMsgRspBO.class);
            if ("FAIL".equalsIgnoreCase(rspBO.getActionStatus())) {
                log.info("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u5931\u8d25!");
                return;
            }
            groupMsg.setGroupId(session.getGroupId());
            groupMsg.setApiMsgId(rspBO.getMsgSeq());
            groupMsg.setDuration(Integer.valueOf(0));
            groupMsg.setMsgContent(msg.getMessage());
            groupMsg.setMsgTime(DateUtils.longToStrDate((String)"yyyy-MM-dd HH:mm:ss", (long)((long)rspBO.getMsgTime().intValue() * 1000L)));
            groupMsg.setMsgType("TIMTextElem");
            groupMsg.setOptPlatform("linux");
            groupMsg.setTimeStamp(Long.valueOf(rspBO.getMsgTime().longValue()));
            groupMsg.setSessionId(session.getId());
            this.groupMsgRepository.saveAndFlush((Object)groupMsg);
        });
    }

    public void pushSystemGroupMsg(ImSessionEntity session, List<PushGroupMsgDataVO> msgData) {
        String TENCENT_SEND_MSG_GROUP_SYSTEM_URL = this.txImUrl.concat("/v4/group_open_http_svc/send_group_system_notification");
        HashMap postMap = new HashMap(16);
        String sendmsgurl = SEND_MSG_URL;
        ArrayList groupMsgRelationList = new ArrayList();
        msgData.stream().forEach(msg -> {
            groupMsgRelationList.clear();
            JSONObject jsonObject = new JSONObject();
            List accountList = msg.getToAccount();
            if (accountList != null && !accountList.isEmpty()) {
                ArrayList sdkAccount = new ArrayList();
                accountList.stream().forEach(account -> {
                    String toAppCode = account.getAppCode();
                    String toUserId = account.getUserId();
                    ImApplicationEntity toApp = this.appRepository.findByAppCode(toAppCode);
                    IMSaveAccountBO accountBO = new IMSaveAccountBO(toApp.getId(), toAppCode, toUserId, "");
                    ImAccountEntity toAccount = this.accountService.saveOrQueryAccount(accountBO);
                    sdkAccount.add(toAccount.getSdkAccount());
                    groupMsgRelationList.add(toAccount.getId());
                });
                jsonObject.put("ToMembers_Account", sdkAccount);
            } else {
                log.info("\u6ca1\u6709\u6307\u5b9a\u63a5\u6536\u8005\uff01");
            }
            ImGroupMsgEntity groupMsg = new ImGroupMsgEntity();
            ImApplicationEntity tempApplication = this.getApplication(session);
            IMSaveAccountBO accountBO = new IMSaveAccountBO(tempApplication.getId(), tempApplication.getAppCode(), tempApplication.getSysAdmin(), "\u7ba1\u7406\u5458");
            ImAccountEntity tempAccount = this.accountService.saveOrQueryAccount(accountBO);
            groupMsg.setSenderId(tempAccount.getId());
            if (postMap.isEmpty()) {
                postMap.put(sendmsgurl, this.createPostTencentUrl(TENCENT_SEND_MSG_GROUP_SYSTEM_URL, tempApplication));
            }
            jsonObject.put("GroupId", (Object)session.getGroupId());
            jsonObject.put("Content", (Object)msg.getMessage());
            Long syncFlag = msg.getSyncFlag();
            if (syncFlag != null && syncFlag > 0L) {
                try {
                    Thread.sleep(syncFlag);
                }
                catch (InterruptedException e) {
                    log.error("pushSystemGroupMsg=\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u7a0b\u5e8f\u7761\u7720\u5f02\u5e38:{}", (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
            log.info("\u8bf7\u6c42url {}", postMap.get(sendmsgurl));
            log.info("\u8bf7\u6c42\u53c2\u6570 {}", (Object)jsonObject.toJSONString());
            String post2TxResult = RestTemplateUtils.post((String)((String)postMap.get(sendmsgurl)), (JSONObject)jsonObject, (MediaType)MediaType.APPLICATION_JSON_UTF8);
            log.info("\u8bf7\u6c42\u7ed3\u679c {}", (Object)post2TxResult);
            if (StringUtils.isEmpty((CharSequence)post2TxResult)) {
                log.error("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de\u7a7a:{}", (Object)post2TxResult);
                return;
            }
            log.info("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u817e\u8baf\u8fd4\u56de \uff1a {}", (Object)post2TxResult);
            TencentSendMsgRspBO rspBO = (TencentSendMsgRspBO)JSON.parseObject((String)post2TxResult, TencentSendMsgRspBO.class);
            if ("FAIL".equalsIgnoreCase(rspBO.getActionStatus())) {
                log.info("\u53d1\u9001\u7fa4\u804a\u6d88\u606f\u5931\u8d25!");
                return;
            }
            try {
                groupMsg.setMsgContent(EmojiConvertUtil.emojiConvert((String)msg.getMessage()));
            }
            catch (Exception e) {
                log.error("\u8f6c\u6362Emoji\u8868\u60c5\u5f02\u5e38:{}", (Object)msg.getMessage());
            }
            groupMsg.setGroupId(session.getGroupId());
            groupMsg.setApiMsgId(rspBO.getMsgSeq());
            groupMsg.setDuration(Integer.valueOf(0));
            groupMsg.setMsgTime(DateUtils.getCurrentDateToString());
            groupMsg.setMsgType(msg.getActionType());
            groupMsg.setOptPlatform("linux");
            groupMsg.setTimeStamp(DateUtils.getSecondTimestamp((Date)new Date()));
            groupMsg.setSessionId(session.getId());
            this.groupMsgRepository.saveAndFlush((Object)groupMsg);
            if (accountList != null && !accountList.isEmpty()) {
                HashSet relationSet = new HashSet();
                groupMsgRelationList.stream().forEach(groupRelation -> {
                    ImGroupMsgRelationEntity groupMsgRelation = new ImGroupMsgRelationEntity();
                    groupMsgRelation.setGroupMsgId(groupMsg.getId());
                    groupMsgRelation.setReceiverId(groupRelation);
                    relationSet.add(groupMsgRelation);
                });
                this.groupMsgRelationRepository.saveAll(relationSet);
            }
        });
    }

    private ImApplicationEntity getApplication(ImSessionEntity session) {
        Optional application;
        String sessionId = session.getId();
        List memberList = this.memberRepository.findBySessionId(sessionId);
        HashMap<String, String> map = new HashMap<String, String>(16);
        String key = "key";
        List patients = memberList.stream().filter(member -> StringUtils.isNotBlank((CharSequence)member.getPatientId()) && !"0".equals(member.getPatientId())).collect(Collectors.toList());
        if (patients != null && !patients.isEmpty()) {
            map.put(key, ((ImMemberEntity)patients.get(0)).getAccountId());
        } else {
            map.put(key, ((ImMemberEntity)memberList.get(0)).getAccountId());
        }
        Optional account = this.accountRepository.findById(map.get(key));
        if (account.isPresent() && (application = this.appRepository.findById((Object)((ImAccountEntity)account.get()).getAppId())).isPresent()) {
            return (ImApplicationEntity)application.get();
        }
        return null;
    }

    private String createPostTencentUrl(String prefixUrl, ImApplicationEntity app) {
        String appId = app.getId();
        String userId = app.getSysAdmin();
        IMSaveAccountBO accountBO = new IMSaveAccountBO(appId, "", userId, "\u7ba1\u7406\u5458");
        ImAccountEntity accountEntity = this.accountService.saveOrQueryAccount(accountBO);
        String accountId = accountEntity.getId();
        IMSaveSigBO sigBo = new IMSaveSigBO(app.getAppSdkId(), userId, accountId);
        ImSigEntity sig = this.sigService.saveSig(sigBo);
        StringBuilder urlBuilder = new StringBuilder(prefixUrl);
        urlBuilder.append("Objectusersig=");
        urlBuilder.append(sig.getAccountSig());
        urlBuilder.append("&");
        urlBuilder.append("identifier=");
        urlBuilder.append(userId);
        urlBuilder.append("&");
        urlBuilder.append("sdkappid=");
        urlBuilder.append(app.getAppSdkId());
        urlBuilder.append("&");
        urlBuilder.append("random=");
        urlBuilder.append(99999999);
        urlBuilder.append("&");
        urlBuilder.append("contenttype=");
        urlBuilder.append("json");
        return urlBuilder.toString();
    }

    @Async
    public BaseResponse<Object> pushRecallMsg(String sdkAccount, String busiCode, String treatmentId, String clientMsgId) {
        log.info("\u5f02\u6b65==\u300b\u8fdb\u5165\u6d88\u606f\u64a4\u56de\u81ea\u5b9a\u4e49\u6d88\u606f\u63a8\u9001,\u4e3b\u52a8\u64a4\u56de\u65b9\u8d26\u53f7sdkAccount={},busiCode={},treatmentId={}", new Object[]{sdkAccount, busiCode, treatmentId});
        ArrayList<PushSingleMsgDataVO> list = new ArrayList<PushSingleMsgDataVO>();
        PushSingleMsgDataVO msgDataVO = new PushSingleMsgDataVO();
        ImSessionEntity session = this.sessionRepository.findByBusiCodeAndTreatmentId(busiCode, treatmentId);
        if (session == null) {
            log.info("\u5f02\u6b65==\u300b\u8fdb\u5165\u6d88\u606f\u64a4\u56de\u81ea\u5b9a\u4e49\u6d88\u606f\u63a8\u9001,\u4f1a\u8bdd\u4e0d\u5b58\u5728treatmentId={}", (Object)treatmentId);
            return BaseResponse.error((IError)ErrorEnum.SESSION_NO_EXIST);
        }
        List memberList = this.memberRepository.findBySessionId(session.getId());
        log.info("\u4f1a\u8bdd\u4fe1\u606fsession={},\u6210\u5458\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)session), (Object)JSON.toJSONString((Object)memberList));
        for (ImMemberEntity member : memberList) {
            String msg;
            JSONObject json;
            JSONObject msgJson;
            AccountVO vo;
            String[] split;
            String accountId = member.getAccountId();
            Optional optional = this.accountRepository.findById((Object)accountId);
            if (!optional.isPresent()) {
                log.info("\u6839\u636e\u4f1a\u8bdd\u6210\u5458\u67e5\u8be2\u6210\u5458SDK\u8d26\u53f7,\u8d26\u53f7\u4e0d\u5b58\u5728:{}", (Object)accountId);
                return BaseResponse.error((IError)ErrorEnum.SESSION_NO_EXIST, (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
            }
            ImAccountEntity imAccountEntity = (ImAccountEntity)optional.get();
            if (imAccountEntity.getSdkAccount().equals(sdkAccount)) {
                log.info("\u8fdb\u5165\u6d88\u606f\u64a4\u56de\u81ea\u5b9a\u4e49\u6d88\u606f\u63a8\u9001\uff0c\u4e3b\u52a8\u64a4\u56de\u65b9\uff0c\u8d26\u53f7\u4fe1\u606f:{}", (Object)JSON.toJSONString((Object)imAccountEntity));
                split = sdkAccount.split("\\*");
                vo = new AccountVO();
                vo.setUserId(imAccountEntity.getUserId());
                vo.setAppCode(split[1]);
                msgDataVO.setFromAccount(new AccountVO());
                msgDataVO.setActionType("system");
                msgJson = new JSONObject();
                msgJson.put("messageType", (Object)"1");
                msgJson.put("businessCode", (Object)busiCode);
                msgJson.put("action", (Object)"recall");
                msgJson.put("admissionId", (Object)treatmentId);
                json = new JSONObject();
                json.put("text", (Object)"\u4f60\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f");
                json.put("clientMsgId", (Object)clientMsgId);
                msgJson.put("data", (Object)json);
                msg = JSON.toJSONString((Object)msgJson);
                msgDataVO.setMessage(msg);
                msgDataVO.setToAccount(vo);
                list.add(msgDataVO);
                log.info("\u6d88\u606f\u64a4\u56de\u65b9\u6d88\u606f\u63a8\u9001==\u300b\u4f1a\u8bddid:{},\u53c2\u6570:{}", (Object)session.getId(), (Object)JSON.toJSONString(list));
                this.pushSystemSingleMsg(session.getId(), list);
                continue;
            }
            String otherSdkAccount = imAccountEntity.getSdkAccount();
            split = otherSdkAccount.split("\\*");
            vo = new AccountVO();
            vo.setUserId(imAccountEntity.getUserId());
            vo.setAppCode(split[1]);
            msgDataVO.setFromAccount(new AccountVO());
            msgDataVO.setActionType("system");
            msgJson = new JSONObject();
            msgJson.put("messageType", (Object)"1");
            msgJson.put("businessCode", (Object)busiCode);
            msgJson.put("action", (Object)"recall");
            msgJson.put("admissionId", (Object)treatmentId);
            json = new JSONObject();
            json.put("text", (Object)"\u5bf9\u65b9\u64a4\u56de\u4e86\u4e00\u6761\u6d88\u606f");
            json.put("clientMsgId", (Object)clientMsgId);
            msgJson.put("data", (Object)json);
            msg = JSON.toJSONString((Object)msgJson);
            msgDataVO.setMessage(msg);
            msgDataVO.setToAccount(vo);
            list.clear();
            list.add(msgDataVO);
            log.info("\u5bf9\u65b9\u6d88\u606f\u64a4\u56de==\u300b\u4f1a\u8bddid:{},\u53c2\u6570:{}", (Object)session.getId(), (Object)JSON.toJSONString(list));
            this.pushSystemSingleMsg(session.getId(), list);
        }
        return BaseResponse.success();
    }
}

